/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketManagerFactory;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.crypto.SigType;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelIRCClient;
import net.i2p.i2ptunnel.I2PTunnelTask;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.SSLClientUtil;
import net.i2p.i2ptunnel.TunnelControllerGroup;
import net.i2p.util.EventDispatcher;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PSSLSocketFactory;
import net.i2p.util.Log;

public abstract class I2PTunnelClientBase
extends I2PTunnelTask
implements Runnable {
    protected final Log _log;
    protected final I2PAppContext _context;
    protected final Logging l;
    static final long DEFAULT_CONNECT_TIMEOUT = 60000L;
    private static final AtomicLong __clientId = new AtomicLong();
    protected long _clientId;
    protected final Object sockLock = new Object();
    protected I2PSocketManager sockMgr;
    protected final List<I2PSocket> mySockets = new ArrayList<I2PSocket>();
    protected boolean _ownDest;
    protected Destination dest;
    private volatile int localPort;
    private final String _handlerName;
    protected boolean listenerReady;
    protected ServerSocket ss;
    private final Object startLock = new Object();
    private boolean startRunning;
    private String privKeyFile;
    private boolean chained;
    private volatile ThreadPoolExecutor _executor;
    private static I2PSocketManager socketManager;
    private static SocketManagerState _socketManagerState;
    public static final String PROP_USE_SSL = "useSSL";
    private static final int RETRY_DELAY = 20000;
    private static final int MAX_RETRIES = 4;

    public I2PTunnelClientBase(int localPort, Logging l, I2PSocketManager sktMgr, I2PTunnel tunnel, EventDispatcher notifyThis, long clientId) throws IllegalArgumentException {
        super(localPort + " (uninitialized)", notifyThis, tunnel);
        this.chained = true;
        this.sockMgr = sktMgr;
        this._clientId = clientId;
        this._handlerName = "chained";
        this.localPort = localPort;
        this.l = l;
        this._ownDest = true;
        this._context = tunnel.getContext();
        this.initStats();
        this._log = this._context.logManager().getLog(this.getClass());
    }

    public I2PTunnelClientBase(int localPort, boolean ownDest, Logging l, EventDispatcher notifyThis, String handlerName, I2PTunnel tunnel) throws IllegalArgumentException {
        this(localPort, ownDest, l, notifyThis, handlerName, tunnel, null);
    }

    public I2PTunnelClientBase(int localPort, boolean ownDest, Logging l, EventDispatcher notifyThis, String handlerName, I2PTunnel tunnel, String pkf) throws IllegalArgumentException {
        super(localPort + " (uninitialized)", notifyThis, tunnel);
        boolean dccEnabled;
        this._clientId = __clientId.incrementAndGet();
        this.localPort = localPort;
        this.l = l;
        this._ownDest = ownDest;
        this._handlerName = handlerName;
        this._context = tunnel.getContext();
        this.initStats();
        this._log = this._context.logManager().getLog(this.getClass());
        if (pkf != null) {
            File keyFile = new File(pkf);
            if (!keyFile.isAbsolute()) {
                keyFile = new File(this._context.getConfigDir(), pkf);
            }
            this.privKeyFile = keyFile.getAbsolutePath();
        }
        boolean bl = dccEnabled = this instanceof I2PTunnelIRCClient && Boolean.parseBoolean(tunnel.getClientOptions().getProperty("i2ptunnel.ircclient.enableDCC"));
        if (!dccEnabled) {
            tunnel.getClientOptions().setProperty("i2cp.dontPublishLeaseSet", "true");
        }
        if (tunnel.getClientOptions().getProperty("i2p.streaming.answerPings") == null) {
            tunnel.getClientOptions().setProperty("i2p.streaming.answerPings", "false");
        }
    }

    private void initStats() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void verifySocketManager() {
        Object object = this.sockLock;
        // MONITORENTER : object
        boolean newManager = false;
        if (this.sockMgr == null || this.sockMgr.isDestroyed()) {
            newManager = true;
        } else {
            I2PSession sess = this.sockMgr.getSession();
            if (sess.isClosed() && Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2cp.closeOnIdle")) && Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2cp.newDestOnResume"))) {
                this.getTunnel().removeSession(sess);
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.getTunnel().getClientOptions().getProperty("inbound.nickname") + ": Built a new destination on resume");
                }
                Class<I2PTunnelClientBase> clazz = I2PTunnelClientBase.class;
                // MONITORENTER : net.i2p.i2ptunnel.I2PTunnelClientBase.class
                boolean shouldDestroy = this.sockMgr != socketManager;
                // MONITOREXIT : clazz
                if (shouldDestroy) {
                    this.sockMgr.destroySocketManager();
                }
                newManager = true;
            }
        }
        if (newManager) {
            this.sockMgr = this._ownDest ? this.buildSocketManager() : this.getSocketManager();
        }
        // MONITOREXIT : object
        this.connectManager();
    }

    protected I2PSocketManager getSocketManager() {
        return I2PTunnelClientBase.getSocketManager(this.getTunnel(), this.privKeyFile);
    }

    protected static I2PSocketManager getSocketManager(I2PTunnel tunnel) {
        return I2PTunnelClientBase.getSocketManager(tunnel, null);
    }

    protected static synchronized I2PSocketManager getSocketManager(I2PTunnel tunnel, String pkf) {
        Log _log = tunnel.getContext().logManager().getLog(I2PTunnelClientBase.class);
        if (socketManager != null && !socketManager.isDestroyed()) {
            I2PSession s = socketManager.getSession();
            if (s.isClosed() && _socketManagerState != SocketManagerState.INIT) {
                if (_log.shouldLog(20)) {
                    _log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Building a new socket manager since the old one closed [s=" + s + "]");
                }
                tunnel.removeSession(s);
                socketManager.destroySocketManager();
                _socketManagerState = SocketManagerState.INIT;
                socketManager = I2PTunnelClientBase.buildSocketManager(tunnel, pkf);
                I2PSession sub = I2PTunnelClientBase.addSubsession(tunnel);
                if (sub != null && _log.shouldLog(30)) {
                    _log.warn("Added subsession " + sub);
                }
            } else {
                if (_log.shouldLog(20)) {
                    _log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Not building a new socket manager since the old one is open [s=" + s + "]");
                }
                tunnel.addSession(s);
            }
        } else {
            if (_log.shouldLog(20)) {
                _log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Building a new socket manager since there is no other one");
            }
            socketManager = I2PTunnelClientBase.buildSocketManager(tunnel, pkf);
            I2PSession sub = I2PTunnelClientBase.addSubsession(tunnel);
            if (sub != null && _log.shouldLog(30)) {
                _log.warn("Added subsession " + sub);
            }
        }
        return socketManager;
    }

    protected static synchronized I2PSession addSubsession(I2PTunnel tunnel) {
        I2PSession sess = socketManager.getSession();
        if (sess.getMyDestination().getSigType() == SigType.DSA_SHA1) {
            return null;
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)tunnel.getClientOptions());
        String name = props.getProperty("inbound.nickname");
        if (name != null) {
            props.setProperty("inbound.nickname", name + " (DSA)");
        }
        if ((name = props.getProperty("outbound.nickname")) != null) {
            props.setProperty("outbound.nickname", name + " (DSA)");
        }
        props.setProperty("i2cp.destination.sigType", "DSA_SHA1");
        try {
            return socketManager.addSubsession(null, props);
        }
        catch (I2PSessionException ise) {
            Log log = tunnel.getContext().logManager().getLog(I2PTunnelClientBase.class);
            if (log.shouldLog(30)) {
                log.warn("Failed to add subssession", ise);
            }
            return null;
        }
    }

    protected static synchronized void killSharedClient() {
        socketManager = null;
    }

    protected I2PSocketManager buildSocketManager() {
        return I2PTunnelClientBase.buildSocketManager(this.getTunnel(), this.privKeyFile, this.l);
    }

    protected static I2PSocketManager buildSocketManager(I2PTunnel tunnel) {
        return I2PTunnelClientBase.buildSocketManager(tunnel, null);
    }

    protected static I2PSocketManager buildSocketManager(I2PTunnel tunnel, String pkf) {
        return I2PTunnelClientBase.buildSocketManager(tunnel, pkf, null);
    }

    protected static I2PSocketManager buildSocketManager(I2PTunnel tunnel, String pkf, Logging log) {
        Log _log = tunnel.getContext().logManager().getLog(I2PTunnelClientBase.class);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)tunnel.getClientOptions());
        int portNum = 7654;
        if (tunnel.port != null) {
            try {
                portNum = Integer.parseInt(tunnel.port);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid port specified [" + tunnel.port + "]", nfe);
            }
        }
        I2PSocketManager sockManager = null;
        FileInputStream fis = null;
        try {
            if (pkf != null) {
                fis = new FileInputStream(pkf);
                sockManager = I2PSocketManagerFactory.createDisconnectedManager(fis, tunnel.host, portNum, props);
            } else {
                sockManager = I2PSocketManagerFactory.createDisconnectedManager(null, tunnel.host, portNum, props);
            }
        }
        catch (I2PSessionException ise) {
            throw new IllegalArgumentException("Can't create socket manager", ise);
        }
        catch (IOException ioe) {
            if (log != null) {
                log.log("Error opening key file " + ioe);
            }
            _log.error("Error opening key file", ioe);
            throw new IllegalArgumentException("Error opening key file", ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        sockManager.setName("Client");
        if (_log.shouldLog(20)) {
            _log.info(tunnel.getClientOptions().getProperty("inbound.nickname") + ": Built a new socket manager [s=" + sockManager.getSession() + "]");
        }
        tunnel.addSession(sockManager.getSession());
        return sockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void connectManager() {
        retries = 0;
        while (this.sockMgr.getSession().isClosed() != false) {
            try {
                this.sockMgr.getSession().connect();
                var2_2 = I2PTunnelClientBase.class;
                // MONITORENTER : net.i2p.i2ptunnel.I2PTunnelClientBase.class
                if (this.sockMgr == I2PTunnelClientBase.socketManager) {
                    I2PTunnelClientBase._socketManagerState = SocketManagerState.CONNECTED;
                }
                // MONITOREXIT : var2_2
            }
            catch (I2PSessionException ise) {
                block11: {
                    _log = this.getTunnel().getContext().logManager().getLog(I2PTunnelClientBase.class);
                    log = this.l;
                    portNum = this.getTunnel().port;
                    if (portNum == null) {
                        portNum = "7654";
                    }
                    msg = this.getTunnel().getContext().isRouterContext() != false ? "Unable to build tunnels for the client" : "Unable to connect to the router at " + this.getTunnel().host + ':' + portNum + " and build tunnels for the client";
                    if (++retries >= 4) break block11;
                    if (log != null) {
                        log.log(msg + ", retrying in " + 20 + " seconds");
                    }
                    _log.error(msg + ", retrying in " + 20 + " seconds", ise);
                    try {}
                    catch (InterruptedException var7_8) {
                        continue;
                    }
                    ** GOTO lbl-1000
                }
                if (log != null) {
                    log.log(msg + ", giving up");
                }
                _log.log(50, msg + ", giving up", ise);
                throw new IllegalArgumentException(msg, ise);
lbl-1000:
                // 1 sources

                {
                    Thread.sleep(20000L);
                }
            }
        }
    }

    public final int getLocalPort() {
        return this.localPort;
    }

    protected final InetAddress getListenHost(Logging l) {
        try {
            return InetAddress.getByName(this.getTunnel().listenHost);
        }
        catch (UnknownHostException uhe) {
            l.log("Could not find listen host to bind to [" + this.getTunnel().host + "]");
            this._log.error("Error finding host to bind", uhe);
            this.notifyEvent("openBaseClientResult", "error");
            return null;
        }
    }

    public void startRunning() {
        boolean openNow;
        boolean bl = openNow = !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2cp.delayOpen"));
        if (openNow) {
            while (this.sockMgr == null) {
                this.verifySocketManager();
                if (this.sockMgr == null) {
                    this._log.error("Unable to connect to router and build tunnels for " + this._handlerName);
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.l.log("Tunnels ready for client: " + this._handlerName);
            }
        }
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startup() {
        if (this._log.shouldLog(10)) {
            this._log.debug("startup " + this._clientId, new Exception("I did it"));
        }
        boolean isDaemon = this.getTunnel().getContext().isRouterContext();
        this.open = true;
        I2PAppThread t = new I2PAppThread(this, "I2PTunnel Client " + this.getTunnel().listenHost + ':' + this.localPort, isDaemon);
        ((Thread)t).start();
        I2PTunnelClientBase i2PTunnelClientBase = this;
        synchronized (i2PTunnelClientBase) {
            while (!this.listenerReady && this.open) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.open && this.listenerReady) {
            boolean openNow;
            boolean bl = openNow = !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2cp.delayOpen"));
            if (openNow || this.chained) {
                this.l.log("Client ready, listening on " + this.getTunnel().listenHost + ':' + this.localPort);
            } else {
                this.l.log("Client ready, listening on " + this.getTunnel().listenHost + ':' + this.localPort + ", delaying tunnel open until required");
            }
            this.notifyEvent("openBaseClientResult", "ok");
        } else {
            this.l.log("Client error for " + this.getTunnel().listenHost + ':' + this.localPort + ", check logs");
            this.notifyEvent("openBaseClientResult", "error");
        }
        Object object = this.startLock;
        synchronized (object) {
            this.startRunning = true;
            this.startLock.notify();
        }
    }

    protected I2PSocketOptions getDefaultOptions() {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    protected I2PSocketOptions getDefaultOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    @Override
    public void optionsUpdated(I2PTunnel tunnel) {
        I2PSocketManager sm;
        if (this.getTunnel() != tunnel) {
            return;
        }
        I2PSocketManager i2PSocketManager = sm = this._ownDest ? this.sockMgr : socketManager;
        if (sm == null) {
            return;
        }
        Properties props = tunnel.getClientOptions();
        sm.setDefaultOptions(sm.buildOptions(props));
    }

    public I2PSocket createI2PSocket(Destination dest) throws I2PException, ConnectException, NoRouteToHostException, InterruptedIOException {
        return this.createI2PSocket(dest, 0);
    }

    public I2PSocket createI2PSocket(Destination dest, int port) throws I2PException, ConnectException, NoRouteToHostException, InterruptedIOException {
        this.verifySocketManager();
        I2PSocketOptions opts = this.getDefaultOptions();
        opts.setPort(port);
        return this.createI2PSocket(dest, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PSocket createI2PSocket(Destination dest, I2PSocketOptions opt) throws I2PException, ConnectException, NoRouteToHostException, InterruptedIOException {
        if (dest == null) {
            throw new NullPointerException();
        }
        this.verifySocketManager();
        I2PSocket i2ps = this.sockMgr.connect(dest, opt);
        Object object = this.sockLock;
        synchronized (object) {
            this.mySockets.add(i2ps);
        }
        return i2ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InetAddress addr = this.getListenHost(this.l);
        if (addr == null) {
            this.close(true);
            this.open = false;
            I2PTunnelClientBase i2PTunnelClientBase = this;
            synchronized (i2PTunnelClientBase) {
                this.notifyAll();
            }
            return;
        }
        try {
            Properties opts = this.getTunnel().getClientOptions();
            boolean useSSL = Boolean.parseBoolean(opts.getProperty(PROP_USE_SSL));
            if (useSSL) {
                boolean wasCreated = SSLClientUtil.verifyKeyStore(opts);
                if (wasCreated) {
                    this._log.logAlways(30, "Created new i2ptunnel SSL keys but can't save the config, disable and enable via i2ptunnel GUI");
                }
                SSLServerSocketFactory fact = SSLClientUtil.initializeFactory(opts);
                this.ss = fact.createServerSocket(this.localPort, 0, addr);
                I2PSSLSocketFactory.setProtocolsAndCiphers((SSLServerSocket)this.ss);
            } else {
                this.ss = new ServerSocket(this.localPort, 0, addr);
            }
            if (this.localPort == 0) {
                this.localPort = this.ss.getLocalPort();
            }
            this.notifyEvent("clientLocalPort", this.ss.getLocalPort());
            Object wasCreated = this;
            synchronized (wasCreated) {
                this.listenerReady = true;
                this.notifyAll();
            }
            wasCreated = this.startLock;
            synchronized (wasCreated) {
                while (!this.startRunning) {
                    try {
                        this.startLock.wait();
                    }
                    catch (InterruptedException fact) {}
                }
            }
            TunnelControllerGroup tcg = TunnelControllerGroup.getInstance();
            this._executor = tcg != null ? tcg.getClientExecutor() : new TunnelControllerGroup.CustomThreadPoolExecutor();
            while (this.open) {
                Socket s = this.ss.accept();
                this.manageConnection(s);
            }
        }
        catch (IOException ex) {
            Object object = this.sockLock;
            synchronized (object) {
                this.mySockets.clear();
            }
            if (this.open) {
                this._log.error("Error listening for connections on " + addr + " port " + this.localPort, ex);
                this.l.log("Error listening for connections on " + addr + " port " + this.localPort + ": " + ex);
                this.notifyEvent("openBaseClientResult", "error");
                this.close(true);
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }
    }

    protected void manageConnection(Socket s) {
        if (s == null) {
            return;
        }
        ThreadPoolExecutor tpe = this._executor;
        if (tpe == null) {
            this._log.error("No executor for socket!");
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            tpe.execute(new BlockingRunner(s));
        }
        catch (RejectedExecutionException ree) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(boolean forced) {
        if (this._log.shouldLog(20)) {
            this._log.info("close() called: forced = " + forced + " open = " + this.open + " sockMgr = " + this.sockMgr);
        }
        if (!this.open) {
            return true;
        }
        Object object = this.sockLock;
        synchronized (object) {
            if (this.sockMgr != null) {
                this.mySockets.retainAll(this.sockMgr.listSockets());
                if (!forced && !this.mySockets.isEmpty()) {
                    this.l.log("Not closing, there are still active connections!");
                    this._log.debug("can't close: there are still active connections!");
                    for (I2PSocket s : this.mySockets) {
                        this.l.log("  -> " + s.toString());
                    }
                    return false;
                }
                if (!this.chained) {
                    I2PSession session = this.sockMgr.getSession();
                    this.getTunnel().removeSession(session);
                    if (this._ownDest) {
                        try {
                            session.destroySession();
                        }
                        catch (I2PException i2PException) {
                            // empty catch block
                        }
                    }
                }
            }
            this.l.log("Stopping client " + this.toString());
            this.open = false;
            try {
                if (this.ss != null) {
                    this.ss.close();
                }
            }
            catch (IOException ex) {
                if (this._log.shouldDebug()) {
                    this._log.debug("error closing", ex);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized boolean destroy() {
        I2PSocketManager sm;
        this.close(true);
        if (this._ownDest && (sm = this.sockMgr) != null) {
            sm.destroySocketManager();
        }
        return true;
    }

    public static void closeSocket(Socket s) {
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected abstract void clientConnectionRun(Socket var1);

    static {
        _socketManagerState = SocketManagerState.INIT;
    }

    private class BlockingRunner
    implements Runnable {
        private final Socket _s;

        public BlockingRunner(Socket s) {
            this._s = s;
        }

        @Override
        public void run() {
            try {
                I2PTunnelClientBase.this.clientConnectionRun(this._s);
            }
            catch (Throwable t) {
                I2PTunnelClientBase.this._log.error("Uncaught error in i2ptunnel client", t);
            }
        }
    }

    private static enum SocketManagerState {
        INIT,
        CONNECTED;

    }
}

