/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import net.i2p.I2PAppContext;
import net.i2p.util.InternalServerSocket;

public class InternalSocket
extends Socket {
    private InputStream _is;
    private OutputStream _os;
    private final int _port;

    InternalSocket(InputStream is, OutputStream os) {
        this._is = is;
        this._os = os;
        this._port = 1;
    }

    public InternalSocket(int port) throws IOException {
        if (port <= 0) {
            throw new IOException("bad port number");
        }
        this._port = port;
        InternalServerSocket.internalConnect(port, this);
    }

    public static Socket getSocket(String host, int port) throws IOException {
        if (I2PAppContext.getGlobalContext().isRouterContext() && (host.equals("127.0.0.1") || host.equals("localhost"))) {
            try {
                return new InternalSocket(port);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new Socket(host, port);
    }

    @Override
    public InputStream getInputStream() {
        return this._is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this._os;
    }

    void setInputStream(InputStream is) {
        this._is = is;
    }

    void setOutputStream(OutputStream os) {
        this._os = os;
    }

    @Override
    public synchronized void close() {
        try {
            if (this._is != null) {
                this._is.close();
                this._is = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this._os != null) {
                this._os.close();
                this._os = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this._is == null || this._os == null;
    }

    @Override
    public String toString() {
        return "Internal socket";
    }

    @Override
    public void setSoTimeout(int timeout) {
    }

    @Override
    public int getSoTimeout() {
        return 0;
    }

    @Override
    @Deprecated
    public void bind(SocketAddress endpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void connect(SocketAddress endpoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void connect(SocketAddress endpoint, int timeout) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public SocketChannel getChannel() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public InetAddress getInetAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean getKeepAlive() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public InetAddress getLocalAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLocalPort() {
        return this.isConnected() ? 1 : -1;
    }

    @Override
    @Deprecated
    public SocketAddress getLocalSocketAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean getOOBInline() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPort() {
        return this.isConnected() ? this._port : 0;
    }

    @Override
    @Deprecated
    public int getReceiveBufferSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public SocketAddress getRemoteSocketAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean getReuseAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int getSendBufferSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSoLinger() {
        return -1;
    }

    @Override
    @Deprecated
    public boolean getTcpNoDelay() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int getTrafficClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean isBound() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean isConnected() {
        return this._is != null || this._os != null;
    }

    @Override
    public synchronized boolean isInputShutdown() {
        return this._is == null;
    }

    @Override
    public synchronized boolean isOutputShutdown() {
        return this._os == null;
    }

    @Override
    @Deprecated
    public void sendUrgentData(int data) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setKeepAlive(boolean on) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setOOBInline(boolean on) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setReceiveBufferSize(int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setReuseAddress(boolean on) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setSendBufferSize(int size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSoLinger(boolean on, int linger) {
    }

    @Override
    @Deprecated
    public void setTcpNoDelay(boolean on) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setTrafficClass(int cize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void shutdownInput() throws IOException {
        if (this._is != null) {
            this._is.close();
            this._is = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownOutput() throws IOException {
        OutputStream out;
        InternalSocket internalSocket = this;
        synchronized (internalSocket) {
            out = this._os;
        }
        if (out == null) {
            return;
        }
        try {
            out.flush();
            out.close();
        }
        finally {
            internalSocket = this;
            synchronized (internalSocket) {
                this._os = null;
            }
        }
    }
}

