/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import net.i2p.I2PAppContext;
import net.i2p.crypto.KeyStoreUtil;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.util.PublicSuffixList;
import org.apache.http.conn.util.PublicSuffixListParser;
import org.apache.http.conn.util.PublicSuffixMatcher;

public class I2PSSLSocketFactory {
    private static final String PROP_DISABLE = "i2p.disableSSLHostnameVerification";
    private static final String PROP_GEOIP_DIR = "geoip.dir";
    private static final String GEOIP_DIR_DEFAULT = "geoip";
    private static final String GEOIP_FILE_DEFAULT = "geoip.txt";
    private static final String COUNTRY_FILE_DEFAULT = "countries.txt";
    private static final String PUBLIC_SUFFIX_LIST = "public-suffix-list.txt";
    private static PublicSuffixMatcher DEFAULT_MATCHER;
    private static boolean _matcherLoaded;
    private static final String[] DEFAULT_TLDS;
    private static final String[] ADDITIONAL_TLDS;
    public static final List<String> EXCLUDE_PROTOCOLS;
    public static final List<String> INCLUDE_PROTOCOLS;
    public static final List<String> EXCLUDE_CIPHERS;
    public static final List<String> INCLUDE_CIPHERS;
    private final SSLSocketFactory _factory;
    private final I2PAppContext _context;

    public I2PSSLSocketFactory(I2PAppContext context, boolean loadSystemCerts, String relativeCertPath) throws GeneralSecurityException {
        this._factory = I2PSSLSocketFactory.initSSLContext(context, loadSystemCerts, relativeCertPath);
        this._context = context;
    }

    public Socket createSocket(String host, int port) throws IOException {
        SSLSocket rv = (SSLSocket)this._factory.createSocket(host, port);
        I2PSSLSocketFactory.setProtocolsAndCiphers(rv);
        I2PSSLSocketFactory.verifyHostname(this._context, rv, host);
        return rv;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket rv = (SSLSocket)this._factory.createSocket(host, port);
        I2PSSLSocketFactory.setProtocolsAndCiphers(rv);
        String name = host.getHostName();
        I2PSSLSocketFactory.verifyHostname(this._context, rv, name);
        return rv;
    }

    public static void verifyHostname(I2PAppContext ctx, SSLSocket socket, String host) throws SSLException {
        SSLSession sess;
        Log log = ctx.logManager().getLog(I2PSSLSocketFactory.class);
        if (ctx.getBooleanProperty(PROP_DISABLE) || host.equals("localhost") || host.equals("127.0.0.1") || host.equals("::1") || host.equals("0:0:0:0:0:0:0:1")) {
            if (log.shouldWarn()) {
                log.warn("Skipping hostname validation for " + host);
            }
            return;
        }
        HostnameVerifier hv = SystemVersion.isAndroid() ? HttpsURLConnection.getDefaultHostnameVerifier() : new DefaultHostnameVerifier(I2PSSLSocketFactory.getDefaultMatcher(ctx));
        if (!hv.verify(host, sess = socket.getSession())) {
            throw new SSLHandshakeException("SSL hostname verify failed, Expected " + host + " - set " + PROP_DISABLE + "=true to disable verification (dangerous!)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PublicSuffixMatcher getDefaultMatcher(I2PAppContext ctx) {
        Class<I2PSSLSocketFactory> clazz = I2PSSLSocketFactory.class;
        synchronized (I2PSSLSocketFactory.class) {
            if (!_matcherLoaded) {
                String geoDir = ctx.getProperty(PROP_GEOIP_DIR, GEOIP_DIR_DEFAULT);
                File geoFile = new File(geoDir);
                if (!geoFile.isAbsolute()) {
                    geoFile = new File(ctx.getBaseDir(), geoDir);
                }
                geoFile = new File(geoFile, PUBLIC_SUFFIX_LIST);
                Log log = ctx.logManager().getLog(I2PSSLSocketFactory.class);
                if (geoFile.exists()) {
                    try {
                        long begin = System.currentTimeMillis();
                        FileInputStream in = null;
                        PublicSuffixList list = new PublicSuffixList(Arrays.asList(ADDITIONAL_TLDS), Collections.emptyList());
                        try {
                            in = new FileInputStream(geoFile);
                            PublicSuffixList list2 = new PublicSuffixListParser().parse(new InputStreamReader((InputStream)in, "UTF-8"));
                            list = I2PSSLSocketFactory.merge(list, list2);
                        }
                        finally {
                            try {
                                if (in != null) {
                                    ((InputStream)in).close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                        DEFAULT_MATCHER = new PublicSuffixMatcher(list.getRules(), list.getExceptions());
                        if (log.shouldWarn()) {
                            log.warn("Loaded " + geoFile + " in " + (System.currentTimeMillis() - begin) + " ms and created list with " + list.getRules().size() + " entries and " + list.getExceptions().size() + " exceptions");
                        }
                    }
                    catch (IOException ex) {
                        log.error("Failure loading public suffix list from " + geoFile, ex);
                    }
                } else {
                    ArrayList<String> list = new ArrayList<String>(320);
                    I2PSSLSocketFactory.addCountries(ctx, list);
                    list.addAll(Arrays.asList(DEFAULT_TLDS));
                    list.addAll(Arrays.asList(ADDITIONAL_TLDS));
                    DEFAULT_MATCHER = new PublicSuffixMatcher(list, null);
                    if (log.shouldWarn()) {
                        log.warn("No public suffix list found at " + geoFile + " - created default with " + list.size() + " entries");
                    }
                }
            }
            _matcherLoaded = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return DEFAULT_MATCHER;
        }
    }

    private static PublicSuffixList merge(PublicSuffixList a, PublicSuffixList b) {
        List<String> ar = a.getRules();
        List<String> ae = a.getExceptions();
        List<String> br = b.getRules();
        List<String> be = b.getExceptions();
        ArrayList<String> cr = new ArrayList<String>(ar.size() + br.size());
        ArrayList<String> ce = new ArrayList<String>(ae.size() + be.size());
        cr.addAll(ar);
        cr.addAll(br);
        ce.addAll(ae);
        ce.addAll(be);
        return new PublicSuffixList(cr, ce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCountries(I2PAppContext ctx, List<String> tlds) {
        Log log = ctx.logManager().getLog(I2PSSLSocketFactory.class);
        String geoDir = ctx.getProperty(PROP_GEOIP_DIR, GEOIP_DIR_DEFAULT);
        File geoFile = new File(geoDir);
        if (!geoFile.isAbsolute()) {
            geoFile = new File(ctx.getBaseDir(), geoDir);
        }
        if (!(geoFile = new File(geoFile, COUNTRY_FILE_DEFAULT)).exists()) {
            if (log.shouldWarn()) {
                log.warn("Country file not found: " + geoFile.getAbsolutePath());
            }
            return;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(geoFile), "UTF-8"));
            String line = null;
            int i = 0;
            while ((line = br.readLine()) != null) {
                try {
                    if (line.charAt(0) == '#') continue;
                    String[] s = DataHelper.split(line, ",");
                    String lc = s[0].toLowerCase(Locale.US);
                    tlds.add(lc);
                    ++i;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            }
            if (log.shouldInfo()) {
                log.info("Loaded " + i + " TLDs from " + geoFile.getAbsolutePath());
            }
        }
        catch (IOException ioe) {
            log.error("Error reading the Country File", ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static SSLSocketFactory initSSLContext(I2PAppContext context, boolean loadSystemCerts, String relativeCertPath) throws GeneralSecurityException {
        int adds;
        KeyStore ks;
        Log log = context.logManager().getLog(I2PSSLSocketFactory.class);
        if (loadSystemCerts) {
            ks = KeyStoreUtil.loadSystemKeyStore();
            if (ks == null) {
                throw new GeneralSecurityException("Key Store init error");
            }
        } else {
            try {
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, "".toCharArray());
            }
            catch (IOException ioe) {
                throw new GeneralSecurityException("Key Store init error", ioe);
            }
        }
        File dir = new File(context.getConfigDir(), relativeCertPath);
        int totalAdds = adds = KeyStoreUtil.addCerts(dir, ks);
        if (adds > 0 && log.shouldLog(20)) {
            log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
        }
        File dir2 = new File(context.getBaseDir(), relativeCertPath);
        if (!dir.getAbsolutePath().equals(dir2.getAbsolutePath())) {
            adds = KeyStoreUtil.addCerts(dir2, ks);
            totalAdds += adds;
            if (adds > 0 && log.shouldLog(20)) {
                log.info("Loaded " + adds + " trusted certificates from " + dir.getAbsolutePath());
            }
        }
        if (totalAdds > 0 || loadSystemCerts) {
            if (log.shouldLog(20)) {
                log.info("Loaded total of " + totalAdds + " new trusted certificates");
            }
        } else {
            String msg = "No trusted certificates loaded (looked in " + dir.getAbsolutePath() + (dir.getAbsolutePath().equals(dir2.getAbsolutePath()) ? "" : " and " + dir2.getAbsolutePath()) + ", SSL connections will fail. Copy the cert in " + relativeCertPath + " from the router to the directory.";
            throw new GeneralSecurityException(msg);
        }
        SSLContext sslc = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        sslc.init(null, tmf.getTrustManagers(), context.random());
        return sslc.getSocketFactory();
    }

    public static void setProtocolsAndCiphers(SSLSocket socket) {
        socket.setEnabledProtocols(I2PSSLSocketFactory.selectProtocols(socket.getEnabledProtocols(), socket.getSupportedProtocols()));
        socket.setEnabledCipherSuites(I2PSSLSocketFactory.selectCipherSuites(socket.getEnabledCipherSuites(), socket.getSupportedCipherSuites()));
    }

    public static void setProtocolsAndCiphers(SSLServerSocket socket) {
        String[] p = I2PSSLSocketFactory.selectProtocols(socket.getEnabledProtocols(), socket.getSupportedProtocols());
        for (int i = 0; i < p.length; ++i) {
            if (!p[i].equals("SSLv3")) continue;
            return;
        }
        socket.setEnabledProtocols(p);
        socket.setEnabledCipherSuites(I2PSSLSocketFactory.selectCipherSuites(socket.getEnabledCipherSuites(), socket.getSupportedCipherSuites()));
    }

    private static String[] selectProtocols(String[] enabledProtocols, String[] supportedProtocols) {
        return I2PSSLSocketFactory.select(enabledProtocols, supportedProtocols, INCLUDE_PROTOCOLS, EXCLUDE_PROTOCOLS);
    }

    private static String[] selectCipherSuites(String[] enabledCipherSuites, String[] supportedCipherSuites) {
        return I2PSSLSocketFactory.select(enabledCipherSuites, supportedCipherSuites, INCLUDE_CIPHERS, EXCLUDE_CIPHERS);
    }

    private static String[] select(String[] enabledArr, String[] supportedArr, List<String> toEnable, List<String> toExclude) {
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(I2PSSLSocketFactory.class);
        HashSet<String> selected = new HashSet<String>(enabledArr.length);
        selected.addAll(Arrays.asList(enabledArr));
        selected.removeAll(toExclude);
        HashSet<String> supported = new HashSet<String>(supportedArr.length);
        supported.addAll(Arrays.asList(supportedArr));
        for (String s : toEnable) {
            if (supported.contains(s)) {
                if (!selected.add(s) || !log.shouldLog(20)) continue;
                log.info("Added, previously disabled: " + s);
                continue;
            }
            if (!log.shouldLog(20)) continue;
            log.info("Not supported in this JVM: " + s);
        }
        if (selected.isEmpty()) {
            log.logAlways(30, "No TLS support for SSLEepGet, falling back");
            return enabledArr;
        }
        if (log.shouldLog(10)) {
            ArrayList foo = new ArrayList(selected);
            Collections.sort(foo);
            log.debug("Selected: " + foo);
        }
        return selected.toArray(new String[selected.size()]);
    }

    static {
        DEFAULT_TLDS = new String[]{"arpa", "asia", "biz", "cat", "com", "coop", "edu", "gov", "info", "int", "jobs", "mil", "mobi", "museum", "name", "net", "org", "post", "pro", "tel", "travel", "xxx"};
        ADDITIONAL_TLDS = new String[]{"i2p", "mooo.com", "onion"};
        EXCLUDE_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("SSLv2Hello", "SSLv3"));
        INCLUDE_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("TLSv1", "TLSv1.1", "TLSv1.2"));
        EXCLUDE_CIPHERS = Collections.unmodifiableList(Arrays.asList("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "SSL_DH_anon_WITH_DES_CBC_SHA", "SSL_DH_anon_WITH_RC4_128_MD5", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA", "TLS_DH_anon_WITH_AES_128_CBC_SHA256", "TLS_DH_anon_WITH_AES_128_GCM_SHA256", "TLS_DH_anon_WITH_AES_256_CBC_SHA", "TLS_DH_anon_WITH_AES_256_CBC_SHA256", "TLS_DH_anon_WITH_AES_256_GCM_SHA384", "TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "TLS_ECDH_anon_WITH_NULL_SHA", "TLS_ECDH_anon_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_NULL_SHA", "TLS_ECDHE_ECDSA_WITH_NULL_SHA", "TLS_ECDHE_RSA_WITH_NULL_SHA", "TLS_ECDH_RSA_WITH_NULL_SHA", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5", "TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA", "TLS_KRB5_EXPORT_WITH_RC4_40_MD5", "TLS_KRB5_EXPORT_WITH_RC4_40_SHA", "TLS_KRB5_WITH_3DES_EDE_CBC_MD5", "TLS_KRB5_WITH_3DES_EDE_CBC_SHA", "TLS_KRB5_WITH_DES_CBC_MD5", "TLS_KRB5_WITH_DES_CBC_SHA", "TLS_KRB5_WITH_RC4_128_MD5", "TLS_KRB5_WITH_RC4_128_SHA", "TLS_RSA_WITH_NULL_SHA256", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "TLS_ECDH_RSA_WITH_RC4_128_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA"));
        INCLUDE_CIPHERS = Collections.emptyList();
    }
}

