/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.socks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import net.i2p.socks.SOCKSException;
import org.apache.http.conn.util.InetAddressUtils;

public class SOCKS5Client {
    private SOCKS5Client() {
    }

    public static void connect(Socket sock, String connHostName, int connPort) throws IOException {
        SOCKS5Client.connect(sock, connHostName, connPort, null, null);
    }

    public static void connect(Socket sock, String connHostName, int connPort, String configUser, String configPW) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = sock.getInputStream();
            out = sock.getOutputStream();
            SOCKS5Client.connect(in, out, connHostName, connPort, configUser, configPW);
        }
        catch (IOException e) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static void connect(InputStream pin, OutputStream pout, String connHostName, int connPort) throws IOException {
        SOCKS5Client.connect(pin, pout, connHostName, connPort, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void connect(InputStream pin, OutputStream pout, String connHostName, int connPort, String configUser, String configPW) throws IOException {
        DataOutputStream out = null;
        FilterInputStream in = null;
        try {
            out = new DataOutputStream(pout);
            boolean authAvail = configUser != null && configPW != null;
            out.writeByte(5);
            if (authAvail) {
                out.writeByte(2);
                out.writeByte(0);
                out.writeByte(2);
            } else {
                out.writeByte(1);
                out.writeByte(0);
            }
            out.flush();
            in = new DataInputStream(pin);
            byte hisVersion = ((DataInputStream)in).readByte();
            if (hisVersion != 5) {
                throw new SOCKSException("SOCKS proxy is not Version 5");
            }
            byte method = ((DataInputStream)in).readByte();
            if (method != 0) {
                if (method != 2) throw new SOCKSException("Proxy authorization failure");
                if (!authAvail) throw new SOCKSException("Proxy requires authorization, please configure username/password");
                out.writeByte(1);
                byte[] user = configUser.getBytes("UTF-8");
                byte[] pw = configPW.getBytes("UTF-8");
                out.writeByte(user.length);
                out.write(user);
                out.writeByte(pw.length);
                out.write(pw);
                out.flush();
                if (((DataInputStream)in).readByte() != 1) {
                    throw new SOCKSException("Bad auth version from proxy");
                }
                if (((DataInputStream)in).readByte() != 0) {
                    throw new SOCKSException("Proxy authorization failure");
                }
            }
            int addressType = InetAddressUtils.isIPv4Address(connHostName) ? 1 : (InetAddressUtils.isIPv6Address(connHostName) ? 4 : 3);
            out.writeByte(5);
            out.writeByte(1);
            out.writeByte(0);
            out.writeByte(addressType);
            if (addressType == 1 || addressType == 4) {
                out.write(InetAddress.getByName(connHostName).getAddress());
            } else {
                byte[] d = connHostName.getBytes("ISO-8859-1");
                out.writeByte(d.length);
                out.write(d);
            }
            out.writeShort(connPort);
            out.flush();
            hisVersion = ((DataInputStream)in).readByte();
            if (hisVersion != 5) {
                throw new SOCKSException("Proxy response is not Version 5");
            }
            byte reply = ((DataInputStream)in).readByte();
            ((DataInputStream)in).readByte();
            byte type = ((DataInputStream)in).readByte();
            int count = 0;
            if (type == 1) {
                count = 4;
            } else if (type == 3) {
                count = ((DataInputStream)in).readUnsignedByte();
            } else {
                if (type != 4) throw new SOCKSException("Unsupported address type in proxy response");
                count = 16;
            }
            byte[] addr = new byte[count];
            ((DataInputStream)in).readFully(addr);
            ((DataInputStream)in).readUnsignedShort();
            if (reply == 0) return;
            throw new SOCKSException("Proxy rejected request, response = " + reply);
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (out == null) throw e;
            try {
                out.close();
                throw e;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }
}

