/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.socks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import net.i2p.socks.SOCKSException;
import org.apache.http.conn.util.InetAddressUtils;

public class SOCKS4Client {
    private SOCKS4Client() {
    }

    public static void connect(Socket sock, String connHostName, int connPort) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = sock.getInputStream();
            out = sock.getOutputStream();
            SOCKS4Client.connect(in, out, connHostName, connPort);
        }
        catch (IOException e) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static void connect(InputStream pin, OutputStream pout, String connHostName, int connPort) throws IOException {
        DataOutputStream out = null;
        FilterInputStream in = null;
        try {
            boolean isIPv4;
            out = new DataOutputStream(pout);
            out.writeByte(4);
            out.writeByte(1);
            out.writeShort(connPort);
            if (InetAddressUtils.isIPv4Address(connHostName)) {
                isIPv4 = true;
                out.write(InetAddress.getByName(connHostName).getAddress());
            } else {
                if (InetAddressUtils.isIPv6Address(connHostName)) {
                    throw new SOCKSException("IPv6 not supported in SOCKS 4");
                }
                isIPv4 = false;
                out.writeInt(1);
            }
            out.writeByte(0);
            if (!isIPv4) {
                byte[] d = connHostName.getBytes("ISO-8859-1");
                out.write(d);
                out.writeByte(0);
            }
            out.flush();
            in = new DataInputStream(pin);
            ((DataInputStream)in).readByte();
            byte reply = ((DataInputStream)in).readByte();
            if (reply != 90) {
                throw new SOCKSException("Proxy rejected request, response = " + reply);
            }
            ((DataInputStream)in).readShort();
            ((DataInputStream)in).readInt();
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }
}

