/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.KeyCertificate;
import net.i2p.data.SDSCache;
import net.i2p.data.SimpleDataStructure;

public class SigningPublicKey
extends SimpleDataStructure {
    private static final SigType DEF_TYPE = SigType.DSA_SHA1;
    public static final int KEYSIZE_BYTES = DEF_TYPE.getPubkeyLen();
    private static final int CACHE_SIZE = 1024;
    private static final SDSCache<SigningPublicKey> _cache = new SDSCache<SigningPublicKey>(SigningPublicKey.class, KEYSIZE_BYTES, 1024);
    private final SigType _type;

    public static SigningPublicKey create(byte[] data, int off) {
        return _cache.get(data, off);
    }

    public static SigningPublicKey create(InputStream in) throws IOException {
        return _cache.get(in);
    }

    public SigningPublicKey() {
        this(DEF_TYPE);
    }

    public SigningPublicKey(SigType type) {
        this._type = type;
    }

    public SigningPublicKey(byte[] data) {
        this(DEF_TYPE, data);
    }

    public SigningPublicKey(SigType type, byte[] data) {
        this._type = type;
        if (type != null || data == null) {
            this.setData(data);
        } else {
            this._data = data;
        }
    }

    public SigningPublicKey(String base64Data) throws DataFormatException {
        this();
        this.fromBase64(base64Data);
    }

    @Override
    public int length() {
        if (this._type != null) {
            return this._type.getPubkeyLen();
        }
        if (this._data != null) {
            return this._data.length;
        }
        return KEYSIZE_BYTES;
    }

    public SigType getType() {
        return this._type;
    }

    public SigningPublicKey toTypedKey(KeyCertificate kcert) {
        if (this._data == null) {
            throw new IllegalStateException();
        }
        SigType newType = kcert.getSigType();
        if (this._type == newType) {
            return this;
        }
        if (this._type != SigType.DSA_SHA1) {
            throw new IllegalArgumentException("Cannot convert " + (Object)((Object)this._type) + " to " + (Object)((Object)newType));
        }
        if (newType == null) {
            return new SigningPublicKey(null, this._data);
        }
        int newLen = newType.getPubkeyLen();
        int ctype = kcert.getCryptoTypeCode();
        if (ctype == 0) {
            int sz = 7;
            if (newLen > KEYSIZE_BYTES) {
                sz += newLen - KEYSIZE_BYTES;
            }
            if (kcert.size() != sz) {
                throw new IllegalArgumentException("Excess data in key certificate");
            }
        }
        if (newLen == KEYSIZE_BYTES) {
            return new SigningPublicKey(newType, this._data);
        }
        byte[] newData = new byte[newLen];
        if (newLen < KEYSIZE_BYTES) {
            System.arraycopy(this._data, this._data.length - newLen, newData, 0, newLen);
        } else {
            System.arraycopy(this._data, 0, newData, 0, this._data.length);
            System.arraycopy(kcert.getPayload(), 4, newData, this._data.length, newLen - this._data.length);
        }
        return new SigningPublicKey(newType, newData);
    }

    public byte[] getPadding(KeyCertificate kcert) {
        if (this._data == null) {
            throw new IllegalStateException();
        }
        SigType newType = kcert.getSigType();
        if (this._type == newType || newType == null) {
            return null;
        }
        if (this._type != SigType.DSA_SHA1) {
            throw new IllegalStateException("Cannot convert " + (Object)((Object)this._type) + " to " + (Object)((Object)newType));
        }
        int newLen = newType.getPubkeyLen();
        if (newLen >= KEYSIZE_BYTES) {
            return null;
        }
        int padLen = KEYSIZE_BYTES - newLen;
        byte[] pad = new byte[padLen];
        System.arraycopy(this._data, 0, pad, 0, padLen);
        return pad;
    }

    public void writeTruncatedBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._data == null) {
            throw new DataFormatException("No data to write out");
        }
        if (this._data.length <= KEYSIZE_BYTES) {
            out.write(this._data);
        } else {
            out.write(this._data, 0, KEYSIZE_BYTES);
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append('[').append(this.getClass().getSimpleName()).append(' ').append((Object)this._type).append(": ");
        if (this._data == null) {
            buf.append("null");
        } else {
            buf.append("size: ").append(Integer.toString(this.length()));
        }
        buf.append(']');
        return buf.toString();
    }

    public static void clearCache() {
        _cache.clear();
    }

    @Override
    public int hashCode() {
        return DataHelper.hashCode((Object)this._type) ^ super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SigningPublicKey)) {
            return false;
        }
        SigningPublicKey s = (SigningPublicKey)obj;
        return this._type == s._type && Arrays.equals(this._data, s._data);
    }
}

