/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import java.io.EOFException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.impl.HandlerImpl;
import net.i2p.client.impl.I2PSessionImpl;
import net.i2p.client.impl.SubSession;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.RequestLeaseSetMessage;

class RequestLeaseSetMessageHandler
extends HandlerImpl {
    private final Map<Destination, LeaseInfo> _existingLeaseSets = new ConcurrentHashMap<Destination, LeaseInfo>(4);

    public RequestLeaseSetMessageHandler(I2PAppContext context) {
        this(context, 21);
    }

    protected RequestLeaseSetMessageHandler(I2PAppContext context, int messageType) {
        super(context, messageType);
    }

    @Override
    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle message " + message);
        }
        RequestLeaseSetMessage msg = (RequestLeaseSetMessage)message;
        LeaseSet leaseSet = new LeaseSet();
        for (int i = 0; i < msg.getEndpoints(); ++i) {
            Lease lease = new Lease();
            lease.setGateway(msg.getRouter(i));
            lease.setTunnelId(msg.getTunnelId(i));
            lease.setEndDate(msg.getEndDate());
            leaseSet.addLease(lease);
        }
        this.signLeaseSet(leaseSet, session);
    }

    protected synchronized void signLeaseSet(LeaseSet leaseSet, I2PSessionImpl session) {
        Destination dest = session.getMyDestination();
        leaseSet.setDestination(dest);
        LeaseInfo li = this._existingLeaseSets.get(dest);
        if (li == null) {
            String spk = session.getOptions().getProperty("i2cp.leaseSetPrivateKey");
            String sspk = session.getOptions().getProperty("i2cp.leaseSetSigningPrivateKey");
            PrivateKey privKey = null;
            SigningPrivateKey signingPrivKey = null;
            if (spk != null && sspk != null) {
                boolean useOldKeys = true;
                int colon = sspk.indexOf(58);
                SigType type = dest.getSigType();
                if (colon > 0) {
                    String stype = sspk.substring(0, colon);
                    SigType t = SigType.parseSigType(stype);
                    if (t == type) {
                        sspk = sspk.substring(colon + 1);
                    } else {
                        useOldKeys = false;
                    }
                }
                if ((colon = spk.indexOf(58)) >= 0) {
                    spk = spk.substring(colon + 1);
                }
                if (useOldKeys) {
                    try {
                        signingPrivKey = new SigningPrivateKey(type);
                        signingPrivKey.fromBase64(sspk);
                    }
                    catch (DataFormatException iae) {
                        useOldKeys = false;
                        signingPrivKey = null;
                    }
                }
                if (useOldKeys) {
                    try {
                        privKey = new PrivateKey();
                        privKey.fromBase64(spk);
                    }
                    catch (DataFormatException iae) {
                        privKey = null;
                    }
                }
            }
            if (privKey == null && !this._existingLeaseSets.isEmpty()) {
                PublicKey pk = dest.getPublicKey();
                for (Map.Entry<Destination, LeaseInfo> e : this._existingLeaseSets.entrySet()) {
                    if (!pk.equals(e.getKey().getPublicKey())) continue;
                    privKey = e.getValue().getPrivateKey();
                    if (!this._log.shouldLog(10)) break;
                    this._log.debug("Creating new leaseInfo keys for " + dest + " with private key from " + e.getKey());
                    break;
                }
            }
            if (privKey != null) {
                if (signingPrivKey != null) {
                    li = new LeaseInfo(privKey, signingPrivKey);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Creating new leaseInfo keys for " + dest + " WITH configured private keys");
                    }
                } else {
                    li = new LeaseInfo(privKey, dest);
                }
            } else {
                li = new LeaseInfo(dest);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Creating new leaseInfo keys for " + dest + " without configured private keys");
                }
            }
            this._existingLeaseSets.put(dest, li);
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Caching the old leaseInfo keys for " + dest);
        }
        leaseSet.setEncryptionKey(li.getPublicKey());
        leaseSet.setSigningKey(li.getSigningPublicKey());
        Properties opts = session instanceof SubSession ? ((SubSession)session).getPrimaryOptions() : session.getOptions();
        boolean encrypt = Boolean.parseBoolean(opts.getProperty("i2cp.encryptLeaseSet"));
        String sk = opts.getProperty("i2cp.leaseSetKey");
        Hash h = dest.calculateHash();
        if (encrypt && sk != null) {
            SessionKey key = new SessionKey();
            try {
                key.fromBase64(sk);
                leaseSet.encrypt(key);
                this._context.keyRing().put(h, key);
            }
            catch (DataFormatException dfe) {
                this._log.error("Bad leaseset key: " + sk);
                this._context.keyRing().remove(h);
            }
        } else {
            this._context.keyRing().remove(h);
        }
        try {
            leaseSet.sign(session.getPrivateKey());
            SigningPrivateKey spk = li.getSigningPrivateKey();
            if (!this._context.isRouterContext() && spk.getType() != SigType.DSA_SHA1) {
                byte[] dummy = new byte[SigningPrivateKey.KEYSIZE_BYTES];
                this._context.random().nextBytes(dummy);
                spk = new SigningPrivateKey(dummy);
            }
            session.getProducer().createLeaseSet(session, leaseSet, spk, li.getPrivateKey());
            session.setLeaseSet(leaseSet);
        }
        catch (DataFormatException dfe) {
            session.propogateError("Error signing the leaseSet", dfe);
        }
        catch (I2PSessionException ise) {
            if (session.isClosed()) {
                EOFException eof = new EOFException("Session closed while signing leaseset");
                eof.initCause(ise);
                session.propogateError("Session closed while signing leaseset", eof);
            }
            session.propogateError("Error sending the signed leaseSet", ise);
        }
    }

    private static class LeaseInfo {
        private final PublicKey _pubKey;
        private final PrivateKey _privKey;
        private final SigningPublicKey _signingPubKey;
        private final SigningPrivateKey _signingPrivKey;

        public LeaseInfo(Destination dest) {
            SimpleDataStructure[] signKeys;
            SimpleDataStructure[] encKeys = KeyGenerator.getInstance().generatePKIKeys();
            try {
                signKeys = KeyGenerator.getInstance().generateSigningKeys(dest.getSigningPublicKey().getType());
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalStateException(gse);
            }
            this._pubKey = (PublicKey)encKeys[0];
            this._privKey = (PrivateKey)encKeys[1];
            this._signingPubKey = (SigningPublicKey)signKeys[0];
            this._signingPrivKey = (SigningPrivateKey)signKeys[1];
        }

        public LeaseInfo(PrivateKey privKey, SigningPrivateKey signingPrivKey) {
            this._pubKey = KeyGenerator.getPublicKey(privKey);
            this._privKey = privKey;
            this._signingPubKey = KeyGenerator.getSigningPublicKey(signingPrivKey);
            this._signingPrivKey = signingPrivKey;
        }

        public LeaseInfo(PrivateKey privKey, Destination dest) {
            SimpleDataStructure[] signKeys;
            try {
                signKeys = KeyGenerator.getInstance().generateSigningKeys(dest.getSigningPublicKey().getType());
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalStateException(gse);
            }
            this._pubKey = KeyGenerator.getPublicKey(privKey);
            this._privKey = privKey;
            this._signingPubKey = (SigningPublicKey)signKeys[0];
            this._signingPrivKey = (SigningPrivateKey)signKeys[1];
        }

        public PublicKey getPublicKey() {
            return this._pubKey;
        }

        public PrivateKey getPrivateKey() {
            return this._privKey;
        }

        public SigningPublicKey getSigningPublicKey() {
            return this._signingPubKey;
        }

        public SigningPrivateKey getSigningPrivateKey() {
            return this._signingPrivKey;
        }

        public int hashCode() {
            return DataHelper.hashCode(this._pubKey) + 7 * DataHelper.hashCode(this._privKey) + 49 * DataHelper.hashCode(this._signingPubKey) + 343 * DataHelper.hashCode(this._signingPrivKey);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof LeaseInfo)) {
                return false;
            }
            LeaseInfo li = (LeaseInfo)obj;
            return DataHelper.eq(this._pubKey, li.getPublicKey()) && DataHelper.eq(this._privKey, li.getPrivateKey()) && DataHelper.eq(this._signingPubKey, li.getSigningPublicKey()) && DataHelper.eq(this._signingPrivKey, li.getSigningPrivateKey());
        }
    }
}

