/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import org.apache.http.conn.util.InetAddressUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class HostCheckHandler
extends HandlerWrapper {
    private final I2PAppContext _context;
    private final Set<String> _listenHosts;

    public HostCheckHandler(I2PAppContext ctx) {
        this._context = ctx;
        this._listenHosts = new HashSet<String>(8);
    }

    public void setListenHosts(Set<String> hosts) {
        this._listenHosts.clear();
        this._listenHosts.addAll(hosts);
    }

    public void handle(String pathInContext, Request baseRequest, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        String host = httpRequest.getHeader("Host");
        if (!this.allowHost(host)) {
            Log log = this._context.logManager().getLog(HostCheckHandler.class);
            host = DataHelper.stripHTML(HostCheckHandler.getHost(host));
            String s = "Console request denied.\n    To allow access using the hostname \"" + host + "\", add the line \"" + "routerconsole.allowedHosts" + '=' + host + "\" to advanced configuration and restart.";
            log.logAlways(30, s);
            httpResponse.sendError(403, s);
            return;
        }
        super.handle(pathInContext, baseRequest, httpRequest, httpResponse);
    }

    private boolean allowHost(String host) {
        if (host == null) {
            return true;
        }
        if (host.equals("127.0.0.1:7657") || host.equals("localhost:7657")) {
            return true;
        }
        if (this._listenHosts.isEmpty()) {
            return true;
        }
        if (this._listenHosts.contains(host = HostCheckHandler.getHost(host))) {
            return true;
        }
        return InetAddressUtils.isIPv4Address(host) || InetAddressUtils.isIPv6Address(host);
    }

    private static String getHost(String host) {
        if (host.startsWith("[")) {
            int brack = (host = host.substring(1)).indexOf(93);
            if (brack >= 0) {
                host = host.substring(0, brack);
            }
        } else {
            int colon = host.indexOf(58);
            if (colon >= 0) {
                host = host.substring(0, colon);
            }
        }
        return host;
    }
}

