/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.news;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.router.news.NewsEntry;
import net.i2p.router.news.PersistNews;
import net.i2p.router.news.RFC3339Date;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import net.i2p.util.TranslateReader;
import org.cybergarage.xml.Node;

public class NewsManager
implements ClientApp {
    private final I2PAppContext _context;
    private final Log _log;
    private final ClientAppManager _cmgr;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;
    private List<NewsEntry> _currentNews;
    public static final String APP_NAME = "news";
    private static final String BUNDLE_NAME = "net.i2p.router.news.messages";

    public NewsManager(I2PAppContext ctx, ClientAppManager listener, String[] args) {
        this._context = ctx;
        this._cmgr = listener;
        this._log = ctx.logManager().getLog(NewsManager.class);
        this._state = ClientAppState.INITIALIZED;
    }

    public synchronized List<NewsEntry> getEntries() {
        List<NewsEntry> rv;
        if (!this._currentNews.isEmpty()) {
            return new ArrayList<NewsEntry>(this._currentNews);
        }
        if (this._log.shouldWarn()) {
            this._log.warn("no real XML, falling back to news.xml");
        }
        if (!(rv = this.parseOldNews()).isEmpty()) {
            this._currentNews = rv;
            return rv;
        }
        if (this._log.shouldWarn()) {
            this._log.warn("no news.xml, falling back to initialNews");
        }
        return this.parseInitialNews();
    }

    public synchronized boolean storeEntries(List<Node> entries) {
        return PersistNews.store(this._context, entries);
    }

    public synchronized void addEntries(List<NewsEntry> entries) {
        for (NewsEntry e : entries) {
            String id = e.id;
            if (id == null) continue;
            String title = e.title;
            boolean found = false;
            for (int i = 0; i < this._currentNews.size(); ++i) {
                NewsEntry old = this._currentNews.get(i);
                if (!id.equals(old.id) && (title == null || !title.equals(old.id))) continue;
                this._currentNews.set(i, e);
                found = true;
                break;
            }
            if (found) continue;
            this._currentNews.add(e);
        }
        Collections.sort(this._currentNews);
    }

    @Override
    public synchronized void startup() {
        this.changeState(ClientAppState.STARTING);
        this._currentNews = PersistNews.load(this._context);
        if (this._log.shouldWarn()) {
            this._log.warn("Initialized with " + this._currentNews.size() + " entries");
        }
        this.changeState(ClientAppState.RUNNING);
        if (this._cmgr != null) {
            this._cmgr.register(this);
        }
    }

    @Override
    public synchronized void shutdown(String[] args) {
        this.changeState(ClientAppState.STOPPED);
    }

    @Override
    public ClientAppState getState() {
        return this._state;
    }

    @Override
    public String getName() {
        return APP_NAME;
    }

    @Override
    public String getDisplayName() {
        return "News Manager";
    }

    private synchronized void changeState(ClientAppState state) {
        this._state = state;
        if (this._cmgr != null) {
            this._cmgr.notify(this, state, null, null);
        }
    }

    private List<NewsEntry> parseOldNews() {
        File file = new File(this._context.getConfigDir(), "docs/news.xml");
        String newsContent = FileUtil.readTextFile(file.toString(), -1, true);
        if (newsContent == null || newsContent.equals("")) {
            return Collections.emptyList();
        }
        return this.parseNews(newsContent, false);
    }

    public NewsEntry getInitialNews() {
        List<NewsEntry> list = this.parseInitialNews();
        if (list.isEmpty()) {
            return null;
        }
        NewsEntry rv = list.get(0);
        long installed = this._context.getProperty("router.firstInstalled", 0L);
        if (installed > 0L) {
            rv.updated = installed;
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NewsEntry> parseInitialNews() {
        File file = new File(this._context.getBaseDir(), "docs/initialNews/initialNews.xml");
        Reader reader = null;
        try {
            int len;
            char[] buf = new char[512];
            StringBuilder out = new StringBuilder(2048);
            reader = new TranslateReader(this._context, BUNDLE_NAME, new FileInputStream(file));
            while ((len = reader.read(buf)) > 0) {
                out.append(buf, 0, len);
            }
            List<NewsEntry> rv = this.parseNews(out.toString(), true);
            if (!rv.isEmpty()) {
                rv.get((int)0).updated = this._context.clock().now();
            } else if (this._log.shouldWarn()) {
                this._log.warn("failed to load " + file);
            }
            List<NewsEntry> list = rv;
            return list;
        }
        catch (IOException ioe) {
            if (this._log.shouldWarn()) {
                this._log.warn("failed to load " + file, ioe);
            }
            List<NewsEntry> list = Collections.emptyList();
            return list;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private List<NewsEntry> parseNews(String newsContent, boolean addMissingDiv) {
        ArrayList<NewsEntry> rv = new ArrayList<NewsEntry>();
        boolean foundEntry = false;
        int start = newsContent.indexOf("<h3>");
        while (start >= 0) {
            String heading;
            int end;
            NewsEntry entry = new NewsEntry();
            if (newsContent.length() > start + 16 && newsContent.substring(start + 4, start + 6).equals("20") && newsContent.substring(start + 14, start + 16).equals(": ")) {
                entry.updated = RFC3339Date.parse3339Date(newsContent.substring(start + 4, start + 14));
                newsContent = newsContent.substring(start + 16);
            } else {
                int colon = (newsContent = newsContent.substring(start + 4)).indexOf(": ");
                if (colon > 0 && colon <= 10) {
                    DateFormat fmt = DateFormat.getDateInstance(3);
                    fmt.setTimeZone(SystemVersion.getSystemTimeZone(this._context));
                    try {
                        Date date = fmt.parse(newsContent.substring(0, colon));
                        entry.updated = date.getTime();
                        newsContent = newsContent.substring(colon + 2);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
            if ((end = newsContent.indexOf("</h3>")) < 0) continue;
            entry.title = heading = newsContent.substring(0, end);
            entry.id = heading;
            entry.content = (end = (newsContent = newsContent.substring(end + 5)).indexOf("<h3>")) > 0 ? newsContent.substring(0, end) : newsContent;
            if (addMissingDiv) {
                entry.content = "<div>\n" + entry.content;
            }
            rv.add(entry);
            start = end;
        }
        Collections.sort(rv);
        return rv;
    }
}

