/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.naming.NamingService;
import net.i2p.crypto.SigType;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.sam.SAMException;

class SAMUtils {
    public static final String COMMAND = "\"\"COMMAND\"\"";
    public static final String OPCODE = "\"\"OPCODE\"\"";

    SAMUtils() {
    }

    public static void genRandomKey(OutputStream priv, OutputStream pub) {
        SAMUtils.genRandomKey(priv, pub, SigType.DSA_SHA1);
    }

    public static void genRandomKey(OutputStream priv, OutputStream pub, SigType sigType) {
        try {
            I2PClient c = I2PClientFactory.createClient();
            Destination d = c.createDestination(priv, sigType);
            priv.flush();
            if (pub != null) {
                d.writeBytes(pub);
                pub.flush();
            }
        }
        catch (I2PException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkPrivateDestination(String dest) {
        byte[] b = Base64.decode(dest);
        if (b == null || b.length < 663) {
            return false;
        }
        ByteArrayInputStream destKeyStream = new ByteArrayInputStream(b);
        try {
            Destination d = Destination.create(destKeyStream);
            new PrivateKey().readBytes(destKeyStream);
            SigningPrivateKey spk = new SigningPrivateKey(d.getSigningPublicKey().getType());
            spk.readBytes(destKeyStream);
        }
        catch (DataFormatException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return destKeyStream.available() == 0;
    }

    private static Destination lookupHost(String name) {
        NamingService ns = I2PAppContext.getGlobalContext().namingService();
        Destination dest = ns.lookup(name);
        return dest;
    }

    public static Destination getDest(String s) throws DataFormatException {
        Destination d = SAMUtils.lookupHost(s);
        if (d == null) {
            String msg = s.length() >= 516 ? "Bad Base64 dest: " : (s.length() == 60 && s.endsWith(".b32.i2p") ? "Lease set not found: " : "Host name not found: ");
            throw new DataFormatException(msg + s);
        }
        return d;
    }

    public static Properties parseParams(String args) throws SAMException {
        Properties rv = new Properties();
        StringBuilder buf = new StringBuilder(32);
        int length = args.length();
        boolean isQuoted = false;
        String key = null;
        block7: for (int i = 0; i <= length; ++i) {
            char c = i < length ? (char)args.charAt(i) : (char)' ';
            switch (c) {
                case '\"': {
                    if (isQuoted) {
                        if (key != null) {
                            if (rv.setProperty(key, buf.length() > 0 ? buf.toString() : "true") != null) {
                                throw new SAMException("Duplicate parameter " + key);
                            }
                            key = null;
                        }
                        buf.setLength(0);
                    }
                    isQuoted = !isQuoted;
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    continue block7;
                }
                case '\b': 
                case '\t': 
                case '\f': 
                case ' ': {
                    if (isQuoted) {
                        buf.append(c);
                        continue block7;
                    }
                    if (key != null) {
                        if (rv.setProperty(key, buf.length() > 0 ? buf.toString() : "true") != null) {
                            throw new SAMException("Duplicate parameter " + key);
                        }
                        key = null;
                    } else if (buf.length() > 0) {
                        String k = buf.toString();
                        if (rv.isEmpty()) {
                            k = k.toUpperCase(Locale.US);
                            rv.setProperty(COMMAND, k);
                            if (k.equals("PING") || k.equals("PONG")) {
                                if (i + 1 < args.length()) {
                                    String pingData = args.substring(i + 1);
                                    rv.setProperty(OPCODE, pingData);
                                }
                                i = length + 1;
                            }
                        } else if (rv.size() == 1) {
                            rv.setProperty(OPCODE, k.toUpperCase(Locale.US));
                        } else if (rv.setProperty(k, "true") != null) {
                            throw new SAMException("Duplicate parameter " + k);
                        }
                    }
                    buf.setLength(0);
                    continue block7;
                }
                case '=': {
                    if (isQuoted) {
                        buf.append(c);
                        continue block7;
                    }
                    if (key != null) {
                        buf.append(c);
                        continue block7;
                    }
                    if (buf.length() == 0) {
                        throw new SAMException("Empty parameter name");
                    }
                    key = buf.toString();
                    buf.setLength(0);
                    continue block7;
                }
                case '\\': {
                    if (++i >= length) {
                        throw new SAMException("Unterminated escape");
                    }
                    c = args.charAt(i);
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (isQuoted) {
            throw new SAMException("Unterminated quote");
        }
        return rv;
    }
}

