/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.router.ClientTunnelSettings;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.router.tunnel.pool.AliasedTunnelPool;
import net.i2p.router.tunnel.pool.BuildExecutor;
import net.i2p.router.tunnel.pool.BuildHandler;
import net.i2p.router.tunnel.pool.ClientPeerSelector;
import net.i2p.router.tunnel.pool.ExploratoryPeerSelector;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TestJob;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;

public class TunnelPoolManager
implements TunnelManagerFacade {
    private final RouterContext _context;
    private final Log _log;
    private final Map<Hash, TunnelPool> _clientInboundPools;
    private final Map<Hash, TunnelPool> _clientOutboundPools;
    private final TunnelPool _inboundExploratory;
    private final TunnelPool _outboundExploratory;
    private final BuildExecutor _executor;
    private final BuildHandler _handler;
    private final TunnelPeerSelector _clientPeerSelector;
    private volatile boolean _isShutdown;
    private final int _numHandlerThreads;
    private static final int MIN_KBPS_TWO_HANDLERS = 512;
    private static final int MIN_KBPS_THREE_HANDLERS = 1024;
    private static final int DEFAULT_MAX_PCT_TUNNELS = 33;

    public TunnelPoolManager(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelPoolManager.class);
        this._clientInboundPools = new ConcurrentHashMap<Hash, TunnelPool>(4);
        this._clientOutboundPools = new ConcurrentHashMap<Hash, TunnelPool>(4);
        this._clientPeerSelector = new ClientPeerSelector(ctx);
        ExploratoryPeerSelector selector = new ExploratoryPeerSelector(this._context);
        TunnelPoolSettings inboundSettings = new TunnelPoolSettings(true);
        this._inboundExploratory = new TunnelPool(this._context, this, inboundSettings, selector);
        TunnelPoolSettings outboundSettings = new TunnelPoolSettings(false);
        this._outboundExploratory = new TunnelPool(this._context, this, outboundSettings, selector);
        this._executor = new BuildExecutor(ctx, this);
        this._handler = new BuildHandler(ctx, this, this._executor);
        int share = TunnelDispatcher.getShareBandwidth(ctx);
        int numHandlerThreads = share >= 1024 ? 3 : (share >= 512 ? 2 : 1);
        this._numHandlerThreads = ctx.getProperty("router.buildHandlerThreads", numHandlerThreads);
        long[] RATES = new long[]{60000L, 600000L, 3600000L};
        ctx.statManager().createRequiredRateStat("tunnel.testFailedTime", "Time for tunnel test failure (ms)", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.testExploratoryFailedTime", "How long did the failure of an exploratory tunnel take (max of 60s for full timeout)?", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.testFailedCompletelyTime", "How long did the complete failure take (max of 60s for full timeout)?", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.testExploratoryFailedCompletelyTime", "How long did the complete failure of an exploratory tunnel take (max of 60s for full timeout)?", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.testSuccessLength", "How long were the tunnels that passed the test?", "Tunnels", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.testSuccessTime", "Time for tunnel test success (ms)", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.testAborted", "Tunnel test could not occur, since there weren't any tunnels to test with", "Tunnels", RATES);
    }

    @Override
    public TunnelInfo selectInboundTunnel() {
        TunnelInfo info = this._inboundExploratory.selectTunnel();
        if (info == null) {
            this._inboundExploratory.buildFallback();
            info = this._inboundExploratory.selectTunnel();
        }
        return info;
    }

    @Override
    public TunnelInfo selectInboundTunnel(Hash destination) {
        if (destination == null) {
            return this.selectInboundTunnel();
        }
        TunnelPool pool = this._clientInboundPools.get(destination);
        if (pool != null) {
            return pool.selectTunnel();
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Want the inbound tunnel for " + destination.toBase32() + " but there isn't a pool?");
        }
        return null;
    }

    @Override
    public TunnelInfo selectOutboundTunnel() {
        TunnelInfo info = this._outboundExploratory.selectTunnel();
        if (info == null) {
            this._outboundExploratory.buildFallback();
            info = this._outboundExploratory.selectTunnel();
        }
        return info;
    }

    @Override
    public TunnelInfo selectOutboundTunnel(Hash destination) {
        if (destination == null) {
            return this.selectOutboundTunnel();
        }
        TunnelPool pool = this._clientOutboundPools.get(destination);
        if (pool != null) {
            return pool.selectTunnel();
        }
        return null;
    }

    @Override
    public TunnelInfo selectInboundExploratoryTunnel(Hash closestTo) {
        TunnelInfo info = this._inboundExploratory.selectTunnel(closestTo);
        if (info == null) {
            this._inboundExploratory.buildFallback();
            info = this._inboundExploratory.selectTunnel();
        }
        return info;
    }

    @Override
    public TunnelInfo selectInboundTunnel(Hash destination, Hash closestTo) {
        if (destination == null) {
            return this.selectInboundExploratoryTunnel(closestTo);
        }
        TunnelPool pool = this._clientInboundPools.get(destination);
        if (pool != null) {
            return pool.selectTunnel(closestTo);
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Want the inbound tunnel for " + destination.toBase32() + " but there isn't a pool?");
        }
        return null;
    }

    @Override
    public TunnelInfo selectOutboundExploratoryTunnel(Hash closestTo) {
        TunnelInfo info = this._outboundExploratory.selectTunnel(closestTo);
        if (info == null) {
            this._outboundExploratory.buildFallback();
            info = this._outboundExploratory.selectTunnel();
        }
        return info;
    }

    @Override
    public TunnelInfo selectOutboundTunnel(Hash destination, Hash closestTo) {
        if (destination == null) {
            return this.selectOutboundExploratoryTunnel(closestTo);
        }
        TunnelPool pool = this._clientOutboundPools.get(destination);
        if (pool != null) {
            return pool.selectTunnel(closestTo);
        }
        return null;
    }

    @Override
    @Deprecated
    public TunnelInfo getTunnelInfo(TunnelId id) {
        TunnelInfo info = null;
        for (TunnelPool pool : this._clientInboundPools.values()) {
            info = pool.getTunnel(id);
            if (info == null) continue;
            return info;
        }
        info = this._inboundExploratory.getTunnel(id);
        if (info != null) {
            return info;
        }
        info = this._outboundExploratory.getTunnel(id);
        if (info != null) {
            return info;
        }
        return null;
    }

    @Override
    public int getFreeTunnelCount() {
        return this._inboundExploratory.size();
    }

    @Override
    public int getOutboundTunnelCount() {
        return this._outboundExploratory.size();
    }

    @Override
    public int getInboundClientTunnelCount() {
        int count = 0;
        for (TunnelPool pool : this._clientInboundPools.values()) {
            count += pool.listTunnels().size();
        }
        return count;
    }

    @Override
    public int getOutboundClientTunnelCount() {
        int count = 0;
        for (TunnelPool pool : this._clientOutboundPools.values()) {
            count += pool.listTunnels().size();
        }
        return count;
    }

    @Override
    public int getOutboundClientTunnelCount(Hash destination) {
        TunnelPool pool = this._clientOutboundPools.get(destination);
        if (pool != null) {
            return pool.getTunnelCount();
        }
        return 0;
    }

    @Override
    public int getParticipatingCount() {
        return this._context.tunnelDispatcher().getParticipatingCount();
    }

    @Override
    public long getLastParticipatingExpiration() {
        return this._context.tunnelDispatcher().getLastParticipatingExpiration();
    }

    @Override
    public double getShareRatio() {
        int part = this.getParticipatingCount();
        if (part <= 0) {
            return 0.0;
        }
        ArrayList<TunnelPool> pools = new ArrayList<TunnelPool>();
        this.listPools(pools);
        int count = 0;
        for (int i = 0; i < pools.size(); ++i) {
            TunnelPool pool = (TunnelPool)pools.get(i);
            count += pool.size() * pool.getSettings().getLength();
        }
        if (count <= 0) {
            return 100.0;
        }
        return Math.min((double)part / (double)count, 100.0);
    }

    @Override
    public boolean isValidTunnel(Hash client, TunnelInfo tunnel) {
        if (tunnel.getExpiration() < this._context.clock().now()) {
            return false;
        }
        TunnelPool pool = tunnel.isInbound() ? this._clientInboundPools.get(client) : this._clientOutboundPools.get(client);
        if (pool == null) {
            return false;
        }
        return pool.listTunnels().contains(tunnel);
    }

    @Override
    public TunnelPoolSettings getInboundSettings() {
        return this._inboundExploratory.getSettings();
    }

    @Override
    public TunnelPoolSettings getOutboundSettings() {
        return this._outboundExploratory.getSettings();
    }

    @Override
    public void setInboundSettings(TunnelPoolSettings settings) {
        this._inboundExploratory.setSettings(settings);
    }

    @Override
    public void setOutboundSettings(TunnelPoolSettings settings) {
        this._outboundExploratory.setSettings(settings);
    }

    @Override
    public TunnelPoolSettings getInboundSettings(Hash client) {
        TunnelPool pool = this._clientInboundPools.get(client);
        if (pool != null) {
            return pool.getSettings();
        }
        return null;
    }

    @Override
    public TunnelPoolSettings getOutboundSettings(Hash client) {
        TunnelPool pool = this._clientOutboundPools.get(client);
        if (pool != null) {
            return pool.getSettings();
        }
        return null;
    }

    @Override
    public void setInboundSettings(Hash client, TunnelPoolSettings settings) {
        TunnelPoolManager.setSettings(this._clientInboundPools, client, settings);
    }

    @Override
    public void setOutboundSettings(Hash client, TunnelPoolSettings settings) {
        TunnelPoolManager.setSettings(this._clientOutboundPools, client, settings);
    }

    private static void setSettings(Map<Hash, TunnelPool> pools, Hash client, TunnelPoolSettings settings) {
        TunnelPool pool = pools.get(client);
        if (pool != null) {
            pool.setSettings(settings);
        }
    }

    @Override
    public synchronized void restart() {
        this._handler.restart();
        this._executor.restart();
        this.shutdownExploratory();
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildTunnels(Destination client, ClientTunnelSettings settings) {
        Hash dest = client.calculateHash();
        if (this._log.shouldLog(10)) {
            this._log.debug("Building tunnels for the client " + client.toBase32() + ": " + settings);
        }
        TunnelPool inbound = null;
        TunnelPool outbound = null;
        boolean delayOutbound = false;
        TunnelPoolManager tunnelPoolManager = this;
        synchronized (tunnelPoolManager) {
            inbound = this._clientInboundPools.get(dest);
            if (inbound == null) {
                inbound = new TunnelPool(this._context, this, settings.getInboundSettings(), this._clientPeerSelector);
                this._clientInboundPools.put(dest, inbound);
            } else {
                inbound.setSettings(settings.getInboundSettings());
            }
            outbound = this._clientOutboundPools.get(dest);
            if (outbound == null) {
                outbound = new TunnelPool(this._context, this, settings.getOutboundSettings(), this._clientPeerSelector);
                this._clientOutboundPools.put(dest, outbound);
                delayOutbound = true;
            } else {
                outbound.setSettings(settings.getOutboundSettings());
            }
        }
        inbound.startup();
        if (delayOutbound) {
            this._context.simpleTimer2().addEvent(new DelayedStartup(outbound), 1000L);
        } else {
            outbound.startup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAlias(Destination dest, ClientTunnelSettings settings, Destination existingClient) {
        if (dest.getSigningPublicKey().equals(existingClient.getSigningPublicKey())) {
            throw new IllegalArgumentException("signing key must differ");
        }
        if (!dest.getPublicKey().equals(existingClient.getPublicKey())) {
            throw new IllegalArgumentException("encryption key mismatch");
        }
        Hash h = dest.calculateHash();
        Hash e = existingClient.calculateHash();
        TunnelPoolManager tunnelPoolManager = this;
        synchronized (tunnelPoolManager) {
            TunnelPool inbound = this._clientInboundPools.get(h);
            TunnelPool outbound = this._clientOutboundPools.get(h);
            if (inbound != null || outbound != null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("already have alias " + dest.toBase32());
                }
                return false;
            }
            TunnelPool eInbound = this._clientInboundPools.get(e);
            TunnelPool eOutbound = this._clientOutboundPools.get(e);
            if (eInbound == null || eOutbound == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("primary not found " + existingClient);
                }
                return false;
            }
            eInbound.getSettings().getAliases().add(h);
            eOutbound.getSettings().getAliases().add(h);
            TunnelPoolSettings newIn = settings.getInboundSettings();
            TunnelPoolSettings newOut = settings.getOutboundSettings();
            newIn.setAliasOf(e);
            newOut.setAliasOf(e);
            inbound = new AliasedTunnelPool(this._context, this, newIn, eInbound);
            outbound = new AliasedTunnelPool(this._context, this, newOut, eOutbound);
            this._clientInboundPools.put(h, inbound);
            this._clientOutboundPools.put(h, outbound);
            inbound.startup();
            outbound.startup();
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("Added " + dest.toBase32() + " as alias for " + existingClient.toBase32() + " with settings " + settings);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAlias(Destination dest) {
        Hash h = dest.calculateHash();
        TunnelPoolManager tunnelPoolManager = this;
        synchronized (tunnelPoolManager) {
            Set<Hash> aliases;
            TunnelPool pri;
            Hash p;
            TunnelPool outbound;
            Set<Hash> aliases2;
            TunnelPool pri2;
            Hash p2;
            TunnelPool inbound = this._clientInboundPools.remove(h);
            if (inbound != null && (p2 = inbound.getSettings().getAliasOf()) != null && (pri2 = this._clientInboundPools.get(p2)) != null && (aliases2 = pri2.getSettings().getAliases()) != null) {
                aliases2.remove(h);
            }
            if ((outbound = this._clientOutboundPools.remove(h)) != null && (p = outbound.getSettings().getAliasOf()) != null && (pri = this._clientOutboundPools.get(p)) != null && (aliases = pri.getSettings().getAliases()) != null) {
                aliases.remove(h);
            }
        }
    }

    public synchronized void removeTunnels(Hash destination) {
        if (destination == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Removing tunnels for the client " + destination.toBase32());
        }
        if (this._context.clientManager().isLocal(destination)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Not removing pool still registered with client manager: " + destination.toBase32(), new Exception("i did it"));
            }
            return;
        }
        TunnelPool inbound = this._clientInboundPools.remove(destination);
        TunnelPool outbound = this._clientOutboundPools.remove(destination);
        if (inbound != null) {
            inbound.shutdown();
        }
        if (outbound != null) {
            outbound.shutdown();
        }
    }

    void buildComplete(PooledTunnelCreatorConfig cfg) {
        if (!(cfg.getLength() <= 1 || this._context.router().gracefulShutdownInProgress() || this._context.getBooleanPropertyDefaultTrue("router.disableTunnelTesting") && !this._context.router().isHidden() && this._context.router().getRouterInfo().getAddressCount() > 0)) {
            TunnelPool pool = cfg.getTunnelPool();
            if (pool == null) {
                this._log.error("How does this not have a pool?  " + cfg, new Exception("baf"));
                pool = cfg.getDestination() != null ? (cfg.isInbound() ? this._clientInboundPools.get(cfg.getDestination()) : this._clientOutboundPools.get(cfg.getDestination())) : (cfg.isInbound() ? this._inboundExploratory : this._outboundExploratory);
                cfg.setTunnelPool(pool);
            }
            this._context.jobQueue().addJob(new TestJob(this._context, cfg, pool));
        }
    }

    @Override
    public synchronized void startup() {
        this._isShutdown = false;
        if (!this._executor.isRunning()) {
            I2PThread t = new I2PThread(this._executor, "BuildExecutor", true);
            t.start();
            this._handler.init();
            for (int i = 1; i <= this._numHandlerThreads; ++i) {
                I2PThread hThread = new I2PThread(this._handler, "BuildHandler " + i + '/' + this._numHandlerThreads, true);
                hThread.start();
            }
        }
        this._inboundExploratory.startup();
        this._context.simpleTimer2().addEvent(new DelayedStartup(this._outboundExploratory), 3000L);
        this._context.jobQueue().addJob(new BootstrapPool(this._context, this._inboundExploratory));
        this._context.jobQueue().addJob(new BootstrapPool(this._context, this._outboundExploratory));
    }

    @Override
    public synchronized void shutdown() {
        this._handler.shutdown(this._numHandlerThreads);
        this._executor.shutdown();
        this.shutdownExploratory();
        this._isShutdown = true;
    }

    private void shutdownExploratory() {
        this._inboundExploratory.shutdown();
        this._outboundExploratory.shutdown();
    }

    @Override
    public void listPools(List<TunnelPool> out) {
        out.addAll(this._clientInboundPools.values());
        out.addAll(this._clientOutboundPools.values());
        out.add(this._inboundExploratory);
        out.add(this._outboundExploratory);
    }

    void tunnelFailed() {
        this._executor.repoll();
    }

    BuildExecutor getExecutor() {
        return this._executor;
    }

    boolean isShutdown() {
        return this._isShutdown;
    }

    @Override
    public int getInboundBuildQueueSize() {
        return this._handler.getInboundBuildQueueSize();
    }

    @Override
    @Deprecated
    public void renderStatusHTML(Writer out) throws IOException {
    }

    private int countTunnelsPerPeer(ObjectCounter<Hash> lc) {
        ArrayList<TunnelPool> pools = new ArrayList<TunnelPool>();
        this.listPools(pools);
        int tunnelCount = 0;
        for (TunnelPool tp : pools) {
            for (TunnelInfo info : tp.listTunnels()) {
                if (info.getLength() <= 1) continue;
                ++tunnelCount;
                for (int j = 0; j < info.getLength(); ++j) {
                    Hash peer = info.getPeer(j);
                    if (this._context.routerHash().equals(peer)) continue;
                    lc.increment(peer);
                }
            }
        }
        return tunnelCount;
    }

    @Override
    public Set<Hash> selectPeersInTooManyTunnels() {
        ObjectCounter<Hash> lc = new ObjectCounter<Hash>();
        int tunnelCount = this.countTunnelsPerPeer(lc);
        HashSet<Hash> rv = new HashSet<Hash>();
        if (tunnelCount >= 4 && this._context.router().getUptime() > 600000L) {
            int max = this._context.getProperty("router.maxTunnelPercentage", 33);
            for (Hash h : lc.objects()) {
                if (lc.count(h) <= 0 || (lc.count(h) + 1) * 100 / (tunnelCount + 1) <= max) continue;
                rv.add(h);
            }
        }
        return rv;
    }

    @Override
    public Map<Hash, TunnelPool> getInboundClientPools() {
        return new HashMap<Hash, TunnelPool>(this._clientInboundPools);
    }

    @Override
    public Map<Hash, TunnelPool> getOutboundClientPools() {
        return new HashMap<Hash, TunnelPool>(this._clientOutboundPools);
    }

    @Override
    public TunnelPool getInboundExploratoryPool() {
        return this._inboundExploratory;
    }

    @Override
    public TunnelPool getOutboundExploratoryPool() {
        return this._outboundExploratory;
    }

    @Override
    public void fail(Hash peer) {
        this.failTunnelsWithFirstHop(this._outboundExploratory, peer);
        for (TunnelPool pool : this._clientOutboundPools.values()) {
            this.failTunnelsWithFirstHop(pool, peer);
        }
        this.failTunnelsWithLastHop(this._inboundExploratory, peer);
        for (TunnelPool pool : this._clientInboundPools.values()) {
            this.failTunnelsWithLastHop(pool, peer);
        }
    }

    private void failTunnelsWithFirstHop(TunnelPool pool, Hash peer) {
        for (TunnelInfo tun : pool.listTunnels()) {
            int len = tun.getLength();
            if (len <= 1 || !tun.getPeer(1).equals(peer)) continue;
            if (this._log.shouldLog(30)) {
                this._log.warn("Removing OB tunnel, first hop banlisted: " + tun);
            }
            pool.tunnelFailed(tun, peer);
        }
    }

    private void failTunnelsWithLastHop(TunnelPool pool, Hash peer) {
        for (TunnelInfo tun : pool.listTunnels()) {
            int len = tun.getLength();
            if (len <= 1 || !tun.getPeer(len - 2).equals(peer)) continue;
            if (this._log.shouldLog(30)) {
                this._log.warn("Removing IB tunnel, prev. hop banlisted: " + tun);
            }
            pool.tunnelFailed(tun, peer);
        }
    }

    private static class BootstrapPool
    extends JobImpl {
        private TunnelPool _pool;

        public BootstrapPool(RouterContext ctx, TunnelPool pool) {
            super(ctx);
            this._pool = pool;
            this.getTiming().setStartAfter(ctx.clock().now() + 30000L);
        }

        @Override
        public String getName() {
            return "Bootstrap tunnel pool";
        }

        @Override
        public void runJob() {
            this._pool.buildFallback();
        }
    }

    private static class DelayedStartup
    implements SimpleTimer.TimedEvent {
        private final TunnelPool pool;

        public DelayedStartup(TunnelPool p) {
            this.pool = p;
        }

        @Override
        public void timeReached() {
            this.pool.startup();
        }
    }
}

