/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.peermanager.ProfileOrganizer;
import net.i2p.router.tunnel.pool.TunnelPeerSelector;

class ClientPeerSelector
extends TunnelPeerSelector {
    public ClientPeerSelector(RouterContext context) {
        super(context);
    }

    @Override
    public List<Hash> selectPeers(TunnelPoolSettings settings) {
        ArrayList<Hash> rv;
        int length = this.getLength(settings);
        if (length < 0) {
            return null;
        }
        if (length == 0 && settings.getLength() + settings.getLengthVariance() > 0) {
            return null;
        }
        if (length > 0) {
            if (this.shouldSelectExplicit(settings)) {
                return this.selectExplicit(settings, length);
            }
            Set<Hash> exclude = this.getExclude(settings.isInbound(), false);
            HashSet<Hash> matches = new HashSet<Hash>(length);
            if (length == 1) {
                Set<Hash> moreExclude = this.getClosestHopExclude(settings.isInbound());
                if (moreExclude != null) {
                    exclude.addAll(moreExclude);
                }
                this.ctx.profileOrganizer().selectFastPeers(length, exclude, matches, 0);
                matches.remove(this.ctx.routerHash());
                rv = new ArrayList<Hash>(matches);
            } else {
                Set<Hash> firstHopExclude;
                Set<Hash> moreExclude;
                rv = new ArrayList(length + 1);
                if (!settings.isInbound()) {
                    moreExclude = this.getClosestHopExclude(false);
                    if (moreExclude != null) {
                        moreExclude.addAll(exclude);
                        firstHopExclude = moreExclude;
                    } else {
                        firstHopExclude = exclude;
                    }
                } else {
                    firstHopExclude = exclude;
                }
                this.ctx.profileOrganizer().selectFastPeers(1, firstHopExclude, matches, settings.getRandomKey(), length == 2 ? ProfileOrganizer.Slice.SLICE_0_1 : ProfileOrganizer.Slice.SLICE_0);
                matches.remove(this.ctx.routerHash());
                exclude.addAll(matches);
                rv.addAll(matches);
                matches.clear();
                if (length > 2) {
                    this.ctx.profileOrganizer().selectFastPeers(length - 2, exclude, matches, settings.getRandomKey(), ProfileOrganizer.Slice.SLICE_2_3);
                    matches.remove(this.ctx.routerHash());
                    if (matches.size() > 1) {
                        ArrayList<Hash> ordered = new ArrayList<Hash>(matches);
                        this.orderPeers(ordered, settings.getRandomKey());
                        rv.addAll(ordered);
                    } else {
                        rv.addAll(matches);
                    }
                    exclude.addAll(matches);
                    matches.clear();
                }
                if (settings.isInbound() && (moreExclude = this.getClosestHopExclude(true)) != null) {
                    exclude.addAll(moreExclude);
                }
                this.ctx.profileOrganizer().selectFastPeers(1, exclude, matches, settings.getRandomKey(), length == 2 ? ProfileOrganizer.Slice.SLICE_2_3 : ProfileOrganizer.Slice.SLICE_1);
                matches.remove(this.ctx.routerHash());
                rv.addAll(matches);
            }
        } else {
            rv = new ArrayList<Hash>(1);
        }
        if (settings.isInbound()) {
            rv.add(0, this.ctx.routerHash());
        } else {
            rv.add(this.ctx.routerHash());
        }
        return rv;
    }
}

