/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import java.util.Map;
import java.util.Properties;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.PeerCoordinator;
import org.klomp.snark.PeerCoordinatorSet;
import org.klomp.snark.SnarkManager;

class IdleChecker
extends SimpleTimer2.TimedEvent {
    private final SnarkManager _mgr;
    private final I2PSnarkUtil _util;
    private final PeerCoordinatorSet _pcs;
    private final Log _log;
    private int _consec;
    private int _consecNotRunning;
    private boolean _isIdle;
    private String _lastIn = "3";
    private String _lastOut = "3";
    private final Object _lock = new Object();
    private static final long CHECK_TIME = 63000L;
    private static final int MAX_CONSEC_IDLE = 4;
    private static final int MAX_CONSEC_NOT_RUNNING = 20;

    public IdleChecker(SnarkManager mgr, PeerCoordinatorSet pcs) {
        super(mgr.util().getContext().simpleTimer2());
        this._util = mgr.util();
        this._log = this._util.getContext().logManager().getLog(IdleChecker.class);
        this._mgr = mgr;
        this._pcs = pcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeReached() {
        Object object = this._lock;
        synchronized (object) {
            this.locked_timeReached();
        }
    }

    private void locked_timeReached() {
        if (this._util.connected()) {
            boolean torrentRunning = false;
            int peerCount = 0;
            for (PeerCoordinator pc : this._pcs) {
                if (pc.halted()) continue;
                torrentRunning = true;
                peerCount += pc.getPeers();
            }
            if (torrentRunning) {
                this._consecNotRunning = 0;
            } else if (this._consecNotRunning++ >= 20) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Closing tunnels on idle");
                }
                this._util.disconnect();
                this._mgr.addMessage(this._util.getString("No more torrents running.") + ' ' + this._util.getString("I2P tunnel closed."));
                this.schedule(189000L);
                return;
            }
            if (peerCount > 0) {
                this.restoreTunnels(peerCount);
            } else if (!this._isIdle) {
                if (this._consec++ >= 4) {
                    this.reduceTunnels();
                } else {
                    this.restoreTunnels(1);
                }
            }
        } else {
            this._isIdle = false;
            this._consec = 0;
            this._consecNotRunning = 0;
            this._lastIn = "3";
            this._lastOut = "3";
        }
        this.schedule(63000L);
    }

    private void reduceTunnels() {
        this._isIdle = true;
        if (this._log.shouldLog(20)) {
            this._log.info("Reducing tunnels on idle");
        }
        this.setTunnels("1", "1", "0", "0");
    }

    private void restoreTunnels(int peerCount) {
        int out;
        int in;
        String ob;
        String ib;
        String o;
        if (this._isIdle && this._log.shouldLog(20)) {
            this._log.info("Restoring tunnels on activity");
        }
        this._isIdle = false;
        Map<String, String> opts = this._util.getI2CPOptions();
        String i = opts.get("inbound.quantity");
        if (i == null) {
            i = Integer.toString(3);
        }
        if ((o = opts.get("outbound.quantity")) == null) {
            o = Integer.toString(3);
        }
        if ((ib = opts.get("inbound.backupQuantity")) == null) {
            ib = "0";
        }
        if ((ob = opts.get("outbound.backupQuantity")) == null) {
            ob = "0";
        }
        try {
            in = Integer.parseInt(i);
        }
        catch (NumberFormatException nfe) {
            in = 3;
        }
        try {
            out = Integer.parseInt(o);
        }
        catch (NumberFormatException nfe) {
            out = 3;
        }
        int target = Math.max(peerCount / 2, 2);
        if (target < in && in > 2) {
            in = target;
            i = Integer.toString(in);
        }
        if (target < out && out > 2) {
            out = target;
            o = Integer.toString(out);
        }
        if (!this._lastIn.equals(i) || !this._lastOut.equals(o)) {
            this.setTunnels(i, o, ib, ob);
        }
    }

    private void setTunnels(String i, String o, String ib, String ob) {
        I2PSession sess;
        this._consec = 0;
        I2PSocketManager mgr = this._util.getSocketManager();
        if (mgr != null && (sess = mgr.getSession()) != null) {
            if (this._log.shouldLog(20)) {
                this._log.info("New tunnel settings " + i + " / " + o + " / " + ib + " / " + ob);
            }
            Properties newProps = new Properties();
            newProps.setProperty("inbound.quantity", i);
            newProps.setProperty("outbound.quantity", o);
            newProps.setProperty("inbound.backupQuantity", ib);
            newProps.setProperty("outbound.backupQuantity", ob);
            sess.updateOptions(newProps);
            this._lastIn = i;
            this._lastOut = o;
        }
    }
}

