/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import engine.misc.DeallocationHelper;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.i2p.util.SystemVersion;
import org.jrobin.core.RrdFileBackend;
import org.jrobin.core.SyncManager;

public class RrdNioBackend
extends RrdFileBackend {
    private final SyncManager m_syncManager;
    private MappedByteBuffer m_byteBuffer = null;
    private static final DeallocationHelper _dHelper = SystemVersion.isJava9() ? null : new DeallocationHelper();

    protected RrdNioBackend(String path, boolean readOnly, int syncPeriod) throws IOException {
        this(path, readOnly, new SyncManager(syncPeriod));
    }

    protected RrdNioBackend(String path, boolean readOnly, SyncManager syncManager) throws IOException {
        super(path, readOnly);
        this.m_syncManager = syncManager;
        try {
            this.mapFile();
        }
        catch (IOException ioe) {
            this.stopSchedule();
            super.close();
            throw ioe;
        }
    }

    private void mapFile() throws IOException {
        long length;
        if (!this.isReadOnly()) {
            this.startSchedule();
        }
        if ((length = this.getLength()) > 0L) {
            FileChannel.MapMode mapMode = this.isReadOnly() ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
            this.m_byteBuffer = this.file.getChannel().map(mapMode, 0L, length);
        }
    }

    private void unmapFile() {
        if (!this.isReadOnly()) {
            this.stopSchedule();
        }
        if (_dHelper != null && this.m_byteBuffer != null) {
            _dHelper.deallocate(this.m_byteBuffer);
            this.m_byteBuffer = null;
        }
    }

    private void startSchedule() {
        if (this.m_syncManager != null) {
            this.m_syncManager.add(this);
        }
    }

    private synchronized void stopSchedule() {
        if (this.m_syncManager != null) {
            this.m_syncManager.remove(this);
        }
        this.sync();
    }

    protected void finalize() throws Throwable {
        this.stopSchedule();
        super.finalize();
    }

    @Override
    protected synchronized void setLength(long newLength) throws IOException {
        this.unmapFile();
        super.setLength(newLength);
        this.mapFile();
    }

    @Override
    protected synchronized void write(long offset, byte[] b) throws IOException {
        if (this.m_byteBuffer == null) {
            throw new IOException("Write failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.m_byteBuffer.position((int)offset);
        this.m_byteBuffer.put(b);
    }

    @Override
    protected synchronized void read(long offset, byte[] b) throws IOException {
        if (this.m_byteBuffer == null) {
            throw new IOException("Read failed, file " + this.getPath() + " not mapped for I/O");
        }
        this.m_byteBuffer.position((int)offset);
        this.m_byteBuffer.get(b);
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.unmapFile();
        }
        finally {
            super.close();
        }
    }

    protected synchronized void sync() {
        if (this.m_byteBuffer != null) {
            this.m_byteBuffer.force();
        }
    }
}

