/*
 * Decompiled with CFR 0.152.
 */
package engine.misc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.util.Log;

public class DeallocationHelper {
    private final Log logger = I2PAppContext.getGlobalContext().logManager().getLog(DeallocationHelper.class);
    private Map<Class<?>, Field> attachmentOrByteBufferFieldMap;
    private Set<Class<?>> deallocatableBufferClassSet;
    private Deallocator deallocator;

    public DeallocationHelper() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeallocationHelper(boolean ignoreClassesAndFieldsHints) {
        Class<?> readWriteDirectByteBufferClass;
        String readOnlyDirectByteBufferClassName;
        Class<?> readOnlyDirectByteBufferClass;
        String msg;
        Iterator<Object> byteBufferAsNonByteBufferClassnames;
        ArrayList buffersToDelete = new ArrayList();
        HashMap<Object, String> attachmentOrByteBufferFieldNameMap = new HashMap<Object, String>();
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        if (!ignoreClassesAndFieldsHints) {
            String byteBufferAsNonByteBufferByteBufferFieldName;
            if (javaVendor.equals("Sun Microsystems Inc.") || javaVendor.equals("Oracle Corporation")) {
                int minor;
                int min;
                int major;
                String java14to16DirectBufferAttachmentFieldName = "viewedBuffer";
                String java17to19DirectBufferAttachmentFieldName = "att";
                Iterator<Object> byteBufferAsNonByteBufferByteBufferFieldName2 = "bb";
                String[] directBufferClassnames = new String[]{"java.nio.DirectByteBuffer", "java.nio.DirectByteBufferR", "java.nio.DirectCharBufferRS", "java.nio.DirectCharBufferRU", "java.nio.DirectCharBufferS", "java.nio.DirectCharBufferU", "java.nio.DirectDoubleBufferRS", "java.nio.DirectDoubleBufferRU", "java.nio.DirectDoubleBufferS", "java.nio.DirectDoubleBufferU", "java.nio.DirectFloatBufferRS", "java.nio.DirectFloatBufferRU", "java.nio.DirectFloatBufferS", "java.nio.DirectFloatBufferU", "java.nio.DirectIntBufferRS", "java.nio.DirectIntBufferRU", "java.nio.DirectIntBufferS", "java.nio.DirectIntBufferU", "java.nio.DirectLongBufferRS", "java.nio.DirectLongBufferRU", "java.nio.DirectLongBufferS", "java.nio.DirectLongBufferU", "java.nio.DirectShortBufferRS", "java.nio.DirectShortBufferRU", "java.nio.DirectShortBufferS", "java.nio.DirectShortBufferU"};
                String[] byteBufferAsNonByteBufferClassnames2 = new String[]{"java.nio.ByteBufferAsCharBufferB", "java.nio.ByteBufferAsCharBufferL", "java.nio.ByteBufferAsCharBufferRB", "java.nio.ByteBufferAsCharBufferRL", "java.nio.ByteBufferAsDoubleBufferB", "java.nio.ByteBufferAsDoubleBufferL", "java.nio.ByteBufferAsDoubleBufferRB", "java.nio.ByteBufferAsDoubleBufferRL", "java.nio.ByteBufferAsFloatBufferB", "java.nio.ByteBufferAsFloatBufferL", "java.nio.ByteBufferAsFloatBufferRB", "java.nio.ByteBufferAsFloatBufferRL", "java.nio.ByteBufferAsIntBufferB", "java.nio.ByteBufferAsIntBufferL", "java.nio.ByteBufferAsIntBufferRB", "java.nio.ByteBufferAsIntBufferRL", "java.nio.ByteBufferAsLongBufferB", "java.nio.ByteBufferAsLongBufferL", "java.nio.ByteBufferAsLongBufferRB", "java.nio.ByteBufferAsLongBufferRL", "java.nio.ByteBufferAsShortBufferB", "java.nio.ByteBufferAsShortBufferL", "java.nio.ByteBufferAsShortBufferRB", "java.nio.ByteBufferAsShortBufferRL"};
                String[] javaVersionElements = System.getProperty("java.version").split("\\.");
                int indexOfEarlyAccessSuffix = javaVersionElements[0].lastIndexOf("-ea");
                if (indexOfEarlyAccessSuffix != -1) {
                    javaVersionElements[0] = javaVersionElements[0].substring(0, indexOfEarlyAccessSuffix);
                } else {
                    indexOfEarlyAccessSuffix = javaVersionElements[0].lastIndexOf("-internal");
                    if (indexOfEarlyAccessSuffix != -1) {
                        javaVersionElements[0] = javaVersionElements[0].substring(0, indexOfEarlyAccessSuffix);
                    } else {
                        indexOfEarlyAccessSuffix = javaVersionElements[0].lastIndexOf("-Ubuntu");
                        if (indexOfEarlyAccessSuffix != -1) {
                            javaVersionElements[0] = javaVersionElements[0].substring(0, indexOfEarlyAccessSuffix);
                        }
                    }
                }
                if (javaVersionElements.length >= 2) {
                    major = Integer.parseInt(javaVersionElements[0]);
                    try {
                        min = Integer.parseInt(javaVersionElements[1]);
                    }
                    catch (NumberFormatException nfe) {
                        min = 7;
                    }
                    minor = min;
                } else {
                    major = 1;
                    try {
                        min = Integer.parseInt(javaVersionElements[0]);
                    }
                    catch (NumberFormatException nfe) {
                        min = 7;
                    }
                    minor = min;
                }
                String directBufferAttachmentFieldName = minor == 1 && major <= 6 ? "viewedBuffer" : "att";
                for (String directBufferClassname : directBufferClassnames) {
                    attachmentOrByteBufferFieldNameMap.put(directBufferClassname, directBufferAttachmentFieldName);
                }
                for (String byteBufferAsNonByteBufferClassname : byteBufferAsNonByteBufferClassnames2) {
                    attachmentOrByteBufferFieldNameMap.put(byteBufferAsNonByteBufferClassname, "bb");
                }
            } else if (javaVendor.equals("The Android Project")) {
                byteBufferAsNonByteBufferByteBufferFieldName = "byteBuffer";
                for (Iterator<Object> byteBufferAsNonByteBufferClassname : byteBufferAsNonByteBufferClassnames = new String[]{"java.nio.ByteBufferAsCharBuffer", "java.nio.ByteBufferAsDoubleBuffer", "java.nio.ByteBufferAsFloatBuffer", "java.nio.ByteBufferAsIntBuffer", "java.nio.ByteBufferAsLongBuffer", "java.nio.ByteBufferAsShortBuffer"}) {
                    attachmentOrByteBufferFieldNameMap.put(byteBufferAsNonByteBufferClassname, "byteBuffer");
                }
            } else if (javaVendor.equals("Free Software Foundation, Inc.")) {
                byteBufferAsNonByteBufferByteBufferFieldName = "bb";
                for (Iterator<Object> byteBufferAsNonByteBufferClassname : byteBufferAsNonByteBufferClassnames = new String[]{"java.nio.CharViewBufferImpl", "java.nio.DoubleViewBufferImpl", "java.nio.FloatViewBufferImpl", "java.nio.IntViewBufferImpl", "java.nio.LongViewBufferImpl", "java.nio.ShortViewBufferImpl"}) {
                    attachmentOrByteBufferFieldNameMap.put(byteBufferAsNonByteBufferClassname, "bb");
                }
            } else if (javaVendor.contains("Apache")) {
                byteBufferAsNonByteBufferByteBufferFieldName = "byteBuffer";
                for (Iterator<Object> byteBufferAsNonByteBufferClassname : byteBufferAsNonByteBufferClassnames = new String[]{"java.nio.CharToByteBufferAdapter", "java.nio.DoubleToByteBufferAdapter", "java.nio.FloatToByteBufferAdapter", "java.nio.IntToByteBufferAdapter", "java.nio.LongToByteBufferAdapter", "java.nio.ShortToByteBufferAdapter"}) {
                    attachmentOrByteBufferFieldNameMap.put(byteBufferAsNonByteBufferClassname, "byteBuffer");
                }
            } else if (javaVendor.equals("Jeroen Frijters") || javaVendor.contains("IBM")) {
                // empty if block
            }
        }
        if (!attachmentOrByteBufferFieldNameMap.isEmpty()) {
            ArrayList classnamesToRemove = new ArrayList();
            for (String classname : attachmentOrByteBufferFieldNameMap.keySet()) {
                try {
                    Class.forName(classname);
                }
                catch (ClassNotFoundException cnfe) {
                    classnamesToRemove.add(classname);
                }
            }
            byteBufferAsNonByteBufferClassnames = classnamesToRemove.iterator();
            while (byteBufferAsNonByteBufferClassnames.hasNext()) {
                String classnameToRemove = (String)byteBufferAsNonByteBufferClassnames.next();
                attachmentOrByteBufferFieldNameMap.remove(classnameToRemove);
            }
        }
        this.attachmentOrByteBufferFieldMap = new HashMap();
        if (!attachmentOrByteBufferFieldNameMap.isEmpty()) {
            for (Map.Entry attachmentOrByteBufferFieldNameEntry : attachmentOrByteBufferFieldNameMap.entrySet()) {
                String classname;
                classname = (String)attachmentOrByteBufferFieldNameEntry.getKey();
                String fieldname = (String)attachmentOrByteBufferFieldNameEntry.getValue();
                try {
                    Class<?> bufferClass = Class.forName(classname);
                    Field bufferField = null;
                    ArrayList intermediaryClassWithoutBufferList = new ArrayList();
                    for (Class<?> bufferIntermediaryClass = bufferClass; bufferIntermediaryClass != null; bufferIntermediaryClass = bufferIntermediaryClass.getSuperclass()) {
                        try {
                            bufferField = bufferIntermediaryClass.getDeclaredField(fieldname);
                            continue;
                        }
                        catch (NoSuchFieldException nsfe) {
                            if (bufferIntermediaryClass.equals(Object.class) || bufferIntermediaryClass.equals(Buffer.class)) continue;
                            intermediaryClassWithoutBufferList.add(bufferIntermediaryClass);
                        }
                    }
                    if (bufferField == null) {
                        String superClassesMsg;
                        if (intermediaryClassWithoutBufferList.isEmpty()) {
                            superClassesMsg = "";
                        } else if (intermediaryClassWithoutBufferList.size() == 1) {
                            superClassesMsg = " and in its super class " + ((Class)intermediaryClassWithoutBufferList.get(0)).getName();
                        } else {
                            StringBuilder builder = new StringBuilder();
                            builder.append(" and in its super classes");
                            int classIndex = 0;
                            for (Class intermediaryClassWithoutBuffer : intermediaryClassWithoutBufferList) {
                                builder.append(' ');
                                builder.append(intermediaryClassWithoutBuffer.getName());
                                if (classIndex < intermediaryClassWithoutBufferList.size() - 1) {
                                    builder.append(',');
                                }
                                ++classIndex;
                            }
                            superClassesMsg = builder.toString();
                        }
                        this.logger.warn("The field " + fieldname + " hasn't been found in the class " + classname + superClassesMsg);
                        continue;
                    }
                    this.attachmentOrByteBufferFieldMap.put(bufferClass, bufferField);
                }
                catch (ClassNotFoundException cnfe) {
                    msg = "The class " + classname + " hasn't been found while initializing the deallocator. Java vendor: " + javaVendor + " Java version: " + javaVersion;
                    this.logger.warn(msg, cnfe);
                }
            }
        }
        if (attachmentOrByteBufferFieldNameMap.isEmpty()) {
            ByteBuffer slicedBigEndianReadOnlyDirectByteBuffer = ((ByteBuffer)ByteBuffer.allocateDirect(2).order(ByteOrder.BIG_ENDIAN).put((byte)0).put((byte)0).position(1).limit(2)).slice().asReadOnlyBuffer();
            ByteBuffer slicedBigEndianReadWriteDirectByteBuffer = ((ByteBuffer)ByteBuffer.allocateDirect(2).order(ByteOrder.BIG_ENDIAN).put((byte)0).put((byte)0).position(1).limit(2)).slice();
            CharBuffer bigEndianReadOnlyDirectCharBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer().asCharBuffer();
            CharBuffer bigEndianReadWriteDirectCharBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asCharBuffer();
            DoubleBuffer bigEndianReadOnlyDirectDoubleBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer().asDoubleBuffer();
            DoubleBuffer bigEndianReadWriteDirectDoubleBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asDoubleBuffer();
            FloatBuffer bigEndianReadOnlyDirectFloatBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer().asFloatBuffer();
            FloatBuffer bigEndianReadWriteDirectFloatBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asFloatBuffer();
            IntBuffer bigEndianReadOnlyDirectIntBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer().asIntBuffer();
            IntBuffer bigEndianReadWriteDirectIntBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
            LongBuffer bigEndianReadOnlyDirectLongBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer().asLongBuffer();
            LongBuffer bigEndianReadWriteDirectLongBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asLongBuffer();
            ShortBuffer bigEndianReadOnlyDirectShortBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer().asShortBuffer();
            ShortBuffer bigEndianReadWriteDirectShortBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.BIG_ENDIAN).asShortBuffer();
            ByteBuffer slicedLittleEndianReadOnlyDirectByteBuffer = ((ByteBuffer)ByteBuffer.allocateDirect(2).order(ByteOrder.LITTLE_ENDIAN).put((byte)0).put((byte)0).position(1).limit(2)).slice().asReadOnlyBuffer();
            ByteBuffer slicedLittleEndianReadWriteDirectByteBuffer = ((ByteBuffer)ByteBuffer.allocateDirect(2).order(ByteOrder.LITTLE_ENDIAN).put((byte)0).put((byte)0).position(1).limit(2)).slice();
            CharBuffer littleEndianReadOnlyDirectCharBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asReadOnlyBuffer().asCharBuffer();
            CharBuffer littleEndianReadWriteDirectCharBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asCharBuffer();
            DoubleBuffer littleEndianReadOnlyDirectDoubleBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asReadOnlyBuffer().asDoubleBuffer();
            DoubleBuffer littleEndianReadWriteDirectDoubleBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer();
            FloatBuffer littleEndianReadOnlyDirectFloatBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asReadOnlyBuffer().asFloatBuffer();
            FloatBuffer littleEndianReadWriteDirectFloatBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
            IntBuffer littleEndianReadOnlyDirectIntBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asReadOnlyBuffer().asIntBuffer();
            IntBuffer littleEndianReadWriteDirectIntBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
            LongBuffer littleEndianReadOnlyDirectLongBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asReadOnlyBuffer().asLongBuffer();
            LongBuffer littleEndianReadWriteDirectLongBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
            ShortBuffer littleEndianReadOnlyDirectShortBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asReadOnlyBuffer().asShortBuffer();
            ShortBuffer littleEndianReadWriteDirectShortBuffer = ByteBuffer.allocateDirect(1).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
            ArrayList<Buffer> buffers = new ArrayList<Buffer>();
            buffers.add(slicedBigEndianReadOnlyDirectByteBuffer);
            buffers.add(slicedBigEndianReadWriteDirectByteBuffer);
            buffers.add(bigEndianReadOnlyDirectCharBuffer);
            buffers.add(bigEndianReadWriteDirectCharBuffer);
            buffers.add(bigEndianReadOnlyDirectDoubleBuffer);
            buffers.add(bigEndianReadWriteDirectDoubleBuffer);
            buffers.add(bigEndianReadOnlyDirectFloatBuffer);
            buffers.add(bigEndianReadWriteDirectFloatBuffer);
            buffers.add(bigEndianReadOnlyDirectIntBuffer);
            buffers.add(bigEndianReadWriteDirectIntBuffer);
            buffers.add(bigEndianReadOnlyDirectLongBuffer);
            buffers.add(bigEndianReadWriteDirectLongBuffer);
            buffers.add(bigEndianReadOnlyDirectShortBuffer);
            buffers.add(bigEndianReadWriteDirectShortBuffer);
            buffers.add(slicedLittleEndianReadOnlyDirectByteBuffer);
            buffers.add(slicedLittleEndianReadWriteDirectByteBuffer);
            buffers.add(littleEndianReadOnlyDirectCharBuffer);
            buffers.add(littleEndianReadWriteDirectCharBuffer);
            buffers.add(littleEndianReadOnlyDirectDoubleBuffer);
            buffers.add(littleEndianReadWriteDirectDoubleBuffer);
            buffers.add(littleEndianReadOnlyDirectFloatBuffer);
            buffers.add(littleEndianReadWriteDirectFloatBuffer);
            buffers.add(littleEndianReadOnlyDirectIntBuffer);
            buffers.add(littleEndianReadWriteDirectIntBuffer);
            buffers.add(littleEndianReadOnlyDirectLongBuffer);
            buffers.add(littleEndianReadWriteDirectLongBuffer);
            buffers.add(littleEndianReadOnlyDirectShortBuffer);
            buffers.add(littleEndianReadWriteDirectShortBuffer);
            for (Buffer buffer : buffers) {
                Class<?> bufferClass = buffer.getClass();
                if (this.attachmentOrByteBufferFieldMap.containsKey(bufferClass)) continue;
                Field bufferField = null;
                block36: for (Class<?> bufferIntermediaryClass = bufferClass; bufferIntermediaryClass != null && bufferField == null; bufferIntermediaryClass = bufferIntermediaryClass.getSuperclass()) {
                    for (Field field : bufferIntermediaryClass.getDeclaredFields()) {
                        boolean fieldWasAccessible = field.isAccessible();
                        try {
                            field.setAccessible(true);
                            Object fieldValue = field.get(buffer);
                            if (fieldValue == null || !(fieldValue instanceof Buffer)) continue;
                            bufferField = field;
                            continue block36;
                        }
                        catch (IllegalAccessException iae) {
                            this.logger.warn("Cannot access the field " + field.getName() + " of the class " + bufferIntermediaryClass.getName(), iae);
                        }
                        finally {
                            field.setAccessible(fieldWasAccessible);
                        }
                    }
                }
                if (bufferField == null) continue;
                this.attachmentOrByteBufferFieldMap.put(bufferClass, bufferField);
            }
            buffersToDelete.addAll(buffers);
        }
        this.deallocatableBufferClassSet = new HashSet();
        if (javaVendor.equals("Sun Microsystems Inc.") || javaVendor.equals("Oracle Corporation") || javaVendor.equals("The Android Project")) {
            Class<?> directByteBufferClass = null;
            String directByteBufferClassName = "java.nio.DirectByteBuffer";
            try {
                directByteBufferClass = Class.forName("java.nio.DirectByteBuffer");
            }
            catch (ClassNotFoundException cnfe) {
                String msg2 = "The class java.nio.DirectByteBuffer hasn't been found while initializing the deallocator. Java vendor: " + javaVendor + " Java version: " + javaVersion;
                this.logger.warn(msg2, cnfe);
            }
            if (directByteBufferClass != null) {
                this.deallocatableBufferClassSet.add(directByteBufferClass);
            }
        } else if (javaVendor.equals("Free Software Foundation, Inc.")) {
            readOnlyDirectByteBufferClass = null;
            readOnlyDirectByteBufferClassName = "java.nio.DirectByteBufferImpl.ReadOnly";
            try {
                readOnlyDirectByteBufferClass = Class.forName("java.nio.DirectByteBufferImpl.ReadOnly");
            }
            catch (ClassNotFoundException cnfe) {
                String msg3 = "The class java.nio.DirectByteBufferImpl.ReadOnly hasn't been found while initializing the deallocator. Java vendor: " + javaVendor + " Java version: " + javaVersion;
                this.logger.warn(msg3, cnfe);
            }
            if (readOnlyDirectByteBufferClass != null) {
                this.deallocatableBufferClassSet.add(readOnlyDirectByteBufferClass);
            }
            readWriteDirectByteBufferClass = null;
            String readWriteDirectByteBufferClassName = "java.nio.DirectByteBufferImpl.ReadWrite";
            try {
                readWriteDirectByteBufferClass = Class.forName("java.nio.DirectByteBufferImpl.ReadWrite");
            }
            catch (ClassNotFoundException cnfe) {
                msg = "The class java.nio.DirectByteBufferImpl.ReadWrite hasn't been found while initializing the deallocator. Java vendor: " + javaVendor + " Java version: " + javaVersion;
                this.logger.warn(msg, cnfe);
            }
            if (readWriteDirectByteBufferClass != null) {
                this.deallocatableBufferClassSet.add(readWriteDirectByteBufferClass);
            }
        } else if (javaVendor.contains("Apache")) {
            readOnlyDirectByteBufferClass = null;
            readOnlyDirectByteBufferClassName = "java.nio.ReadOnlyDirectByteBuffer";
            try {
                readOnlyDirectByteBufferClass = Class.forName("java.nio.ReadOnlyDirectByteBuffer");
            }
            catch (ClassNotFoundException cnfe) {
                String msg4 = "The class java.nio.ReadOnlyDirectByteBuffer hasn't been found while initializing the deallocator. Java vendor: " + javaVendor + " Java version: " + javaVersion;
                this.logger.warn(msg4, cnfe);
            }
            if (readOnlyDirectByteBufferClass != null) {
                this.deallocatableBufferClassSet.add(readOnlyDirectByteBufferClass);
            }
            readWriteDirectByteBufferClass = null;
            String readWriteDirectByteBufferClassName = "java.nio.ReadWriteDirectByteBuffer";
            try {
                readWriteDirectByteBufferClass = Class.forName("java.nio.ReadWriteDirectByteBuffer");
            }
            catch (ClassNotFoundException cnfe) {
                msg = "The class java.nio.ReadWriteDirectByteBuffer hasn't been found while initializing the deallocator. Java vendor: " + javaVendor + " Java version: " + javaVersion;
                this.logger.warn(msg, cnfe);
            }
            if (readWriteDirectByteBufferClass != null) {
                this.deallocatableBufferClassSet.add(readWriteDirectByteBufferClass);
            }
        } else if (javaVendor.equals("Jeroen Frijters") || javaVendor.contains("IBM")) {
            // empty if block
        }
        if (this.deallocatableBufferClassSet.isEmpty()) {
            ByteBuffer dummyReadWriteDirectByteBuffer = ByteBuffer.allocateDirect(1);
            Class<?> readWriteDirectByteBufferClass2 = dummyReadWriteDirectByteBuffer.getClass();
            this.deallocatableBufferClassSet.add(readWriteDirectByteBufferClass2);
            buffersToDelete.add(dummyReadWriteDirectByteBuffer);
            ByteBuffer dummyReadOnlyDirectByteBuffer = ByteBuffer.allocateDirect(1).asReadOnlyBuffer();
            Class<?> readOnlyDirectByteBufferClass2 = dummyReadOnlyDirectByteBuffer.getClass();
            this.deallocatableBufferClassSet.add(readOnlyDirectByteBufferClass2);
            buffersToDelete.add(dummyReadOnlyDirectByteBuffer);
        }
        this.deallocator = javaVendor.equals("Sun Microsystems Inc.") || javaVendor.equals("Oracle Corporation") ? new OracleSunOpenJdkDeallocator() : (javaVendor.equals("The Android Project") ? new AndroidDeallocator() : (javaVendor.equals("Free Software Foundation, Inc.") ? new GnuClasspathDeallocator() : (javaVendor.contains("Apache") ? new ApacheHarmonyDeallocator() : (javaVendor.equals("Jeroen Frijters") ? null : (javaVendor.contains("IBM") ? null : null)))));
        for (Buffer bufferToDelete : buffersToDelete) {
            this.deallocate(bufferToDelete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer findDeallocatableBuffer(Buffer buffer) {
        ByteBuffer deallocatableDirectByteBuffer;
        if (buffer != null && buffer.isDirect()) {
            Buffer attachmentBufferOrByteBuffer;
            Field attachmentOrByteBufferField;
            Class<?> bufferClass = buffer.getClass();
            Field field = attachmentOrByteBufferField = this.attachmentOrByteBufferFieldMap == null ? null : this.attachmentOrByteBufferFieldMap.get(bufferClass);
            if (attachmentOrByteBufferField == null) {
                attachmentBufferOrByteBuffer = null;
            } else {
                Object attachedObjectOrByteBuffer;
                boolean attachedObjectOrByteBufferFieldWasAccessible = attachmentOrByteBufferField.isAccessible();
                try {
                    attachmentOrByteBufferField.setAccessible(true);
                    attachedObjectOrByteBuffer = attachmentOrByteBufferField.get(buffer);
                }
                catch (IllegalAccessException | IllegalArgumentException iae) {
                    attachedObjectOrByteBuffer = null;
                }
                finally {
                    attachmentOrByteBufferField.setAccessible(attachedObjectOrByteBufferFieldWasAccessible);
                }
                attachmentBufferOrByteBuffer = attachedObjectOrByteBuffer instanceof Buffer ? (Buffer)attachedObjectOrByteBuffer : null;
            }
            if (attachmentBufferOrByteBuffer == null) {
                if (buffer instanceof ByteBuffer && this.deallocatableBufferClassSet.contains(bufferClass)) {
                    deallocatableDirectByteBuffer = (ByteBuffer)buffer;
                } else {
                    deallocatableDirectByteBuffer = null;
                    String bufferClassName = bufferClass.getName();
                    this.logger.warn("No deallocatable buffer has been found for an instance of the class " + bufferClassName + " whereas it is a direct NIO buffer");
                }
            } else {
                deallocatableDirectByteBuffer = this.findDeallocatableBuffer(attachmentBufferOrByteBuffer);
            }
        } else {
            deallocatableDirectByteBuffer = null;
        }
        return deallocatableDirectByteBuffer;
    }

    public void deallocate(Buffer buffer) {
        ByteBuffer deallocatableBuffer;
        if (this.deallocator != null && (deallocatableBuffer = this.findDeallocatableBuffer(buffer)) != null) {
            this.deallocator.run(deallocatableBuffer);
        }
    }

    public Deallocator getDeallocator() {
        return this.deallocator;
    }

    public void setDeallocator(Deallocator deallocator) {
        this.deallocator = deallocator;
    }

    public Map<Class<?>, Field> getAttachmentOrByteBufferFieldMap() {
        return this.attachmentOrByteBufferFieldMap;
    }

    public void setAttachmentOrByteBufferFieldMap(Map<Class<?>, Field> attachmentOrByteBufferFieldMap) {
        this.attachmentOrByteBufferFieldMap = attachmentOrByteBufferFieldMap;
    }

    public Set<Class<?>> getDeallocatableBufferClassSet() {
        return this.deallocatableBufferClassSet;
    }

    public void setDeallocatableBufferClassSet(Set<Class<?>> deallocatableBufferClassSet) {
        this.deallocatableBufferClassSet = deallocatableBufferClassSet;
    }

    public static class AndroidDeallocator
    extends Deallocator {
        private Method directByteBufferFreeMethod;

        public AndroidDeallocator() {
            try {
                Class<?> directByteBufferClass = Class.forName("java.nio.DirectByteBuffer");
                this.directByteBufferFreeMethod = directByteBufferClass.getDeclaredMethod("free", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                this.logger.warn("The initialization of the deallocator for Android has failed", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run(ByteBuffer directByteBuffer) {
            boolean success = false;
            if (this.directByteBufferFreeMethod != null) {
                boolean directByteBufferFreeMethodWasAccessible = this.directByteBufferFreeMethod.isAccessible();
                try {
                    this.directByteBufferFreeMethod.setAccessible(true);
                    this.directByteBufferFreeMethod.invoke((Object)directByteBuffer, new Object[0]);
                    success = true;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    this.logger.warn("The deallocation of a direct NIO buffer has failed", e);
                }
                finally {
                    this.directByteBufferFreeMethod.setAccessible(directByteBufferFreeMethodWasAccessible);
                }
            }
            return success;
        }
    }

    public static class ApacheHarmonyDeallocator
    extends Deallocator {
        private Method directByteBufferFreeMethod;

        public ApacheHarmonyDeallocator() {
            try {
                Class<?> directByteBufferClass = Class.forName("java.nio.DirectByteBuffer");
                this.directByteBufferFreeMethod = directByteBufferClass.getDeclaredMethod("free", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                this.logger.warn("The initialization of the deallocator for Apache Harmony has failed", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run(ByteBuffer directByteBuffer) {
            boolean success = false;
            if (this.directByteBufferFreeMethod != null) {
                boolean directByteBufferFreeMethodWasAccessible = this.directByteBufferFreeMethod.isAccessible();
                try {
                    this.directByteBufferFreeMethod.setAccessible(true);
                    this.directByteBufferFreeMethod.invoke((Object)directByteBuffer, new Object[0]);
                    success = true;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    this.logger.warn("The deallocation of a direct NIO buffer has failed", e);
                }
                finally {
                    this.directByteBufferFreeMethod.setAccessible(directByteBufferFreeMethodWasAccessible);
                }
            }
            return success;
        }
    }

    public static abstract class Deallocator {
        protected final Log logger = I2PAppContext.getGlobalContext().logManager().getLog(DeallocationHelper.class);

        public abstract boolean run(ByteBuffer var1);
    }

    public static class GnuClasspathDeallocator
    extends Deallocator {
        private Method vmDirectByteBufferFreeMethod;
        private Field bufferAddressField;

        public GnuClasspathDeallocator() {
            try {
                Class<?> vmDirectByteBufferClass = Class.forName("java.nio.VMDirectByteBuffer");
                Class<?> gnuClasspathPointerClass = Class.forName("gnu.classpath.Pointer");
                this.vmDirectByteBufferFreeMethod = vmDirectByteBufferClass.getDeclaredMethod("free", gnuClasspathPointerClass);
                this.bufferAddressField = Buffer.class.getDeclaredField("address");
            }
            catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException e) {
                this.logger.warn("The initialization of the deallocator for GNU Classpath has failed", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run(ByteBuffer directByteBuffer) {
            boolean success = false;
            if (this.vmDirectByteBufferFreeMethod != null && this.bufferAddressField != null) {
                boolean bufferAddressFieldWasAccessible = this.bufferAddressField.isAccessible();
                boolean vmDirectByteBufferFreeMethodWasAccessible = this.vmDirectByteBufferFreeMethod.isAccessible();
                try {
                    this.bufferAddressField.setAccessible(true);
                    Object address = this.bufferAddressField.get(directByteBuffer);
                    if (address != null) {
                        this.vmDirectByteBufferFreeMethod.setAccessible(true);
                        this.vmDirectByteBufferFreeMethod.invoke(null, address);
                        success = true;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    this.logger.warn("The deallocation of a direct NIO buffer has failed", e);
                }
                finally {
                    this.bufferAddressField.setAccessible(bufferAddressFieldWasAccessible);
                    this.vmDirectByteBufferFreeMethod.setAccessible(vmDirectByteBufferFreeMethodWasAccessible);
                }
            }
            return success;
        }
    }

    public static class OracleSunOpenJdkDeallocator
    extends Deallocator {
        private Method directByteBufferCleanerMethod;
        private Method cleanerCleanMethod;

        public OracleSunOpenJdkDeallocator() {
            try {
                Class<?> directByteBufferClass = Class.forName("java.nio.DirectByteBuffer");
                this.directByteBufferCleanerMethod = directByteBufferClass.getDeclaredMethod("cleaner", new Class[0]);
                Class<?> cleanerClass = this.directByteBufferCleanerMethod.getReturnType();
                this.cleanerCleanMethod = Runnable.class.isAssignableFrom(cleanerClass) ? Runnable.class.getDeclaredMethod("run", new Class[0]) : cleanerClass.getDeclaredMethod("clean", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                this.logger.warn("The initialization of the deallocator for Oracle Java, Sun Java and OpenJDK has failed", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean run(ByteBuffer directByteBuffer) {
            boolean success = false;
            if (this.directByteBufferCleanerMethod != null && this.cleanerCleanMethod != null) {
                boolean directByteBufferCleanerMethodWasAccessible = this.directByteBufferCleanerMethod.isAccessible();
                boolean cleanerCleanMethodWasAccessible = this.cleanerCleanMethod.isAccessible();
                try {
                    this.directByteBufferCleanerMethod.setAccessible(true);
                    Object cleaner = this.directByteBufferCleanerMethod.invoke((Object)directByteBuffer, new Object[0]);
                    if (cleaner != null) {
                        this.cleanerCleanMethod.setAccessible(true);
                        this.cleanerCleanMethod.invoke(cleaner, new Object[0]);
                        success = true;
                    }
                }
                catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
                    this.logger.warn("The deallocation of a direct NIO buffer has failed", e);
                }
                finally {
                    this.directByteBufferCleanerMethod.setAccessible(directByteBufferCleanerMethodWasAccessible);
                    this.cleanerCleanMethod.setAccessible(cleanerCleanMethodWasAccessible);
                }
            }
            return success;
        }
    }
}

