/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jrobin.core.ArcDef;
import org.jrobin.core.Archive;
import org.jrobin.core.Datasource;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;

public class RrdToolkit {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDatasource(String sourcePath, String destPath, DsDef newDatasource) throws IOException, RrdException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new RrdException("Source and destination paths are the same");
        }
        try (RrdDb rrdSource = new RrdDb(sourcePath);){
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            rrdDef.addDatasource(newDatasource);
            try (RrdDb rrdDest = new RrdDb(rrdDef);){
                rrdSource.copyStateTo(rrdDest);
            }
        }
    }

    public static void addDatasource(String sourcePath, DsDef newDatasource, boolean saveBackup) throws IOException, RrdException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.addDatasource(sourcePath, destPath, newDatasource);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDatasource(String sourcePath, String destPath, String dsName) throws IOException, RrdException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new RrdException("Source and destination paths are the same");
        }
        try (RrdDb rrdSource = new RrdDb(sourcePath);){
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            rrdDef.removeDatasource(dsName);
            try (RrdDb rrdDest = new RrdDb(rrdDef);){
                rrdSource.copyStateTo(rrdDest);
            }
        }
    }

    public static void removeDatasource(String sourcePath, String dsName, boolean saveBackup) throws IOException, RrdException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.removeDatasource(sourcePath, destPath, dsName);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameDatasource(String sourcePath, String oldDsName, String newDsName) throws IOException, RrdException {
        block4: {
            try (RrdDb rrd = new RrdDb(sourcePath);){
                if (rrd.containsDs(oldDsName)) {
                    Datasource datasource = rrd.getDatasource(oldDsName);
                    datasource.setDsName(newDsName);
                    break block4;
                }
                throw new RrdException("Could not find datasource [" + oldDsName + "] in file " + sourcePath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int forceZerosForNans(String sourcePath, String dsName) throws IOException, RrdException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource[] datasources;
            if (dsName == null) {
                datasources = rrd.getDatasources();
            } else if (rrd.containsDs(dsName)) {
                datasources = new Datasource[]{rrd.getDatasource(dsName)};
            } else {
                throw new RrdException("Could not find datasource [" + dsName + "] in file " + sourcePath);
            }
            int count = 0;
            for (Datasource datasource : datasources) {
                String currentDsName = datasource.getDsName();
                if (currentDsName.endsWith("!")) continue;
                datasource.setDsName(currentDsName + "!");
                ++count;
            }
            int n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addArchive(String sourcePath, String destPath, ArcDef newArchive) throws IOException, RrdException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new RrdException("Source and destination paths are the same");
        }
        try (RrdDb rrdSource = new RrdDb(sourcePath);){
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            rrdDef.addArchive(newArchive);
            try (RrdDb rrdDest = new RrdDb(rrdDef);){
                rrdSource.copyStateTo(rrdDest);
            }
        }
    }

    public static void addArchive(String sourcePath, ArcDef newArchive, boolean saveBackup) throws IOException, RrdException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.addArchive(sourcePath, destPath, newArchive);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeArchive(String sourcePath, String destPath, String consolFun, int steps) throws IOException, RrdException {
        if (Util.sameFilePath(sourcePath, destPath)) {
            throw new RrdException("Source and destination paths are the same");
        }
        try (RrdDb rrdSource = new RrdDb(sourcePath);){
            RrdDef rrdDef = rrdSource.getRrdDef();
            rrdDef.setPath(destPath);
            rrdDef.removeArchive(consolFun, steps);
            try (RrdDb rrdDest = new RrdDb(rrdDef);){
                rrdSource.copyStateTo(rrdDest);
            }
        }
    }

    public static void removeArchive(String sourcePath, String consolFun, int steps, boolean saveBackup) throws IOException, RrdException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.removeArchive(sourcePath, destPath, consolFun, steps);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    private static void copyFile(String sourcePath, String destPath, boolean saveBackup) throws IOException {
        File source = new File(sourcePath);
        File dest = new File(destPath);
        if (saveBackup) {
            String backupPath = RrdToolkit.getBackupPath(destPath);
            File backup = new File(backupPath);
            RrdToolkit.deleteFile(backup);
            if (!dest.renameTo(backup)) {
                throw new IOException("Could not create backup file " + backupPath);
            }
        }
        RrdToolkit.deleteFile(dest);
        if (!source.renameTo(dest)) {
            throw new IOException("Could not create file " + destPath + " from " + sourcePath);
        }
    }

    private static String getBackupPath(String destPath) {
        StringBuffer sb = new StringBuffer(destPath);
        do {
            sb.append(".bak");
        } while (Util.fileExists(sb.toString()));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsHeartbeat(String sourcePath, String datasourceName, long newHeartbeat) throws RrdException, IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setHeartbeat(newHeartbeat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsHeartbeat(String sourcePath, int dsIndex, long newHeartbeat) throws RrdException, IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource ds = rrd.getDatasource(dsIndex);
            ds.setHeartbeat(newHeartbeat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsMinValue(String sourcePath, String datasourceName, double newMinValue, boolean filterArchivedValues) throws RrdException, IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setMinValue(newMinValue, filterArchivedValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsMaxValue(String sourcePath, String datasourceName, double newMaxValue, boolean filterArchivedValues) throws RrdException, IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setMaxValue(newMaxValue, filterArchivedValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDsMinMaxValue(String sourcePath, String datasourceName, double newMinValue, double newMaxValue, boolean filterArchivedValues) throws RrdException, IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Datasource ds = rrd.getDatasource(datasourceName);
            ds.setMinMaxValue(newMinValue, newMaxValue, filterArchivedValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setArcXff(String sourcePath, String consolFun, int steps, double newXff) throws RrdException, IOException {
        try (RrdDb rrd = new RrdDb(sourcePath);){
            Archive arc = rrd.getArchive(consolFun, steps);
            arc.setXff(newXff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resizeArchive(String sourcePath, String destPath, String consolFun, int numSteps, int newRows) throws IOException, RrdException {
        block8: {
            if (Util.sameFilePath(sourcePath, destPath)) {
                throw new RrdException("Source and destination paths are the same");
            }
            if (newRows < 2) {
                throw new RrdException("New arcihve size must be at least 2");
            }
            try (RrdDb rrdSource = new RrdDb(sourcePath);){
                RrdDef rrdDef = rrdSource.getRrdDef();
                ArcDef arcDef = rrdDef.findArchive(consolFun, numSteps);
                if (arcDef.getRows() == newRows) break block8;
                arcDef.setRows(newRows);
                rrdDef.setPath(destPath);
                try (RrdDb rrdDest = new RrdDb(rrdDef);){
                    rrdSource.copyStateTo(rrdDest);
                }
            }
        }
    }

    public static void resizeArchive(String sourcePath, String consolFun, int numSteps, int newRows, boolean saveBackup) throws IOException, RrdException {
        String destPath = Util.getTmpFilename();
        RrdToolkit.resizeArchive(sourcePath, destPath, consolFun, numSteps, newRows);
        RrdToolkit.copyFile(destPath, sourcePath, saveBackup);
    }

    private static void deleteFile(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete file: " + file.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void split(String sourcePath) throws IOException, RrdException {
        try (RrdDb rrdSource = new RrdDb(sourcePath);){
            String[] dsNames;
            for (String dsName : dsNames = rrdSource.getDsNames()) {
                RrdDef rrdDef = rrdSource.getRrdDef();
                rrdDef.setPath(RrdToolkit.createSplitPath(dsName, sourcePath));
                rrdDef.saveSingleDatasource(dsName);
                try (RrdDb rrdDest = new RrdDb(rrdDef);){
                    rrdSource.copyStateTo(rrdDest);
                }
            }
        }
    }

    public static String[] getCanonicalPaths(String directory, String extension, boolean resursive) throws IOException {
        File baseDir = new File(directory);
        if (!baseDir.isDirectory()) {
            throw new IOException("Not a directory: " + directory);
        }
        LinkedList<String> fileList = new LinkedList<String>();
        RrdToolkit.traverseDirectory(new File(directory), extension, resursive, fileList);
        Object[] result = fileList.toArray(new String[fileList.size()]);
        Arrays.sort(result);
        return result;
    }

    private static void traverseDirectory(File directory, String extension, boolean recursive, List<String> list) throws IOException {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory() && recursive) {
                RrdToolkit.traverseDirectory(file, extension, recursive, list);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(extension)) continue;
            list.add(file.getCanonicalPath());
        }
    }

    private static String createSplitPath(String dsName, String sourcePath) {
        File file = new File(sourcePath);
        String newName = dsName + "-" + file.getName();
        String path = file.getAbsolutePath();
        String parentDir = path.substring(0, 1 + path.lastIndexOf(Util.getFileSeparator()));
        return parentDir + newName;
    }
}

