/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jrobin.core.RrdBackend;

public class RrdMemoryBackend
extends RrdBackend {
    private static final ReadWriteLock m_readWritelock = new ReentrantReadWriteLock();
    private static final Lock m_readLock = m_readWritelock.readLock();
    private static final Lock m_writeLock = m_readWritelock.writeLock();
    private byte[] buffer = new byte[0];

    protected RrdMemoryBackend(String path) {
        super(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(long offset, byte[] b) {
        m_writeLock.lock();
        try {
            int pos = (int)offset;
            for (byte singleByte : b) {
                this.buffer[pos++] = singleByte;
            }
        }
        finally {
            m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void read(long offset, byte[] b) throws IOException {
        block5: {
            m_readLock.lock();
            try {
                int pos = (int)offset;
                if (pos + b.length <= this.buffer.length) {
                    for (int i = 0; i < b.length; ++i) {
                        b[i] = this.buffer[pos++];
                    }
                    break block5;
                }
                throw new IOException("Not enough bytes available in memory " + this.getPath());
            }
            finally {
                m_readLock.unlock();
            }
        }
    }

    @Override
    public long getLength() {
        m_readLock.lock();
        try {
            long l = this.buffer.length;
            return l;
        }
        finally {
            m_readLock.unlock();
        }
    }

    @Override
    protected void setLength(long newLength) throws IOException {
        m_writeLock.lock();
        try {
            if (newLength > Integer.MAX_VALUE) {
                throw new IOException("Cannot create this big memory backed RRD");
            }
            this.buffer = new byte[(int)newLength];
        }
        finally {
            m_writeLock.unlock();
        }
    }

    @Override
    public void close() {
    }

    @Override
    protected boolean isCachingAllowed() {
        return false;
    }
}

