/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.transport.udp.OutboundMessageState;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

class OutboundMessageFragments {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final Set<PeerState> _activePeers;
    private Iterator<PeerState> _iterator;
    private boolean _isWaiting;
    private volatile boolean _alive;
    private final PacketBuilder _builder;
    static final int MAX_VOLLEYS = 10;
    private static final int MAX_WAIT = 1000;

    public OutboundMessageFragments(RouterContext ctx, UDPTransport transport, ActiveThrottle throttle) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(OutboundMessageFragments.class);
        this._transport = transport;
        this._activePeers = new ConcurrentHashSet<PeerState>(256);
        this._builder = new PacketBuilder(ctx, transport);
        this._alive = true;
        this._context.statManager().createRateStat("udp.sendVolleyTime", "Long it takes to send a full volley", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendConfirmTime", "How long it takes to send a message and get the ACK", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendConfirmFragments", "How many fragments are included in a fully ACKed message", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendFragmentsPerPacket", "How many fragments are sent in a data packet", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendConfirmVolley", "How many times did fragments need to be sent before ACK", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendFailed", "How many sends a failed message was pushed", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendAggressiveFailed", "How many volleys was a packet sent before we gave up", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.outboundActiveCount", "How many messages are in the peer's active pool", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.outboundActivePeers", "How many peers we are actively sending to", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendRejected", "What volley are we on when the peer was throttled", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.partialACKReceived", "How many fragments were partially ACKed", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPiggyback", "How many acks were piggybacked on a data packet (time == message lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendPiggybackPartial", "How many partial acks were piggybacked on a data packet (time == message lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRequiredRateStat("udp.packetsRetransmitted", "Lifetime of packets during retransmission (ms)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.peerPacketsRetransmitted", "How many packets have been retransmitted to the peer (lifetime) when a burst of packets are retransmitted (period == packets transmitted, lifetime)", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.blockedRetransmissions", "How packets have been transmitted to the peer when we blocked a retransmission to them?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendCycleTime", "How long it takes to cycle through all of the active messages?", "udp", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendCycleTimeSlow", "How long it takes to cycle through all of the active messages, when its going slowly?", "udp", UDPTransport.RATES);
    }

    public synchronized void startup() {
        this._alive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        this._alive = false;
        this._activePeers.clear();
        Set<PeerState> set = this._activePeers;
        synchronized (set) {
            this._activePeers.notifyAll();
        }
    }

    void dropPeer(PeerState peer) {
        if (this._log.shouldLog(20)) {
            this._log.info("Dropping peer " + peer.getRemotePeer());
        }
        peer.dropOutbound();
        this._activePeers.remove(peer);
    }

    public boolean waitForMoreAllowed() {
        return true;
    }

    public void add(OutNetMessage msg) {
        RouterInfo target = msg.getTarget();
        if (target == null) {
            return;
        }
        PeerState peer = this._transport.getPeerState(target.getIdentity().calculateHash());
        try {
            OutboundMessageState state = new OutboundMessageState((I2PAppContext)this._context, msg, peer);
            peer.add(state);
            this.add(peer);
        }
        catch (IllegalArgumentException iae) {
            this._transport.failed(msg, "Peer disconnected quickly");
            return;
        }
    }

    public void add(OutboundMessageState state, PeerState peer) {
        if (peer == null) {
            throw new RuntimeException("null peer for " + state);
        }
        peer.add(state);
        this.add(peer);
    }

    public void add(List<OutboundMessageState> states, PeerState peer) {
        if (peer == null) {
            throw new RuntimeException("null peer");
        }
        int sz = states.size();
        for (int i = 0; i < sz; ++i) {
            peer.add(states.get(i));
        }
        this.add(peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(PeerState peer) {
        boolean wasEmpty = this._activePeers.isEmpty();
        boolean added = this._activePeers.add(peer);
        if (added) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Add a new message to a new peer " + peer.getRemotePeer());
            }
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Add a new message to an existing peer " + peer.getRemotePeer());
        }
        this._context.statManager().addRateData("udp.outboundActivePeers", this._activePeers.size());
        if (this._isWaiting || wasEmpty) {
            Set<PeerState> set = this._activePeers;
            synchronized (set) {
                this._activePeers.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UDPPacket> getNextVolley() {
        PeerState peer = null;
        List<OutboundMessageState> states = null;
        int peersProcessed = 0;
        while (this._alive && states == null) {
            int nextSendDelay = Integer.MAX_VALUE;
            if (this._iterator == null || !this._activePeers.isEmpty() && !this._iterator.hasNext()) {
                this._iterator = this._activePeers.iterator();
            }
            while (this._iterator.hasNext()) {
                peer = this._iterator.next();
                int remaining = peer.finishMessages();
                if (remaining <= 0) {
                    this._iterator.remove();
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("No more pending messages for " + peer.getRemotePeer());
                    continue;
                }
                states = peer.allocateSend();
                if (states != null || ++peersProcessed >= this._activePeers.size()) break;
                int delay = peer.getNextDelay();
                if (delay < nextSendDelay) {
                    nextSendDelay = delay;
                }
                peer = null;
            }
            if (states != null || peersProcessed < this._activePeers.size() || nextSendDelay <= 0) continue;
            this._isWaiting = true;
            peersProcessed = 0;
            int toWait = Math.min(Math.max(nextSendDelay, 10), 1000);
            Set<PeerState> set = this._activePeers;
            synchronized (set) {
                block11: {
                    try {
                        this._activePeers.wait(toWait);
                    }
                    catch (InterruptedException ie) {
                        if (!this._log.shouldLog(10)) break block11;
                        this._log.debug("Woken up while waiting");
                    }
                }
            }
            this._isWaiting = false;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending " + DataHelper.toString(states));
        }
        List<UDPPacket> packets = this.preparePackets(states, peer);
        return packets;
    }

    private List<UDPPacket> preparePackets(List<OutboundMessageState> states, PeerState peer) {
        if (states == null || peer == null) {
            return null;
        }
        List<Long> msgIds = peer.getCurrentFullACKs();
        int newFullAckCount = msgIds.size();
        msgIds.addAll(peer.getCurrentResendACKs());
        ArrayList<ACKBitfield> partialACKBitfields = new ArrayList<ACKBitfield>();
        peer.fetchPartialACKs(partialACKBitfields);
        int piggybackedPartialACK = partialACKBitfields.size();
        ArrayList<Long> remaining = new ArrayList<Long>(msgIds);
        ArrayList<PacketBuilder.Fragment> toSend = new ArrayList<PacketBuilder.Fragment>(8);
        for (OutboundMessageState state : states) {
            int fragments = state.getFragmentCount();
            int queued = 0;
            for (int i = 0; i < fragments; ++i) {
                if (!state.needsSending(i)) continue;
                toSend.add(new PacketBuilder.Fragment(state, i));
                ++queued;
            }
            if (queued <= 0 || state.getPushCount() <= 1) continue;
            peer.messageRetransmitted(queued);
            this._context.statManager().addRateData("udp.peerPacketsRetransmitted", peer.getPacketsRetransmitted(), peer.getPacketsTransmitted());
            this._context.statManager().addRateData("udp.packetsRetransmitted", state.getLifetime(), peer.getPacketsTransmitted());
            if (this._log.shouldLog(20)) {
                this._log.info("Retransmitting " + state + " to " + peer);
            }
            this._context.statManager().addRateData("udp.sendVolleyTime", state.getLifetime(), queued);
        }
        if (toSend.isEmpty()) {
            return null;
        }
        int fragmentsToSend = toSend.size();
        ArrayList<PacketBuilder.Fragment> sendNext = new ArrayList<PacketBuilder.Fragment>(Math.min(toSend.size(), 4));
        ArrayList<UDPPacket> rv = new ArrayList<UDPPacket>(toSend.size());
        for (int i = 0; i < toSend.size(); ++i) {
            int msgType;
            PacketBuilder.Fragment next = (PacketBuilder.Fragment)toSend.get(i);
            sendNext.add(next);
            OutboundMessageState state = next.state;
            OutNetMessage msg = state.getMessage();
            int n = msgType = msg != null ? msg.getMessageTypeId() : -1;
            if (this._log.shouldLog(20)) {
                this._log.info("Building packet for " + next + " to " + peer);
            }
            int curTotalDataSize = state.fragmentSize(next.num);
            if (i + 1 < toSend.size()) {
                int maxAvail = PacketBuilder.getMaxAdditionalFragmentSize(peer, sendNext.size(), curTotalDataSize);
                for (int j = i + 1; j < toSend.size(); ++j) {
                    next = (PacketBuilder.Fragment)toSend.get(j);
                    int nextDataSize = next.state.fragmentSize(next.num);
                    if (nextDataSize > maxAvail) continue;
                    toSend.remove(j);
                    --j;
                    sendNext.add(next);
                    maxAvail = PacketBuilder.getMaxAdditionalFragmentSize(peer, sendNext.size(), curTotalDataSize += nextDataSize);
                    if (!this._log.shouldLog(20)) continue;
                    this._log.info("Adding in additional " + next + " to " + peer);
                }
            }
            int before = remaining.size();
            UDPPacket pkt = this._builder.buildPacket(sendNext, peer, remaining, newFullAckCount, partialACKBitfields);
            if (pkt != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Built packet with " + sendNext.size() + " fragments totalling " + curTotalDataSize + " data bytes to " + peer);
                }
                this._context.statManager().addRateData("udp.sendFragmentsPerPacket", sendNext.size());
            }
            sendNext.clear();
            if (pkt == null) {
                if (!this._log.shouldLog(30)) continue;
                this._log.info("Build packet FAIL for " + DataHelper.toString(sendNext) + " to " + peer);
                continue;
            }
            rv.add(pkt);
            int after = remaining.size();
            newFullAckCount = Math.max(0, newFullAckCount - (before - after));
            int piggybackedAck = 0;
            if (msgIds.size() != remaining.size()) {
                for (int j = 0; j < msgIds.size(); ++j) {
                    Long id = msgIds.get(j);
                    if (remaining.contains(id)) continue;
                    peer.removeACKMessage(id);
                    ++piggybackedAck;
                }
            }
            if (piggybackedAck > 0) {
                this._context.statManager().addRateData("udp.sendPiggyback", piggybackedAck);
            }
            if (piggybackedPartialACK - partialACKBitfields.size() > 0) {
                this._context.statManager().addRateData("udp.sendPiggybackPartial", piggybackedPartialACK - partialACKBitfields.size(), state.getLifetime());
            }
            pkt.setFragmentCount(sendNext.size());
            pkt.setMessageType(msgType);
        }
        int sent = rv.size();
        peer.packetsTransmitted(sent);
        if (this._log.shouldLog(20)) {
            this._log.info("Sent " + fragmentsToSend + " fragments of " + states.size() + " messages in " + sent + " packets to " + peer);
        }
        return rv;
    }

    public static interface ActiveThrottle {
        public void choke(Hash var1);

        public void unchoke(Hash var1);

        public boolean isChoked(Hash var1);
    }
}

