/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.data.i2np.GarlicClove;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.message.GarlicConfig;
import net.i2p.router.message.PayloadGarlicConfig;
import net.i2p.util.Log;

public class GarlicMessageBuilder {
    static boolean needsTags(RouterContext ctx, PublicKey key, Hash local, int minTagOverride) {
        SessionKeyManager skm = ctx.clientManager().getClientSessionKeyManager(local);
        if (skm == null) {
            return true;
        }
        SessionKey curKey = skm.getCurrentKey(key);
        if (curKey == null) {
            return true;
        }
        if (minTagOverride > 0) {
            return skm.shouldSendTags(key, curKey, minTagOverride);
        }
        return skm.shouldSendTags(key, curKey);
    }

    private static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config) {
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        log.error("buildMessage 2 args, using router SKM", new Exception("who did it"));
        return GarlicMessageBuilder.buildMessage(ctx, config, new SessionKey(), new HashSet<SessionTag>(), ctx.sessionKeyManager());
    }

    public static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, SessionKey wrappedKey, Set<SessionTag> wrappedTags, SessionKeyManager skm) {
        return GarlicMessageBuilder.buildMessage(ctx, config, wrappedKey, wrappedTags, skm.getTagsToSend(), skm);
    }

    public static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, SessionKey wrappedKey, Set<SessionTag> wrappedTags, int numTagsToDeliver, SessionKeyManager skm) {
        return GarlicMessageBuilder.buildMessage(ctx, config, wrappedKey, wrappedTags, numTagsToDeliver, skm.getLowThreshold(), skm);
    }

    public static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, SessionKey wrappedKey, Set<SessionTag> wrappedTags, int numTagsToDeliver, int lowTagsThreshold, SessionKeyManager skm) {
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        PublicKey key = config.getRecipientPublicKey();
        if (key == null) {
            if (config.getRecipient() == null) {
                throw new IllegalArgumentException("Null recipient specified");
            }
            if (config.getRecipient().getIdentity() == null) {
                throw new IllegalArgumentException("Null recipient.identity specified");
            }
            if (config.getRecipient().getIdentity().getPublicKey() == null) {
                throw new IllegalArgumentException("Null recipient.identity.publicKey specified");
            }
            key = config.getRecipient().getIdentity().getPublicKey();
        }
        if (log.shouldLog(20)) {
            log.info("Encrypted with public key to expire on " + new Date(config.getExpiration()));
        }
        SessionKey curKey = skm.getCurrentOrNewKey(key);
        SessionTag curTag = null;
        curTag = skm.consumeNextAvailableTag(key, curKey);
        if (log.shouldLog(10)) {
            int availTags = skm.getAvailableTags(key, curKey);
            log.debug("Available tags for encryption: " + availTags + " low threshold: " + lowTagsThreshold);
        }
        if (numTagsToDeliver > 0 && skm.shouldSendTags(key, curKey, lowTagsThreshold)) {
            for (int i = 0; i < numTagsToDeliver; ++i) {
                wrappedTags.add(new SessionTag(true));
            }
            if (log.shouldLog(20)) {
                log.info("Too few tags available so we're including " + numTagsToDeliver);
            }
        }
        wrappedKey.setData(curKey.getData());
        return GarlicMessageBuilder.buildMessage(ctx, config, wrappedKey, wrappedTags, key, curKey, curTag);
    }

    public static GarlicMessage buildMessage(RouterContext ctx, GarlicConfig config, SessionKey wrappedKey, Set<SessionTag> wrappedTags, PublicKey target, SessionKey encryptKey, SessionTag encryptTag) {
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        if (config == null) {
            throw new IllegalArgumentException("Null config specified");
        }
        GarlicMessage msg = new GarlicMessage(ctx);
        byte[] cloveSet = GarlicMessageBuilder.buildCloveSet(ctx, config);
        byte[] encData = ctx.elGamalAESEngine().encrypt(cloveSet, target, encryptKey, wrappedTags, encryptTag, 128L);
        msg.setData(encData);
        msg.setMessageExpiration(config.getExpiration());
        long timeFromNow = config.getExpiration() - ctx.clock().now();
        if (timeFromNow < 1000L) {
            if (log.shouldLog(10)) {
                log.debug("Building a message expiring in " + timeFromNow + "ms: " + config, new Exception("created by"));
            }
            return null;
        }
        if (log.shouldLog(10)) {
            log.debug("CloveSet (" + config.getCloveCount() + " cloves) for message " + msg.getUniqueId() + " is " + cloveSet.length + " bytes and encrypted message data is " + encData.length + " bytes");
        }
        return msg;
    }

    private static byte[] buildCloveSet(RouterContext ctx, GarlicConfig config) {
        ByteArrayOutputStream baos = null;
        Log log = ctx.logManager().getLog(GarlicMessageBuilder.class);
        try {
            if (config instanceof PayloadGarlicConfig) {
                byte[] clove = GarlicMessageBuilder.buildClove(ctx, (PayloadGarlicConfig)config);
                baos = new ByteArrayOutputStream(clove.length + 16);
                baos.write(1);
                baos.write(clove);
            } else {
                int i;
                byte[][] cloves = new byte[config.getCloveCount()][];
                for (int i2 = 0; i2 < config.getCloveCount(); ++i2) {
                    GarlicConfig c = config.getClove(i2);
                    if (c instanceof PayloadGarlicConfig) {
                        cloves[i2] = GarlicMessageBuilder.buildClove(ctx, (PayloadGarlicConfig)c);
                        continue;
                    }
                    log.debug("Subclove IS NOT a payload garlic clove");
                    cloves[i2] = GarlicMessageBuilder.buildClove(ctx, c);
                }
                int len = 1;
                for (i = 0; i < cloves.length; ++i) {
                    len += cloves[i].length;
                }
                baos = new ByteArrayOutputStream(len + 16);
                baos.write((byte)cloves.length);
                for (i = 0; i < cloves.length; ++i) {
                    baos.write(cloves[i]);
                }
            }
            config.getCertificate().writeBytes(baos);
            DataHelper.writeLong(baos, 4, config.getId());
            DataHelper.writeLong(baos, 8, config.getExpiration());
        }
        catch (IOException ioe) {
            log.error("Error building the clove set", ioe);
            throw new IllegalArgumentException("Error building the clove set", ioe);
        }
        catch (DataFormatException dfe) {
            log.error("Error building the clove set", dfe);
            throw new IllegalArgumentException("Error building the clove set", dfe);
        }
        return baos.toByteArray();
    }

    private static byte[] buildClove(RouterContext ctx, PayloadGarlicConfig config) throws DataFormatException, IOException {
        GarlicClove clove = new GarlicClove(ctx);
        clove.setData(config.getPayload());
        return GarlicMessageBuilder.buildCommonClove(clove, config);
    }

    private static byte[] buildClove(RouterContext ctx, GarlicConfig config) throws DataFormatException, IOException {
        GarlicClove clove = new GarlicClove(ctx);
        GarlicMessage msg = GarlicMessageBuilder.buildMessage(ctx, config);
        if (msg == null) {
            throw new DataFormatException("Unable to build message from clove config");
        }
        clove.setData(msg);
        return GarlicMessageBuilder.buildCommonClove(clove, config);
    }

    private static byte[] buildCommonClove(GarlicClove clove, GarlicConfig config) throws DataFormatException, IOException {
        clove.setCertificate(config.getCertificate());
        clove.setCloveId(config.getId());
        clove.setExpiration(new Date(config.getExpiration()));
        clove.setInstructions(config.getDeliveryInstructions());
        return clove.toByteArray();
    }
}

