/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.util.KeyRing;

public class PersistentKeyRing
extends KeyRing {
    private static final long serialVersionUID = 1L;
    private final transient RouterContext _ctx;
    private static final String PROP_PFX = "router.keyring.key.";

    public PersistentKeyRing(RouterContext ctx) {
        this._ctx = ctx;
        this.addFromProperties();
    }

    @Override
    public SessionKey put(Hash h, SessionKey sk) {
        SessionKey old = super.put(h, sk);
        if (!sk.equals(old)) {
            this._ctx.router().saveConfig(PROP_PFX + h.toBase64().replace("=", "$"), sk.toBase64());
        }
        return old;
    }

    public SessionKey remove(Hash h) {
        this._ctx.router().saveConfig(PROP_PFX + h.toBase64().replace("=", "$"), null);
        return (SessionKey)super.remove(h);
    }

    private void addFromProperties() {
        for (String prop : this._ctx.getPropertyNames()) {
            String key;
            if (!prop.startsWith(PROP_PFX) || (key = this._ctx.getProperty(prop)) == null || key.length() != 44) continue;
            String hb = prop.substring(PROP_PFX.length());
            hb = hb.replace("$", "=");
            Hash dest = new Hash();
            SessionKey sk = new SessionKey();
            try {
                dest.fromBase64(hb);
                sk.fromBase64(key);
                super.put(dest, sk);
            }
            catch (DataFormatException dfe) {}
        }
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("\n<table class=\"configtable\"><tr><th align=\"left\">Destination Hash<th align=\"left\">Name or Dest.<th align=\"left\">Encryption Key</tr>");
        for (Map.Entry e : this.entrySet()) {
            buf.append("\n<tr><td>");
            Hash h = (Hash)e.getKey();
            buf.append(h.toBase64().substring(0, 6)).append("&hellip;");
            buf.append("<td>");
            Destination dest = this._ctx.netDb().lookupDestinationLocally(h);
            if (dest != null) {
                if (this._ctx.clientManager().isLocal(dest)) {
                    TunnelPoolSettings in = this._ctx.tunnelManager().getInboundSettings(h);
                    if (in != null && in.getDestinationNickname() != null) {
                        buf.append(in.getDestinationNickname());
                    } else {
                        buf.append(dest.toBase64().substring(0, 6)).append("&hellip;");
                    }
                } else {
                    String host = this._ctx.namingService().reverseLookup(dest);
                    if (host != null) {
                        buf.append(host);
                    } else {
                        buf.append(dest.toBase64().substring(0, 6)).append("&hellip;");
                    }
                }
            }
            buf.append("<td>");
            SessionKey sk = (SessionKey)e.getValue();
            buf.append(sk.toBase64());
        }
        buf.append("\n</table>\n");
        out.write(buf.toString());
        out.flush();
    }
}

