/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.net.Socket;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.Outproxy;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.i2ptunnel.socks.I2PSOCKSTunnel;
import net.i2p.i2ptunnel.socks.SOCKSException;
import net.i2p.util.Log;

abstract class SOCKSServer {
    private static final String PROP_MAPPING_PREFIX = "ipmapping.";
    protected String connHostName;
    protected int connPort;
    protected int addressType;
    protected final I2PAppContext _context;
    protected final Socket clientSock;
    protected final Properties props;
    protected final Log _log;

    protected SOCKSServer(I2PAppContext ctx, Socket clientSock, Properties props) {
        this._context = ctx;
        this.clientSock = clientSock;
        this.props = props;
        this._log = ctx.logManager().getLog(this.getClass());
    }

    protected String getMappedDomainNameForIP(String ip) {
        if (this.props.containsKey(PROP_MAPPING_PREFIX + ip)) {
            return this.props.getProperty(PROP_MAPPING_PREFIX + ip);
        }
        return null;
    }

    protected abstract void setupServer() throws SOCKSException;

    public abstract Socket getClientSocket() throws SOCKSException;

    protected abstract void confirmConnection() throws SOCKSException;

    public abstract I2PSocket getDestinationI2PSocket(I2PSOCKSTunnel var1) throws SOCKSException;

    private boolean shouldUseOutproxyPlugin() {
        return Boolean.parseBoolean(this.props.getProperty("i2ptunnel.useLocalOutproxy", "true"));
    }

    protected Outproxy getOutproxyPlugin() {
        ClientApp op;
        ClientAppManager mgr;
        if (this.shouldUseOutproxyPlugin() && (mgr = this._context.clientAppManager()) != null && (op = mgr.getRegisteredApp("outproxy")) != null) {
            return (Outproxy)((Object)op);
        }
        return null;
    }
}

