/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.comments;

import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;

public class Comment
implements Comparable<Comment> {
    private final String text;
    private final String name;
    private final int time;
    private final byte rating;
    private final boolean byMe;
    private boolean hidden;
    private static final AtomicInteger _id = new AtomicInteger();
    private final int id = _id.incrementAndGet();
    public static final int MAX_NAME_LEN = 32;
    private static final int MAX_TEXT_LEN = 512;
    private static final int BUCKET_SIZE = 600000;
    private static final long TIME_SHRINK = 1000L;
    private static final long TIME_OFFSET = 1104537600000L;

    public Comment(String text, String name, int rating) {
        this(text, name, rating, I2PAppContext.getGlobalContext().clock().now(), true);
    }

    public Comment(String text, String name, int rating, long time, boolean isMine) {
        if (text != null) {
            text = text.trim();
            if ((text = text.replaceAll("[\r\n]", " ")).length() == 0) {
                text = null;
            } else if (text.length() > 512) {
                text = text.substring(0, 512);
            }
        }
        this.text = text;
        if (name != null) {
            name = name.trim();
            if ((name = name.replaceAll("[,\r\n]", "")).length() == 0) {
                name = null;
            } else if (name.length() > 32) {
                name = name.substring(0, 32);
            }
        }
        this.name = name;
        if (rating < 0) {
            rating = 0;
        } else if (rating > 5) {
            rating = 5;
        }
        this.rating = (byte)rating;
        if (time < 1104537600000L) {
            time = 1104537600000L;
        } else {
            long now = I2PAppContext.getGlobalContext().clock().now();
            if (time > now) {
                time = now;
            }
        }
        this.time = (int)((time - 1104537600000L) / 1000L);
        this.byMe = isMine;
    }

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public int getRating() {
        return this.rating;
    }

    public long getTime() {
        return (long)this.time * 1000L + 1104537600000L;
    }

    public boolean isMine() {
        return this.byMe;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    void setHidden() {
        this.hidden = true;
    }

    public int getID() {
        return this.id;
    }

    @Override
    public int compareTo(Comment c) {
        int rv;
        if (this.time > c.time) {
            return -1;
        }
        if (this.time < c.time) {
            return 1;
        }
        if (this.rating != c.rating) {
            return c.rating - this.rating;
        }
        if (this.name != null || c.name != null) {
            if (this.name == null) {
                return 1;
            }
            if (c.name == null) {
                return -1;
            }
            rv = this.name.compareTo(c.name);
            if (rv != 0) {
                return rv;
            }
        }
        if (this.text != null || c.text != null) {
            if (this.text == null) {
                return 1;
            }
            if (c.text == null) {
                return -1;
            }
            rv = this.text.compareTo(c.text);
            if (rv != 0) {
                return rv;
            }
        }
        return 0;
    }

    public String toPersistentString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getTime());
        buf.append(',');
        buf.append(Byte.toString(this.rating));
        buf.append(',');
        buf.append(this.byMe ? "1" : "0");
        buf.append(',');
        buf.append(this.hidden ? "1" : "0");
        buf.append(',');
        if (this.name != null) {
            buf.append(this.name);
        }
        buf.append(',');
        if (this.text != null) {
            buf.append(this.text);
        }
        return buf.toString();
    }

    public static Comment fromPersistentString(String s) {
        String[] ss = DataHelper.split(s, ",", 6);
        if (ss.length != 6) {
            return null;
        }
        try {
            long t = Long.parseLong(ss[0]);
            int r = Integer.parseInt(ss[1]);
            boolean m = !ss[2].equals("0");
            boolean h = !ss[3].equals("0");
            Comment rv = new Comment(ss[5], ss[4], r, t, m);
            if (h) {
                rv.setHidden();
            }
            return rv;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public int hashCode() {
        return this.time / 600;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Comment)) {
            return false;
        }
        Comment c = (Comment)o;
        return this.rating == c.rating && Comment.eq(this.text, c.text) && Comment.eq(this.name, c.name) && this.hashCode() == c.hashCode();
    }

    public boolean equalsIgnoreTimestamp(Comment c) {
        return this.rating == c.rating && Comment.eq(this.text, c.text) && Comment.eq(this.name, c.name);
    }

    private static boolean eq(String lhs, String rhs) {
        return lhs == null && rhs == null || lhs != null && lhs.equals(rhs);
    }
}

