/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import gnu.getopt.Getopt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SHA1;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SecureFile;
import net.i2p.util.SystemVersion;
import org.klomp.snark.BitField;
import org.klomp.snark.I2PSnarkUtil;
import org.klomp.snark.MetaInfo;
import org.klomp.snark.PartialPiece;
import org.klomp.snark.StorageListener;

public class Storage
implements Closeable {
    private final MetaInfo metainfo;
    private final List<TorrentFile> _torrentFiles;
    private final File _base;
    private final StorageListener listener;
    private final I2PSnarkUtil _util;
    private final Log _log;
    private BitField bitfield;
    private int needed;
    private boolean _probablyComplete;
    private final int piece_size;
    private final int pieces;
    private final long total_length;
    private final boolean _preserveFileNames;
    private boolean changed;
    private volatile boolean _isChecking;
    private final AtomicInteger _allocateCount = new AtomicInteger();
    private final AtomicInteger _checkProgress = new AtomicInteger();
    private static final int DEFAULT_PIECE_SIZE = 262144;
    public static final int MAX_PIECE_SIZE = 0x1000000;
    public static final int MAX_PIECES = 32768;
    public static final long MAX_TOTAL_SIZE = 0x8000000000L;
    private static final Map<String, String> _filterNameCache = new ConcurrentHashMap<String, String>();
    private static final boolean _isWindows = SystemVersion.isWindows();
    private static final boolean _isARM = SystemVersion.isARM();
    private static final int BUFSIZE = 16384;
    private static final ByteCache _cache = ByteCache.getInstance(16, 16384);
    private static final char[] ILLEGAL = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*', '\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u2028', '\u2029'};
    private static final long RAF_CLOSE_DELAY = 240000L;

    public Storage(I2PSnarkUtil util, File baseFile, MetaInfo metainfo, StorageListener listener, boolean preserveFileNames) {
        this._util = util;
        this._log = util.getContext().logManager().getLog(Storage.class);
        this._base = baseFile;
        this.metainfo = metainfo;
        this.listener = listener;
        this.needed = metainfo.getPieces();
        this.bitfield = new BitField(this.needed);
        this.piece_size = metainfo.getPieceLength(0);
        this.pieces = this.needed;
        this.total_length = metainfo.getTotalLength();
        List<List<String>> files = metainfo.getFiles();
        int sz = files != null ? files.size() : 1;
        this._torrentFiles = new ArrayList<TorrentFile>(sz);
        this._preserveFileNames = preserveFileNames;
    }

    public Storage(I2PSnarkUtil util, File baseFile, String announce, List<List<String>> announce_list, String created_by, boolean privateTorrent, StorageListener listener) throws IOException {
        this._util = util;
        this._base = baseFile;
        this._log = util.getContext().logManager().getLog(Storage.class);
        this.listener = listener;
        this._preserveFileNames = true;
        this._torrentFiles = this.getFiles(baseFile);
        long total = 0L;
        ArrayList<Long> lengthsList = new ArrayList<Long>();
        for (TorrentFile tf : this._torrentFiles) {
            long length = tf.length;
            total += length;
            lengthsList.add(length);
        }
        if (total <= 0L) {
            throw new IOException("Torrent contains no data");
        }
        if (total > 0x8000000000L) {
            throw new IOException("Torrent too big (" + total + " bytes), max is " + 0x8000000000L);
        }
        int pc_size = total <= 0x500000L ? 65536 : (total <= 0xA00000L ? 131072 : 262144);
        int pcs = (int)((total - 1L) / (long)pc_size) + 1;
        while (pcs > 10922 && pc_size < 0x1000000) {
            pcs = (int)((total - 1L) / (long)(pc_size *= 2)) + 1;
        }
        this.piece_size = pc_size;
        this.pieces = pcs;
        this.total_length = total;
        this.bitfield = new BitField(this.pieces);
        this.needed = 0;
        ArrayList<List<String>> files = new ArrayList<List<String>>();
        for (TorrentFile tf : this._torrentFiles) {
            ArrayList<String> file = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(tf.name, File.separator);
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                file.add(part);
            }
            files.add(file);
        }
        if (files.size() == 1 && !baseFile.isDirectory()) {
            files = null;
            lengthsList = null;
        }
        byte[] piece_hashes = this.fast_digestCreate();
        this.metainfo = new MetaInfo(announce, baseFile.getName(), null, files, lengthsList, this.piece_size, piece_hashes, total, privateTorrent, announce_list, created_by);
    }

    private byte[] fast_digestCreate() throws IOException {
        MessageDigest digest = SHA1.getInstance();
        byte[] piece_hashes = new byte[20 * this.pieces];
        byte[] piece = new byte[this.piece_size];
        for (int i = 0; i < this.pieces; ++i) {
            int length = this.getUncheckedPiece(i, piece);
            digest.update(piece, 0, length);
            byte[] hash = digest.digest();
            System.arraycopy(hash, 0, piece_hashes, 20 * i, 20);
            this.bitfield.set(i);
        }
        return piece_hashes;
    }

    private List<TorrentFile> getFiles(File base) throws IOException {
        if (base.getAbsolutePath().equals("/")) {
            throw new IOException("Don't seed root");
        }
        ArrayList<File> files = new ArrayList<File>();
        this.addFiles(files, base);
        int size = files.size();
        ArrayList<TorrentFile> rv = new ArrayList<TorrentFile>(size);
        for (File f : files) {
            rv.add(new TorrentFile(base, f));
        }
        Collections.sort(rv);
        return rv;
    }

    private void addFiles(List<File> l, File f) throws IOException {
        if (!f.isDirectory()) {
            if (l.size() >= 2000) {
                throw new IOException("Too many files, limit is 2000, zip them?");
            }
            l.add(f);
        } else {
            File[] files = f.listFiles();
            if (files == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("WARNING: Skipping '" + f + "' not a normal file.");
                }
                return;
            }
            for (int i = 0; i < files.length; ++i) {
                this.addFiles(l, files[i]);
            }
        }
    }

    public MetaInfo getMetaInfo() {
        return this.metainfo;
    }

    public int needed() {
        return this.needed;
    }

    public boolean complete() {
        return this.needed == 0;
    }

    public boolean isChanged() {
        return this.changed;
    }

    void clearChanged() {
        this.changed = false;
    }

    public boolean isChecking() {
        return this._isChecking;
    }

    public double getCheckingProgress() {
        if (this._isChecking) {
            return (double)this._checkProgress.get() / (double)this.pieces;
        }
        return 1.0;
    }

    public boolean isAllocating() {
        return this._allocateCount.get() > 0;
    }

    public int indexOf(File file) {
        for (int i = 0; i < this._torrentFiles.size(); ++i) {
            File f = this._torrentFiles.get((int)i).RAFfile;
            if (!f.equals(file)) continue;
            return i;
        }
        return -1;
    }

    public long[] remaining() {
        long[] rv = new long[this._torrentFiles.size()];
        if (this.complete()) {
            return rv;
        }
        long bytes = 0L;
        for (int i = 0; i < this._torrentFiles.size(); ++i) {
            TorrentFile tf = this._torrentFiles.get(i);
            long start = bytes;
            long end = start + tf.length;
            int pc = (int)(bytes / (long)this.piece_size);
            long rvi = 0L;
            if (!this.bitfield.get(pc)) {
                rvi = Math.min((long)this.piece_size - start % (long)this.piece_size, tf.length);
            }
            for (int j = pc + 1; (long)j * (long)this.piece_size < end && j < this.pieces; ++j) {
                if (this.bitfield.get(j)) continue;
                if ((long)(j + 1) * (long)this.piece_size < end) {
                    rvi += (long)this.piece_size;
                    continue;
                }
                rvi += end - (long)j * (long)this.piece_size;
            }
            rv[i] = rvi;
            bytes += tf.length;
        }
        return rv;
    }

    public int getPriority(int fileIndex) {
        if (this.complete() || this.metainfo.getFiles() == null) {
            return 0;
        }
        if (fileIndex < 0 || fileIndex >= this._torrentFiles.size()) {
            return 0;
        }
        return this._torrentFiles.get((int)fileIndex).priority;
    }

    public void setPriority(int fileIndex, int pri) {
        if (this.complete() || this.metainfo.getFiles() == null) {
            return;
        }
        if (fileIndex < 0 || fileIndex >= this._torrentFiles.size()) {
            return;
        }
        this._torrentFiles.get((int)fileIndex).priority = pri;
    }

    public int[] getFilePriorities() {
        if (this.complete()) {
            return null;
        }
        int sz = this._torrentFiles.size();
        if (sz <= 1) {
            return null;
        }
        int[] priorities = new int[sz];
        for (int i = 0; i < sz; ++i) {
            priorities[i] = this._torrentFiles.get((int)i).priority;
        }
        return priorities;
    }

    void setFilePriorities(int[] p) {
        if (p == null) {
            for (TorrentFile tf : this._torrentFiles) {
                tf.priority = 0;
            }
        } else {
            int sz = this._torrentFiles.size();
            if (p.length != sz) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < sz; ++i) {
                this._torrentFiles.get((int)i).priority = p[i];
            }
        }
    }

    public int[] getPiecePriorities() {
        if (this.complete() || this.metainfo.getFiles() == null) {
            return null;
        }
        int[] rv = new int[this.metainfo.getPieces()];
        int file = 0;
        long pcEnd = -1L;
        long fileEnd = this._torrentFiles.get((int)0).length - 1L;
        for (int i = 0; i < rv.length; ++i) {
            pcEnd += (long)this.piece_size;
            int pri = this._torrentFiles.get((int)file).priority;
            while (fileEnd <= pcEnd && file < this._torrentFiles.size() - 1) {
                TorrentFile tf = this._torrentFiles.get(++file);
                long oldFileEnd = fileEnd;
                fileEnd += tf.length;
                if (tf.priority <= pri || oldFileEnd >= pcEnd) continue;
                pri = tf.priority;
            }
            rv[i] = pri;
        }
        return rv;
    }

    public long getSkippedLength() {
        int[] pri = this.getPiecePriorities();
        if (pri == null) {
            return 0L;
        }
        long rv = 0L;
        int end = pri.length - 1;
        for (int i = 0; i <= end; ++i) {
            if (pri[i] > -9 || this.bitfield.get(i)) continue;
            rv += i != end ? (long)this.piece_size : (long)this.metainfo.getPieceLength(i);
        }
        return rv;
    }

    public BitField getBitField() {
        return this.bitfield;
    }

    public String getBaseName() {
        return this.optFilterName(this.metainfo.getName());
    }

    public boolean getPreserveFileNames() {
        return this._preserveFileNames;
    }

    public void check() throws IOException {
        this.check(0L, null);
    }

    public void check(long savedTime, BitField savedBitField) throws IOException {
        boolean useSavedBitField;
        boolean areFilesPublic = this._util.getFilesPublic();
        boolean bl = useSavedBitField = savedTime > 0L && savedBitField != null;
        if (!this._torrentFiles.isEmpty()) {
            throw new IllegalStateException();
        }
        List<List<String>> files = this.metainfo.getFiles();
        if (files == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Creating/Checking file: " + this._base);
            }
            if (!this._base.exists() && !this._base.createNewFile()) {
                throw new IOException("Could not create file " + this._base);
            }
            this._torrentFiles.add(new TorrentFile(this._base, this._base, this.metainfo.getTotalLength()));
            if (useSavedBitField) {
                long lm = this._base.lastModified();
                if (lm <= 0L || lm > savedTime) {
                    useSavedBitField = false;
                } else if (this._base.length() != this.metainfo.getTotalLength()) {
                    useSavedBitField = false;
                }
            }
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info("Creating/Checking directory: " + this._base);
            }
            if (!this._base.mkdir() && !this._base.isDirectory()) {
                throw new IOException("Could not create directory " + this._base);
            }
            List<Long> ls = this.metainfo.getLengths();
            int size = files.size();
            long total = 0L;
            for (int i = 0; i < size; ++i) {
                List<String> path = files.get(i);
                File f = this.createFileFromNames(this._base, path, areFilesPublic);
                for (int j = 0; j < i; ++j) {
                    if (!f.equals(this._torrentFiles.get((int)j).RAFfile)) continue;
                    int last = path.size() - 1;
                    String lastPath = (path = new ArrayList<String>(path)).get(last);
                    int dot = lastPath.lastIndexOf(46);
                    lastPath = dot >= 0 ? lastPath.substring(0, dot) + '_' + lastPath.substring(dot) : '_' + lastPath;
                    path.set(last, lastPath);
                    f = this.createFileFromNames(this._base, path, areFilesPublic);
                    j = 0;
                }
                long len = ls.get(i);
                this._torrentFiles.add(new TorrentFile(this._base, f, len));
                total += len;
                if (!useSavedBitField) continue;
                long lm = f.lastModified();
                if (lm <= 0L || lm > savedTime) {
                    useSavedBitField = false;
                    continue;
                }
                if (f.length() == len) continue;
                useSavedBitField = false;
            }
            long metalength = this.metainfo.getTotalLength();
            if (total != metalength) {
                throw new IOException("File lengths do not add up " + total + " != " + metalength);
            }
        }
        if (useSavedBitField) {
            this.bitfield = savedBitField;
            this.needed = this.metainfo.getPieces() - this.bitfield.count();
            this._probablyComplete = this.complete();
            if (this._log.shouldLog(20)) {
                this._log.info("Found saved state and files unchanged, skipping check");
            }
        } else {
            this.changed = true;
            if (this._log.shouldLog(20)) {
                this._log.info("Forcing check");
            }
            this.checkCreateFiles(false);
        }
        if (this.complete()) {
            if (this._log.shouldLog(20)) {
                this._log.info("Torrent is complete");
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info("Still need " + this.needed + " out of " + this.metainfo.getPieces() + " pieces");
        }
    }

    public void reopen() throws IOException {
        if (this._torrentFiles.isEmpty()) {
            throw new IOException("Storage not checked yet");
        }
        for (TorrentFile tf : this._torrentFiles) {
            if (tf.RAFfile.exists()) continue;
            throw new IOException("File does not exist: " + tf);
        }
    }

    private String optFilterName(String name) {
        if (this._preserveFileNames) {
            return name;
        }
        return Storage.filterName(name);
    }

    public static String filterName(String name) {
        String rv = _filterNameCache.get(name);
        if (rv != null) {
            return rv;
        }
        if (name.equals(".") || name.equals(" ")) {
            rv = "_";
        } else {
            rv = name;
            if (rv.startsWith(".")) {
                rv = '_' + rv.substring(1);
            }
            if (rv.endsWith(".") || rv.endsWith(" ")) {
                rv = rv.substring(0, rv.length() - 1) + '_';
            }
            for (int i = 0; i < ILLEGAL.length; ++i) {
                if (rv.indexOf(ILLEGAL[i]) < 0) continue;
                rv = rv.replace(ILLEGAL[i], '_');
            }
            if (!Charset.defaultCharset().name().equals("UTF-8")) {
                try {
                    CharsetEncoder enc = Charset.defaultCharset().newEncoder();
                    if (!enc.canEncode(rv)) {
                        String repl = rv;
                        for (int i = 0; i < rv.length(); ++i) {
                            char c = rv.charAt(i);
                            if (enc.canEncode(c)) continue;
                            repl = repl.replace(c, '_');
                        }
                        rv = repl;
                    }
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                }
            }
        }
        _filterNameCache.put(name, rv);
        return rv;
    }

    private File createFileFromNames(File base, List<String> names, boolean areFilesPublic) throws IOException {
        File f = null;
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            String name = this.optFilterName(it.next());
            if (it.hasNext()) {
                f = areFilesPublic ? new File(base, name) : new SecureFile(base, name);
                if (!f.mkdir() && !f.isDirectory()) {
                    throw new IOException("Could not create directory " + f);
                }
                base = f;
                continue;
            }
            f = areFilesPublic ? new File(base, name) : new SecureFile(base, name);
            if (f.exists() || f.createNewFile()) continue;
            throw new IOException("Could not create file " + f);
        }
        return f;
    }

    public File getBase() {
        return this._base;
    }

    public List<File> getFiles() {
        ArrayList<File> rv = new ArrayList<File>(this._torrentFiles.size());
        for (TorrentFile tf : this._torrentFiles) {
            rv.add(tf.RAFfile);
        }
        return rv;
    }

    public int getFileCount() {
        return this._torrentFiles.size();
    }

    public SortedSet<File> getDirectories() {
        if (!this._base.isDirectory()) {
            return null;
        }
        TreeSet<File> rv = new TreeSet<File>(Collections.reverseOrder());
        rv.add(this._base);
        for (TorrentFile tf : this._torrentFiles) {
            File f = tf.RAFfile;
            while ((f = f.getParentFile()) != null && rv.add(f)) {
            }
        }
        return rv;
    }

    public boolean recheck() throws IOException {
        boolean changed;
        int previousNeeded = this.needed;
        this.checkCreateFiles(true);
        boolean bl = changed = previousNeeded != this.needed;
        if (this.listener != null && changed) {
            this.listener.setWantedPieces(this);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCreateFiles(boolean recheck) throws IOException {
        Storage storage = this;
        synchronized (storage) {
            this._isChecking = true;
            try {
                this.locked_checkCreateFiles(recheck);
            }
            finally {
                this._isChecking = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void locked_checkCreateFiles(boolean recheck) throws IOException {
        this._checkProgress.set(0);
        boolean resume = false;
        this._probablyComplete = true;
        int need = this.metainfo.getPieces();
        BitField bfield = recheck ? new BitField(need) : this.bitfield;
        long lengthProgress = 0L;
        for (TorrentFile tf : this._torrentFiles) {
            long length = tf.RAFfile.length();
            lengthProgress += tf.length;
            if (tf.RAFfile.exists() && length == tf.length) {
                if (this.listener != null) {
                    this.listener.storageAllocated(this, length);
                }
                this._checkProgress.set(0);
                resume = true;
                continue;
            }
            if (length == 0L) {
                this.changed = true;
                TorrentFile torrentFile = tf;
                synchronized (torrentFile) {
                    this.allocateFile(tf);
                    try {
                        tf.closeRAF();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (resume) continue;
                this._checkProgress.set((int)((long)this.pieces * lengthProgress / this.total_length));
                continue;
            }
            String msg = "File '" + tf.name + "' exists, but has wrong length (expected " + tf.length + " but found " + length + ") - repairing corruption";
            if (this.listener != null) {
                this.listener.addMessage(msg);
            }
            this._log.error(msg);
            this.changed = true;
            resume = true;
            this._checkProgress.set(0);
            this._probablyComplete = false;
            TorrentFile torrentFile = tf;
            synchronized (torrentFile) {
                RandomAccessFile raf = tf.checkRAF();
                raf.setLength(tf.length);
                try {
                    tf.closeRAF();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (resume) {
            byte[] piece = new byte[this.piece_size];
            int file = 0;
            long fileEnd = this._torrentFiles.get((int)0).length;
            long pieceEnd = 0L;
            for (int i = 0; i < this.pieces; ++i) {
                this._checkProgress.set(i);
                int length = this.getUncheckedPiece(i, piece);
                boolean correctHash = this.metainfo.checkPiece(i, piece, 0, length);
                pieceEnd += (long)length;
                while (fileEnd <= pieceEnd) {
                    TorrentFile tf = this._torrentFiles.get(file);
                    try {
                        tf.closeRAF();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (++file >= this._torrentFiles.size()) break;
                    fileEnd += this._torrentFiles.get((int)file).length;
                }
                if (correctHash) {
                    bfield.set(i);
                    --need;
                }
                if (this.listener == null) continue;
                this.listener.storageChecked(this, i, correctHash);
            }
        }
        this._checkProgress.set(this.pieces);
        this._probablyComplete = this.complete();
        this.needed = need;
        if (recheck && need > 0) {
            BitField bitField = this.bitfield;
            synchronized (bitField) {
                this.bitfield = bfield;
            }
        }
        if (this.listener != null) {
            this.listener.storageAllChecked(this);
            if (this.needed <= 0) {
                this.listener.storageCompleted(this);
            }
        }
    }

    private void allocateFile(TorrentFile tf) throws IOException {
        tf.allocateFile();
        if (this.listener != null) {
            this.listener.storageCreateFile(this, tf.name, tf.length);
            this.listener.storageAllocated(this, tf.length);
        }
    }

    @Override
    public void close() throws IOException {
        for (TorrentFile tf : this._torrentFiles) {
            try {
                tf.closeRAF();
            }
            catch (IOException ioe) {
                this._log.error("Error closing " + tf, ioe);
            }
        }
        this.changed = false;
    }

    public ByteArray getPiece(int piece, int off, int len) throws IOException {
        ByteArray rv;
        if (!this.bitfield.get(piece)) {
            return null;
        }
        try {
            rv = len == 16384 ? _cache.acquire() : new ByteArray(new byte[len]);
        }
        catch (OutOfMemoryError oom) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Out of memory, can't honor request for piece " + piece, oom);
            }
            return null;
        }
        byte[] bs = rv.getData();
        this.getUncheckedPiece(piece, bs, off, len);
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean putPiece(PartialPiece pp) throws IOException {
        int piece = pp.getPiece();
        try {
            int len;
            long start;
            BitField bitField = this.bitfield;
            // MONITORENTER : bitField
            if (this.bitfield.get(piece)) {
                boolean bl = true;
                // MONITOREXIT : bitField
                return bl;
            }
            // MONITOREXIT : bitField
            boolean correctHash = this.metainfo.checkPiece(pp);
            if (!correctHash) {
                if (this.listener != null) {
                    this.listener.storageChecked(this, piece, false);
                }
                boolean bl = false;
                return bl;
            }
            int i = 0;
            long raflen = this._torrentFiles.get((int)i).length;
            for (start = (long)piece * (long)this.piece_size; start > raflen; start -= raflen) {
                raflen = this._torrentFiles.get((int)(++i)).length;
            }
            int length = this.metainfo.getPieceLength(piece);
            for (int written = 0; written < length; written += len) {
                TorrentFile tf;
                int need = length - written;
                len = start + (long)need < raflen ? need : (int)(raflen - start);
                TorrentFile torrentFile = tf = this._torrentFiles.get(i);
                // MONITORENTER : torrentFile
                try {
                    RandomAccessFile raf = tf.checkRAF();
                    if (tf.isSparse) {
                        if (tf.priority >= 0) {
                            if (this._log.shouldLog(20)) {
                                this._log.info("Ballooning " + tf);
                            }
                            tf.balloonFile();
                        } else {
                            tf.isSparse = false;
                        }
                    }
                    raf.seek(start);
                    pp.write(raf, written, len);
                }
                catch (IOException ioe) {
                    IOException ioe2 = new IOException("Error writing " + tf.RAFfile.getAbsolutePath());
                    ioe2.initCause(ioe);
                    throw ioe2;
                }
                if (need - len <= 0) continue;
                raflen = this._torrentFiles.get((int)(++i)).length;
                start = 0L;
            }
        }
        finally {
            pp.release();
        }
        this.changed = true;
        boolean complete = false;
        BitField bitField = this.bitfield;
        // MONITORENTER : bitField
        if (!this.bitfield.get(piece)) {
            this.bitfield.set(piece);
            --this.needed;
            complete = this.needed == 0;
        }
        // MONITOREXIT : bitField
        if (this.listener != null) {
            this.listener.storageChecked(this, piece, true);
        }
        if (!complete) return true;
        this.checkCreateFiles(true);
        if (this.needed <= 0) return true;
        if (this.listener != null) {
            this.listener.setWantedPieces(this);
        }
        if (!this._log.shouldLog(30)) return true;
        this._log.warn("WARNING: Not really done, missing " + this.needed + " pieces");
        return true;
    }

    private int getPieceLength(int piece) {
        if (piece >= 0 && piece < this.pieces - 1) {
            return this.piece_size;
        }
        if (piece == this.pieces - 1) {
            return (int)(this.total_length - (long)piece * (long)this.piece_size);
        }
        throw new IndexOutOfBoundsException("no piece: " + piece);
    }

    private int getUncheckedPiece(int piece, byte[] bs) throws IOException {
        return this.getUncheckedPiece(piece, bs, 0, this.getPieceLength(piece));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUncheckedPiece(int piece, byte[] bs, int off, int length) throws IOException {
        int len;
        long start;
        int i = 0;
        long raflen = this._torrentFiles.get((int)i).length;
        for (start = (long)piece * (long)this.piece_size + (long)off; start > raflen; start -= raflen) {
            raflen = this._torrentFiles.get((int)(++i)).length;
        }
        for (int read = 0; read < length; read += len) {
            TorrentFile tf;
            int need = length - read;
            len = start + (long)need < raflen ? need : (int)(raflen - start);
            TorrentFile torrentFile = tf = this._torrentFiles.get(i);
            synchronized (torrentFile) {
                try {
                    RandomAccessFile raf = tf.checkRAF();
                    raf.seek(start);
                    raf.readFully(bs, read, len);
                }
                catch (IOException ioe) {
                    IOException ioe2 = new IOException("Error reading " + tf.RAFfile.getAbsolutePath());
                    ioe2.initCause(ioe);
                    throw ioe2;
                }
            }
        }
        return length;
    }

    public void cleanRAFs() {
        long cutoff = System.currentTimeMillis() - 240000L;
        for (TorrentFile tf : this._torrentFiles) {
            tf.closeRAF(cutoff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        boolean error = false;
        String created_by = null;
        String announce = null;
        Getopt g = new Getopt("Storage", args, "a:c:");
        try {
            int c;
            block17: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 97: {
                        announce = g.getOptarg();
                        continue block17;
                    }
                    case 99: {
                        created_by = g.getOptarg();
                        continue block17;
                    }
                }
                error = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            error = true;
        }
        if (error || args.length - g.getOptind() != 1) {
            System.err.println("Usage: Storage [-a announceURL] [-c created-by] file-or-dir");
            System.exit(1);
        }
        File base = new File(args[g.getOptind()]);
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        I2PSnarkUtil util = new I2PSnarkUtil(ctx);
        File file = null;
        FileOutputStream out = null;
        try {
            Storage storage = new Storage(util, base, announce, null, created_by, false, null);
            MetaInfo meta = storage.getMetaInfo();
            file = new File(storage.getBaseName() + ".torrent");
            out = new FileOutputStream(file);
            out.write(meta.getTorrentData());
            String hex = DataHelper.toString(meta.getInfoHash());
            System.out.println("Created:     " + file);
            System.out.println("InfoHash:    " + hex);
            String basename = base.getName().replace(" ", "%20");
            String magnet = "magnet:?xt=urn:btih:" + hex + "&dn=" + basename;
            if (announce != null) {
                magnet = magnet + "&tr=" + announce;
            }
            System.out.println("Magnet:      " + magnet);
        }
        catch (IOException ioe) {
            if (file != null) {
                file.delete();
            }
            ioe.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private class TorrentFile
    implements Comparable<TorrentFile> {
        public final long length;
        public final String name;
        public final File RAFfile;
        private long RAFtime;
        private RandomAccessFile raf;
        public boolean isSparse;
        public volatile int priority;

        public TorrentFile(File base, File f) {
            this(base, f, f.length());
        }

        public TorrentFile(File base, File f, long len) {
            String n = f.getPath();
            if (base.isDirectory() && n.startsWith(base.getPath())) {
                n = n.substring(base.getPath().length() + 1);
            }
            this.name = n;
            this.length = len;
            this.RAFfile = f;
        }

        public synchronized RandomAccessFile checkRAF() throws IOException {
            if (this.raf != null) {
                this.RAFtime = System.currentTimeMillis();
            } else {
                this.openRAF();
            }
            return this.raf;
        }

        private synchronized void openRAF() throws IOException {
            this.openRAF(Storage.this._probablyComplete);
        }

        private synchronized void openRAF(boolean readonly) throws IOException {
            this.raf = new RandomAccessFile(this.RAFfile, readonly || !this.RAFfile.canWrite() ? "r" : "rw");
            this.RAFtime = System.currentTimeMillis();
        }

        public synchronized void closeRAF(long cutoff) {
            if (this.RAFtime > 0L && this.RAFtime < cutoff) {
                try {
                    this.closeRAF();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public synchronized void closeRAF() throws IOException {
            this.RAFtime = 0L;
            if (this.raf == null) {
                return;
            }
            this.raf.close();
            this.raf = null;
        }

        public synchronized void allocateFile() throws IOException {
            this.openRAF(false);
            this.raf.setLength(this.length);
            if (!_isWindows && !_isARM) {
                this.isSparse = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void balloonFile() throws IOException {
            long remaining = this.length;
            int ZEROBLOCKSIZE = (int)Math.min(remaining, 32768L);
            byte[] zeros = new byte[ZEROBLOCKSIZE];
            this.raf.seek(0L);
            if (remaining > 0x1400000L) {
                Storage.this._allocateCount.incrementAndGet();
            }
            try {
                while (remaining > 0L) {
                    int size = (int)Math.min(remaining, (long)ZEROBLOCKSIZE);
                    this.raf.write(zeros, 0, size);
                    remaining -= (long)size;
                }
            }
            finally {
                remaining = this.length;
                if (remaining > 0x1400000L) {
                    Storage.this._allocateCount.decrementAndGet();
                }
            }
            this.isSparse = false;
        }

        @Override
        public int compareTo(TorrentFile tf) {
            return this.name.compareTo(tf.name);
        }

        public int hashCode() {
            return this.RAFfile.getAbsolutePath().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof TorrentFile && this.RAFfile.getAbsolutePath().equals(((TorrentFile)o).RAFfile.getAbsolutePath());
        }

        public String toString() {
            return this.name;
        }
    }
}

