/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.mortbay.servlet.MultiPartRequest;

public class RequestWrapper {
    private final HttpServletRequest httpRequest;
    private final MultiPartRequest multiPartRequest;
    private final Hashtable<String, String> cache = new Hashtable();
    private Hashtable<String, Integer> cachedParameterNames;

    public RequestWrapper(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
        String contentType = httpRequest.getContentType();
        MultiPartRequest mpr = null;
        if (contentType != null && contentType.toLowerCase(Locale.US).startsWith("multipart/form-data")) {
            try {
                mpr = new MultiPartRequest(httpRequest);
            }
            catch (OutOfMemoryError oome) {
                oome.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.multiPartRequest = mpr;
    }

    public HttpSession getSession(boolean b) {
        return this.httpRequest.getSession(b);
    }

    public String getParameter(String name) {
        return this.getParameter(name, null);
    }

    public HttpSession getSession() {
        return this.httpRequest.getSession();
    }

    public Enumeration<String> getParameterNames() {
        if (this.multiPartRequest != null) {
            if (this.cachedParameterNames == null) {
                this.cachedParameterNames = new Hashtable();
                String[] partNames = this.multiPartRequest.getPartNames();
                for (int i = 0; i < partNames.length; ++i) {
                    this.cachedParameterNames.put(partNames[i], i);
                }
            }
            return this.cachedParameterNames.keys();
        }
        return this.httpRequest.getParameterNames();
    }

    public int getContentLength() {
        return this.httpRequest.getContentLength();
    }

    public String getContentType() {
        return this.httpRequest.getContentType();
    }

    public String getContentType(String partName) {
        String result = null;
        if (this.multiPartRequest != null) {
            Hashtable<String, String> params = this.multiPartRequest.getParams(partName);
            for (Map.Entry<String, String> e : params.entrySet()) {
                String key = e.getKey();
                if (key.toLowerCase(Locale.US).compareToIgnoreCase("content-type") != 0) continue;
                String value = e.getValue();
                int i = value.indexOf(59);
                if (i != -1) {
                    result = value.substring(0, i);
                    continue;
                }
                result = value;
            }
        }
        return result;
    }

    public Object getAttribute(String string) {
        return this.httpRequest.getAttribute(string);
    }

    public String getParameter(String name, String defaultValue) {
        String result = defaultValue;
        if (this.multiPartRequest != null) {
            String str = this.cache.get(name);
            if (str != null) {
                result = str;
            } else {
                String[] partNames = this.multiPartRequest.getPartNames();
                for (int i = 0; i < partNames.length; ++i) {
                    if (partNames[i].compareToIgnoreCase(name) != 0 || (str = this.multiPartRequest.getString(partNames[i])) == null) continue;
                    result = str;
                    this.cache.put(name, result);
                    break;
                }
            }
        } else {
            String str = this.httpRequest.getParameter(name);
            if (str != null) {
                result = str;
            }
        }
        return result;
    }

    public String getFilename(String partName) {
        String str;
        String result = null;
        if (this.multiPartRequest != null && (str = this.multiPartRequest.getFilename(partName)) != null) {
            result = str;
        }
        return result;
    }

    public InputStream getInputStream(String partName) {
        InputStream result = null;
        if (this.multiPartRequest != null) {
            result = this.multiPartRequest.getInputStream(partName);
        }
        return result;
    }
}

