/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.jetty;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.util.I2PAppThread;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyStart
implements ClientApp {
    private final ClientAppManager _mgr;
    private final String[] _args;
    private final List<LifeCycle> _jettys;
    private final I2PAppContext _context;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;
    private volatile int _port;

    public JettyStart(I2PAppContext context, ClientAppManager mgr, String[] args) throws Exception {
        this._mgr = mgr;
        this._args = args;
        this._jettys = new ArrayList<LifeCycle>(args.length);
        this._context = context;
        this.parseArgs(args);
        this._state = ClientAppState.INITIALIZED;
    }

    public void parseArgs(String[] args) throws Exception {
        Properties properties = new Properties();
        XmlConfiguration last = null;
        InputStream in = null;
        for (int i = 0; i < args.length; ++i) {
            Object o;
            if (args[i].toLowerCase().endsWith(".properties")) {
                in = Resource.newResource((String)args[i]).getInputStream();
                properties.load(in);
                in.close();
                continue;
            }
            XmlConfiguration configuration = new XmlConfiguration(Resource.newResource((String)args[i]).getURL());
            if (last != null) {
                configuration.getIdMap().putAll(last.getIdMap());
            }
            if (properties.size() > 0) {
                Map<String, String> foo = configuration.getProperties();
                foo.putAll(properties);
            }
            if ((o = configuration.configure()) instanceof LifeCycle) {
                this._jettys.add((LifeCycle)o);
            }
            last = configuration;
        }
    }

    public synchronized void startup() {
        if (this._state != ClientAppState.INITIALIZED) {
            return;
        }
        if (this._jettys.isEmpty()) {
            this.changeState(ClientAppState.START_FAILED);
        } else {
            new Starter().start();
        }
    }

    public synchronized void shutdown(String[] args) {
        if (this._state != ClientAppState.RUNNING) {
            return;
        }
        if (this._jettys.isEmpty()) {
            this.changeState(ClientAppState.STOPPED);
        } else {
            new Stopper().start();
        }
    }

    public ClientAppState getState() {
        return this._state;
    }

    public String getName() {
        return "Jetty";
    }

    public String getDisplayName() {
        return "Jetty " + Arrays.toString(this._args);
    }

    private void changeState(ClientAppState state) {
        this.changeState(state, null);
    }

    private synchronized void changeState(ClientAppState state, Exception e) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify((ClientApp)this, state, null, e);
        }
    }

    public static void main(String[] args) {
        try {
            JettyStart js = new JettyStart(null, null, args);
            js.startup();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class Starter
    extends I2PAppThread {
        public Starter() {
            super("JettyStarter");
            JettyStart.this.changeState(ClientAppState.STARTING);
        }

        public void run() {
            for (LifeCycle lc : JettyStart.this._jettys) {
                if (lc.isRunning()) continue;
                try {
                    NetworkConnector nconn;
                    int port;
                    Connector conn;
                    Server server;
                    Connector[] connectors;
                    lc.start();
                    if (JettyStart.this._context == null || JettyStart.this._context.portMapper().getPort("eepsite") > 0 || !(lc instanceof Server) || (connectors = (server = (Server)lc).getConnectors()).length <= 0 || !((conn = connectors[0]) instanceof NetworkConnector) || (port = (nconn = (NetworkConnector)conn).getPort()) <= 0) continue;
                    JettyStart.this._port = port;
                    String host = nconn.getHost();
                    if (host.equals("0.0.0.0") || host.equals("::")) {
                        host = "127.0.0.1";
                    }
                    JettyStart.this._context.portMapper().register("eepsite", host, port);
                }
                catch (Exception e) {
                    JettyStart.this.changeState(ClientAppState.START_FAILED, e);
                    return;
                }
            }
            JettyStart.this.changeState(ClientAppState.RUNNING);
            if (JettyStart.this._mgr != null) {
                JettyStart.this._mgr.register((ClientApp)JettyStart.this);
            }
        }
    }

    private class Stopper
    extends I2PAppThread {
        public Stopper() {
            super("JettyStopper");
            JettyStart.this.changeState(ClientAppState.STOPPING);
        }

        public void run() {
            for (LifeCycle lc : JettyStart.this._jettys) {
                if (!lc.isRunning()) continue;
                try {
                    lc.stop();
                }
                catch (Exception e) {
                    JettyStart.this.changeState(ClientAppState.STOPPING, e);
                }
            }
            if (JettyStart.this._context != null && JettyStart.this._port > 0 && JettyStart.this._context.portMapper().getPort("eepsite") == JettyStart.this._port) {
                JettyStart.this._port = 0;
                JettyStart.this._context.portMapper().unregister("eepsite");
            }
            JettyStart.this.changeState(ClientAppState.STOPPED);
        }
    }
}

