/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.naming;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.i2p.I2PAppContext;
import net.i2p.client.naming.NamingService;
import net.i2p.client.naming.NamingServiceListener;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.FileUtil;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;

public class SingleFileNamingService
extends NamingService {
    private final File _file;
    private final ReentrantReadWriteLock _fileLock;
    private int _size;
    private long _lastWrite;
    private volatile boolean _isClosed;

    public SingleFileNamingService(I2PAppContext context, String filename) {
        super(context);
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(context.getRouterDir(), filename);
        }
        this._file = file;
        this._fileLock = new ReentrantReadWriteLock(true);
    }

    @Override
    public String getName() {
        return this._file.getAbsolutePath();
    }

    @Override
    public Destination lookup(String hostname, Properties lookupOptions, Properties storedOptions) {
        block5: {
            try {
                String key = this.getKey(hostname);
                if (key == null && hostname.startsWith("www.") && hostname.length() > 7) {
                    key = this.getKey(hostname.substring(4));
                }
                if (key != null) {
                    return this.lookupBase64(key);
                }
            }
            catch (IOException ioe) {
                if (this._file.exists()) {
                    this._log.error("Error loading hosts file " + this._file, ioe);
                }
                if (!this._log.shouldLog(30)) break block5;
                this._log.warn("Error loading hosts file " + this._file, ioe);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String reverseLookup(Destination dest, Properties options) {
        String destkey = dest.toBase64();
        BufferedReader in = null;
        this.getReadLock();
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            String line = null;
            while ((line = in.readLine()) != null) {
                int split;
                if (line.startsWith("#")) continue;
                if (line.indexOf(35) > 0) {
                    line = line.substring(0, line.indexOf(35)).trim();
                }
                if ((split = line.indexOf(61)) <= 0) continue;
                if (!destkey.equals(line.substring(split + 1))) continue;
                String string = line.substring(0, split);
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException ioe) {
            if (this._file.exists()) {
                this._log.error("Error loading hosts file " + this._file, ioe);
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Error loading hosts file " + this._file, ioe);
            }
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKey(String host) throws IOException {
        BufferedReader in = null;
        this.getReadLock();
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            String line = null;
            String search = host + '=';
            while ((line = in.readLine()) != null) {
                if (!line.startsWith(search)) continue;
                if (line.indexOf(35) > 0) {
                    line = line.substring(0, line.indexOf(35)).trim();
                }
                int split = line.indexOf(61);
                String string = line.substring(split + 1);
                return string;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            this.releaseReadLock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(String hostname, Destination d, Properties options) {
        if (this.putIfAbsent(hostname, d, options)) {
            return true;
        }
        if (!this.getWriteLock()) {
            return false;
        }
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            if (this._isClosed) {
                boolean bl = false;
                return bl;
            }
            File tmp = SecureFile.createTempFile("temp-", ".tmp", this._file.getAbsoluteFile().getParentFile());
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(tmp), "UTF-8"));
            if (this._file.exists()) {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
                String line = null;
                String search = hostname + '=';
                while ((line = in.readLine()) != null) {
                    if (line.startsWith(search)) continue;
                    out.write(line);
                    out.newLine();
                }
                in.close();
            }
            out.write(hostname);
            out.write(61);
            out.write(d.toBase64());
            if (options != null) {
                SingleFileNamingService.writeOptions(options, out);
            }
            out.newLine();
            out.close();
            boolean success = FileUtil.rename(tmp, this._file);
            if (success) {
                for (NamingServiceListener nsl : this._listeners) {
                    nsl.entryChanged(this, hostname, d, options);
                }
            }
            boolean bl = success;
            return bl;
        }
        catch (IOException ioe) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this._log.error("Error adding " + hostname, ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean putIfAbsent(String hostname, Destination d, Properties options) {
        BufferedWriter out = null;
        if (!this.getWriteLock()) {
            return false;
        }
        try {
            if (this._isClosed) {
                boolean bl = false;
                this.releaseWriteLock();
                return bl;
            }
            if (this.getKey(hostname) != null) {
                boolean bl = false;
                this.releaseWriteLock();
                return bl;
            }
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(this._file, true), "UTF-8"));
            out.write(hostname);
            out.write(61);
            out.write(d.toBase64());
            if (options != null) {
                SingleFileNamingService.writeOptions(options, out);
            }
            out.write(10);
            out.close();
            Iterator ioe = this._listeners.iterator();
            while (ioe.hasNext()) {
                NamingServiceListener nsl = (NamingServiceListener)ioe.next();
                nsl.entryAdded(this, hostname, d, options);
            }
            return true;
        }
        catch (IOException ioe) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this._log.error("Error adding " + hostname, ioe);
            return false;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public static void writeOptions(Properties options, Writer out) throws IOException {
        boolean started = false;
        for (Map.Entry<Object, Object> e : options.entrySet()) {
            String k = (String)e.getKey();
            if (!k.startsWith("=")) continue;
            k = k.substring(1);
            String v = (String)e.getValue();
            if (started) {
                out.write(35);
            } else {
                started = true;
                out.write("#!");
            }
            out.write(k);
            out.write(61);
            out.write(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String hostname, Properties options) {
        BufferedReader in = null;
        BufferedWriter out = null;
        if (!this.getWriteLock()) {
            return false;
        }
        try {
            if (!this._file.exists()) {
                boolean bl = false;
                return bl;
            }
            if (this._isClosed) {
                boolean bl = false;
                return bl;
            }
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            File tmp = SecureFile.createTempFile("temp-", ".tmp", this._file.getAbsoluteFile().getParentFile());
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(tmp), "UTF-8"));
            String line = null;
            String search = hostname + '=';
            boolean success = false;
            while ((line = in.readLine()) != null) {
                if (line.startsWith(search)) {
                    success = true;
                    continue;
                }
                out.write(line);
                out.newLine();
            }
            in.close();
            out.close();
            if (!success) {
                tmp.delete();
                boolean bl = false;
                return bl;
            }
            success = FileUtil.rename(tmp, this._file);
            if (success) {
                for (NamingServiceListener nsl : this._listeners) {
                    nsl.entryRemoved(this, hostname);
                }
            }
            boolean bl = success;
            return bl;
        }
        catch (IOException ioe) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this._log.error("Error removing " + hostname, ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Destination> getEntries(Properties options) {
        if (!this._file.exists()) {
            return Collections.emptyMap();
        }
        String searchOpt = null;
        String startsWith = null;
        if (options != null) {
            searchOpt = options.getProperty("search");
            startsWith = options.getProperty("startsWith");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Searching  starting with " + startsWith + " search string " + searchOpt);
        }
        BufferedReader in = null;
        this.getReadLock();
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            String line = null;
            HashMap<String, Destination> rv = new HashMap<String, Destination>();
            while ((line = in.readLine()) != null) {
                int split;
                if (line.length() <= 0 || startsWith != null && (!startsWith.equals("[0-9]") ? !line.startsWith(startsWith) : line.charAt(0) < '0' || line.charAt(0) > '9')) continue;
                if (line.startsWith("#")) continue;
                if (line.indexOf(35) > 0) {
                    line = line.substring(0, line.indexOf(35)).trim();
                }
                if ((split = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, split);
                if (searchOpt != null && key.indexOf(searchOpt) < 0) continue;
                String b64 = line.substring(split + 1);
                try {
                    Destination dest = new Destination(b64);
                    rv.put(key, dest);
                }
                catch (DataFormatException dataFormatException) {}
            }
            if (searchOpt == null && startsWith == null) {
                this._lastWrite = this._file.lastModified();
                this._size = rv.size();
            }
            HashMap<String, Destination> hashMap = rv;
            return hashMap;
        }
        catch (IOException ioe) {
            this._log.error("getEntries error", ioe);
            Map<String, Destination> map = Collections.emptyMap();
            return map;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getBase64Entries(Properties options) {
        if (!this._file.exists()) {
            return Collections.emptyMap();
        }
        String searchOpt = null;
        String startsWith = null;
        if (options != null) {
            searchOpt = options.getProperty("search");
            startsWith = options.getProperty("startsWith");
        }
        BufferedReader in = null;
        this.getReadLock();
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            String line = null;
            HashMap<String, String> rv = new HashMap<String, String>();
            while ((line = in.readLine()) != null) {
                String b64;
                int split;
                if (line.length() <= 0 || startsWith != null && (!startsWith.equals("[0-9]") ? !line.startsWith(startsWith) : line.charAt(0) < '0' || line.charAt(0) > '9')) continue;
                if (line.startsWith("#")) continue;
                if (line.indexOf(35) > 0) {
                    line = line.substring(0, line.indexOf(35)).trim();
                }
                if ((split = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, split);
                if (searchOpt != null && key.indexOf(searchOpt) < 0 || (b64 = line.substring(split + 1)).length() < 387) continue;
                rv.put(key, b64);
            }
            if (searchOpt == null && startsWith == null) {
                this._lastWrite = this._file.lastModified();
                this._size = rv.size();
            }
            HashMap<String, String> hashMap = rv;
            return hashMap;
        }
        catch (IOException ioe) {
            this._log.error("getEntries error", ioe);
            Map<String, String> map = Collections.emptyMap();
            return map;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Writer out, Properties options) throws IOException {
        out.write("# Address book: ");
        out.write(this.getName());
        String nl = System.getProperty("line.separator", "\n");
        out.write(nl);
        out.write("# Exported: ");
        out.write(new Date().toString());
        out.write(nl);
        BufferedReader in = null;
        this.getReadLock();
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            String line = null;
            while ((line = in.readLine()) != null) {
                out.write(line);
                out.write(nl);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getNames(Properties options) {
        if (!this._file.exists()) {
            return Collections.emptySet();
        }
        BufferedReader in = null;
        this.getReadLock();
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            String line = null;
            HashSet<String> rv = new HashSet<String>();
            while ((line = in.readLine()) != null) {
                int split;
                if (line.length() <= 0 || line.startsWith("#") || (split = line.indexOf(61)) <= 0) continue;
                String key = line.substring(0, split);
                rv.add(key);
            }
            HashSet<String> hashSet = rv;
            return hashSet;
        }
        catch (IOException ioe) {
            this._log.error("getNames error", ioe);
            Set<String> set = Collections.emptySet();
            return set;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(Properties options) {
        if (!this._file.exists()) {
            return 0;
        }
        BufferedReader in = null;
        this.getReadLock();
        try {
            if (this._file.lastModified() <= this._lastWrite) {
                int n = this._size;
                return n;
            }
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this._file), "UTF-8"), 16384);
            String line = null;
            int rv = 0;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#") || line.length() <= 0) continue;
                ++rv;
            }
            this._lastWrite = this._file.lastModified();
            this._size = rv;
            int n = rv;
            return n;
        }
        catch (IOException ioe) {
            this._log.error("size() error", ioe);
            int n = -1;
            return n;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            this.releaseReadLock();
        }
    }

    @Override
    public void shutdown() {
        if (!this.getWriteLock()) {
            return;
        }
        try {
            this._isClosed = true;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void getReadLock() {
        this._fileLock.readLock().lock();
    }

    private void releaseReadLock() {
        this._fileLock.readLock().unlock();
    }

    private boolean getWriteLock() {
        try {
            boolean rv = this._fileLock.writeLock().tryLock(10000L, TimeUnit.MILLISECONDS);
            if (!rv && this._log.shouldLog(30)) {
                this._log.warn("no lock, size is: " + this._fileLock.getQueueLength(), new Exception("rats"));
            }
            return rv;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private void releaseWriteLock() {
        this._fileLock.writeLock().unlock();
    }
}

