/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.i2p.app.ClientAppManager;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.news.NewsEntry;
import net.i2p.router.news.NewsManager;
import net.i2p.router.web.CSSHelper;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NavHelper;
import net.i2p.router.web.NewsHelper;
import net.i2p.router.web.StatSummarizer;
import net.i2p.router.web.SummaryHelper;
import net.i2p.util.SystemVersion;

class SummaryBarRenderer {
    static final String[] ALL_SECTIONS = new String[]{"HelpAndFAQ", "I2PServices", "I2PInternals", "General", "ShortGeneral", "NetworkReachability", "UpdateStatus", "RestartStatus", "Peers", "FirewallAndReseedStatus", "Bandwidth", "Tunnels", "Congestion", "TunnelStatus", "Destinations", "NewsHeadings", "Advanced"};
    static final Map<String, String> SECTION_NAMES;
    private final RouterContext _context;
    private final SummaryHelper _helper;

    public SummaryBarRenderer(RouterContext context, SummaryHelper helper) {
        this._context = context;
        this._helper = helper;
    }

    public void renderSummaryHTML(Writer out) throws IOException {
        String requestURI = this._helper.getRequestURI();
        String page = requestURI.replace("/", "").replace(".jsp", "");
        List<String> sections = this._helper.getSummaryBarSections(page);
        StringBuilder buf = new StringBuilder(8192);
        for (String section : sections) {
            buf.setLength(0);
            buf.append("<hr>\n");
            if ("HelpAndFAQ".equals(section)) {
                buf.append(this.renderHelpAndFAQHTML());
            } else if ("I2PServices".equals(section)) {
                buf.append(this.renderI2PServicesHTML());
            } else if ("I2PInternals".equals(section)) {
                buf.append(this.renderI2PInternalsHTML());
            } else if ("Advanced".equals(section)) {
                buf.append(this.renderAdvancedHTML());
            } else if ("General".equals(section)) {
                buf.append(this.renderGeneralHTML());
            } else if ("ShortGeneral".equals(section)) {
                buf.append(this.renderShortGeneralHTML());
            } else if ("NetworkReachability".equals(section)) {
                buf.append(this.renderNetworkReachabilityHTML());
            } else if ("UpdateStatus".equals(section)) {
                buf.append(this.renderUpdateStatusHTML());
            } else if ("RestartStatus".equals(section)) {
                buf.append(this.renderRestartStatusHTML());
            } else if ("Peers".equals(section)) {
                buf.append(this.renderPeersHTML());
            } else if ("FirewallAndReseedStatus".equals(section)) {
                buf.append(this.renderFirewallAndReseedStatusHTML());
            } else if ("Bandwidth".equals(section)) {
                buf.append(this.renderBandwidthHTML());
            } else if ("Tunnels".equals(section)) {
                buf.append(this.renderTunnelsHTML());
            } else if ("Congestion".equals(section)) {
                buf.append(this.renderCongestionHTML());
            } else if ("TunnelStatus".equals(section)) {
                buf.append(this.renderTunnelStatusHTML());
            } else if ("Destinations".equals(section)) {
                buf.append(this.renderDestinationsHTML());
            } else if ("NewsHeadings".equals(section)) {
                buf.append(this.renderNewsHeadingsHTML());
            }
            if (buf.length() <= 5) continue;
            out.write(buf.toString());
        }
    }

    public String renderHelpAndFAQHTML() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3 id=\"helpfaq\"><a href=\"/help\" target=\"_top\" title=\"").append(this._t("I2P Router Help &amp; FAQ")).append("\">").append(this._t("Help &amp; FAQ")).append("</a></h3>");
        return buf.toString();
    }

    public String renderI2PServicesHTML() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/configclients\" target=\"_top\" title=\"").append(this._t("Configure startup of clients and webapps (services); manually start dormant services")).append("\">").append(this._t("I2P Services")).append("</a></h3>\n<hr class=\"b\"><table id=\"sb_services\"><tr><td><a href=\"/susimail/susimail\" target=\"_blank\" title=\"").append(this._t("Anonymous webmail client")).append("\">").append(SummaryBarRenderer.nbsp(this._t("Email"))).append("</a>\n<a href=\"/i2psnark/\" target=\"_blank\" title=\"").append(this._t("Built-in anonymous BitTorrent Client")).append("\">").append(SummaryBarRenderer.nbsp(this._t("Torrents"))).append("</a>\n<a href=\"http://").append(this._context.portMapper().getHost("eepsite", "127.0.0.1")).append(':').append(this._context.portMapper().getPort("eepsite", 7658)).append("/\" target=\"_blank\" title=\"").append(this._t("Local web server")).append("\">").append(SummaryBarRenderer.nbsp(this._t("Web Server"))).append("</a>\n").append(NavHelper.getClientAppLinks(this._context)).append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderI2PInternalsHTML() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/config\" target=\"_top\" title=\"").append(this._t("Configure I2P Router")).append("\">").append(this._t("I2P Internals")).append("</a></h3><hr class=\"b\">\n<table id=\"sb_internals\"><tr><td>\n<a href=\"/dns\" target=\"_top\" title=\"").append(this._t("Manage your I2P hosts file here (I2P domain name resolution)")).append("\">").append(SummaryBarRenderer.nbsp(this._t("Addressbook"))).append("</a>\n");
        if (!StatSummarizer.isDisabled()) {
            buf.append("<a href=\"/graphs\" target=\"_top\" title=\"").append(this._t("Graph router performance")).append("\">").append(SummaryBarRenderer.nbsp(this._t("Graphs"))).append("</a>\n");
        }
        buf.append("<a href=\"/i2ptunnelmgr\" target=\"_top\" title=\"").append(this._t("Local Tunnels")).append("\">").append(SummaryBarRenderer.nbsp(this._t("Hidden Services Manager"))).append("</a>\n<a href=\"/logs\" target=\"_top\" title=\"").append(this._t("Health Report")).append("\">").append(SummaryBarRenderer.nbsp(this._t("Logs"))).append("</a>\n<a href=\"/netdb\" target=\"_top\" title=\"").append(this._t("Show list of all known I2P routers")).append("\">").append(SummaryBarRenderer.nbsp(this._t("NetDB"))).append("</a>\n<a href=\"/peers\" target=\"_top\" title=\"").append(this._t("Show all current peer connections")).append("\">").append(SummaryBarRenderer.nbsp(this._t("Peers"))).append("</a>\n<a href=\"/profiles\" target=\"_top\" title=\"").append(this._t("Show recent peer performance profiles")).append("\">").append(SummaryBarRenderer.nbsp(this._t("Profiles"))).append("</a>\n<a href=\"/tunnels\" target=\"_top\" title=\"").append(this._t("View existing tunnels and tunnel build status")).append("\">").append(SummaryBarRenderer.nbsp(this._t("Tunnels"))).append("</a>\n");
        buf.append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderAdvancedHTML() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3 id=\"advanced\"><a title=\"").append(this._t("Advanced Configuration")).append("\" href=\"/configadvanced\">").append(this._t("Advanced")).append("</a></h3>\n").append("<hr class=\"b\"><table id=\"sb_advanced\"><tr><td>").append("<a title=\"").append(this._t("Review active encryption certificates used in console")).append("\" href=\"/certs\">").append(SummaryBarRenderer.nbsp(this._t("Certs"))).append("</a>\n").append("<a title=\"").append(this._t("View full changelog")).append("\" href=\"/viewhistory\" target=\"_blank\">").append(SummaryBarRenderer.nbsp(this._t("Changelog"))).append("</a>\n").append("<a title=\"").append(this._t("View router debug information")).append("\" href=\"/debug\">").append(SummaryBarRenderer.nbsp(this._t("Debug"))).append("</a>\n").append("<a title=\"").append(this._t("Review extended info about installed .jar and .war files")).append("\" href=\"/jars\">").append(SummaryBarRenderer.nbsp(this._t("Jars"))).append("</a>\n");
        File javadoc = new File(this._context.getBaseDir(), "docs/javadoc/index.html");
        if (javadoc.exists()) {
            buf.append("<a href=\"/javadoc/index.html\" target=\"_blank\">Javadoc</a>\n");
        }
        buf.append("<a title=\"").append(this._t("View active leasesets (debug mode)")).append("\" href=\"/netdb?l=2\">").append(SummaryBarRenderer.nbsp(this._t("LeaseSets"))).append("</a>\n").append("<a title=\"").append(this._t("Network database search tool")).append("\" href=\"/netdb?f=4\">").append(SummaryBarRenderer.nbsp(this._t("NetDB Search"))).append("</a>\n").append("<a title=\"").append(this._t("Signed proof of ownership of this router")).append("\" href=\"/proof\">").append(SummaryBarRenderer.nbsp(this._t("Proof"))).append("</a>\n").append("<a href=\"/stats\" target=\"_top\" title=\"").append(this._t("Textual router performance statistics")).append("\">").append(SummaryBarRenderer.nbsp(this._t("Stats"))).append("</a>\n").append("<a title=\"").append(this._t("Review possible sybils in network database")).append("\" href=\"/netdb?f=3\">").append(SummaryBarRenderer.nbsp(this._t("Sybils"))).append("</a>\n").append("</td></tr></table>");
        return buf.toString();
    }

    public String renderGeneralHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/help\" target=\"_top\" title=\"").append(this._t("I2P Router Help")).append("\">").append(this._t("General")).append("</a></h3><hr class=\"b\">\n<table id=\"sb_localid\"><tr><td align=\"left\"><b title=\"").append(this._t("Your Local Identity is your unique I2P router identity, similar to an ip address but tailored to I2P. ")).append(this._t("Never disclose this to anyone, as it can reveal your real world ip.")).append("\">").append(this._t("Local Identity")).append(":</b></td><td align=\"right\"><a title=\"").append(this._t("Your unique I2P router identity is")).append(' ').append(this._helper.getIdent()).append(", ").append(this._t("never reveal it to anyone")).append("\" href=\"/netdb?r=.\" target=\"_top\">").append(this._t("show")).append("</a></td></tr>\n</table><table id=\"sb_version\"><tr title=\"").append(this._t("The version of the I2P software we are running")).append("\"><td align=\"left\"><b>").append(this._t("Version")).append(":</b></td><td align=\"right\">").append(this._helper.getVersion()).append("</td></tr>\n</table><table id=\"sb_uptime\"><tr title=\"").append(this._t("How long we've been running for this session")).append("\"><td align=\"left\"><b>").append(this._t("Uptime")).append(":</b></td><td align=\"right\">").append(this._helper.getUptime()).append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderShortGeneralHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<table id=\"sb_shortgeneral\"><tr title=\"").append(this._t("The version of the I2P software we are running")).append("\"><td align=\"left\"><b>").append(this._t("Version")).append(":</b></td><td align=\"right\">").append(this._helper.getVersion()).append("</td></tr>\n<tr title=\"").append(this._t("How long we've been running for this session")).append("\"><td align=\"left\"><b>").append(this._t("Uptime")).append(":</b></td><td align=\"right\">").append(this._helper.getUptime()).append("</td></tr></table>\n");
        return buf.toString();
    }

    public String renderNetworkReachabilityHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        SummaryHelper.NetworkStateMessage reachability = this._helper.getReachability();
        buf.append("<h4><span class=\"");
        switch (reachability.getState()) {
            case ERROR: {
                buf.append("error");
                break;
            }
            case WARN: {
                buf.append("warn");
                break;
            }
            case HIDDEN: {
                buf.append("hidden");
                break;
            }
            case FIREWALLED: {
                buf.append("firewalled");
                break;
            }
            case RUNNING: {
                buf.append("running");
                break;
            }
            default: {
                buf.append("testing");
            }
        }
        buf.append("\"><a href=\"/help#confignet\" target=\"_top\" title=\"").append(this._t("Help with configuring your firewall and router for optimal I2P performance")).append("\">").append(this._t("Network")).append(": ").append(reachability.getMessage()).append("</a></span></h4>\n");
        if (!SigType.ECDSA_SHA256_P256.isAvailable()) {
            buf.append("<hr>\n<h4><span class=\"warn\"><a href=\"http://trac.i2p2.i2p/wiki/Crypto/ECDSA");
            if ("ru".equals(Messages.getLanguage(this._context))) {
                buf.append("-ru");
            }
            buf.append("\" target=\"_top\" title=\"").append(this._t("See more information on the wiki")).append("\">").append(this._t("Warning: ECDSA is not available. Update your Java or OS")).append("</a></span></h4>\n");
        }
        if (!SystemVersion.isJava7()) {
            buf.append("<hr><h4><span class=\"warn\">").append(this._t("Warning: Java version {0} is no longer supported by I2P.", System.getProperty("java.version"))).append(' ').append(this._t("Update Java to version {0} or higher to receive I2P updates.", "7")).append("</span></h4>\n");
        }
        return buf.toString();
    }

    public String renderUpdateStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        String updateStatus = this._helper.getUpdateStatus();
        if ("".equals(updateStatus)) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/configupdate\" target=\"_top\" title=\"").append(this._t("Configure I2P Updates")).append("\">").append(this._t("I2P Update")).append("</a></h3><hr class=\"b\">\n");
        buf.append(updateStatus);
        return buf.toString();
    }

    public String renderRestartStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append(this._helper.getRestartStatus());
        return buf.toString();
    }

    public String renderPeersHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/peers\" target=\"_top\" title=\"").append(this._t("Show all current peer connections")).append("\">").append(this._t("Peers")).append("</a></h3><hr class=\"b\">\n<table id=\"sb_peers\">\n<tr title=\"").append(this._t("Peers we've been talking to in the last few minutes/last hour")).append("\"><td align=\"left\"><b>").append(this._t("Active")).append(":</b></td><td align=\"right\">");
        int active = this._helper.getActivePeers();
        buf.append(active).append(" / ").append(Math.max(active, this._helper.getActiveProfiles())).append("</td></tr>\n<tr title=\"").append(this._t("The number of peers available for building client tunnels")).append("\"><td align=\"left\"><b>").append(this._t("Fast")).append(":</b></td><td align=\"right\">").append(this._helper.getFastPeers()).append("</td></tr>\n<tr title=\"").append(this._t("The number of peers available for building exploratory tunnels")).append("\"><td align=\"left\"><b>").append(this._t("High capacity")).append(":</b></td><td align=\"right\">").append(this._helper.getHighCapacityPeers()).append("</td></tr>\n<tr title=\"").append(this._t("The number of peers available for network database inquiries")).append("\"><td align=\"left\"><b>").append(this._t("Integrated")).append(":</b></td><td align=\"right\">").append(this._helper.getWellIntegratedPeers()).append("</td></tr>\n<tr title=\"").append(this._t("The total number of peers in our network database")).append("\"><td align=\"left\"><b>").append(this._t("Known")).append(":</b></td><td align=\"right\">").append(this._helper.getAllPeers()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderFirewallAndReseedStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append(this._helper.getFirewallAndReseedStatus());
        return buf.toString();
    }

    public String renderBandwidthHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/config\" title=\"").append(this._t("Configure router bandwidth allocation")).append("\" target=\"_top\">").append(this._t("Bandwidth in/out")).append("</a></h3><hr class=\"b\"><table id=\"sb_bandwidth\">\n<tr><td align=\"left\"><b>").append(DataHelper.formatDuration2(3000L)).append(":</b></td><td align=\"right\">").append(this._helper.getSecondKBps()).append("Bps</td></tr>\n");
        if (this._context.router().getUptime() > 360000L) {
            buf.append("<tr><td align=\"left\"><b>").append(DataHelper.formatDuration2(300000L)).append(":</b></td><td align=\"right\">").append(this._helper.getFiveMinuteKBps()).append("Bps</td></tr>\n");
        }
        if (this._context.router().getUptime() > 120000L) {
            buf.append("<tr><td align=\"left\"><b>").append(this._t("Total")).append(":</b></td><td align=\"right\">").append(this._helper.getLifetimeKBps()).append("Bps</td></tr>\n");
        }
        buf.append("<tr><td align=\"left\"><b>").append(this._t("Used")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundTransferred()).append(" / ").append(this._helper.getOutboundTransferred()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderTunnelsHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/tunnels\" target=\"_top\" title=\"").append(this._t("View existing tunnels and tunnel build status")).append("\">").append(this._t("Tunnels")).append("</a></h3><hr class=\"b\"><table id=\"sb_tunnels\">\n<tr title=\"").append(this._t("Used for building and testing tunnels, and communicating with floodfill peers")).append("\"><td align=\"left\"><b>").append(this._t("Exploratory")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundTunnels() + this._helper.getOutboundTunnels()).append("</td></tr>\n<tr title=\"").append(this._t("Tunnels we are using to provide or access services on the network")).append("\"><td align=\"left\"><b>").append(this._t("Client")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundClientTunnels() + this._helper.getOutboundClientTunnels()).append("</td></tr>\n<tr title=\"").append(this._t("Tunnels we are participating in, directly contributing bandwidth to the network")).append("\"><td align=\"left\"><b>").append(this._t("Participating")).append(":</b></td><td align=\"right\">").append(this._helper.getParticipatingTunnels()).append("</td></tr>\n<tr title=\"").append(this._t("The ratio of tunnel hops we provide to tunnel hops we use - a value greater than 1.00 indicates a positive contribution to the network")).append("\"><td align=\"left\"><b>").append(this._t("Share ratio")).append(":</b></td><td align=\"right\">").append(this._helper.getShareRatio()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderCongestionHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3><a href=\"/jobs\" target=\"_top\" title=\"").append(this._t("What's in the router's job queue?")).append("\">").append(this._t("Congestion")).append("</a></h3><hr class=\"b\"><table id=\"sb_queue\">\n<tr title=\"").append(this._t("Indicates router performance")).append("\"><td align=\"left\"><b>").append(this._t("Job lag")).append(":</b></td><td align=\"right\">").append(this._helper.getJobLag()).append("</td></tr>\n<tr title=\"").append(this._t("Indicates how quickly outbound messages to other I2P routers are sent")).append("\"><td align=\"left\"><b>").append(this._t("Message delay")).append(":</b></td><td align=\"right\">").append(this._helper.getMessageDelay()).append("</td></tr>\n");
        if (!this._context.getBooleanPropertyDefaultTrue("router.disableTunnelTesting")) {
            buf.append("<tr title=\"").append(this._t("Round trip time for a tunnel test")).append("\"><td align=\"left\"><b>").append(this._t("Tunnel lag")).append(":</b></td><td align=\"right\">").append(this._helper.getTunnelLag()).append("</td></tr>\n");
        }
        buf.append("<tr title=\"").append(this._t("Queued requests from other routers to participate in tunnels")).append("\"><td align=\"left\"><b>").append(this._t("Backlog")).append(":</b></td><td align=\"right\">").append(this._helper.getInboundBacklog()).append("</td></tr>\n</table>\n");
        return buf.toString();
    }

    public String renderTunnelStatusHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(50);
        buf.append("<h4><span class=\"tunnelBuildStatus\">").append(this._t(this._helper.getTunnelStatus())).append("</span></h4>\n");
        return buf.toString();
    }

    public String renderDestinationsHTML() {
        if (this._helper == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append(this._helper.getDestinations());
        return buf.toString();
    }

    public String renderNewsHeadingsHTML() {
        if (this._helper == null) {
            return "";
        }
        NewsHelper newshelper = this._helper.getNewsHelper();
        if (newshelper == null || newshelper.shouldShowNews()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(512);
        String consoleNonce = CSSHelper.getNonce();
        if (consoleNonce != null) {
            NewsManager nmgr;
            buf.append("<h3><a href=\"/news\">").append(this._t("News &amp; Updates")).append("</a></h3><hr class=\"b\"><div class=\"sb_newsheadings\">\n");
            List<Object> entries = Collections.emptyList();
            ClientAppManager cmgr = this._context.clientAppManager();
            if (cmgr != null && (nmgr = (NewsManager)cmgr.getRegisteredApp("news")) != null) {
                entries = nmgr.getEntries();
            }
            if (!entries.isEmpty()) {
                buf.append("<table>\n");
                DateFormat fmt = DateFormat.getDateInstance(3);
                fmt.setTimeZone(SystemVersion.getSystemTimeZone(this._context));
                int i = 0;
                boolean min = true;
                int max = 3;
                for (NewsEntry newsEntry : entries) {
                    if (i >= 1 && newsEntry.updated > 0L && newsEntry.updated < this._context.clock().now() - 5184000000L) break;
                    buf.append("<tr><td><a href=\"/?news=1&amp;consoleNonce=").append(consoleNonce).append("\"");
                    if (newsEntry.updated > 0L) {
                        Date date = new Date(newsEntry.updated);
                        buf.append(" title=\"Published: ").append(fmt.format(date)).append("\"");
                    }
                    buf.append(">");
                    buf.append(newsEntry.title).append("</a></td></tr>\n");
                    if (++i < 3) continue;
                    break;
                }
                buf.append("</table>\n");
            } else {
                buf.append("<center><i>").append(this._t("none")).append("</i></center>");
            }
            buf.append("</div>\n");
        }
        return buf.toString();
    }

    private String _t(String s) {
        return Messages.getString(s, this._context);
    }

    private String _t(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    private static String nbsp(String s) {
        if (s.length() <= 30) {
            return s.replace(" ", "&nbsp;");
        }
        return s;
    }

    static {
        HashMap<String, String> aMap = new HashMap<String, String>();
        aMap.put("HelpAndFAQ", "Help &amp; FAQ");
        aMap.put("I2PServices", "I2P Services");
        aMap.put("I2PInternals", "I2P Internals");
        aMap.put("General", "General");
        aMap.put("ShortGeneral", "Short General");
        aMap.put("NetworkReachability", "Network Reachability");
        aMap.put("UpdateStatus", "Update Status");
        aMap.put("RestartStatus", "Restart Status");
        aMap.put("Peers", "Peers");
        aMap.put("FirewallAndReseedStatus", "Firewall &amp; Reseed Status");
        aMap.put("Bandwidth", "Bandwidth");
        aMap.put("Tunnels", "Tunnels");
        aMap.put("Congestion", "Congestion");
        aMap.put("TunnelStatus", "Tunnel Status");
        aMap.put("Destinations", "Local Tunnels");
        aMap.put("NewsHeadings", "News &amp; Updates");
        aMap.put("Advanced", "Advanced");
        SECTION_NAMES = Collections.unmodifiableMap(aMap);
    }
}

