/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.data.router.RouterAddress;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.UDPSorters;

public class PeerHelper
extends HelperBase {
    private int _sortFlags;
    private String _urlBase;
    private static final String THINSP = " / ";
    private static final NumberFormat _rateFmt = new DecimalFormat("#,##0.00");
    private static final DecimalFormat _fmt = new DecimalFormat("#,##0.00");

    public void setSort(String flags) {
        if (flags != null) {
            try {
                this._sortFlags = Integer.parseInt(flags);
            }
            catch (NumberFormatException nfe) {
                this._sortFlags = 0;
            }
        } else {
            this._sortFlags = 0;
        }
    }

    public void setUrlBase(String base) {
        this._urlBase = base;
    }

    public String getPeerSummary() {
        try {
            this.renderStatusHTML(this._out, this._urlBase, this._sortFlags);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        if (this.isAdvanced()) {
            out.write("<p id=\"upnpstatus\"><b>");
            out.write(this._t("Status"));
            out.write(": ");
            out.write(this._t(this._context.commSystem().getStatus().toStatusString()));
            out.write("</b></p>");
        }
        SortedMap<String, Transport> transports = this._context.commSystem().getTransports();
        for (Map.Entry<String, Transport> e : transports.entrySet()) {
            String style = e.getKey();
            Transport t = e.getValue();
            if (style.equals("NTCP")) {
                NTCPTransport nt = (NTCPTransport)t;
                this.render(nt, out, urlBase, sortFlags);
                continue;
            }
            if (style.equals("SSU")) {
                UDPTransport ut = (UDPTransport)t;
                this.render(ut, out, urlBase, sortFlags);
                continue;
            }
            t.renderStatusHTML(out, urlBase, sortFlags);
        }
        if (!transports.isEmpty()) {
            out.write(this.getTransportsLegend());
        }
        StringBuilder buf = new StringBuilder(4096);
        buf.append("<h3 id=\"transports\">").append(this._t("Router Transport Addresses")).append("</h3><pre id=\"transports\">\n");
        for (Transport t : transports.values()) {
            if (t.hasCurrentAddress()) {
                for (RouterAddress ra : t.getCurrentAddresses()) {
                    buf.append(ra.toString());
                    buf.append("\n\n");
                }
                continue;
            }
            buf.append(this._t("{0} is used for outbound connections only", t.getStyle()));
            buf.append("\n\n");
        }
        buf.append("</pre>\n");
        out.write(buf.toString());
        this._context.commSystem().renderStatusHTML(this._out, this._urlBase, this._sortFlags);
        out.write("</p>\n");
        out.flush();
    }

    private final String getTransportsLegend() {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<p class=\"infohelp\">").append(this._t("Your transport connection limits are automatically set based on your configured bandwidth.")).append('\n').append(this._t("To override these limits, add the settings i2np.ntcp.maxConnections=nnn and i2np.udp.maxConnections=nnn on the advanced configuration page.")).append("</p>\n");
        buf.append("<h3 class=\"tabletitle\">").append(this._t("Definitions")).append("</h3>").append("<table id=\"peerdefs\">\n").append("<tr><td><b id=\"def.peer\">").append(this._t("Peer")).append("</b></td><td>").append(this._t("The remote peer, identified by router hash")).append("</td></tr>\n").append("<tr><td><b id=\"def.dir\">").append(this._t("Dir")).append("</b></td><td><span class=\"peer_arrow\"><img alt=\"Inbound\" src=\"/themes/console/images/inbound.png\"></span> ").append(this._t("Inbound connection")).append("<br>\n").append("<span class=\"peer_arrow\"><img alt=\"Outbound\" src=\"/themes/console/images/outbound.png\"></span> ").append(this._t("Outbound connection")).append("<br>\n").append("<span class=\"peer_arrow\"><img src=\"/themes/console/images/inbound.png\" alt=\"V\" height=\"8\" width=\"12\"></span> ").append(this._t("They offered to introduce us (help other peers traverse our firewall)")).append("<br>\n").append("<span class=\"peer_arrow\"><img src=\"/themes/console/images/outbound.png\" alt=\"^\" height=\"8\" width=\"12\"></span> ").append(this._t("We offered to introduce them (help other peers traverse their firewall)")).append("</td></tr>\n").append("<tr><td><b id=\"def.idle\">").append(this._t("Idle")).append("</b></td><td>").append(this._t("How long since a packet has been received / sent")).append("</td></tr>\n").append("<tr><td><b id=\"def.rate\">").append(this._t("In/Out")).append("</b></td><td>").append(this._t("The smoothed inbound / outbound transfer rate (KBytes per second)")).append("</td></tr>\n").append("<tr><td><b id=\"def.up\">").append(this._t("Up")).append("</b></td><td>").append(this._t("How long ago this connection was established")).append("</td></tr>\n").append("<tr><td><b id=\"def.skew\">").append(this._t("Skew")).append("</b></td><td>").append(this._t("The difference between the peer's clock and your own")).append("</td></tr>\n").append("<tr><td><b id=\"def.cwnd\">CWND</b></td><td>").append(this._t("The congestion window, which is how many bytes can be sent without an acknowledgement")).append(" /<br>\n").append(this._t("The number of sent messages awaiting acknowledgement")).append(" /<br>\n").append(this._t("The maximum number of concurrent messages to send")).append(" /<br>\n").append(this._t("The number of pending sends which exceed congestion window")).append("</td></tr>\n").append("<tr><td><b id=\"def.ssthresh\">SST</b></td><td>").append(this._t("The slow start threshold")).append("</td></tr>\n").append("<tr><td><b id=\"def.rtt\">RTT</b></td><td>").append(this._t("The round trip time in milliseconds")).append("</td></tr>\n").append("<tr><td><b id=\"def.rto\">RTO</b></td><td>").append(this._t("The retransmit timeout in milliseconds")).append("</td></tr>\n").append("<tr><td><b id=\"def.mtu\">MTU</b></td><td>").append(this._t("Current maximum send packet size / estimated maximum receive packet size (bytes)")).append("</td></tr>\n").append("<tr><td><b id=\"def.send\">").append(this._t("TX")).append("</b></td><td>").append(this._t("The total number of messages sent to the peer")).append("</td></tr>\n").append("<tr><td><b id=\"def.recv\">").append(this._t("RX")).append("</b></td><td>").append(this._t("The total number of messages received from the peer")).append("</td></tr>\n").append("<tr><td><b id=\"def.resent\">").append(this._t("Dup TX")).append("</b></td><td>").append(this._t("The total number of packets retransmitted to the peer")).append("</td></tr>\n").append("<tr><td><b id=\"def.dupRecv\">").append(this._t("Dup RX")).append("</b></td><td>").append(this._t("The total number of duplicate packets received from the peer")).append("</td></tr>\n").append("</table>");
        return buf.toString();
    }

    private void render(NTCPTransport nt, Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet<NTCPConnection> peers = new TreeSet<NTCPConnection>(this.getNTCPComparator(sortFlags));
        peers.addAll(nt.getPeers());
        long offsetTotal = 0L;
        float bpsSend = 0.0f;
        float bpsRecv = 0.0f;
        long totalUptime = 0L;
        long totalSend = 0L;
        long totalRecv = 0L;
        if (!this.isAdvanced()) {
            Iterator<NTCPConnection> iter = peers.iterator();
            while (iter.hasNext()) {
                if (iter.next().isEstablished()) continue;
                iter.remove();
            }
        }
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3 id=\"ntcpcon\">").append(this._t("NTCP connections")).append(": ").append(peers.size());
        buf.append(". ").append(this._t("Limit")).append(": ").append(nt.getMaxConnections());
        if (this._context.getBooleanProperty("routerconsole.advanced")) {
            buf.append(". ").append(this._t("Status")).append(": ").append(this._t(nt.getReachabilityStatus().toStatusString()));
        }
        buf.append(".</h3>\n<div class=\"widescroll\"><table id=\"ntcpconnections\">\n<tr><th><a href=\"#def.peer\">").append(this._t("Peer")).append("</a></th><th><a href=\"#def.dir\" title=\"").append(this._t("Direction/Introduction")).append("\">").append(this._t("Dir")).append("</a></th><th>").append(this._t("IPv6")).append("</th><th align=\"right\"><a href=\"#def.idle\">").append(this._t("Idle")).append("</a></th><th align=\"right\"><a href=\"#def.rate\">").append(this._t("In/Out")).append("</a></th><th align=\"right\"><a href=\"#def.up\">").append(this._t("Up")).append("</a></th><th align=\"right\"><a href=\"#def.skew\">").append(this._t("Skew")).append("</a></th><th align=\"right\"><a href=\"#def.send\">").append(this._t("TX")).append("</a></th><th align=\"right\"><a href=\"#def.recv\">").append(this._t("RX")).append("</a></th><th>").append(this._t("Out Queue")).append("</th><th title=\"").append(this._t("Is peer backlogged?")).append("\">").append(this._t("Backlogged?")).append("</th> </tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        for (NTCPConnection con : peers) {
            float r;
            buf.append("<tr><td class=\"cells\" align=\"left\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(con.getRemotePeer().calculateHash()));
            buf.append("</td><td class=\"cells\" align=\"center\">");
            if (con.isInbound()) {
                buf.append("<img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"").append(this._t("Inbound")).append("\"/>");
            } else {
                buf.append("<img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"").append(this._t("Outbound")).append("\"/>");
            }
            buf.append("</td><td class=\"cells peeripv6\" align=\"center\">");
            if (con.isIPv6()) {
                buf.append("<span class=\"backlogged\">&#x2714;</span>");
            } else {
                buf.append("");
            }
            buf.append("</td><td class=\"cells\" align=\"center\"><span class=\"right\">");
            buf.append(DataHelper.formatDuration2(con.getTimeSinceReceive()));
            buf.append("</span>").append(THINSP).append("<span class=\"left\">").append(DataHelper.formatDuration2(con.getTimeSinceSend()));
            buf.append("</span></td><td class=\"cells\" align=\"center\"><span class=\"right\">");
            if (con.getTimeSinceReceive() < 120000L) {
                r = con.getRecvRate();
                buf.append(PeerHelper.formatRate(r / 1024.0f));
                bpsRecv += r;
            } else {
                buf.append(PeerHelper.formatRate(0.0f));
            }
            buf.append("</span>").append(THINSP).append("<span class=\"left\">");
            if (con.getTimeSinceSend() < 120000L) {
                r = con.getSendRate();
                buf.append(PeerHelper.formatRate(r / 1024.0f));
                bpsSend += r;
            } else {
                buf.append(PeerHelper.formatRate(0.0f));
            }
            buf.append("</span></td><td class=\"cells\" align=\"right\">").append(DataHelper.formatDuration2(con.getUptime()));
            totalUptime += con.getUptime();
            offsetTotal += con.getClockSkew();
            buf.append("</td><td class=\"cells\" align=\"right\">").append(DataHelper.formatDuration2(1000L * con.getClockSkew()));
            buf.append("</td><td class=\"cells\" align=\"right\">").append(con.getMessagesSent());
            totalSend += (long)con.getMessagesSent();
            buf.append("</td><td class=\"cells\" align=\"right\">").append(con.getMessagesReceived());
            totalRecv += (long)con.getMessagesReceived();
            long outQueue = con.getOutboundQueueSize();
            buf.append("</td><td class=\"cells\" align=\"center\">").append(outQueue);
            buf.append("</td><td class=\"cells\" align=\"center\">");
            if (con.isBacklogged()) {
                buf.append("<span class=\"backlogged\">&#x2714;</span>");
            } else {
                buf.append("&nbsp;");
            }
            buf.append("</td></tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
        }
        if (!peers.isEmpty()) {
            buf.append("<tr class=\"tablefooter\"><td colspan=\"4\" align=\"left\"><b>").append(this.ngettext("{0} peer", "{0} peers", peers.size()));
            buf.append("</b></td><td align=\"center\" nowrap><span class=\"right\"><b>").append(PeerHelper.formatRate(bpsRecv / 1024.0f)).append("</b></span>");
            buf.append(THINSP).append("<span class=\"left\"><b>").append(PeerHelper.formatRate(bpsSend / 1024.0f)).append("</b></span>");
            buf.append("</td><td align=\"right\"><b>").append(DataHelper.formatDuration2(totalUptime / (long)peers.size()));
            buf.append("</b></td><td align=\"right\"><b>").append(DataHelper.formatDuration2(offsetTotal * 1000L / (long)peers.size()));
            buf.append("</b></td><td align=\"right\"><b>").append(totalSend).append("</b></td><td align=\"right\"><b>").append(totalRecv);
            buf.append("</b></td><td>&nbsp;</td><td>&nbsp;</td></tr>\n");
        }
        buf.append("</table></div>\n");
        out.write(buf.toString());
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatRate(float rate) {
        NumberFormat numberFormat = _rateFmt;
        synchronized (numberFormat) {
            return _rateFmt.format(rate);
        }
    }

    private Comparator<NTCPConnection> getNTCPComparator(int sortFlags) {
        Comparator<NTCPConnection> rv = null;
        switch (Math.abs(sortFlags)) {
            default: 
        }
        rv = AlphaComparator.instance();
        if (sortFlags < 0) {
            rv = Collections.reverseOrder(rv);
        }
        return rv;
    }

    private void render(UDPTransport ut, Writer out, String urlBase, int sortFlags) throws IOException {
        TreeSet<PeerState> peers = new TreeSet<PeerState>(UDPSorters.getComparator(sortFlags));
        peers.addAll(ut.getPeers());
        long offsetTotal = 0L;
        int bpsIn = 0;
        int bpsOut = 0;
        long uptimeMsTotal = 0L;
        long cwinTotal = 0L;
        long rttTotal = 0L;
        long rtoTotal = 0L;
        long sendTotal = 0L;
        long recvTotal = 0L;
        long resentTotal = 0L;
        long dupRecvTotal = 0L;
        int numPeers = 0;
        StringBuilder buf = new StringBuilder(512);
        buf.append("<h3 id=\"udpcon\">").append(this._t("UDP connections")).append(": ").append(peers.size());
        buf.append(". ").append(this._t("Limit")).append(": ").append(ut.getMaxConnections());
        if (this.isAdvanced()) {
            buf.append(". ").append(this._t("Status")).append(": ").append(this._t(ut.getReachabilityStatus().toStatusString()));
        }
        buf.append(".</h3>\n");
        buf.append("<div class=\"widescroll\"><table id=\"udpconnections\">\n");
        buf.append("<tr class=\"smallhead\"><th nowrap><a href=\"#def.peer\">").append(this._t("Peer")).append("</a><br>");
        if (sortFlags != 0) {
            UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by peer hash"), 0);
        }
        buf.append("</th><th nowrap><a href=\"#def.dir\" title=\"").append(this._t("Direction/Introduction")).append("\">").append(this._t("Dir")).append("</a></th><th nowrap>").append(this._t("IPv6")).append("</th><th nowrap><a href=\"#def.idle\">").append(this._t("Idle")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by idle inbound"), 1);
        buf.append(THINSP);
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by idle outbound"), 2);
        buf.append("</th>");
        buf.append("<th nowrap><a href=\"#def.rate\">").append(this._t("In/Out")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by inbound rate"), 3);
        buf.append(THINSP);
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by outbound rate"), 4);
        buf.append("</th>\n");
        buf.append("<th nowrap><span class=\"peersort\"><a href=\"#def.up\">").append(this._t("Up")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by connection uptime"), 16);
        buf.append("</span></th><th nowrap><span class=\"peersort\"><a href=\"#def.skew\">").append(this._t("Skew")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by clock skew"), 5);
        buf.append("</span></th>\n");
        buf.append("<th nowrap><a href=\"#def.cwnd\">CWND</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by congestion window"), 6);
        buf.append("</th><th nowrap><span class=\"peersort\"><a href=\"#def.ssthresh\">SST</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by slow start threshold"), 7);
        buf.append("</span></th>\n");
        buf.append("<th nowrap><span class=\"peersort\"><a href=\"#def.rtt\">RTT</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by round trip time"), 8);
        buf.append("</span></th><th nowrap><span class=\"peersort\"><a href=\"#def.rto\">RTO</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by retransmission timeout"), 10);
        buf.append("</span></th>\n");
        buf.append("<th nowrap><a href=\"#def.mtu\">MTU</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by outbound maximum transmit unit"), 11);
        buf.append("</th><th nowrap><span class=\"peersort\"><a href=\"#def.send\">").append(this._t("TX")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets sent"), 12);
        buf.append("</span></th><th nowrap><span class=\"peersort\"><a href=\"#def.recv\">").append(this._t("RX")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets received"), 13);
        buf.append("</span></th>\n");
        buf.append("<th nowrap><span class=\"peersort\"><a href=\"#def.resent\">").append(this._t("Dup TX")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets retransmitted"), 14);
        buf.append("</span></th><th nowrap><span class=\"peersort\"><a href=\"#def.dupRecv\">").append(this._t("Dup RX")).append("</a><br>");
        UDPSorters.appendSortLinks(buf, urlBase, sortFlags, this._t("Sort by packets received more than once"), 15);
        buf.append("</span></th></tr>\n");
        out.write(buf.toString());
        buf.setLength(0);
        long now = this._context.clock().now();
        for (PeerState peer : peers) {
            if (now - peer.getLastReceiveTime() > 3600000L) continue;
            buf.append("<tr><td class=\"cells\" align=\"left\" nowrap>");
            buf.append(this._context.commSystem().renderPeerHTML(peer.getRemotePeer()));
            buf.append("</td><td class=\"cells\" nowrap align=\"left\">");
            if (peer.isInbound()) {
                buf.append("<img src=\"/themes/console/images/inbound.png\" alt=\"Inbound\" title=\"").append(this._t("Inbound")).append("\">");
            } else {
                buf.append("<img src=\"/themes/console/images/outbound.png\" alt=\"Outbound\" title=\"").append(this._t("Outbound")).append("\">");
            }
            if (peer.getWeRelayToThemAs() > 0L) {
                buf.append("&nbsp;&nbsp;<img src=\"/themes/console/images/outbound.png\" height=\"8\" width=\"12\" alt=\"^\" title=\"").append(this._t("We offered to introduce them")).append("\">");
            }
            if (peer.getTheyRelayToUsAs() > 0L) {
                buf.append("&nbsp;&nbsp;<img src=\"/themes/console/images/inbound.png\" height=\"8\" width=\"12\" alt=\"V\" title=\"").append(this._t("They offered to introduce us")).append("\">");
            }
            boolean appended = false;
            int cfs = peer.getConsecutiveFailedSends();
            if (cfs > 0) {
                if (!appended) {
                    buf.append("<br>");
                }
                buf.append(" <i>");
                if (cfs == 1) {
                    buf.append(this._t("1 fail"));
                } else {
                    buf.append(this._t("{0} fails", cfs));
                }
                buf.append("</i>");
                appended = true;
            }
            if (this._context.banlist().isBanlisted(peer.getRemotePeer(), "SSU")) {
                if (!appended) {
                    buf.append("<br>");
                }
                buf.append(" <i>").append(this._t("Banned")).append("</i>");
                appended = true;
            }
            buf.append("</td>");
            buf.append("<td class=\"cells peeripv6\" align=\"center\">");
            if (peer.isIPv6()) {
                buf.append("&#x2713;");
            } else {
                buf.append("");
            }
            buf.append("</td>");
            long idleIn = Math.max(now - peer.getLastReceiveTime(), 0L);
            long idleOut = Math.max(now - peer.getLastSendTime(), 0L);
            buf.append("<td class=\"cells\" align=\"center\"><span class=\"right\">");
            buf.append(DataHelper.formatDuration2(idleIn));
            buf.append("</span>").append(THINSP);
            buf.append("<span class=\"left\">").append(DataHelper.formatDuration2(idleOut));
            buf.append("</span></td>");
            int recvBps = idleIn > 15000L ? 0 : peer.getReceiveBps();
            int sendBps = idleOut > 15000L ? 0 : peer.getSendBps();
            buf.append("<td class=\"cells\" align=\"center\" nowrap><span class=\"right\">");
            buf.append(PeerHelper.formatKBps(recvBps));
            buf.append("</span>").append(THINSP);
            buf.append("<span class=\"left\">").append(PeerHelper.formatKBps(sendBps));
            buf.append("</span></td>");
            long uptime = now - peer.getKeyEstablishedTime();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2(uptime));
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            long skew = peer.getClockSkew();
            buf.append(DataHelper.formatDuration2(skew));
            buf.append("</td>");
            offsetTotal += skew;
            long sendWindow = peer.getSendWindowBytes();
            buf.append("<td class=\"cells cwnd\" align=\"center\"><span class=\"right\">");
            buf.append(sendWindow / 1024L);
            buf.append("K");
            buf.append("</span>").append(THINSP).append("<span class=\"right\">").append(peer.getConcurrentSends());
            buf.append("</span>").append(THINSP).append("<span class=\"right\">").append(peer.getConcurrentSendWindow());
            buf.append("</span>").append(THINSP).append("<span class=\"left\">").append(peer.getConsecutiveSendRejections());
            if (peer.isBacklogged()) {
                buf.append(' ').append(this._t("backlogged"));
            }
            buf.append("</span></td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(peer.getSlowStartThreshold() / 1024);
            buf.append("K</td>");
            int rtt = peer.getRTT();
            int rto = peer.getRTO();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2(rtt));
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(DataHelper.formatDuration2(rto));
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"center\"><span class=\"right\">");
            buf.append(peer.getMTU()).append("</span>").append(THINSP);
            buf.append("<span class=\"left\">").append(peer.getReceiveMTU());
            buf.append("</span></td>");
            long sent = peer.getMessagesSent();
            long recv = peer.getMessagesReceived();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(sent);
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(recv);
            buf.append("</td>");
            long resent = peer.getPacketsRetransmitted();
            long dupRecv = peer.getPacketsReceivedDuplicate();
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(resent);
            buf.append("</td>");
            buf.append("<td class=\"cells\" align=\"right\">");
            buf.append(dupRecv);
            buf.append("</td>");
            buf.append("</tr>\n");
            out.write(buf.toString());
            buf.setLength(0);
            bpsIn += recvBps;
            bpsOut += sendBps;
            uptimeMsTotal += uptime;
            cwinTotal += sendWindow;
            rttTotal += (long)rtt;
            rtoTotal += (long)rto;
            sendTotal += sent;
            recvTotal += recv;
            resentTotal += resent;
            dupRecvTotal += dupRecv;
            ++numPeers;
        }
        if (numPeers > 0) {
            buf.append("<tr class=\"tablefooter\"><td colspan=\"4\" align=\"left\"><b>").append(this.ngettext("{0} peer", "{0} peers", peers.size())).append("</b></td><td align=\"center\" nowrap><span class=\"right\"><b>");
            buf.append(PeerHelper.formatKBps(bpsIn)).append("</b></span>").append(THINSP);
            buf.append("<span class=\"left\"><b>").append(PeerHelper.formatKBps(bpsOut));
            long x = uptimeMsTotal / (long)numPeers;
            buf.append("</b></span></td><td align=\"right\"><b>").append(DataHelper.formatDuration2(x));
            x = offsetTotal / (long)numPeers;
            buf.append("</b></td><td align=\"right\"><b>").append(DataHelper.formatDuration2(x)).append("</b></td>\n<td align=\"center\"><b>");
            buf.append(cwinTotal / (long)(numPeers * 1024) + "K");
            buf.append("</b></td><td>&nbsp;</td>\n<td align=\"right\"><b>");
            buf.append(DataHelper.formatDuration2(rttTotal / (long)numPeers));
            buf.append("</b></td><td align=\"right\"><b>");
            buf.append(DataHelper.formatDuration2(rtoTotal / (long)numPeers));
            buf.append("</b></td><td align=\"center\"><b>").append(ut.getMTU(false)).append("</b></td><td align=\"right\"><b>");
            buf.append(sendTotal).append("</b></td><td align=\"right\"><b>").append(recvTotal).append("</b></td>\n<td align=\"right\"><b>").append(resentTotal);
            buf.append("</b></td><td align=\"right\"><b>").append(dupRecvTotal).append("</b></td></tr>\n");
        }
        buf.append("</table></div>\n");
        out.write(buf.toString());
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String formatKBps(int bps) {
        DecimalFormat decimalFormat = _fmt;
        synchronized (decimalFormat) {
            return _fmt.format((float)bps / 1024.0f);
        }
    }

    private static class AlphaComparator
    extends PeerComparator {
        private static final AlphaComparator _instance = new AlphaComparator();

        private AlphaComparator() {
        }

        public static final AlphaComparator instance() {
            return _instance;
        }
    }

    private static class PeerComparator
    implements Comparator<NTCPConnection>,
    Serializable {
        private PeerComparator() {
        }

        @Override
        public int compare(NTCPConnection l, NTCPConnection r) {
            if (l == null || r == null) {
                throw new IllegalArgumentException();
            }
            return l.getRemotePeer().calculateHash().toBase64().compareTo(r.getRemotePeer().calculateHash().toBase64());
        }
    }
}

