/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.util.HashDistance;
import net.i2p.router.web.Messages;
import net.i2p.router.web.SybilRenderer;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.Translate;
import net.i2p.util.VersionComparator;

class NetDbRenderer {
    private final RouterContext _context;
    private static final int SSU = 1;
    private static final int SSUI = 2;
    private static final int NTCP = 4;
    private static final int IPV6 = 8;
    private static final String[] TNAMES = new String[]{NetDbRenderer._x("Hidden or starting up"), NetDbRenderer._x("SSU"), NetDbRenderer._x("SSU with introducers"), "", NetDbRenderer._x("NTCP"), NetDbRenderer._x("NTCP and SSU"), NetDbRenderer._x("NTCP and SSU with introducers"), "", "", NetDbRenderer._x("IPv6 SSU"), NetDbRenderer._x("IPv6 Only SSU, introducers"), NetDbRenderer._x("IPv6 SSU, introducers"), NetDbRenderer._x("IPv6 NTCP"), NetDbRenderer._x("IPv6 NTCP, SSU"), NetDbRenderer._x("IPv6 Only NTCP, SSU, introducers"), NetDbRenderer._x("IPv6 NTCP, SSU, introducers")};

    public NetDbRenderer(RouterContext ctx) {
        this._context = ctx;
    }

    public void renderRouterInfoHTML(Writer out, String routerPrefix, String version, String country, String family, String caps, String ip, String sybil, int port, SigType type, String mtu, String ipv6, String ssucaps, int cost) throws IOException {
        ArrayList<Hash> sybils;
        StringBuilder buf = new StringBuilder(4096);
        ArrayList<Hash> arrayList = sybils = sybil != null ? new ArrayList<Hash>(128) : null;
        if (".".equals(routerPrefix)) {
            this.renderRouterInfo(buf, this._context.router().getRouterInfo(), true, true);
        } else {
            boolean notFound = true;
            Set<RouterInfo> routers = this._context.netDb().getRouters();
            int ipMode = 0;
            if (ip != null) {
                if (ip.endsWith("/24")) {
                    ipMode = 1;
                } else if (ip.endsWith("/16")) {
                    ipMode = 2;
                } else if (ip.endsWith("/8")) {
                    ipMode = 3;
                }
                for (int i = 0; i < ipMode; ++i) {
                    int last = ip.substring(0, ip.length() - 1).lastIndexOf(46);
                    if (last <= 0) continue;
                    ip = ip.substring(0, last + 1);
                }
            }
            block1: for (RouterInfo ri : routers) {
                String host;
                Hash key = ri.getIdentity().getHash();
                if (routerPrefix != null && key.toBase64().startsWith(routerPrefix) || version != null && version.equals(ri.getVersion()) || country != null && country.equals(this._context.commSystem().getCountry(key)) || family != null && family.equals(ri.getOption("family")) || caps != null && ri.getCapabilities().contains(caps) || type != null && type == ri.getIdentity().getSigType()) {
                    this.renderRouterInfo(buf, ri, false, true);
                    if (sybil != null) {
                        sybils.add(key);
                    }
                    notFound = false;
                    continue;
                }
                if (ip != null) {
                    for (RouterAddress ra : ri.getAddresses()) {
                        if (ipMode == 0) {
                            if (!ip.equals(ra.getHost())) continue;
                            this.renderRouterInfo(buf, ri, false, true);
                            if (sybil != null) {
                                sybils.add(key);
                            }
                            notFound = false;
                            continue block1;
                        }
                        host = ra.getHost();
                        if (host == null || !host.startsWith(ip)) continue;
                        this.renderRouterInfo(buf, ri, false, true);
                        if (sybil != null) {
                            sybils.add(key);
                        }
                        notFound = false;
                        continue block1;
                    }
                    continue;
                }
                if (port != 0) {
                    for (RouterAddress ra : ri.getAddresses()) {
                        if (port != ra.getPort()) continue;
                        this.renderRouterInfo(buf, ri, false, true);
                        if (sybil != null) {
                            sybils.add(key);
                        }
                        notFound = false;
                        continue block1;
                    }
                    continue;
                }
                if (mtu != null) {
                    for (RouterAddress ra : ri.getAddresses()) {
                        if (!mtu.equals(ra.getOption("mtu"))) continue;
                        this.renderRouterInfo(buf, ri, false, true);
                        if (sybil != null) {
                            sybils.add(key);
                        }
                        notFound = false;
                        continue block1;
                    }
                    continue;
                }
                if (ipv6 != null) {
                    for (RouterAddress ra : ri.getAddresses()) {
                        host = ra.getHost();
                        if (host == null || !host.startsWith(ipv6)) continue;
                        this.renderRouterInfo(buf, ri, false, true);
                        if (sybil != null) {
                            sybils.add(key);
                        }
                        notFound = false;
                        continue block1;
                    }
                    continue;
                }
                if (ssucaps != null) {
                    for (RouterAddress ra : ri.getAddresses()) {
                        if (!"SSU".equals(ra.getTransportStyle()) || !ssucaps.equals(ra.getOption("caps"))) continue;
                        this.renderRouterInfo(buf, ri, false, true);
                        if (sybil != null) {
                            sybils.add(key);
                        }
                        notFound = false;
                        continue block1;
                    }
                    continue;
                }
                if (cost == 0) continue;
                for (RouterAddress ra : ri.getAddresses()) {
                    if (cost != ra.getCost()) continue;
                    this.renderRouterInfo(buf, ri, false, true);
                    if (sybil != null) {
                        sybils.add(key);
                    }
                    notFound = false;
                    continue block1;
                }
            }
            if (notFound) {
                buf.append("<div class=\"netdbnotfound\">");
                buf.append(this._t("Router")).append(' ');
                if (routerPrefix != null) {
                    buf.append(routerPrefix);
                } else if (version != null) {
                    buf.append(version);
                } else if (country != null) {
                    buf.append(country);
                } else if (family != null) {
                    buf.append(this._t("Family")).append(' ').append(family);
                }
                buf.append(' ').append(this._t("not found in network database"));
                buf.append("</div>");
            }
        }
        out.write(buf.toString());
        out.flush();
        if (sybil != null) {
            SybilRenderer.renderSybilHTML(out, this._context, sybils, sybil);
        }
    }

    public void renderLeaseSetHTML(Writer out, boolean debug) throws IOException {
        DecimalFormat fmt;
        TreeSet<LeaseSet> leases;
        Hash ourRKey;
        StringBuilder buf = new StringBuilder(4096);
        if (debug) {
            buf.append("<p id=\"debugmode\">Debug mode - Sorted by hash distance, closest first</p>\n");
        }
        if (debug) {
            ourRKey = this._context.routerHash();
            leases = new TreeSet<LeaseSet>(new LeaseSetRoutingKeyComparator(ourRKey));
            fmt = new DecimalFormat("#0.00");
        } else {
            ourRKey = null;
            leases = new TreeSet<LeaseSet>(new LeaseSetComparator());
            fmt = null;
        }
        leases.addAll(this._context.netDb().getLeases());
        int medianCount = 0;
        int rapCount = 0;
        BigInteger median = null;
        int c = 0;
        FloodfillNetworkDatabaseFacade netdb = (FloodfillNetworkDatabaseFacade)this._context.netDb();
        if (debug) {
            buf.append("<table id=\"leasesetdebug\">\n");
        } else {
            buf.append("<table id=\"leasesetsummary\">\n");
        }
        buf.append("<tr><th colspan=\"3\">Leaseset Summary</th>").append("<th><a href=\"/configadvanced\" title=\"").append(this._t("Manually Configure Floodfill Participation")).append("\">[").append(this._t("Configure Floodfill Participation")).append("]</a></th></tr>\n").append("<tr><td><b>Total Leasesets:</b></td><td colspan=\"3\">").append(leases.size()).append("</td></tr>\n");
        if (debug) {
            buf.append("<tr><td><b>Published (RAP) Leasesets:</b></td><td colspan=\"3\">").append(netdb.getKnownLeaseSets()).append("</td></tr>\n").append("<tr><td><b>Mod Data:</b></td><td>").append(DataHelper.getUTF8(this._context.routerKeyGenerator().getModData())).append("</td>").append("<td><b>Last Changed:</b></td><td>").append(new Date(this._context.routerKeyGenerator().getLastChanged())).append("</td></tr>\n").append("<tr><td><b>Next Mod Data:</b></td><td>").append(DataHelper.getUTF8(this._context.routerKeyGenerator().getNextModData())).append("</td>").append("<td><b>Change in:</b></td><td>").append(DataHelper.formatDuration(this._context.routerKeyGenerator().getTimeTillMidnight())).append("</td></tr>\n");
        }
        int ff = this._context.peerManager().getPeersByCapability('f').size();
        buf.append("<tr><td><b>Known Floodfills:</b></td><td colspan=\"3\">").append(ff).append("</td></tr>\n").append("<tr><td><b>Currently Floodfill?</b></td><td colspan=\"3\">").append(netdb.floodfillEnabled() ? "yes" : "no").append("</td></tr>\n");
        if (debug) {
            buf.append("<tr><td><b>Network data (only valid if floodfill):</b></td><td colspan=\"3\">");
            if (median != null) {
                double log2 = NetDbRenderer.biLog2(median);
                buf.append("</td></tr>").append("<tr><td><b>Median distance (bits):</b></td><td colspan=\"3\">").append(fmt.format(log2)).append("</td></tr>\n");
                int total = (int)Math.round(Math.pow(2.0, 257.0 - log2));
                buf.append("<tr><td><b>Estimated total floodfills:</b></td><td colspan=\"3\">").append(total).append("</td></tr>\n");
                buf.append("<tr><td><b>Estimated total leasesets:</b></td><td colspan=\"3\">").append(total * rapCount / 4);
            } else {
                buf.append("<i>Not floodfill or no data.</i>");
            }
            buf.append("</td></tr>\n");
        }
        buf.append("</table>\n");
        if (leases.isEmpty()) {
            if (!debug) {
                buf.append("<div id=\"noleasesets\"><i>").append(this._t("No Leasesets currently active.")).append("</i></div>");
            }
        } else {
            if (debug) {
                for (LeaseSet ls : leases) {
                    if (!ls.getReceivedAsPublished()) continue;
                    ++rapCount;
                }
                medianCount = rapCount / 2;
            }
            long now = this._context.clock().now();
            buf.append("<div class=\"leasesets_container\">");
            for (LeaseSet ls : leases) {
                Destination dest = ls.getDestination();
                Hash key = dest.calculateHash();
                buf.append("<table class=\"leaseset\">\n").append("<tr><th><b>").append(this._t("LeaseSet")).append(":</b>&nbsp;<code>").append(key.toBase64()).append("</code></th>");
                if (this._context.clientManager().isLocal(dest)) {
                    boolean unpublished;
                    buf.append("<th><a href=\"tunnels#" + key.toBase64().substring(0, 4) + "\">" + this._t("Local") + "</a> ");
                    boolean bl = unpublished = !this._context.clientManager().shouldPublishLeaseSet(key);
                    if (unpublished) {
                        buf.append("<b>").append(this._t("Unpublished")).append("</b> ");
                    }
                    buf.append("<b>").append(this._t("Destination")).append(":</b> ");
                    TunnelPoolSettings in = this._context.tunnelManager().getInboundSettings(key);
                    if (in != null && in.getDestinationNickname() != null) {
                        buf.append(in.getDestinationNickname());
                    } else {
                        buf.append(dest.toBase64().substring(0, 6));
                    }
                    buf.append("</th></tr>\n<tr><td");
                    String host = null;
                    if (!unpublished) {
                        host = this._context.namingService().reverseLookup(dest);
                    }
                    if (unpublished || host != null) {
                        buf.append(" colspan=\"2\"");
                    }
                    buf.append(">");
                    String b32 = dest.toBase32();
                    buf.append("<a href=\"http://").append(b32).append("\">").append(b32).append("</a></td>");
                    if (!unpublished && host == null) {
                        buf.append("<td class=\"addtobook\" colspan=\"2\">").append("<a title=\"").append(this._t("Add to addressbook")).append("\" href=\"/susidns/addressbook.jsp?book=private&amp;destination=").append(dest.toBase64()).append("#add\">").append(this._t("Add to local addressbook")).append("</a></td>");
                    }
                } else {
                    buf.append("<th><b>").append(this._t("Destination")).append(":</b> ");
                    String host = this._context.namingService().reverseLookup(dest);
                    if (host != null) {
                        buf.append("<a href=\"http://").append(host).append("/\">").append(host).append("</a></th>");
                    } else {
                        String b32 = dest.toBase32();
                        buf.append("<code>").append(dest.toBase64().substring(0, 6)).append("</code></th>").append("</tr>\n<tr>").append("<td><a href=\"http://").append(b32).append("\">").append(b32).append("</a></td>\n").append("<td class=\"addtobook\"><a title=\"").append(this._t("Add to addressbook")).append("\" href=\"/susidns/addressbook.jsp?book=private&amp;destination=").append(dest.toBase64()).append("#add\">").append(this._t("Add to local addressbook")).append("</a></td>");
                    }
                }
                buf.append("</tr>\n<tr><td colspan=\"2\">\n");
                long exp = ls.getLatestLeaseDate() - now;
                if (exp > 0L) {
                    buf.append("<b>").append(this._t("Expires in {0}", DataHelper.formatDuration2(exp))).append("</b>");
                } else {
                    buf.append("<b>").append(this._t("Expired {0} ago", DataHelper.formatDuration2(0L - exp))).append("</b>");
                }
                buf.append("</td></tr>\n");
                if (debug) {
                    buf.append("<tr><td colspan=\"2\">");
                    buf.append("<b>RAP?</b> ").append(ls.getReceivedAsPublished());
                    buf.append("&nbsp;&nbsp;<b>RAR?</b> ").append(ls.getReceivedAsReply());
                    BigInteger dist = HashDistance.getDistance(ourRKey, ls.getRoutingKey());
                    if (ls.getReceivedAsPublished() && c++ == medianCount) {
                        median = dist;
                    }
                    buf.append("&nbsp;&nbsp;<b>Distance: </b>").append(fmt.format(NetDbRenderer.biLog2(dist)));
                    buf.append("</td></tr>\n<tr><td colspan=\"2\">");
                    buf.append("<b>Signature type:</b> ").append((Object)dest.getSigningPublicKey().getType());
                    buf.append("&nbsp;&nbsp;<b>Encryption Key:</b> ").append(ls.getEncryptionKey().toBase64().substring(0, 20)).append("&hellip;");
                    buf.append("</td></tr>\n<tr><td colspan=\"2\">");
                    buf.append("<b>Routing Key:</b> ").append(ls.getRoutingKey().toBase64());
                    buf.append("</td></tr>");
                }
                buf.append("<tr><td colspan=\"2\"><ul class=\"netdb_leases\">");
                for (int i = 0; i < ls.getLeaseCount(); ++i) {
                    Lease lease = ls.getLease(i);
                    buf.append("<li><b>").append(this._t("Lease")).append(' ').append(i + 1).append(":</b> <span class=\"netdb_gateway\" title=\"").append(this._t("Gateway")).append("\"><img src=\"themes/console/images/info/gateway.png\" alt=\"").append(this._t("Gateway")).append("\"></span> <span class=\"tunnel_peer\">");
                    buf.append(this._context.commSystem().renderPeerHTML(lease.getGateway()));
                    buf.append("</span> <span class=\"netdb_tunnel\">").append(this._t("Tunnel")).append(" <span class=\"tunnel_id\">").append(lease.getTunnelId().getTunnelId()).append("</span></span> ");
                    if (debug) {
                        long exl = lease.getEndDate().getTime() - now;
                        if (exl > 0L) {
                            buf.append("<b class=\"netdb_expiry\">").append(this._t("Expires in {0}", DataHelper.formatDuration2(exl))).append("</b>");
                        } else {
                            buf.append("<b class=\"netdb_expiry\">").append(this._t("Expired {0} ago", DataHelper.formatDuration2(0L - exl))).append("</b>");
                        }
                    }
                    buf.append("</li>");
                }
                buf.append("</ul></td></tr>\n");
                buf.append("</table>\n");
                out.write(buf.toString());
                buf.setLength(0);
            }
            buf.append("</div>");
        }
        out.write(buf.toString());
        out.flush();
    }

    public static double biLog2(BigInteger a) {
        int b = a.bitLength() - 1;
        double c = 0.0;
        double d = 0.5;
        for (int i = b; i >= 0; --i) {
            if (a.testBit(i)) {
                c += d;
            }
            d /= 2.0;
        }
        return (double)b + c;
    }

    public void renderStatusHTML(Writer out, int mode) throws IOException {
        if (!this._context.netDb().isInitialized()) {
            out.write("<div id=\"notinitialized\">");
            out.write(this._t("Not initialized"));
            out.write("</div>");
            out.flush();
            return;
        }
        Log log = this._context.logManager().getLog(NetDbRenderer.class);
        long start = System.currentTimeMillis();
        boolean full = mode == 1;
        boolean shortStats = mode == 2;
        boolean showStats = full || shortStats;
        Hash us = this._context.routerHash();
        StringBuilder buf = new StringBuilder(8192);
        if (showStats) {
            RouterInfo ourInfo = this._context.router().getRouterInfo();
            this.renderRouterInfo(buf, ourInfo, true, true);
            out.write(buf.toString());
            buf.setLength(0);
        }
        ObjectCounter<String> versions = new ObjectCounter<String>();
        ObjectCounter<String> countries = new ObjectCounter<String>();
        int[] transportCount = new int[TNAMES.length];
        TreeSet<RouterInfo> routers = new TreeSet<RouterInfo>(new RouterInfoComparator());
        routers.addAll(this._context.netDb().getRouters());
        for (RouterInfo ri : routers) {
            String country;
            String routerVersion;
            Hash key = ri.getIdentity().getHash();
            boolean isUs = key.equals(us);
            if (isUs) continue;
            if (showStats) {
                this.renderRouterInfo(buf, ri, false, full);
                out.write(buf.toString());
                buf.setLength(0);
            }
            if ((routerVersion = ri.getOption("router.version")) != null) {
                versions.increment(routerVersion);
            }
            if ((country = this._context.commSystem().getCountry(key)) != null) {
                countries.increment(country);
            }
            int n = NetDbRenderer.classifyTransports(ri);
            transportCount[n] = transportCount[n] + 1;
        }
        long end = System.currentTimeMillis();
        if (log.shouldWarn()) {
            log.warn("part 1 took " + (end - start));
        }
        start = end;
        if (!showStats) {
            buf.append("<table id=\"netdboverview\" border=\"0\" cellspacing=\"30\"><tr><th colspan=\"3\">").append(this._t("Network Database Router Statistics")).append("</th></tr><tr><td style=\"vertical-align: top;\">");
            ArrayList versionList = new ArrayList(versions.objects());
            if (!versionList.isEmpty()) {
                Collections.sort(versionList, Collections.reverseOrder(new VersionComparator()));
                buf.append("<table id=\"netdbversions\">\n");
                buf.append("<tr><th>" + this._t("Version") + "</th><th>" + this._t("Count") + "</th></tr>\n");
                for (String routerVersion : versionList) {
                    int num = versions.count(routerVersion);
                    String ver = DataHelper.stripHTML(routerVersion);
                    buf.append("<tr><td align=\"center\"><a href=\"/netdb?v=").append(ver).append("\">").append(ver);
                    buf.append("</a></td><td align=\"center\">").append(num).append("</td></tr>\n");
                }
                buf.append("</table>\n");
            }
            buf.append("</td><td style=\"vertical-align: top;\">");
            out.write(buf.toString());
            buf.setLength(0);
            end = System.currentTimeMillis();
            if (log.shouldWarn()) {
                log.warn("part 2 took " + (end - start));
            }
            start = end;
            buf.append("<table id=\"netdbtransports\">\n");
            buf.append("<tr><th align=\"left\">" + this._t("Transports") + "</th><th>" + this._t("Count") + "</th></tr>\n");
            for (int i = 0; i < TNAMES.length; ++i) {
                int num = transportCount[i];
                if (num <= 0) continue;
                buf.append("<tr><td>").append(this._t(TNAMES[i]));
                buf.append("</td><td align=\"center\">").append(num).append("</td></tr>\n");
            }
            buf.append("</table>\n");
            buf.append("</td><td style=\"vertical-align: top;\">");
            out.write(buf.toString());
            buf.setLength(0);
            end = System.currentTimeMillis();
            if (log.shouldWarn()) {
                log.warn("part 3 took " + (end - start));
            }
            start = end;
            ArrayList countryList = new ArrayList(countries.objects());
            if (!countryList.isEmpty()) {
                Collections.sort(countryList, new CountryComparator());
                buf.append("<table id=\"netdbcountrylist\">\n");
                buf.append("<tr><th align=\"left\">" + this._t("Country") + "</th><th>" + this._t("Count") + "</th></tr>\n");
                for (String country : countryList) {
                    int num = countries.count(country);
                    buf.append("<tr><td><a href=\"/netdb?c=").append(country).append("\">");
                    buf.append("<img height=\"11\" width=\"16\" alt=\"").append(country.toUpperCase(Locale.US)).append("\"");
                    buf.append(" src=\"/flags.jsp?c=").append(country).append("\">");
                    buf.append(this.getTranslatedCountry(country));
                    buf.append("</a></td><td align=\"center\">").append(num).append("</td></tr>\n");
                }
                buf.append("</table>\n");
            }
            buf.append("</td></tr></table>");
            end = System.currentTimeMillis();
            if (log.shouldWarn()) {
                log.warn("part 4 took " + (end - start));
            }
            start = end;
        }
        out.write(buf.toString());
        out.flush();
    }

    private String getTranslatedCountry(String code) {
        String name = this._context.commSystem().getCountryName(code);
        return Translate.getString(name, this._context, "net.i2p.router.countries.messages");
    }

    private void renderRouterInfo(StringBuilder buf, RouterInfo info, boolean isUs, boolean full) {
        String hash = info.getIdentity().getHash().toBase64();
        buf.append("<table class=\"netdbentry\">").append("<tr><th colspan=\"2\"><a name=\"").append(hash.substring(0, 6)).append("\" ></a>");
        if (isUs) {
            buf.append("<a name=\"our-info\" ></a><b>" + this._t("Our info") + ":</b>&nbsp;<code>").append(hash).append("</code></th><th>");
        } else {
            buf.append("<b>" + this._t("Peer info for") + ":</b>&nbsp;<code>").append(hash).append("</code></th><th>");
            String country = this._context.commSystem().getCountry(info.getIdentity().getHash());
            if (country != null) {
                buf.append("<a href=\"/netdb?c=").append(country).append("\">");
                buf.append("<img height=\"11\" width=\"16\" alt=\"").append(country.toUpperCase(Locale.US)).append('\"');
                buf.append(" title=\"").append(this.getTranslatedCountry(country)).append('\"');
                buf.append(" src=\"/flags.jsp?c=").append(country).append("\"> ").append("</a>");
            }
            if (!full) {
                buf.append("<a title=\"").append(this._t("View extended router info")).append("\" class=\"viewfullentry\" href=\"netdb?r=").append(hash.substring(0, 6)).append("\" >[").append(this._t("Full entry")).append("]</a>");
            }
        }
        buf.append("</th></tr>\n<tr>");
        long age = this._context.clock().now() - info.getPublished();
        if (isUs && this._context.router().isHidden()) {
            buf.append("<td><b>").append(this._t("Hidden")).append(", ").append(this._t("Updated")).append(":</b></td>").append("<td colspan=\"2\"><span class=\"netdb_info\">").append(this._t("{0} ago", DataHelper.formatDuration2(age))).append("</span>&nbsp;&nbsp;");
        } else if (age > 0L) {
            buf.append("<td><b>").append(this._t("Published")).append(":</b></td>").append("<td colspan=\"2\"><span class=\"netdb_info\">").append(this._t("{0} ago", DataHelper.formatDuration2(age))).append("</span>&nbsp;&nbsp;");
        } else {
            buf.append("<td><b>").append(this._t("Published")).append("</td><td colspan=\"2\">:</b> in ").append(DataHelper.formatDuration2(0L - age)).append("<span class=\"netdb_info\">???</span>&nbsp;&nbsp;");
        }
        buf.append("<b>").append(this._t("Signing Key")).append(":</b> ").append(info.getIdentity().getSigningPublicKey().getType().toString());
        buf.append("</td></tr>\n<tr>").append("<td><b>" + this._t("Address(es)") + ":</b></td>").append("<td colspan=\"2\" class=\"netdb_addresses\">");
        for (RouterAddress addr : info.getAddresses()) {
            String style = addr.getTransportStyle();
            buf.append("<br><b class=\"netdb_transport\">").append(DataHelper.stripHTML(style)).append(":</b>");
            int cost = addr.getCost();
            if (!(style.equals("SSU") && cost == 5 || style.equals("NTCP") && cost == 10)) {
                buf.append("&nbsp;<span class=\"netdb_name\">").append(this._t("cost")).append("</span>: <span class=\"netdb_info\">").append("" + cost).append("</span>&nbsp;");
            }
            Map<Object, Object> p = addr.getOptionsMap();
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                String name = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append(" <span class=\"nowrap\"><span class=\"netdb_name\">").append(this._t(DataHelper.stripHTML(name))).append(":</span> <span class=\"netdb_info\">").append(DataHelper.stripHTML(val)).append("</span></span>&nbsp;");
            }
        }
        buf.append("</td></tr>\n");
        if (full) {
            buf.append("<tr><td><b>" + this._t("Stats") + ":</b><td colspan=\"2\"><code>");
            Map<Object, Object> p = info.getOptionsMap();
            for (Map.Entry<Object, Object> e : p.entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append(DataHelper.stripHTML(key)).append(" = ").append(DataHelper.stripHTML(val)).append("<br>\n");
            }
            buf.append("</code></td></tr>\n");
        }
        buf.append("</table>\n");
    }

    private static int classifyTransports(RouterInfo info) {
        int rv = 0;
        for (RouterAddress addr : info.getAddresses()) {
            String host;
            String style = addr.getTransportStyle();
            if (style.equals("NTCP")) {
                rv |= 4;
            } else if (style.equals("SSU")) {
                rv = addr.getOption("iport0") != null ? (rv |= 2) : (rv |= 1);
            }
            if ((host = addr.getHost()) == null || !host.contains(":")) continue;
            rv |= 8;
        }
        return rv;
    }

    private String _t(String s) {
        return Messages.getString(s, this._context);
    }

    private static final String _x(String s) {
        return s;
    }

    private String _t(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    private class CountryComparator
    implements Comparator<String> {
        private static final long serialVersionUID = 1L;
        private final Collator coll;

        public CountryComparator() {
            this.coll = Collator.getInstance(new Locale(Messages.getLanguage(NetDbRenderer.this._context)));
        }

        @Override
        public int compare(String l, String r) {
            return this.coll.compare(NetDbRenderer.this.getTranslatedCountry(l), NetDbRenderer.this.getTranslatedCountry(r));
        }
    }

    private class LeaseSetComparator
    implements Comparator<LeaseSet> {
        private LeaseSetComparator() {
        }

        @Override
        public int compare(LeaseSet l, LeaseSet r) {
            Destination dl = l.getDestination();
            Destination dr = r.getDestination();
            boolean locall = NetDbRenderer.this._context.clientManager().isLocal(dl);
            boolean localr = NetDbRenderer.this._context.clientManager().isLocal(dr);
            if (locall && !localr) {
                return -1;
            }
            if (localr && !locall) {
                return 1;
            }
            return dl.calculateHash().toBase64().compareTo(dr.calculateHash().toBase64());
        }
    }

    private static class LeaseSetRoutingKeyComparator
    implements Comparator<LeaseSet>,
    Serializable {
        private final Hash _us;

        public LeaseSetRoutingKeyComparator(Hash us) {
            this._us = us;
        }

        @Override
        public int compare(LeaseSet l, LeaseSet r) {
            return HashDistance.getDistance(this._us, l.getRoutingKey()).compareTo(HashDistance.getDistance(this._us, r.getRoutingKey()));
        }
    }

    private static class RouterInfoComparator
    implements Comparator<RouterInfo>,
    Serializable {
        private RouterInfoComparator() {
        }

        @Override
        public int compare(RouterInfo l, RouterInfo r) {
            return l.getIdentity().getHash().toBase64().compareTo(r.getIdentity().getHash().toBase64());
        }
    }
}

