/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.NetDbRenderer;
import net.i2p.router.web.SybilRenderer;

public class NetDbHelper
extends HelperBase {
    private String _routerPrefix;
    private String _version;
    private String _country;
    private String _family;
    private String _caps;
    private String _ip;
    private String _sybil;
    private String _mtu;
    private String _ssucaps;
    private String _ipv6;
    private int _full;
    private int _port;
    private int _cost;
    private boolean _lease;
    private boolean _debug;
    private boolean _graphical;
    private SigType _type;
    private static final String[] titles = new String[]{NetDbHelper._x("Summary"), NetDbHelper._x("Local Router"), NetDbHelper._x("Router Lookup"), NetDbHelper._x("All Routers"), NetDbHelper._x("All Routers with Full Stats"), "LeaseSet Debug", NetDbHelper._x("LeaseSets"), "Sybil", "Advanced Lookup"};
    private static final String[] links = new String[]{"", "?r=.", "", "?f=2", "?f=1", "?l=2", "?l=1", "?f=3", "?f=4"};

    public void setRouter(String r) {
        if (r != null && r.length() > 0) {
            this._routerPrefix = DataHelper.stripHTML(r);
        }
    }

    public void setVersion(String v) {
        if (v != null && v.length() > 0) {
            this._version = DataHelper.stripHTML(v);
        }
    }

    public void setCountry(String c) {
        if (c != null && c.length() > 0) {
            this._country = DataHelper.stripHTML(c);
        }
    }

    public void setFamily(String c) {
        if (c != null && c.length() > 0) {
            this._family = DataHelper.stripHTML(c);
        }
    }

    public void setCaps(String c) {
        if (c != null && c.length() > 0) {
            this._caps = DataHelper.stripHTML(c);
        }
    }

    public void setIp(String c) {
        if (c != null && c.length() > 0) {
            this._ip = DataHelper.stripHTML(c);
        }
    }

    public void setSybil(String c) {
        if (c != null) {
            this._sybil = DataHelper.stripHTML(c);
        }
    }

    public void setSybil2(String c) {
        if (c != null && c.length() > 0) {
            this._sybil = DataHelper.stripHTML(c);
        }
    }

    public void setPort(String f) {
        try {
            this._port = Integer.parseInt(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setType(String f) {
        if (f != null && f.length() > 0) {
            this._type = SigType.parseSigType(f);
        }
    }

    public void setMtu(String f) {
        if (f != null && f.length() > 0) {
            this._mtu = DataHelper.stripHTML(f);
        }
    }

    public void setIpv6(String f) {
        if (f != null && f.length() > 0) {
            this._ipv6 = DataHelper.stripHTML(f);
            if (!this._ipv6.endsWith(":")) {
                this._ipv6 = this._ipv6 + ':';
            }
        }
    }

    public void setSsucaps(String f) {
        if (f != null && f.length() > 0) {
            this._ssucaps = DataHelper.stripHTML(f);
        }
    }

    public void setCost(String f) {
        try {
            this._cost = Integer.parseInt(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setFull(String f) {
        try {
            this._full = Integer.parseInt(f);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setLease(String l) {
        this._debug = "2".equals(l);
        this._lease = this._debug || "1".equals(l);
    }

    public void allowGraphical() {
        this._graphical = true;
    }

    public String getNetDbSummary() {
        NetDbRenderer renderer = new NetDbRenderer(this._context);
        try {
            this.renderNavBar();
            if (this._routerPrefix != null || this._version != null || this._country != null || this._family != null || this._caps != null || this._ip != null || this._sybil != null || this._port != 0 || this._type != null || this._mtu != null || this._ipv6 != null || this._ssucaps != null || this._cost != 0) {
                renderer.renderRouterInfoHTML(this._out, this._routerPrefix, this._version, this._country, this._family, this._caps, this._ip, this._sybil, this._port, this._type, this._mtu, this._ipv6, this._ssucaps, this._cost);
            } else if (this._lease) {
                renderer.renderLeaseSetHTML(this._out, this._debug);
            } else if (this._full == 3) {
                new SybilRenderer(this._context).getNetDbSummary(this._out);
            } else if (this._full == 4) {
                this.renderLookupForm();
            } else {
                renderer.renderStatusHTML(this._out, this._full);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return "";
    }

    private int getTab() {
        if (this._debug) {
            return 5;
        }
        if (this._lease) {
            return 6;
        }
        if (".".equals(this._routerPrefix)) {
            return 1;
        }
        if (this._routerPrefix != null || this._version != null || this._country != null || this._family != null || this._caps != null || this._ip != null || this._sybil != null || this._port != 0 || this._type != null || this._mtu != null || this._ipv6 != null || this._ssucaps != null || this._cost != 0) {
            return 2;
        }
        if (this._full == 2) {
            return 3;
        }
        if (this._full == 1) {
            return 4;
        }
        if (this._full == 3) {
            return 7;
        }
        if (this._full == 4) {
            return 8;
        }
        return 0;
    }

    private void renderNavBar() throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<div class=\"confignav\" id=\"confignav\">");
        boolean span = this._graphical;
        if (!span) {
            buf.append("<center>");
        }
        int tab = this.getTab();
        for (int i = 0; i < titles.length; ++i) {
            if (i == 2 && tab != 2 || (i == 5 || i == 7 || i == 8) && !this._context.getBooleanProperty("routerconsole.advanced")) continue;
            if (i == tab) {
                if (span) {
                    buf.append("<span class=\"tab2\">");
                }
                buf.append(this._t(titles[i]));
            } else {
                if (span) {
                    buf.append("<span class=\"tab\">");
                }
                buf.append("<a href=\"netdb").append(links[i]).append("\">").append(this._t(titles[i])).append("</a>");
            }
            if (span) {
                buf.append("</span>\n");
                continue;
            }
            if (i == titles.length - 1) continue;
            buf.append("&nbsp;&nbsp;\n");
        }
        if (!span) {
            buf.append("</center>");
        }
        buf.append("</div>\n");
        this._out.write(buf.toString());
    }

    private void renderLookupForm() throws IOException {
        this._out.write("<form action=\"/netdb\" method=\"GET\">\n<table id=\"netdblookup\"><tr><th colspan=\"3\">Network Database Search</th></tr>\n<tr><td colspan=\"3\" class=\"subheading\"><b>Select one search field <i>only</i>:</b></td></tr>\n<tr><td>Capabilities:</td><td><input type=\"text\" name=\"caps\"></td><td>e.g. f or XOfR</td></tr>\n<tr><td>Cost:</td><td><input type=\"text\" name=\"cost\"></td><td></td></tr>\n<tr><td>Country Code:</td><td><input type=\"text\" name=\"c\"></td><td>e.g. ru</td></tr>\n<tr><td>Router Family:</td><td><input type=\"text\" name=\"fam\"></td><td></td></tr>\n<tr><td>Hash Prefix:</td><td><input type=\"text\" name=\"r\"></td><td></td></tr>\n<tr><td>IP or Hostname:</td><td><input type=\"text\" name=\"ip\"></td><td>host name, IPv4, or IPv6, /24,/16,/8 suffixes optional for IPv4</td></tr>\n<tr><td>IPv6 Prefix:</td><td><input type=\"text\" name=\"ipv6\"></td><td></td></tr>\n<tr><td>MTU:</td><td><input type=\"text\" name=\"mtu\"></td><td></td></tr>\n<tr><td>Port Number:</td><td><input type=\"text\" name=\"port\"></td><td></td></tr>\n<tr><td>Signature Type:</td><td><input type=\"text\" name=\"type\"></td><td></td></tr>\n<tr><td>SSU Capabilities:</td><td><input type=\"text\" name=\"ssucaps\"></td><td></td></tr>\n<tr><td>Router Version:</td><td><input type=\"text\" name=\"v\"></td><td></td></tr>\n<tr><td colspan=\"3\" class=\"subheading\"><b>Add Sybil analysis (must pick one above):</b></td></tr>\n<tr><td>Sybil close to:</td><td><input type=\"text\" name=\"sybil2\"></td><td>Router hash, dest hash, b32, or from address book</td>\n<tr><td><label for=\"closetorouter\">or Sybil close to this router:</label></td><td><input type=\"checkbox\" class=\"optbox\" value=\"1\" name=\"sybil\" id=\"closetorouter\"></td><td></td></tr>\n<tr><td colspan=\"3\" class=\"optionsave\"><button type=\"submit\" class=\"search\" value=\"Lookup\">Lookup</button></td></tr>\n</table>\n</form>\n");
    }
}

