/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.router.web.ConsolePasswordManager;
import net.i2p.router.web.HelperBase;
import net.i2p.router.web.Messages;

public class ConfigUIHelper
extends HelperBase {
    static final String PROP_THEME_PFX = "routerconsole.theme.";
    private static final String[][] langs = new String[][]{{"en", "us", "English", null}, {"ar", "lang_ar", "Arabic \ufec9\ufeae\ufe92\ufef3\ufe93", null}, {"cs", "cz", "\u010ce\u0161tina", null}, {"zh", "cn", "Chinese \u4e2d\u6587", null}, {"zh_TW", "tw", "Chinese \u4e2d\u6587", "Taiwan"}, {"da", "dk", "Dansk", null}, {"de", "de", "Deutsch", null}, {"et", "ee", "Eesti", null}, {"es", "es", "Espa\u00f1ol", null}, {"fr", "fr", "Fran\u00e7ais", null}, {"gl", "lang_gl", "Galego", null}, {"el", "gr", "Greek \u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", null}, {"it", "it", "Italiano", null}, {"ja", "jp", "Japanese \u65e5\u672c\u8a9e", null}, {"ko", "kr", "Korean \ud55c\uad6d\uc5b4", null}, {"mg", "mg", "Malagasy", null}, {"hu", "hu", "Magyar", null}, {"nl", "nl", "Nederlands", null}, {"nb", "no", "Norsk (bokm\u00e5l)", null}, {"pl", "pl", "Polski", null}, {"pt", "pt", "Portugu\u00eas", null}, {"pt_BR", "br", "Portugu\u00eas", "Brazil"}, {"ro", "ro", "Rom\u00e2n\u0103", null}, {"ru", "ru", "Russian \u0420\u0443\u0441\u0441\u043a\u0438\u0439", null}, {"sk", "sk", "Sloven\u010dina", null}, {"fi", "fi", "Suomi", null}, {"sv", "se", "Svenska", null}, {"tr", "tr", "T\u00fcrk\u00e7e", null}, {"uk", "ua", "Ukraine \u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430", null}, {"vi", "vn", "Vietnam Ti\u1ebfng Vi\u1ec7t", null}, {"xx", "a1", "Untagged strings", null}};

    public String getSettings() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("<div id=\"availablethemes\">");
        String current = this._context.getProperty("routerconsole.theme", "light");
        Set<String> themes = this.themeSet();
        for (String theme : themes) {
            buf.append("<div class=\"themechoice\">").append("<input type=\"radio\" class=\"optbox\" name=\"theme\" ");
            if (theme.equals(current)) {
                buf.append(" checked=\"checked\" ");
            }
            buf.append("value=\"").append(theme).append("\">").append("<object height=\"48\" width=\"48\" data=\"/themes/console/").append(theme).append("/images/thumbnail.png\">").append("<img height=\"48\" width=\"48\" alt=\"\" src=\"/themes/console/images/thumbnail.png\">").append("</object><br>").append("<div class=\"themelabel\">").append(this._t(theme)).append("</div>").append("</div>\n");
        }
        boolean universalTheming = this._context.getBooleanProperty("routerconsole.universal.theme");
        buf.append("</div><div id=\"themeoptions\">");
        buf.append("<label><input type=\"checkbox\" name=\"universalTheming\" ");
        if (universalTheming) {
            buf.append(" checked=\"checked\" ");
        }
        buf.append("value=\"1\">").append(this._t("Set theme universally across all apps")).append("</label><br>\n");
        return buf.toString();
    }

    public String getForceMobileConsole() {
        StringBuilder buf = new StringBuilder(256);
        boolean forceMobileConsole = this._context.getBooleanProperty("routerconsole.forceMobileConsole");
        buf.append("<label><input type=\"checkbox\" name=\"forceMobileConsole\" ");
        if (forceMobileConsole) {
            buf.append(" checked=\"checked\" ");
        }
        buf.append("value=\"1\">").append(this._t("Force the mobile console to be used")).append("</label></div>\n");
        return buf.toString();
    }

    private Set<String> themeSet() {
        TreeSet<String> rv = new TreeSet<String>();
        rv.add("light");
        File dir = new File(this._context.getBaseDir(), "docs/themes/console");
        File[] files = dir.listFiles();
        if (files == null) {
            return rv;
        }
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            if (!files[i].isDirectory() || name.equals("images")) continue;
            rv.add(name);
        }
        Set<String> props = this._context.getPropertyNames();
        for (String prop : props) {
            if (!prop.startsWith(PROP_THEME_PFX) || prop.length() <= PROP_THEME_PFX.length()) continue;
            rv.add(prop.substring(PROP_THEME_PFX.length()));
        }
        return rv;
    }

    public String getLangSettings() {
        int i;
        String clang;
        String current = clang = Messages.getLanguage(this._context);
        String country = Messages.getCountry(this._context);
        if (country != null && country.length() > 0) {
            current = current + '_' + country;
        }
        boolean found = false;
        for (i = 0; i < langs.length; ++i) {
            if (!langs[i][0].equals(current)) continue;
            found = true;
            break;
        }
        if (!found) {
            if (country != null && country.length() > 0) {
                current = clang;
                for (i = 0; i < langs.length; ++i) {
                    if (!langs[i][0].equals(current)) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                current = "en";
            }
        }
        StringBuilder buf = new StringBuilder(512);
        for (int i2 = 0; i2 < langs.length; ++i2) {
            String lang = langs[i2][0];
            if (lang.equals("xx") && !this.isAdvanced()) continue;
            buf.append("<div class=\"langselect\"><input type=\"radio\" class=\"optbox\" name=\"lang\" ");
            if (lang.equals(current)) {
                buf.append(" checked=\"checked\" ");
            }
            buf.append("value=\"").append(lang).append("\">").append("<img height=\"11\" width=\"16\" alt=\"\" src=\"/flags.jsp?c=").append(langs[i2][1]).append("\">").append("<div class=\"ui_lang\">");
            int under = lang.indexOf(95);
            String slang = under > 0 ? lang.substring(0, under) : lang;
            buf.append(langs[i2][2]);
            String name = langs[i2][3];
            if (name != null) {
                buf.append(" (").append(name).append(')');
            }
            buf.append("</div></div>\n");
        }
        return buf.toString();
    }

    public String getPasswordForm() {
        StringBuilder buf = new StringBuilder(512);
        ConsolePasswordManager mgr = new ConsolePasswordManager(this._context);
        Map<String, String> userpw = mgr.getMD5("routerconsole.auth.i2prouter");
        buf.append("<table id=\"consolepass\">");
        if (userpw.isEmpty()) {
            buf.append("<tr><td colspan=\"3\">");
            buf.append(this._t("Add a user and password to enable."));
            buf.append("</td></tr>");
        } else {
            buf.append("<tr><th title=\"").append(this._t("Mark for deletion")).append("\">").append(this._t("Remove")).append("</th><th>").append(this._t("Username")).append("</th><th>&nbsp;</th></tr>\n");
            for (String name : userpw.keySet()) {
                buf.append("<tr><td align=\"center\"><input type=\"checkbox\" class=\"optbox\" id=\"").append(name).append("\" name=\"delete_").append(name).append("\"></td><td colspan=\"2\"><label for=\"").append(name).append("\">").append(name).append("</label></td></tr>\n");
            }
        }
        buf.append("<tr><td id=\"pw_adduser\" align=\"left\" colspan=\"3\">").append("<b>").append(this._t("Username")).append(":</b> ").append("<input type=\"text\" name=\"name\">").append("<b>").append(this._t("Password")).append(":</b> ").append("<input type=\"password\" size=\"40\" name=\"nofilter_pw\">").append("</td></tr>").append("</table>\n");
        return buf.toString();
    }
}

