/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.HashMap;
import net.i2p.data.DataHelper;
import net.i2p.router.web.ConsolePasswordManager;
import net.i2p.router.web.FormHandler;

public class ConfigUIHandler
extends FormHandler {
    private boolean _shouldSave;
    private boolean _universalTheming;
    private boolean _forceMobileConsole;
    private String _config;

    @Override
    protected void processForm() {
        if (this._shouldSave) {
            this.saveChanges();
        } else if (this._action.equals(this._t("Delete selected"))) {
            this.delUser();
        } else if (this._action.equals(this._t("Add user"))) {
            this.addUser();
        }
    }

    public void setShouldsave(String moo) {
        this._shouldSave = true;
    }

    public void setUniversalTheming(String baa) {
        this._universalTheming = true;
    }

    public void setForceMobileConsole(String baa) {
        this._forceMobileConsole = true;
    }

    public void setTheme(String val) {
        this._config = val;
    }

    private void saveChanges() {
        if (this._config == null || this._config.length() <= 0) {
            return;
        }
        if (this._config.replaceAll("[a-zA-Z0-9_-]", "").length() != 0) {
            this.addFormError("Bad theme name");
            return;
        }
        HashMap<String, String> changes = new HashMap<String, String>();
        ArrayList<String> removes = new ArrayList<String>();
        String oldTheme = this._context.getProperty("routerconsole.theme", "light");
        boolean oldForceMobileConsole = this._context.getBooleanProperty("routerconsole.forceMobileConsole");
        if (this._config.equals("default")) {
            removes.add("routerconsole.theme");
        } else {
            changes.put("routerconsole.theme", this._config);
        }
        if (this._universalTheming) {
            changes.put("routerconsole.universal.theme", "true");
        } else {
            removes.add("routerconsole.universal.theme");
        }
        if (this._forceMobileConsole) {
            changes.put("routerconsole.forceMobileConsole", "true");
        } else {
            removes.add("routerconsole.forceMobileConsole");
        }
        boolean ok = this._context.router().saveConfig(changes, removes);
        if (ok) {
            if (!oldTheme.equals(this._config)) {
                this.addFormNoticeNoEscape(this._t("Theme change saved.") + " <a href=\"configui\">" + this._t("Refresh the page to view.") + "</a>");
            }
            if (oldForceMobileConsole != this._forceMobileConsole) {
                this.addFormNoticeNoEscape(this._t("Mobile console option saved.") + " <a href=\"configui\">" + this._t("Refresh the page to view.") + "</a>");
            }
        } else {
            this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs."));
        }
    }

    private void addUser() {
        String pw;
        byte[] b2;
        String name = this.getJettyString("name");
        if (name == null || name.length() <= 0) {
            this.addFormError(this._t("No user name entered"));
            return;
        }
        if (name.contains("=")) {
            this.addFormError("User name may not contain '='");
            return;
        }
        byte[] b1 = DataHelper.getUTF8(name);
        if (!DataHelper.eq(b1, b2 = DataHelper.getASCII(name))) {
            this.addFormError(this._t("Warning: User names outside the ISO-8859-1 character set are not recommended. Support is not standardized and varies by browser."));
        }
        if ((pw = this.getJettyString("nofilter_pw")) == null || pw.length() <= 0) {
            this.addFormError(this._t("No password entered"));
            return;
        }
        ConsolePasswordManager mgr = new ConsolePasswordManager(this._context);
        if (mgr.saveMD5("routerconsole.auth.i2prouter", "i2prouter", name, pw)) {
            if (!this._context.getBooleanProperty("routerconsole.auth.enable")) {
                this._context.router().saveConfig("routerconsole.auth.enable", "true");
            }
            this.addFormNotice(this._t("Added user {0}", name));
            this.addFormNotice(this._t("To recover from a forgotten or non-working password, stop I2P, edit the file {0}, delete the line {1}, and restart I2P.", this._context.router().getConfigFilename(), "routerconsole.auth.enable=true"));
            this.addFormError(this._t("Restart required to take effect"));
        } else {
            this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs."));
        }
    }

    private void delUser() {
        ConsolePasswordManager mgr = new ConsolePasswordManager(this._context);
        boolean success = false;
        for (Object o : this._settings.keySet()) {
            String k;
            if (!(o instanceof String) || !(k = (String)o).startsWith("delete_")) continue;
            if (mgr.remove("routerconsole.auth.i2prouter", k = k.substring(7))) {
                this.addFormNotice(this._t("Removed user {0}", k));
                success = true;
                continue;
            }
            this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs."));
        }
        if (success) {
            this.addFormError(this._t("Restart required to take effect"));
        }
    }
}

