/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppState;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.web.ConfigClientsHelper;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.ConsolePasswordManager;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.Messages;
import net.i2p.router.web.NewsHelper;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.UpdateHandler;
import net.i2p.router.web.WebAppStarter;
import net.i2p.update.UpdateType;
import net.i2p.util.SecureFileOutputStream;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;

public class ConfigClientsHandler
extends FormHandler {
    @Override
    protected void processForm() {
        if (this._action.length() <= 0) {
            String url = this.getJettyString("pluginURL");
            this._action = url != null && url.length() > 0 ? "Install Plugin" : "Save Client Configuration";
        }
        if (this._action.equals(this._t("Save Client Configuration"))) {
            this.saveClientChanges();
            return;
        }
        if (this._action.equals(this._t("Save Interface Configuration"))) {
            this.saveInterfaceChanges();
            return;
        }
        if (this._action.equals(this._t("Save WebApp Configuration"))) {
            this.saveWebAppChanges();
            return;
        }
        boolean pluginsEnabled = PluginStarter.pluginsEnabled(this._context);
        if (this._action.equals(this._t("Save Plugin Configuration"))) {
            if (pluginsEnabled) {
                this.savePluginChanges();
            } else {
                this.addFormError("Plugins disabled");
            }
            return;
        }
        if (this._action.equals(this._t("Install Plugin"))) {
            if (pluginsEnabled && (this._context.getBooleanPropertyDefaultTrue("routerconsole.enablePluginInstall") || this.isAdvanced())) {
                this.installPlugin();
            } else {
                this.addFormError("Plugins disabled");
            }
            return;
        }
        if (this._action.equals(this._t("Install Plugin from File"))) {
            if (pluginsEnabled && (this._context.getBooleanPropertyDefaultTrue("routerconsole.enablePluginInstall") || this.isAdvanced())) {
                this.installPluginFromFile();
            } else {
                this.addFormError("Plugins disabled");
            }
            return;
        }
        if (this._action.equals(this._t("Update All Installed Plugins"))) {
            if (pluginsEnabled) {
                this.updateAllPlugins();
            } else {
                this.addFormError("Plugins disabled");
            }
            return;
        }
        if (this._action.startsWith("Start ")) {
            String app = this._action.substring(6);
            int appnum = -1;
            try {
                appnum = Integer.parseInt(app);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (appnum >= 0) {
                this.startClient(appnum);
            } else {
                List<String> plugins = PluginStarter.getPlugins();
                if (plugins.contains(app)) {
                    if (pluginsEnabled) {
                        this.startPlugin(app);
                    } else {
                        this.addFormError("Plugins disabled");
                    }
                } else {
                    this.startWebApp(app);
                }
            }
            return;
        }
        if (this._action.startsWith("Delete ")) {
            String app = this._action.substring(7);
            int appnum = -1;
            try {
                appnum = Integer.parseInt(app);
            }
            catch (NumberFormatException plugins) {
                // empty catch block
            }
            if (appnum >= 0) {
                if (this._context.getBooleanProperty("routerconsole.enableClientChange") || this.isAdvanced()) {
                    this.deleteClient(appnum);
                } else {
                    this.addFormError("Delete client disabled");
                }
            } else if (pluginsEnabled) {
                try {
                    PluginStarter.stopPlugin(this._context, app);
                }
                catch (ClassNotFoundException plugins) {
                }
                catch (Throwable e) {
                    this.addFormError(this._t("Error stopping plugin {0}", app) + ": " + e);
                    this._log.error("Error stopping plugin " + app, e);
                }
                try {
                    PluginStarter.deletePlugin(this._context, app);
                    this.addFormNotice(this._t("Deleted plugin {0}", app));
                }
                catch (Throwable e) {
                    this.addFormError(this._t("Error deleting plugin {0}", app) + ": " + e);
                    this._log.error("Error deleting plugin " + app, e);
                }
            } else {
                this.addFormError("Plugins disabled");
            }
            return;
        }
        if (this._action.startsWith("Stop ")) {
            block64: {
                String app = this._action.substring(5);
                int appnum = -1;
                try {
                    appnum = Integer.parseInt(app);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (appnum >= 0) {
                    this.stopClient(appnum);
                } else {
                    List<String> plugins = PluginStarter.getPlugins();
                    if (plugins.contains(app)) {
                        try {
                            if (pluginsEnabled) {
                                PluginStarter.stopPlugin(this._context, app);
                                this.addFormNotice(this._t("Stopped plugin {0}", app));
                                break block64;
                            }
                            this.addFormError("Plugins disabled");
                        }
                        catch (Throwable e) {
                            this.addFormError(this._t("Error stopping plugin {0}", app) + ": " + e);
                            this._log.error("Error stopping plugin " + app, e);
                        }
                    } else {
                        WebAppStarter.stopWebApp(app);
                        this.addFormNotice(this._t("Stopped webapp {0}", app));
                    }
                }
            }
            return;
        }
        if (this._action.startsWith("Update ")) {
            if (pluginsEnabled) {
                String app = this._action.substring(7);
                this.updatePlugin(app);
            } else {
                this.addFormError("Plugins disabled");
            }
            return;
        }
        if (this._action.startsWith("Check ")) {
            if (pluginsEnabled) {
                String app = this._action.substring(6);
                this.checkPlugin(app);
            } else {
                this.addFormError("Plugins disabled");
            }
            return;
        }
        String xStart = this._t("Start");
        if (this._action.toLowerCase(Locale.US).startsWith(xStart + "<span class=hide> ") && this._action.toLowerCase(Locale.US).endsWith("</span>")) {
            String app = this._action.substring(xStart.length() + 18, this._action.length() - 7);
            int appnum = -1;
            try {
                appnum = Integer.parseInt(app);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (appnum >= 0) {
                this.startClient(appnum);
            } else {
                List<String> plugins = PluginStarter.getPlugins();
                if (plugins.contains(app)) {
                    if (pluginsEnabled) {
                        this.startPlugin(app);
                    } else {
                        this.addFormError("Plugins disabled");
                    }
                } else {
                    this.startWebApp(app);
                }
            }
        }
    }

    private void saveClientChanges() {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        for (int cur = 0; cur < clients.size(); ++cur) {
            String desc;
            ClientAppConfig ca = clients.get(cur);
            Object val = this._settings.get(cur + ".enabled");
            if (!RouterConsoleRunner.class.getName().equals(ca.className)) {
                boolean bl = ca.disabled = val == null;
            }
            if (!this._context.getBooleanProperty("routerconsole.enableClientChange") && !this.isAdvanced() || (desc = this.getJettyString("nofilter_desc" + cur)) == null) continue;
            int spc = desc.indexOf(32);
            String clss = desc;
            String args = null;
            if (spc >= 0) {
                clss = desc.substring(0, spc);
                args = desc.substring(spc + 1);
            }
            ca.className = clss;
            ca.args = args;
            ca.clientName = this.getJettyString("nofilter_name" + cur);
        }
        if (this._context.getBooleanProperty("routerconsole.enableClientChange") || this.isAdvanced()) {
            int newClient = clients.size();
            String newDesc = this.getJettyString("nofilter_desc" + newClient);
            if (newDesc != null && newDesc.trim().length() > 0) {
                String name;
                int spc = newDesc.indexOf(32);
                String clss = newDesc;
                String args = null;
                if (spc >= 0) {
                    clss = newDesc.substring(0, spc);
                    args = newDesc.substring(spc + 1);
                }
                if ((name = this.getJettyString("nofilter_name" + newClient)) == null || name.trim().length() <= 0) {
                    name = "new client";
                }
                ClientAppConfig ca = new ClientAppConfig(clss, name, args, 120000L, this._settings.get(newClient + ".enabled") == null);
                clients.add(ca);
                this.addFormNotice(this._t("New client added") + ": " + name + " (" + clss + ").");
            }
        }
        ClientAppConfig.writeClientAppConfig(this._context, clients);
        this.addFormNotice(this._t("Client configuration saved successfully"));
    }

    private void stopClient(int i) {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        if (i >= clients.size()) {
            this.addFormError(this._t("Bad client index."));
            return;
        }
        ClientAppConfig ca = clients.get(i);
        ClientApp clientApp = this._context.routerAppManager().getClientApp(ca.className, LoadClientAppsJob.parseArgs(ca.args));
        if (clientApp != null && clientApp.getState() == ClientAppState.RUNNING) {
            try {
                clientApp.shutdown(null);
                this.addFormNotice(this._t("Client {0} stopped", ca.clientName));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Throwable t) {
                this.addFormError("Cannot stop client " + ca.className + ": " + t);
                this._log.error("Error stopping client " + ca.className, t);
            }
        } else {
            this.addFormError("Cannot stop client " + i + ": " + ca.className);
        }
    }

    private void startClient(int i) {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        if (i >= clients.size()) {
            this.addFormError(this._t("Bad client index."));
            return;
        }
        ClientAppConfig ca = clients.get(i);
        LoadClientAppsJob.runClient(ca.className, ca.clientName, LoadClientAppsJob.parseArgs(ca.args), this._context, this._log);
        this.addFormNotice(this._t("Client {0} started", ca.clientName));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void deleteClient(int i) {
        List<ClientAppConfig> clients = ClientAppConfig.getClientApps(this._context);
        if (i < 0 || i >= clients.size()) {
            this.addFormError(this._t("Bad client index."));
            return;
        }
        ClientAppConfig ca = clients.remove(i);
        ClientAppConfig.writeClientAppConfig(this._context, clients);
        this.addFormNotice(this._t("Client {0} deleted", ca.clientName));
    }

    private void saveWebAppChanges() {
        Properties props = RouterConsoleRunner.webAppProperties(this._context);
        Set<String> keys = props.stringPropertyNames();
        for (String name : keys) {
            if (!name.startsWith("webapps.") || !name.endsWith(".startOnLoad")) continue;
            String app = name.substring("webapps.".length(), name.lastIndexOf(".startOnLoad"));
            Object val = this._settings.get(app + ".enabled");
            if ("routerconsole".equals(app)) continue;
            props.setProperty(name, "" + (val != null));
        }
        RouterConsoleRunner.storeWebAppProperties(this._context, props);
        this.addFormNotice(this._t("WebApp configuration saved."));
    }

    private void savePluginChanges() {
        Properties props = PluginStarter.pluginProperties();
        Set<String> keys = props.stringPropertyNames();
        for (String name : keys) {
            if (!name.startsWith("plugin.") || !name.endsWith(".startOnLoad")) continue;
            String app = name.substring("plugin.".length(), name.lastIndexOf(".startOnLoad"));
            Object val = this._settings.get(app + ".enabled");
            props.setProperty(name, "" + (val != null));
        }
        PluginStarter.storePluginProperties(props);
        this.addFormNotice(this._t("Plugin configuration saved."));
    }

    private void startWebApp(String app) {
        ContextHandlerCollection s = WebAppStarter.getConsoleServer();
        if (s != null) {
            try {
                File path = new File(this._context.getBaseDir(), "webapps");
                path = new File(path, app + ".war");
                WebAppStarter.startWebApp(this._context, s, app, path.getAbsolutePath());
                this.addFormNoticeNoEscape(this._t("WebApp") + " <a href=\"/" + app + "/\">" + this._t(app) + "</a> " + this._t("started") + '.');
            }
            catch (Throwable e) {
                this.addFormError(this._t("Failed to start") + ' ' + this._t(app) + ": " + e);
                this._log.error("Failed to start webapp " + app, e);
            }
            return;
        }
        this.addFormError(this._t("Failed to find server."));
    }

    private void installPlugin() {
        String url = this.getJettyString("pluginURL");
        if (url == null || url.length() <= 0) {
            this.addFormError(this._t("No plugin URL specified."));
            return;
        }
        this.installPlugin(null, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void installPluginFromFile() {
        InputStream in = this._requestWrapper.getInputStream("pluginFile");
        byte[] su3Magic = DataHelper.getASCII("I2Psu3");
        byte[] zipMagic = new byte[]{80, 75, 3, 4};
        byte[] magic = new byte[TrustedUpdate.HEADER_BYTES + zipMagic.length];
        File tmp = null;
        OutputStream out = null;
        try {
            String status;
            if (in == null || in.available() <= 0) {
                this.addFormError(this._t("You must enter a file"));
                return;
            }
            DataHelper.read(in, magic);
            boolean isSU3 = DataHelper.eq(magic, 0, su3Magic, 0, su3Magic.length);
            if (!isSU3 && !DataHelper.eq(magic, TrustedUpdate.HEADER_BYTES, zipMagic, 0, zipMagic.length)) {
                String name = this._requestWrapper.getFilename("pluginFile");
                if (name != null) throw new IOException(name + " is not an xpi2p or su3 plugin");
                name = "File";
                throw new IOException(name + " is not an xpi2p or su3 plugin");
            }
            tmp = new File(this._context.getTempDir(), "plugin-" + this._context.random().nextInt() + (isSU3 ? ".su3" : ".xpi2p"));
            out = new BufferedOutputStream(new SecureFileOutputStream(tmp));
            out.write(magic);
            DataHelper.copy(in, out);
            out.close();
            String url = tmp.toURI().toString();
            this.installPlugin(null, url);
            ConsoleUpdateManager mgr = UpdateHandler.updateManager(this._context);
            if (mgr == null) {
                return;
            }
            for (int i = 0; i < 20; ++i) {
                if (!mgr.isUpdateInProgress(UpdateType.PLUGIN)) {
                    tmp.delete();
                    break;
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if ((status = mgr.getStatus()) == null) return;
            if (status.length() <= 0) return;
            this.addFormNoticeNoEscape(status);
            return;
        }
        catch (IOException ioe) {
            this.addFormError(this._t("Install from file failed") + " - " + ioe.getMessage());
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void updatePlugin(String app) {
        Properties props = PluginStarter.pluginProperties(this._context, app);
        String url = props.getProperty("updateURL.su3");
        if (url == null) {
            url = props.getProperty("updateURL");
        }
        if (url == null) {
            this.addFormError(this._t("No update URL specified for {0}", app));
            return;
        }
        this.installPlugin(app, url);
    }

    private void updateAllPlugins() {
        if (NewsHelper.isAnyUpdateInProgress()) {
            this.addFormError(this._t("Plugin or update download already in progress."));
            return;
        }
        if (!this.verifyProxy()) {
            return;
        }
        this.addFormNotice(this._t("Updating all plugins"));
        PluginStarter.updateAll(this._context);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void installPlugin(String app, String url) {
        URI uri;
        ConsoleUpdateManager mgr = UpdateHandler.updateManager(this._context);
        if (mgr == null) {
            this.addFormError("Update manager not registered, cannot install");
            return;
        }
        if (mgr.isUpdateInProgress()) {
            this.addFormError(this._t("Plugin or update download already in progress."));
            return;
        }
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException use) {
            this.addFormError(this._t("Bad URL {0}", url));
            return;
        }
        if (!url.startsWith("file:") && !this.verifyProxy()) {
            return;
        }
        if (mgr.installPlugin(app, uri)) {
            if (url.startsWith("file:")) {
                this.addFormNotice(this._t("Installing plugin from {0}", uri.getPath()));
            } else {
                this.addFormNotice(this._t("Downloading plugin from {0}", url));
            }
        } else {
            this.addFormError("Cannot install, check logs");
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void checkPlugin(String app) {
        ConsoleUpdateManager mgr = UpdateHandler.updateManager(this._context);
        if (mgr == null) {
            this.addFormError("Update manager not registered, cannot check");
            return;
        }
        if (!this.verifyProxy()) {
            return;
        }
        mgr.check(UpdateType.PLUGIN, app);
        this.addFormNotice(this._t("Checking plugin {0} for updates", app));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean verifyProxy() {
        boolean rv;
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = ConfigUpdateHandler.proxyPort(this._context);
        boolean bl = rv = proxyPort != 4444 || !proxyHost.equals("127.0.0.1") || this._context.portMapper().getPort("HTTP") >= 0;
        if (!rv) {
            this.addFormError(this._t("HTTP client proxy tunnel must be running"));
        }
        return rv;
    }

    private void startPlugin(String app) {
        try {
            PluginStarter.startPlugin(this._context, app);
            Properties props = PluginStarter.pluginProperties(this._context, app);
            String name = ConfigClientsHelper.stripHTML(props, "consoleLinkName_" + Messages.getLanguage(this._context));
            if (name == null) {
                name = ConfigClientsHelper.stripHTML(props, "consoleLinkName");
            }
            String url = ConfigClientsHelper.stripHTML(props, "consoleLinkURL");
            if (name != null && url != null && name.length() > 0 && url.length() > 0) {
                app = "<a href=\"" + url + "\">" + name + "</a>";
                this.addFormNoticeNoEscape(this._t("Started plugin {0}", app));
            } else {
                this.addFormNotice(this._t("Started plugin {0}", app));
            }
        }
        catch (Throwable e) {
            this.addFormError(this._t("Error starting plugin {0}", app) + ": " + e);
            this._log.error("Error starting plugin " + app, e);
        }
    }

    private void saveInterfaceChanges() {
        String intfc;
        HashMap<String, String> changes = new HashMap<String, String>();
        String port = this.getJettyString("port");
        if (port != null) {
            changes.put("i2cp.port", port);
        }
        if ((intfc = this.getJettyString("interface")) != null) {
            changes.put("i2cp.hostname", intfc);
        }
        String user = this.getJettyString("user");
        String pw = this.getJettyString("nofilter_pw");
        if (user != null && pw != null && user.length() > 0 && pw.length() > 0) {
            ConsolePasswordManager mgr = new ConsolePasswordManager(this._context);
            mgr.saveHash("i2cp.auth", user, pw);
            this.addFormNotice(this._t("Added user {0}", user));
        }
        String mode = this.getJettyString("mode");
        boolean disabled = "0".equals(mode);
        boolean ssl = "2".equals(mode);
        changes.put("i2cp.disableInterface", Boolean.toString(disabled));
        changes.put("i2cp.SSL", Boolean.toString(ssl));
        changes.put("i2cp.auth", Boolean.toString(this._settings.get("auth") != null));
        boolean all = "0.0.0.0".equals(intfc) || "0:0:0:0:0:0:0:0".equals(intfc) || "::".equals(intfc);
        changes.put("i2cp.tcp.bindAllInterfaces", Boolean.toString(all));
        if (this._context.router().saveConfig(changes, null)) {
            this.addFormNotice(this._t("Interface configuration saved"));
            this.addFormNotice(this._t("Restart required to take effect"));
        } else {
            this.addFormError(this._t("Error saving the configuration (applied but not saved) - please see the error logs"));
        }
    }
}

