/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.Banlist;
import net.i2p.router.RouterContext;
import net.i2p.router.web.Messages;

class BanlistRenderer {
    private final RouterContext _context;

    public BanlistRenderer(RouterContext context) {
        this._context = context;
    }

    public void renderStatusHTML(Writer out) throws IOException {
        StringBuilder buf = new StringBuilder(1024);
        TreeMap<Hash, Banlist.Entry> entries = new TreeMap<Hash, Banlist.Entry>(new HashComparator());
        entries.putAll(this._context.banlist().getEntries());
        if (entries.isEmpty()) {
            buf.append("<i>").append(this._t("none")).append("</i>");
            out.write(buf.toString());
            return;
        }
        buf.append("<ul id=\"banlist\">");
        for (Map.Entry e : entries.entrySet()) {
            Hash key = (Hash)e.getKey();
            Banlist.Entry entry = (Banlist.Entry)e.getValue();
            long expires = entry.expireOn - this._context.clock().now();
            if (expires <= 0L) continue;
            buf.append("<li>").append(this._context.commSystem().renderPeerHTML(key));
            buf.append(' ');
            String expireString = DataHelper.formatDuration2(expires);
            if (key.equals(Hash.FAKE_HASH)) {
                buf.append(this._t("Permanently banned"));
            } else if (expires < 432000000L) {
                buf.append(this._t("Temporary ban expiring in {0}", expireString));
            } else {
                buf.append(this._t("Banned until restart or in {0}", expireString));
            }
            Set<String> transports = entry.transports;
            if (transports != null && !transports.isEmpty()) {
                buf.append(" on the following transport: ").append(transports);
            }
            if (entry.cause != null) {
                buf.append("<br>\n");
                if (entry.causeCode != null) {
                    buf.append(this._t(entry.cause, entry.causeCode));
                } else {
                    buf.append(this._t(entry.cause));
                }
            }
            if (!key.equals(Hash.FAKE_HASH)) {
                buf.append(" <a href=\"configpeer?peer=").append(key.toBase64()).append("#unsh\">[").append(this._t("unban now")).append("]</a>");
            }
            buf.append("</li>\n");
        }
        buf.append("</ul>\n");
        out.write(buf.toString());
        out.flush();
    }

    private String _t(String s) {
        return Messages.getString(s, this._context);
    }

    private String _t(String s, Object o) {
        return Messages.getString(s, o, this._context);
    }

    private static class HashComparator
    implements Comparator<Hash>,
    Serializable {
        private HashComparator() {
        }

        @Override
        public int compare(Hash l, Hash r) {
            return DataHelper.compareTo(l.getData(), r.getData());
        }
    }
}

