/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.addressbook;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.i2p.addressbook.HostTxtParser;
import net.i2p.client.naming.HostTxtEntry;

class HostTxtIterator
implements Iterator<Map.Entry<String, HostTxtEntry>>,
Closeable {
    private BufferedReader input;
    private MapEntry next;

    public HostTxtIterator() {
    }

    public HostTxtIterator(File file) throws IOException {
        FileInputStream fileStream = new FileInputStream(file);
        this.input = new BufferedReader(new InputStreamReader((InputStream)fileStream, "UTF-8"));
    }

    @Override
    public boolean hasNext() {
        if (this.input == null) {
            return false;
        }
        if (this.next != null) {
            return true;
        }
        try {
            String inputLine;
            while ((inputLine = this.input.readLine()) != null) {
                HostTxtEntry he = HostTxtParser.parse(inputLine, true);
                if (he == null) continue;
                this.next = new MapEntry(he.getName(), he);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.input = null;
        this.next = null;
        return false;
    }

    @Override
    public Map.Entry<String, HostTxtEntry> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        MapEntry rv = this.next;
        this.next = null;
        return rv;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    private static class MapEntry
    implements Map.Entry<String, HostTxtEntry> {
        private final String key;
        private final HostTxtEntry value;

        public MapEntry(String k, HostTxtEntry v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public HostTxtEntry getValue() {
            return this.value;
        }

        @Override
        public HostTxtEntry setValue(HostTxtEntry v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
        }
    }
}

