/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.io.Serializable;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.StringCache;

public final class CharChunk
implements Cloneable,
Serializable,
CharSequence {
    private static final long serialVersionUID = 1L;
    private int hashCode = 0;
    private boolean hasHashCode = false;
    private char[] buff;
    private int start;
    private int end;
    private boolean isSet = false;
    private int limit = -1;
    private CharInputChannel in = null;
    private CharOutputChannel out = null;
    private boolean optimizedWrite = true;

    public CharChunk() {
    }

    public CharChunk(int size) {
        this.allocate(size, -1);
    }

    public boolean isNull() {
        if (this.end > 0) {
            return false;
        }
        return !this.isSet;
    }

    public void recycle() {
        this.isSet = false;
        this.hasHashCode = false;
        this.start = 0;
        this.end = 0;
    }

    public void allocate(int initial, int limit) {
        if (this.buff == null || this.buff.length < initial) {
            this.buff = new char[initial];
        }
        this.limit = limit;
        this.start = 0;
        this.end = 0;
        this.isSet = true;
        this.hasHashCode = false;
    }

    public void setOptimizedWrite(boolean optimizedWrite) {
        this.optimizedWrite = optimizedWrite;
    }

    public void setChars(char[] c, int off, int len) {
        this.buff = c;
        this.start = off;
        this.end = this.start + len;
        this.isSet = true;
        this.hasHashCode = false;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setCharInputChannel(CharInputChannel in) {
        this.in = in;
    }

    public void setCharOutputChannel(CharOutputChannel out) {
        this.out = out;
    }

    public char[] getChars() {
        return this.getBuffer();
    }

    public char[] getBuffer() {
        return this.buff;
    }

    public int getStart() {
        return this.start;
    }

    public int getOffset() {
        return this.start;
    }

    public void setOffset(int off) {
        this.start = off;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int i) {
        this.end = i;
    }

    public void append(char b) throws IOException {
        this.makeSpace(1);
        if (this.limit > 0 && this.end >= this.limit) {
            this.flushBuffer();
        }
        this.buff[this.end++] = b;
    }

    public void append(CharChunk src) throws IOException {
        this.append(src.getBuffer(), src.getOffset(), src.getLength());
    }

    public void append(char[] src, int off, int len) throws IOException {
        this.makeSpace(len);
        if (this.limit < 0) {
            System.arraycopy(src, off, this.buff, this.end, len);
            this.end += len;
            return;
        }
        if (this.optimizedWrite && len == this.limit && this.end == this.start && this.out != null) {
            this.out.realWriteChars(src, off, len);
            return;
        }
        if (len <= this.limit - this.end) {
            System.arraycopy(src, off, this.buff, this.end, len);
            this.end += len;
            return;
        }
        if (len + this.end < 2 * this.limit) {
            int avail = this.limit - this.end;
            System.arraycopy(src, off, this.buff, this.end, avail);
            this.end += avail;
            this.flushBuffer();
            System.arraycopy(src, off + avail, this.buff, this.end, len - avail);
            this.end += len - avail;
        } else {
            this.flushBuffer();
            this.out.realWriteChars(src, off, len);
        }
    }

    public void append(String s) throws IOException {
        this.append(s, 0, s.length());
    }

    public void append(String s, int off, int len) throws IOException {
        if (s == null) {
            return;
        }
        this.makeSpace(len);
        if (this.limit < 0) {
            s.getChars(off, off + len, this.buff, this.end);
            this.end += len;
            return;
        }
        int sOff = off;
        int sEnd = off + len;
        while (sOff < sEnd) {
            int d = this.min(this.limit - this.end, sEnd - sOff);
            s.getChars(sOff, sOff + d, this.buff, this.end);
            sOff += d;
            this.end += d;
            if (this.end < this.limit) continue;
            this.flushBuffer();
        }
    }

    public int substract() throws IOException {
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            int n = this.in.realReadChars(this.buff, this.end, this.buff.length - this.end);
            if (n < 0) {
                return -1;
            }
        }
        return this.buff[this.start++];
    }

    public int substract(char[] src, int off, int len) throws IOException {
        int n;
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            n = this.in.realReadChars(this.buff, this.end, this.buff.length - this.end);
            if (n < 0) {
                return -1;
            }
        }
        n = len;
        if (len > this.getLength()) {
            n = this.getLength();
        }
        System.arraycopy(this.buff, this.start, src, off, n);
        this.start += n;
        return n;
    }

    public void flushBuffer() throws IOException {
        if (this.out == null) {
            throw new IOException("Buffer overflow, no sink " + this.limit + " " + this.buff.length);
        }
        this.out.realWriteChars(this.buff, this.start, this.end - this.start);
        this.end = this.start;
    }

    public void makeSpace(int count) {
        char[] tmp = null;
        int desiredSize = this.end + count;
        if (this.limit > 0 && desiredSize > this.limit) {
            desiredSize = this.limit;
        }
        if (this.buff == null) {
            if (desiredSize < 256) {
                desiredSize = 256;
            }
            this.buff = new char[desiredSize];
        }
        if (desiredSize <= this.buff.length) {
            return;
        }
        if (desiredSize < 2 * this.buff.length) {
            int newSize = this.buff.length * 2;
            if (this.limit > 0 && newSize > this.limit) {
                newSize = this.limit;
            }
            tmp = new char[newSize];
        } else {
            int newSize = this.buff.length * 2 + count;
            if (this.limit > 0 && newSize > this.limit) {
                newSize = this.limit;
            }
            tmp = new char[newSize];
        }
        System.arraycopy(this.buff, 0, tmp, 0, this.end);
        this.buff = tmp;
        tmp = null;
    }

    @Override
    public String toString() {
        if (null == this.buff) {
            return null;
        }
        if (this.end - this.start == 0) {
            return "";
        }
        return StringCache.toString(this);
    }

    public String toStringInternal() {
        return new String(this.buff, this.start, this.end - this.start);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CharChunk) {
            return this.equals((CharChunk)obj);
        }
        return false;
    }

    public boolean equals(String s) {
        char[] c = this.buff;
        int len = this.end - this.start;
        if (c == null || len != s.length()) {
            return false;
        }
        int off = this.start;
        for (int i = 0; i < len; ++i) {
            if (c[off++] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String s) {
        char[] c = this.buff;
        int len = this.end - this.start;
        if (c == null || len != s.length()) {
            return false;
        }
        int off = this.start;
        for (int i = 0; i < len; ++i) {
            if (Ascii.toLower(c[off++]) == Ascii.toLower(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharChunk cc) {
        return this.equals(cc.getChars(), cc.getOffset(), cc.getLength());
    }

    public boolean equals(char[] b2, int off2, int len2) {
        char[] b1 = this.buff;
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null || this.end - this.start != len2) {
            return false;
        }
        int off1 = this.start;
        int len = this.end - this.start;
        while (len-- > 0) {
            if (b1[off1++] == b2[off2++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String s) {
        char[] c = this.buff;
        int len = s.length();
        if (c == null || len > this.end - this.start) {
            return false;
        }
        int off = this.start;
        for (int i = 0; i < len; ++i) {
            if (c[off++] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String s, int pos) {
        char[] c = this.buff;
        int len = s.length();
        if (c == null || len + pos > this.end - this.start) {
            return false;
        }
        int off = this.start + pos;
        for (int i = 0; i < len; ++i) {
            if (Ascii.toLower(c[off++]) == Ascii.toLower(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String s) {
        char[] c = this.buff;
        int len = s.length();
        if (c == null || len > this.end - this.start) {
            return false;
        }
        int off = this.end - len;
        for (int i = 0; i < len; ++i) {
            if (c[off++] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hasHashCode) {
            return this.hashCode;
        }
        int code = 0;
        this.hashCode = code = this.hash();
        this.hasHashCode = true;
        return code;
    }

    public int hash() {
        int code = 0;
        for (int i = this.start; i < this.start + this.end - this.start; ++i) {
            code = code * 37 + this.buff[i];
        }
        return code;
    }

    public int indexOf(char c) {
        return this.indexOf(c, this.start);
    }

    public int indexOf(char c, int starting) {
        int ret = CharChunk.indexOf(this.buff, this.start + starting, this.end, c);
        return ret >= this.start ? ret - this.start : -1;
    }

    public static int indexOf(char[] chars, int off, int cend, char qq) {
        while (off < cend) {
            char b = chars[off];
            if (b == qq) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    public int indexOf(String src, int srcOff, int srcLen, int myOff) {
        char first = src.charAt(srcOff);
        int srcEnd = srcOff + srcLen;
        for (int i = myOff + this.start; i <= this.end - srcLen; ++i) {
            if (this.buff[i] != first) continue;
            int myPos = i + 1;
            int srcPos = srcOff + 1;
            while (srcPos < srcEnd && this.buff[myPos++] == src.charAt(srcPos++)) {
                if (srcPos != srcEnd) continue;
                return i - this.start;
            }
        }
        return -1;
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    @Override
    public char charAt(int index) {
        return this.buff[index + this.start];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        try {
            CharChunk result = (CharChunk)this.clone();
            result.setOffset(this.start + start);
            result.setEnd(this.start + end);
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    public static interface CharInputChannel {
        public int realReadChars(char[] var1, int var2, int var3) throws IOException;
    }

    public static interface CharOutputChannel {
        public void realWriteChars(char[] var1, int var2, int var3) throws IOException;
    }
}

