/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.router.web.RouterConsoleRunner;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppConfiguration
implements Configuration {
    private WebAppContext _wac;
    private static final String CLASSPATH = ".classpath";

    public void setWebAppContext(WebAppContext context) {
        this._wac = context;
    }

    public WebAppContext getWebAppContext() {
        return this._wac;
    }

    private void configureClassPath() throws Exception {
        String cp;
        String ctxPath = this._wac.getContextPath();
        if (ctxPath.equals("/")) {
            return;
        }
        String appName = ctxPath.substring(1);
        I2PAppContext i2pContext = I2PAppContext.getGlobalContext();
        File libDir = new File(i2pContext.getBaseDir(), "lib");
        File pluginDir = new File(i2pContext.getConfigDir(), "plugins" + ctxPath);
        File dir = libDir;
        if (pluginDir.exists()) {
            File consoleDir = new File(pluginDir, "console");
            Properties props = RouterConsoleRunner.webAppProperties(consoleDir.getAbsolutePath());
            cp = props.getProperty("webapps." + appName + CLASSPATH);
            dir = pluginDir;
        } else {
            Properties props = RouterConsoleRunner.webAppProperties();
            cp = props.getProperty("webapps." + appName + CLASSPATH);
        }
        if (cp == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(cp, " ,");
        StringBuilder buf = new StringBuilder();
        Set<URL> systemCP = WebAppConfiguration.getSystemClassPath();
        while (tok.hasMoreTokens()) {
            String elem;
            if (buf.length() > 0) {
                buf.append(',');
            }
            String path = (elem = tok.nextToken().trim()).startsWith("$I2P") ? i2pContext.getBaseDir().getAbsolutePath() + elem.substring(4) : (elem.startsWith("$PLUGIN") ? dir.getAbsolutePath() + elem.substring(7) : dir.getAbsolutePath() + '/' + elem);
            File jfile = new File(path);
            File jdir = jfile.getParentFile();
            if (systemCP.contains(jfile.toURI().toURL()) || jdir != null && systemCP.contains(jdir.toURI().toURL())) continue;
            System.err.println("Adding " + path + " to classpath for " + appName);
            buf.append(path);
        }
        if (buf.length() <= 0) {
            return;
        }
        ClassLoader cl = this._wac.getClassLoader();
        if (cl != null && cl instanceof WebAppClassLoader) {
            WebAppClassLoader wacl = (WebAppClassLoader)cl;
            wacl.addClassPath(buf.toString());
        } else {
            this._wac.setExtraClasspath(buf.toString());
        }
    }

    private static Set<URL> getSystemClassPath() {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = urlClassLoader.getURLs();
        HashSet<URL> rv = new HashSet<URL>(32);
        for (int i = 0; i < urls.length; ++i) {
            rv.add(urls[i]);
        }
        return rv;
    }

    public void configureDefaults() {
    }

    public void configureWebApp() {
    }

    public void deconfigureWebApp() {
    }

    public void configureClassLoader() throws Exception {
        this.configureClassPath();
    }
}

