/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigClientsHelper;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.LogsHelper;
import net.i2p.router.web.Messages;
import net.i2p.router.web.PluginStarter;
import net.i2p.router.web.UpdateHandler;
import net.i2p.util.EepGet;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFile;
import net.i2p.util.SimpleTimer;
import net.i2p.util.VersionComparator;

public class PluginUpdateHandler
extends UpdateHandler {
    private static PluginUpdateRunner _pluginUpdateRunner;
    private String _xpi2pURL;
    private String _appStatus = "";
    private volatile boolean _updated;
    private static final String XPI2P = "app.xpi2p";
    private static final String ZIP = "app.xpi2p.zip";
    public static final String PLUGIN_DIR = "plugins";
    private static PluginUpdateHandler _instance;

    public static final synchronized PluginUpdateHandler getInstance(RouterContext ctx) {
        if (_instance != null) {
            return _instance;
        }
        _instance = new PluginUpdateHandler(ctx);
        return _instance;
    }

    private PluginUpdateHandler(RouterContext ctx) {
        super(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String xpi2pURL) {
        if ("true".equals(System.getProperty("net.i2p.router.web.UpdateHandler.updateInProgress"))) {
            this._log.error("Update already running");
            return;
        }
        Class<UpdateHandler> clazz = UpdateHandler.class;
        synchronized (UpdateHandler.class) {
            if (_pluginUpdateRunner == null) {
                _pluginUpdateRunner = new PluginUpdateRunner(this._xpi2pURL);
            }
            if (_pluginUpdateRunner.isRunning()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this._xpi2pURL = xpi2pURL;
            this._updateFile = new File(this._context.getTempDir(), "tmp" + this._context.random().nextInt() + XPI2P).getAbsolutePath();
            System.setProperty("net.i2p.router.web.UpdateHandler.updateInProgress", "true");
            I2PAppThread update = new I2PAppThread(_pluginUpdateRunner, "AppDownload");
            update.start();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getAppStatus() {
        return this._appStatus;
    }

    public boolean isRunning() {
        return _pluginUpdateRunner != null && _pluginUpdateRunner.isRunning();
    }

    public boolean isDone() {
        return false;
    }

    public boolean wasUpdateSuccessful() {
        return this._updated;
    }

    private void scheduleStatusClean(String msg) {
        this._context.simpleScheduler().addEvent(new Cleaner(msg), 1200000L);
    }

    protected void updateStatus(String s) {
        super.updateStatus(s);
        this._appStatus = s;
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private final String _msg;

        public Cleaner(String msg) {
            this._msg = msg;
        }

        public void timeReached() {
            if (this._msg.equals(UpdateHandler.getStatus())) {
                PluginUpdateHandler.this.updateStatus("");
            }
        }
    }

    public class PluginUpdateRunner
    extends UpdateHandler.UpdateRunner
    implements Runnable,
    EepGet.StatusListener {
        public PluginUpdateRunner(String url) {
            super(PluginUpdateHandler.this);
        }

        protected void update() {
            PluginUpdateHandler.this._updated = false;
            if (PluginUpdateHandler.this._xpi2pURL.startsWith("file://")) {
                PluginUpdateHandler.this.updateStatus("<b>" + PluginUpdateHandler.this._("Attempting to install from file {0}", PluginUpdateHandler.this._xpi2pURL) + "</b>");
                String xpi2pfile = PluginUpdateHandler.this._xpi2pURL.substring(7);
                if (xpi2pfile.length() == 0) {
                    this.statusDone("<b>" + PluginUpdateHandler.this._("No file specified {0}", PluginUpdateHandler.this._xpi2pURL) + "</b>");
                } else {
                    long alreadyTransferred = new File(xpi2pfile).getAbsoluteFile().length();
                    if (FileUtil.copy(new File(xpi2pfile).getAbsolutePath(), PluginUpdateHandler.this._updateFile, true, false)) {
                        this.transferComplete(alreadyTransferred, alreadyTransferred, 0L, PluginUpdateHandler.this._xpi2pURL, PluginUpdateHandler.this._updateFile, false);
                    } else {
                        this.statusDone("<b>" + PluginUpdateHandler.this._("Failed to install from file {0}, copy failed.", PluginUpdateHandler.this._xpi2pURL) + "</b>");
                    }
                }
            } else {
                PluginUpdateHandler.this.updateStatus("<b>" + PluginUpdateHandler.this._("Downloading plugin from {0}", PluginUpdateHandler.this._xpi2pURL) + "</b>");
                boolean shouldProxy = Boolean.parseBoolean(PluginUpdateHandler.this._context.getProperty("router.updateThroughProxy", ConfigUpdateHandler.DEFAULT_SHOULD_PROXY));
                String proxyHost = PluginUpdateHandler.this._context.getProperty("router.updateProxyHost", "127.0.0.1");
                int proxyPort = ConfigUpdateHandler.proxyPort(PluginUpdateHandler.this._context);
                try {
                    this._get = shouldProxy ? new EepGet((I2PAppContext)PluginUpdateHandler.this._context, proxyHost, proxyPort, 10, PluginUpdateHandler.this._updateFile, PluginUpdateHandler.this._xpi2pURL, false) : new EepGet(PluginUpdateHandler.this._context, 1, PluginUpdateHandler.this._updateFile, PluginUpdateHandler.this._xpi2pURL, false);
                    this._get.addStatusListener(this);
                    this._get.fetch(55000L, -1L, shouldProxy ? 300000L : 60000L);
                }
                catch (Throwable t) {
                    PluginUpdateHandler.this._log.error("Error downloading plugin", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("<b>").append(PluginUpdateHandler.this._("Downloading plugin")).append(' ');
            double pct = ((double)alreadyTransferred + (double)currentWrite) / ((double)alreadyTransferred + (double)currentWrite + (double)bytesRemaining);
            DecimalFormat decimalFormat = this._pct;
            synchronized (decimalFormat) {
                buf.append(this._pct.format(pct));
            }
            buf.append(": ");
            buf.append(PluginUpdateHandler.this._("{0}B transferred", DataHelper.formatSize2((long)currentWrite + alreadyTransferred)));
            buf.append("</b>");
            PluginUpdateHandler.this.updateStatus(buf.toString());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
            String signingKeyName;
            boolean update = false;
            PluginUpdateHandler.this.updateStatus("<b>" + PluginUpdateHandler.this._("Plugin downloaded") + "</b>");
            File f = new File(PluginUpdateHandler.this._updateFile);
            SecureDirectory appDir = new SecureDirectory(PluginUpdateHandler.this._context.getConfigDir(), PluginUpdateHandler.PLUGIN_DIR);
            if (!appDir.exists() && !((File)appDir).mkdir()) {
                f.delete();
                this.statusDone("<b>" + PluginUpdateHandler.this._("Cannot create plugin directory {0}", appDir.getAbsolutePath()) + "</b>");
                return;
            }
            TrustedUpdate up = new TrustedUpdate(PluginUpdateHandler.this._context);
            File to = new File(PluginUpdateHandler.this._context.getTempDir(), "tmp" + PluginUpdateHandler.this._context.random().nextInt() + PluginUpdateHandler.ZIP);
            String err = up.migrateFile(f, to);
            if (err != null) {
                this.statusDone("<b>" + err + ' ' + PluginUpdateHandler.this._("from {0}", url) + " </b>");
                f.delete();
                to.delete();
                return;
            }
            File tempDir = new File(PluginUpdateHandler.this._context.getTempDir(), "tmp" + PluginUpdateHandler.this._context.random().nextInt() + "-unzip");
            if (!FileUtil.extractZip(to, tempDir)) {
                f.delete();
                to.delete();
                FileUtil.rmdir(tempDir, false);
                this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin from {0} is corrupt", url) + "</b>");
                return;
            }
            File installProps = new File(tempDir, "plugin.config");
            OrderedProperties props = new OrderedProperties();
            try {
                DataHelper.loadProps((Properties)props, installProps);
            }
            catch (IOException ioe) {
                f.delete();
                to.delete();
                FileUtil.rmdir(tempDir, false);
                this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin from {0} does not contain the required configuration file", url) + "</b>");
                return;
            }
            FileUtil.rmdir(tempDir, false);
            String pubkey = props.getProperty("key");
            String signer = props.getProperty("signer");
            if (pubkey == null || signer == null || pubkey.length() != 172 || signer.length() <= 0) {
                f.delete();
                to.delete();
                this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin from {0} contains an invalid key", url) + "</b>");
                return;
            }
            Map<String, String> existingKeys = PluginStarter.getPluginKeys(PluginUpdateHandler.this._context);
            for (Map.Entry<String, String> e : existingKeys.entrySet()) {
                up.addKey(e.getKey(), e.getValue());
            }
            if (up.haveKey(pubkey)) {
                signingKeyName = up.verifyAndGetSigner(f);
                if (!signer.equals(signingKeyName) && !"".equals(signingKeyName)) {
                    f.delete();
                    to.delete();
                    if (signingKeyName == null) {
                        PluginUpdateHandler.this._log.error("Failed to verify plugin signature, corrupt plugin or bad signature, signed by: " + signer);
                    } else {
                        PluginUpdateHandler.this._log.error("Plugin signer \"" + signer + "\" does not match existing signer in plugin.config file \"" + signingKeyName + "\"");
                    }
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin signature verification of {0} failed", url) + "</b>");
                    return;
                }
            } else {
                if (!up.addKey(pubkey, signer)) {
                    f.delete();
                    to.delete();
                    PluginUpdateHandler.this._log.error("Bad key or key mismatch - Failed to add plugin key \"" + pubkey + "\" for plugin signer \"" + signer + "\"");
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin signature verification of {0} failed", url) + "</b>");
                    return;
                }
                signingKeyName = up.verifyAndGetSigner(f);
                if (!signer.equals(signingKeyName)) {
                    f.delete();
                    to.delete();
                    if (signingKeyName == null) {
                        PluginUpdateHandler.this._log.error("Failed to verify plugin signature, corrupt plugin or bad signature, signed by: " + signer);
                    } else {
                        PluginUpdateHandler.this._log.error("Plugin signer \"" + signer + "\" does not match new signer in plugin.config file \"" + signingKeyName + "\"");
                    }
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin signature verification of {0} failed", url) + "</b>");
                    return;
                }
            }
            String sudVersion = TrustedUpdate.getVersionString(f);
            f.delete();
            String appName = props.getProperty("name");
            String version = props.getProperty("version");
            if (appName == null || version == null || appName.length() <= 0 || version.length() <= 0 || appName.indexOf("<") >= 0 || appName.indexOf(">") >= 0 || version.indexOf("<") >= 0 || version.indexOf(">") >= 0 || appName.startsWith(".") || appName.indexOf("/") >= 0 || appName.indexOf("\\") >= 0) {
                to.delete();
                this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin from {0} has invalid name or version", url) + "</b>");
                return;
            }
            if (!version.equals(sudVersion)) {
                to.delete();
                this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin {0} has mismatched versions", appName) + "</b>");
                return;
            }
            String minVersion = ConfigClientsHelper.stripHTML(props, "min-i2p-version");
            if (minVersion != null && new VersionComparator().compare("0.9.3", minVersion) < 0) {
                to.delete();
                this.statusDone("<b>" + PluginUpdateHandler.this._("This plugin requires I2P version {0} or higher", minVersion) + "</b>");
                return;
            }
            minVersion = ConfigClientsHelper.stripHTML(props, "min-java-version");
            if (minVersion != null && new VersionComparator().compare(System.getProperty("java.version"), minVersion) < 0) {
                to.delete();
                this.statusDone("<b>" + PluginUpdateHandler.this._("This plugin requires Java version {0} or higher", minVersion) + "</b>");
                return;
            }
            boolean wasRunning = false;
            SecureDirectory destDir = new SecureDirectory(appDir, appName);
            if (destDir.exists()) {
                if (Boolean.parseBoolean(props.getProperty("install-only"))) {
                    to.delete();
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Downloaded plugin is for new installs only, but the plugin is already installed", url) + "</b>");
                    return;
                }
                File oldPropFile = new File(destDir, "plugin.config");
                OrderedProperties oldProps = new OrderedProperties();
                try {
                    DataHelper.loadProps((Properties)oldProps, oldPropFile);
                }
                catch (IOException ioe) {
                    to.delete();
                    FileUtil.rmdir(tempDir, false);
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Installed plugin does not contain the required configuration file", url) + "</b>");
                    return;
                }
                String oldPubkey = oldProps.getProperty("key");
                String oldKeyName = oldProps.getProperty("signer");
                String oldAppName = oldProps.getProperty("name");
                if (!(pubkey.equals(oldPubkey) && signer.equals(oldKeyName) && appName.equals(oldAppName))) {
                    to.delete();
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Signature of downloaded plugin does not match installed plugin") + "</b>");
                    return;
                }
                String oldVersion = oldProps.getProperty("version");
                if (oldVersion == null || new VersionComparator().compare(oldVersion, version) >= 0) {
                    to.delete();
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Downloaded plugin version {0} is not newer than installed plugin", version) + "</b>");
                    return;
                }
                minVersion = ConfigClientsHelper.stripHTML(props, "min-installed-version");
                if (minVersion != null && new VersionComparator().compare(minVersion, oldVersion) > 0) {
                    to.delete();
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin update requires installed plugin version {0} or higher", minVersion) + "</b>");
                    return;
                }
                String maxVersion = ConfigClientsHelper.stripHTML(props, "max-installed-version");
                if (maxVersion != null && new VersionComparator().compare(maxVersion, oldVersion) < 0) {
                    to.delete();
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin update requires installed plugin version {0} or lower", maxVersion) + "</b>");
                    return;
                }
                oldVersion = LogsHelper.jettyVersion();
                minVersion = ConfigClientsHelper.stripHTML(props, "min-jetty-version");
                if (minVersion != null && new VersionComparator().compare(minVersion, oldVersion) > 0) {
                    to.delete();
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin requires Jetty version {0} or higher", minVersion) + "</b>");
                    return;
                }
                maxVersion = ConfigClientsHelper.stripHTML(props, "max-jetty-version");
                if (maxVersion != null && new VersionComparator().compare(maxVersion, oldVersion) < 0) {
                    to.delete();
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin requires Jetty version {0} or lower", maxVersion) + "</b>");
                    return;
                }
                if (Boolean.parseBoolean(props.getProperty("router-restart-required"))) {
                    try {
                        if (!FileUtil.copy(to, new SecureFile(new SecureFile(appDir.getCanonicalPath() + "/" + appName + "/" + PluginUpdateHandler.ZIP).getCanonicalPath()), true, true)) {
                            to.delete();
                            this.statusDone("<b>" + PluginUpdateHandler.this._("Cannot copy plugin to directory {0}", destDir.getAbsolutePath()) + "</b>");
                            return;
                        }
                    }
                    catch (Throwable t) {
                        to.delete();
                        PluginUpdateHandler.this._log.error("Error copying plugin {0}", t);
                        return;
                    }
                    to.delete();
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin will be installed on next restart.") + "</b>");
                    return;
                }
                if (PluginStarter.isPluginRunning(appName, PluginUpdateHandler.this._context)) {
                    wasRunning = true;
                    try {
                        if (PluginStarter.stopPlugin(PluginUpdateHandler.this._context, appName)) {
                            // empty if block
                        }
                    }
                    catch (Throwable e) {
                        PluginUpdateHandler.this._log.error("Error stopping plugin " + appName, e);
                    }
                }
                update = true;
            } else {
                if (Boolean.parseBoolean(props.getProperty("update-only"))) {
                    to.delete();
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin is for upgrades only, but the plugin is not installed") + "</b>");
                    return;
                }
                if (!((File)destDir).mkdir()) {
                    to.delete();
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Cannot create plugin directory {0}", destDir.getAbsolutePath()) + "</b>");
                    return;
                }
            }
            if (!FileUtil.extractZip(to, destDir)) {
                to.delete();
                this.statusDone("<b>" + PluginUpdateHandler.this._("Failed to install plugin in {0}", destDir.getAbsolutePath()) + "</b>");
                return;
            }
            PluginUpdateHandler.this._updated = true;
            to.delete();
            if (Boolean.parseBoolean(props.getProperty("dont-start-at-install"))) {
                this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin {0} installed", appName) + "</b>");
                if (update) return;
                Properties pluginProps = PluginStarter.pluginProperties();
                pluginProps.setProperty("plugin." + appName + ".startOnLoad", "false");
                PluginStarter.storePluginProperties(pluginProps);
                return;
            }
            if (!wasRunning && !PluginStarter.isPluginEnabled(appName)) {
                this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin {0} installed", appName) + "</b>");
                return;
            }
            try {
                if (!PluginStarter.startPlugin(PluginUpdateHandler.this._context, appName)) {
                    this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin {0} installed but failed to start, check logs", appName) + "</b>");
                    return;
                }
                String linkName = ConfigClientsHelper.stripHTML(props, "consoleLinkName_" + Messages.getLanguage(PluginUpdateHandler.this._context));
                if (linkName == null) {
                    linkName = ConfigClientsHelper.stripHTML(props, "consoleLinkName");
                }
                String linkURL = ConfigClientsHelper.stripHTML(props, "consoleLinkURL");
                String link = linkName != null && linkURL != null ? "<a target=\"_blank\" href=\"" + linkURL + "\"/>" + linkName + "</a>" : appName;
                this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin {0} installed and started", link) + "</b>");
                return;
            }
            catch (Throwable e) {
                this.statusDone("<b>" + PluginUpdateHandler.this._("Plugin {0} installed but failed to start", appName) + ": " + e + "</b>");
                PluginUpdateHandler.this._log.error("Error starting plugin " + appName, e);
                return;
            }
        }

        public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
            File f = new File(PluginUpdateHandler.this._updateFile);
            f.delete();
            this.statusDone("<b>" + PluginUpdateHandler.this._("Failed to download plugin from {0}", url) + "</b>");
        }

        private void statusDone(String msg) {
            PluginUpdateHandler.this.updateStatus(msg);
            PluginUpdateHandler.this.scheduleStatusClean(msg);
        }
    }
}

