/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.util.RFC822Date;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.ConfigUpdateHelper;
import net.i2p.router.web.Messages;
import net.i2p.router.web.UnsignedUpdateHandler;
import net.i2p.router.web.UpdateHandler;
import net.i2p.util.EepGet;
import net.i2p.util.EepHead;
import net.i2p.util.FileUtil;
import net.i2p.util.Log;

public class NewsFetcher
implements Runnable,
EepGet.StatusListener {
    private final RouterContext _context;
    private final Log _log;
    private boolean _updateAvailable;
    private boolean _unsignedUpdateAvailable;
    private long _lastFetch;
    private long _lastUpdated;
    private String _updateVersion;
    private String _unsignedUpdateVersion;
    private String _lastModified;
    private boolean _invalidated;
    private final File _newsFile;
    private final File _tempFile;
    private static NewsFetcher _instance;
    private volatile boolean _isRunning;
    private static final String NEWS_FILE = "docs/news.xml";
    private static final String TEMP_NEWS_FILE = "news.xml.temp";
    private static final String BACKUP_NEWS_URL = "http://www.i2p2.i2p/_static/news/news.xml";
    private static final String PROP_LAST_CHECKED = "router.newsLastChecked";
    private static final String PROP_LAST_HIDDEN = "routerconsole.newsLastHidden";
    private static final long INITIAL_DELAY = 300000L;
    private static final long RUN_DELAY = 600000L;
    private static final String VERSION_STRING = "version=\"0.9.3\"";
    private static final String VERSION_PREFIX = "version=\"";

    public static final synchronized NewsFetcher getInstance(RouterContext ctx) {
        if (_instance != null) {
            return _instance;
        }
        _instance = new NewsFetcher(ctx);
        return _instance;
    }

    private NewsFetcher(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(NewsFetcher.class);
        _instance = this;
        try {
            String last = ctx.getProperty(PROP_LAST_CHECKED);
            if (last != null) {
                this._lastFetch = Long.parseLong(last);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this._newsFile = new File(this._context.getRouterDir(), NEWS_FILE);
        this._tempFile = new File(this._context.getTempDir(), TEMP_NEWS_FILE);
        this.updateLastFetched();
        this._updateVersion = "";
        this._isRunning = true;
    }

    void shutdown() {
        this._isRunning = false;
    }

    private void updateLastFetched() {
        if (this._newsFile.exists()) {
            if (this._lastUpdated == 0L) {
                this._lastUpdated = this._newsFile.lastModified();
            }
            if (this._lastFetch == 0L) {
                this._lastFetch = this._lastUpdated;
            }
            if (this._lastModified == null) {
                this._lastModified = RFC822Date.to822Date(this._lastFetch);
            }
        } else {
            this._lastUpdated = 0L;
            this._lastFetch = 0L;
            this._lastModified = null;
        }
    }

    public boolean updateAvailable() {
        return this._updateAvailable;
    }

    public String updateVersion() {
        return this._updateVersion;
    }

    public boolean unsignedUpdateAvailable() {
        return this._unsignedUpdateAvailable;
    }

    public String unsignedUpdateVersion() {
        return this._unsignedUpdateVersion;
    }

    public boolean shouldShowNews() {
        if (this._lastUpdated <= 0L) {
            return true;
        }
        String h = this._context.getProperty(PROP_LAST_HIDDEN);
        if (h == null) {
            return true;
        }
        long last = 0L;
        try {
            last = Long.parseLong(h);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return this._lastUpdated > last;
    }

    public void showNews(boolean yes) {
        long stamp = yes ? 0L : this._lastUpdated;
        this._context.router().saveConfig(PROP_LAST_HIDDEN, Long.toString(stamp));
    }

    public String status() {
        StringBuilder buf = new StringBuilder(128);
        long now = this._context.clock().now();
        buf.append("<i>");
        if (this._lastUpdated > 0L) {
            buf.append(Messages.getString("News last updated {0} ago.", DataHelper.formatDuration2(now - this._lastUpdated), this._context)).append('\n');
        }
        if (this._lastFetch > this._lastUpdated) {
            buf.append(Messages.getString("News last checked {0} ago.", DataHelper.formatDuration2(now - this._lastFetch), this._context));
        }
        buf.append("</i>");
        String consoleNonce = System.getProperty("router.consoleNonce");
        if (this._lastUpdated > 0L && consoleNonce != null) {
            if (this.shouldShowNews()) {
                buf.append(" <a href=\"/?news=0&amp;consoleNonce=").append(consoleNonce).append("\">").append(Messages.getString("Hide news", this._context));
            } else {
                buf.append(" <a href=\"/?news=1&amp;consoleNonce=").append(consoleNonce).append("\">").append(Messages.getString("Show news", this._context));
            }
            buf.append("</a>");
        }
        return buf.toString();
    }

    public void run() {
        try {
            Thread.sleep(300000L + this._context.random().nextLong(300000L));
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        while (this._isRunning) {
            if (!this._updateAvailable) {
                this.checkForUpdates();
            }
            if (this.shouldFetchNews()) {
                this.fetchNews();
                if (this.shouldFetchUnsigned()) {
                    this.fetchUnsignedHead();
                }
            }
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    boolean dontInstall() {
        File test = new File(this._context.getBaseDir(), "history.txt");
        boolean readonly = test.exists() && !test.canWrite() || !this._context.getBaseDir().canWrite();
        boolean disabled = this._context.getBooleanProperty("router.updateDisabled");
        return readonly || disabled;
    }

    private boolean shouldInstall() {
        String policy = this._context.getProperty("router.updatePolicy");
        if ("notify".equals(policy) || this.dontInstall()) {
            return false;
        }
        File zip = new File(this._context.getRouterDir(), "i2pupdate.zip");
        return !zip.exists();
    }

    private boolean shouldFetchNews() {
        if (this._invalidated) {
            return true;
        }
        this.updateLastFetched();
        String freq = this._context.getProperty("router.newsRefreshFrequency", ConfigUpdateHandler.DEFAULT_REFRESH_FREQUENCY);
        try {
            long ms = Long.parseLong(freq);
            if (ms <= 0L) {
                return false;
            }
            if (this._lastFetch + ms < this._context.clock().now()) {
                return true;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Last fetched " + DataHelper.formatDuration(this._context.clock().now() - this._lastFetch) + " ago");
            }
            return false;
        }
        catch (NumberFormatException nfe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Invalid refresh frequency: " + freq);
            }
            return false;
        }
    }

    void invalidateNews() {
        this._lastModified = null;
        this._invalidated = true;
    }

    public void fetchNews() {
        String newsURL = ConfigUpdateHelper.getNewsURL(this._context);
        boolean shouldProxy = Boolean.parseBoolean(this._context.getProperty("router.updateThroughProxy", ConfigUpdateHandler.DEFAULT_SHOULD_PROXY));
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = ConfigUpdateHandler.proxyPort(this._context);
        if (this._tempFile.exists()) {
            this._tempFile.delete();
        }
        try {
            EepGet get = null;
            get = shouldProxy ? new EepGet(this._context, true, proxyHost, proxyPort, 0, this._tempFile.getAbsolutePath(), newsURL, true, null, this._lastModified) : new EepGet(this._context, false, null, 0, 0, this._tempFile.getAbsolutePath(), newsURL, true, null, this._lastModified);
            get.addStatusListener(this);
            if (get.fetch()) {
                this._lastModified = get.getLastModified();
                this._invalidated = false;
            } else {
                this._tempFile.delete();
                get = new EepGet(this._context, true, proxyHost, proxyPort, 0, this._tempFile.getAbsolutePath(), BACKUP_NEWS_URL, true, null, this._lastModified);
                get.addStatusListener(this);
                if (get.fetch()) {
                    this._lastModified = get.getLastModified();
                }
            }
        }
        catch (Throwable t) {
            this._log.error("Error fetching the news", t);
        }
    }

    public boolean shouldFetchUnsigned() {
        String url = this._context.getProperty("router.updateUnsignedURL");
        return url != null && url.length() > 0 && this._context.getBooleanProperty("router.updateUnsigned") && !this.dontInstall();
    }

    public void fetchUnsignedHead() {
        block10: {
            String url = this._context.getProperty("router.updateUnsignedURL");
            if (url == null || url.length() <= 0) {
                return;
            }
            String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
            int proxyPort = this._context.getProperty("router.updateProxyPort", 4444);
            try {
                String lastmod;
                EepHead get = new EepHead((I2PAppContext)this._context, proxyHost, proxyPort, 0, url);
                if (!get.fetch() || (lastmod = get.getLastModified()) == null) break block10;
                long modtime = RFC822Date.parse822Date(lastmod);
                if (modtime <= 0L) {
                    return;
                }
                String lastUpdate = this._context.getProperty("router.updateLastDownloaded");
                if (lastUpdate == null) {
                    this._context.router().saveConfig("router.updateLastDownloaded", Long.toString(this._context.clock().now()));
                    return;
                }
                long ms = 0L;
                try {
                    ms = Long.parseLong(lastUpdate);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (ms <= 0L) {
                    return;
                }
                if (modtime > ms) {
                    this._unsignedUpdateAvailable = true;
                    this._unsignedUpdateVersion = new SimpleDateFormat("dd-MMM HH:mm").format(new Date(modtime)) + " UTC";
                    if (this.shouldInstall()) {
                        this.fetchUnsigned();
                    }
                }
            }
            catch (Throwable t) {
                this._log.error("Error fetching the unsigned update", t);
            }
        }
    }

    public void fetchUnsigned() {
        String url = this._context.getProperty("router.updateUnsignedURL");
        if (url == null || url.length() <= 0) {
            return;
        }
        UnsignedUpdateHandler handler = new UnsignedUpdateHandler(this._context, url, this._unsignedUpdateVersion);
        ((UpdateHandler)handler).update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForUpdates() {
        this._updateAvailable = false;
        if (!this._newsFile.exists() || this._newsFile.length() <= 0L) {
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(this._newsFile);
            StringBuilder buf = new StringBuilder(128);
            while (DataHelper.readLine((InputStream)in, buf)) {
                int end;
                int index = buf.indexOf(VERSION_PREFIX);
                if (index != -1 && (end = buf.indexOf("\"", index + VERSION_PREFIX.length())) > index) {
                    String ver = buf.substring(index + VERSION_PREFIX.length(), end);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Found version: [" + ver + "]");
                    }
                    if (TrustedUpdate.needsUpdate("0.9.3", ver)) {
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Our version is out of date, update!");
                        }
                        this._updateVersion = ver;
                        break;
                    }
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Our version is current");
                    }
                    return;
                }
                if (buf.indexOf(VERSION_STRING) != -1) {
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Our version found, no need to update: " + buf.toString());
                    }
                    return;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("No match in " + buf.toString());
                }
                buf.setLength(0);
            }
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error checking the news for an update", ioe);
            }
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Our version was NOT found (0.9.3), update needed");
        }
        boolean bl = this._updateAvailable = !this.dontInstall();
        if (this.shouldInstall()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Policy requests update, so we update");
            }
            UpdateHandler handler = new UpdateHandler(this._context);
            handler.update();
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Policy requests manual update, so we do nothing");
        }
    }

    public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
    }

    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
    }

    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        if (this._log.shouldLog(20)) {
            this._log.info("News fetched from " + url + " with " + (alreadyTransferred + bytesTransferred));
        }
        long now = this._context.clock().now();
        if (this._tempFile.exists()) {
            boolean copied = FileUtil.copy(this._tempFile, this._newsFile, true, false);
            if (copied) {
                this._lastUpdated = now;
                this._tempFile.delete();
                this.checkForUpdates();
            } else if (this._log.shouldLog(40)) {
                this._log.error("Failed to copy the news file!");
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Transfer complete, but no file? - probably 304 Not Modified");
        }
        this._lastFetch = now;
        this._context.router().saveConfig(PROP_LAST_CHECKED, Long.toString(now));
    }

    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        if (this._log.shouldLog(30)) {
            this._log.warn("Failed to fetch the news from " + url);
        }
        this._tempFile.delete();
    }

    public void headerReceived(String url, int attemptNum, String key, String val) {
    }

    public void attempting(String url) {
    }
}

