/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.i2p.data.DataHelper;
import net.i2p.router.web.FormHandler;
import net.i2p.router.web.SummaryHelper;

public class ConfigSummaryHandler
extends FormHandler {
    private Map _settings;

    protected void processForm() {
        if (this._action == null) {
            return;
        }
        String group = this.getJettyString("group");
        boolean deleting = this._action.equals(this._("Delete selected"));
        boolean adding = this._action.equals(this._("Add item"));
        boolean saving = this._action.equals(this._("Save order"));
        boolean moving = this._action.startsWith("move_");
        if (this._action.equals(this._("Save")) && "0".equals(group)) {
            try {
                int refreshInterval = Integer.parseInt(this.getJettyString("refreshInterval"));
                if (refreshInterval >= 3) {
                    this._context.router().saveConfig("routerconsole.summaryRefresh", "" + refreshInterval);
                    this.addFormNotice(this._("Refresh interval changed"));
                }
                this.addFormError(this._("Refresh interval must be at least {0} seconds", 3));
            }
            catch (NumberFormatException e) {
                this.addFormError(this._("Refresh interval must be a number"));
                return;
            }
        } else if (this._action.equals(this._("Restore full default"))) {
            this._context.router().saveConfig("routerconsole.summaryBar.default", "HelpAndFAQ,I2PServices,I2PInternals,General,NetworkReachability,UpdateStatus,RestartStatus,Peers,FirewallAndReseedStatus,Bandwidth,Tunnels,Congestion,TunnelStatus,Destinations,");
            this.addFormNotice(this._("Full summary bar default restored.") + " " + this._("Summary bar will refresh shortly."));
        } else if (this._action.equals(this._("Restore minimal default"))) {
            this._context.router().saveConfig("routerconsole.summaryBar.default", "ShortGeneral,NewsHeadings,UpdateStatus,NetworkReachability,RestartStatus,FirewallAndReseedStatus,Destinations,");
            this.addFormNotice(this._("Minimal summary bar default restored.") + " " + this._("Summary bar will refresh shortly."));
        } else if (adding || deleting || saving || moving) {
            TreeMap<Integer, String> sections = new TreeMap<Integer, String>();
            for (Object o : this._settings.keySet()) {
                String k;
                if (!(o instanceof String) || !(k = (String)o).startsWith("order_")) continue;
                String v = this.getJettyString(k);
                k = k.substring(6);
                k = k.substring(k.indexOf(95) + 1);
                try {
                    int order = Integer.parseInt(v);
                    sections.put(order, k);
                }
                catch (NumberFormatException e) {
                    this.addFormError(this._("Order must be an integer"));
                    return;
                }
            }
            if (adding) {
                String name = this.getJettyString("name");
                if (name == null || name.length() <= 0) {
                    this.addFormError(this._("No section selected"));
                    return;
                }
                String order = this.getJettyString("order");
                if (order == null || order.length() <= 0) {
                    this.addFormError(this._("No order entered"));
                    return;
                }
                name = DataHelper.escapeHTML(name).replace(",", "&#44;");
                order = DataHelper.escapeHTML(order).replace(",", "&#44;");
                try {
                    int ki = Integer.parseInt(order);
                    sections.put(ki, name);
                    this.addFormNotice(this._("Added") + ": " + name);
                }
                catch (NumberFormatException e) {
                    this.addFormError(this._("Order must be an integer"));
                    return;
                }
            }
            if (deleting) {
                HashSet<Integer> toDelete = new HashSet<Integer>();
                for (Object o : this._settings.keySet()) {
                    String k;
                    if (!(o instanceof String) || !(k = (String)o).startsWith("delete_")) continue;
                    k = k.substring(7);
                    try {
                        int ki = Integer.parseInt(k);
                        toDelete.add(ki);
                    }
                    catch (NumberFormatException e) {}
                }
                Iterator iter = sections.keySet().iterator();
                while (iter.hasNext()) {
                    int i = (Integer)iter.next();
                    if (!toDelete.contains(i)) continue;
                    String removedName = (String)sections.get(i);
                    iter.remove();
                    this.addFormNotice(this._("Removed") + ": " + removedName);
                }
            } else if (moving) {
                String[] parts = this._action.split("_");
                try {
                    int from = Integer.parseInt(parts[1]);
                    int to = 0;
                    if ("up".equals(parts[2])) {
                        to = from - 1;
                    }
                    if ("down".equals(parts[2])) {
                        to = from + 1;
                    }
                    if ("bottom".equals(parts[2])) {
                        to = sections.size() - 1;
                    }
                    int n = -1;
                    if ("down".equals(parts[2]) || "bottom".equals(parts[2])) {
                        n = 1;
                    }
                    int i = from;
                    while (n * i < n * to) {
                        String temp = (String)sections.get(i + n);
                        sections.put(i + n, (String)sections.get(i));
                        sections.put(i, temp);
                        i += n;
                    }
                    this.addFormNotice(this._("Moved") + ": " + (String)sections.get(to));
                }
                catch (NumberFormatException e) {
                    this.addFormError(this._("Order must be an integer"));
                    return;
                }
            }
            SummaryHelper.saveSummaryBarSections(this._context, "default", sections);
            this.addFormNotice(this._("Saved order of sections.") + " " + this._("Summary bar will refresh shortly."));
        } else {
            this.addFormError(this._("Unsupported"));
        }
    }

    public void setSettings(Map settings) {
        this._settings = new HashMap(settings);
    }

    private String getJettyString(String key) {
        String[] arr = (String[])this._settings.get(key);
        if (arr == null) {
            return null;
        }
        return arr[0].trim();
    }

    public void setMovingAction() {
        for (Object o : this._settings.keySet()) {
            String k;
            if (!(o instanceof String) || !(k = (String)o).startsWith("move_") || !k.endsWith(".x") || this._settings.get(k) == null) continue;
            this._action = k.substring(0, k.length() - 2);
            break;
        }
    }
}

