/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.web.ConfigServiceHandler;
import net.i2p.router.web.ContextHelper;
import net.i2p.router.web.Messages;

public class ConfigRestartBean {
    static final String[] SET1 = new String[]{"shutdownImmediate", "stop", "Shutdown immediately", "cancelShutdown", "cancel", "Cancel shutdown"};
    static final String[] SET2 = new String[]{"restartImmediate", "reload", "Restart immediately", "cancelShutdown", "cancel", "Cancel restart"};
    static final String[] SET3 = new String[]{"restart", "reload", "Restart", "shutdown", "stop", "Shutdown"};
    static final String[] SET4 = new String[]{"shutdown", "stop", "Shutdown"};

    public static String getNonce() {
        RouterContext ctx = ContextHelper.getContext(null);
        String nonce = System.getProperty("console.nonce");
        if (nonce == null) {
            nonce = "" + ctx.random().nextLong();
            System.setProperty("console.nonce", nonce);
        }
        return nonce;
    }

    public static String renderStatus(String urlBase, String action, String nonce) {
        RouterContext ctx = ContextHelper.getContext(null);
        String systemNonce = ConfigRestartBean.getNonce();
        if (nonce != null && systemNonce.equals(nonce) && action != null) {
            if ("shutdownImmediate".equals(action) || ConfigRestartBean._("Shutdown immediately", ctx).equals(action)) {
                if (ctx.hasWrapper()) {
                    ConfigServiceHandler.registerWrapperNotifier(ctx, 3, false);
                }
                ctx.router().shutdownGracefully(3);
            } else if ("cancelShutdown".equals(action) || ConfigRestartBean._("Cancel shutdown", ctx).equals(action) || ConfigRestartBean._("Cancel restart", ctx).equals(action)) {
                ctx.router().cancelGracefulShutdown();
            } else if ("restartImmediate".equals(action) || ConfigRestartBean._("Restart immediately", ctx).equals(action)) {
                if (ctx.hasWrapper()) {
                    ConfigServiceHandler.registerWrapperNotifier(ctx, 4, false);
                }
                ctx.router().shutdownGracefully(4);
            } else if ("restart".equals(action) || ConfigRestartBean._("Restart", ctx).equals(action)) {
                if (ctx.hasWrapper()) {
                    ConfigServiceHandler.registerWrapperNotifier(ctx, 5, false);
                }
                ctx.router().shutdownGracefully(5);
            } else if ("shutdown".equals(action) || ConfigRestartBean._("Shutdown", ctx).equals(action)) {
                if (ctx.hasWrapper()) {
                    ConfigServiceHandler.registerWrapperNotifier(ctx, 2, false);
                }
                ctx.router().shutdownGracefully();
            }
        }
        boolean shuttingDown = ConfigRestartBean.isShuttingDown(ctx);
        boolean restarting = ConfigRestartBean.isRestarting(ctx);
        long timeRemaining = ctx.router().getShutdownTimeRemaining();
        StringBuilder buf = new StringBuilder(128);
        if ((shuttingDown || restarting) && timeRemaining <= 5000L) {
            buf.append("<h4>");
            if (restarting) {
                buf.append(ConfigRestartBean._("Restart imminent", ctx));
            } else {
                buf.append(ConfigRestartBean._("Shutdown imminent", ctx));
            }
            buf.append("</h4>");
        } else if (shuttingDown) {
            buf.append("<h4>");
            buf.append(ConfigRestartBean._("Shutdown in {0}", DataHelper.formatDuration2(timeRemaining), ctx));
            buf.append("</h4><hr>");
            ConfigRestartBean.buttons(ctx, buf, urlBase, systemNonce, SET1);
        } else if (restarting) {
            buf.append("<h4>");
            buf.append(ConfigRestartBean._("Restart in {0}", DataHelper.formatDuration2(timeRemaining), ctx));
            buf.append("</h4><hr>");
            ConfigRestartBean.buttons(ctx, buf, urlBase, systemNonce, SET2);
        } else if (ctx.hasWrapper()) {
            ConfigRestartBean.buttons(ctx, buf, urlBase, systemNonce, SET3);
        } else {
            ConfigRestartBean.buttons(ctx, buf, urlBase, systemNonce, SET4);
        }
        return buf.toString();
    }

    private static void buttons(RouterContext ctx, StringBuilder buf, String url, String nonce, String[] s) {
        buf.append("<form action=\"").append(url).append("\" method=\"POST\">\n");
        buf.append("<input type=\"hidden\" name=\"consoleNonce\" value=\"").append(nonce).append("\" >\n");
        for (int i = 0; i < s.length; i += 3) {
            buf.append("<button type=\"submit\" name=\"action\" value=\"").append(s[i]).append("\" class=\"").append(s[i + 1]).append("\" >").append(ConfigRestartBean._(s[i + 2], ctx)).append("</button>\n");
        }
        buf.append("</form>\n");
    }

    private static boolean isShuttingDown(RouterContext ctx) {
        return 2 == ctx.router().scheduledGracefulExitCode() || 3 == ctx.router().scheduledGracefulExitCode();
    }

    private static boolean isRestarting(RouterContext ctx) {
        return 5 == ctx.router().scheduledGracefulExitCode() || 4 == ctx.router().scheduledGracefulExitCode();
    }

    public static long getRestartTimeRemaining() {
        RouterContext ctx = ContextHelper.getContext(null);
        if (ctx.router().gracefulShutdownInProgress()) {
            return ctx.router().getShutdownTimeRemaining();
        }
        return 0x3FFFFFFFFFFFFFFFL;
    }

    private static String _(String s, RouterContext ctx) {
        return Messages.getString(s, ctx);
    }

    private static String _(String s, Object o, RouterContext ctx) {
        return Messages.getString(s, o, ctx);
    }
}

