/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.client.streaming.I2PSocketOptionsImpl;
import net.i2p.data.Hash;
import net.i2p.util.ConvertToHash;
import net.i2p.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectionOptions
extends I2PSocketOptionsImpl {
    private int _connectDelay;
    private boolean _fullySigned;
    private boolean _answerPings;
    private boolean _enforceProto;
    private volatile int _windowSize;
    private int _receiveWindow;
    private int _profile;
    private int _rtt;
    private int _rttDev;
    private int _rto;
    private int _resendDelay;
    private int _sendAckDelay;
    private int _maxMessageSize;
    private int _choke;
    private int _maxResends;
    private int _inactivityTimeout;
    private int _inactivityAction;
    private int _inboundBufferSize;
    private int _maxWindowSize;
    private int _congestionAvoidanceGrowthRateFactor;
    private int _slowStartGrowthRateFactor;
    private boolean _accessListEnabled;
    private boolean _blackListEnabled;
    private Set<Hash> _accessList;
    private Set<Hash> _blackList;
    private int _maxConnsPerMinute;
    private int _maxConnsPerHour;
    private int _maxConnsPerDay;
    private int _maxTotalConnsPerMinute;
    private int _maxTotalConnsPerHour;
    private int _maxTotalConnsPerDay;
    private int _maxConns;
    public static final int PROFILE_BULK = 1;
    public static final int PROFILE_INTERACTIVE = 2;
    public static final int INACTIVITY_ACTION_NOOP = 0;
    public static final int INACTIVITY_ACTION_DISCONNECT = 1;
    public static final int INACTIVITY_ACTION_SEND = 2;
    public static final String PROP_CONNECT_DELAY = "i2p.streaming.connectDelay";
    public static final String PROP_PROFILE = "i2p.streaming.profile";
    public static final String PROP_MAX_MESSAGE_SIZE = "i2p.streaming.maxMessageSize";
    public static final String PROP_MAX_RESENDS = "i2p.streaming.maxResends";
    public static final String PROP_INITIAL_RTT = "i2p.streaming.initialRTT";
    public static final String PROP_INITIAL_RESEND_DELAY = "i2p.streaming.initialResendDelay";
    public static final String PROP_INITIAL_ACK_DELAY = "i2p.streaming.initialAckDelay";
    public static final String PROP_INITIAL_WINDOW_SIZE = "i2p.streaming.initialWindowSize";
    public static final String PROP_INITIAL_RECEIVE_WINDOW = "i2p.streaming.initialReceiveWindow";
    public static final String PROP_INACTIVITY_TIMEOUT = "i2p.streaming.inactivityTimeout";
    public static final String PROP_INACTIVITY_ACTION = "i2p.streaming.inactivityAction";
    public static final String PROP_MAX_WINDOW_SIZE = "i2p.streaming.maxWindowSize";
    public static final String PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR = "i2p.streaming.congestionAvoidanceGrowthRateFactor";
    public static final String PROP_SLOW_START_GROWTH_RATE_FACTOR = "i2p.streaming.slowStartGrowthRateFactor";
    public static final String PROP_ANSWER_PINGS = "i2p.streaming.answerPings";
    public static final String PROP_ENABLE_ACCESS_LIST = "i2cp.enableAccessList";
    public static final String PROP_ENABLE_BLACKLIST = "i2cp.enableBlackList";
    public static final String PROP_ACCESS_LIST = "i2cp.accessList";
    public static final String PROP_MAX_CONNS_MIN = "i2p.streaming.maxConnsPerMinute";
    public static final String PROP_MAX_CONNS_HOUR = "i2p.streaming.maxConnsPerHour";
    public static final String PROP_MAX_CONNS_DAY = "i2p.streaming.maxConnsPerDay";
    public static final String PROP_MAX_TOTAL_CONNS_MIN = "i2p.streaming.maxTotalConnsPerMinute";
    public static final String PROP_MAX_TOTAL_CONNS_HOUR = "i2p.streaming.maxTotalConnsPerHour";
    public static final String PROP_MAX_TOTAL_CONNS_DAY = "i2p.streaming.maxTotalConnsPerDay";
    public static final String PROP_ENFORCE_PROTO = "i2p.streaming.enforceProtocol";
    public static final String PROP_MAX_STREAMS = "i2p.streaming.maxConcurrentStreams";
    private static final int TREND_COUNT = 3;
    static final int INITIAL_WINDOW_SIZE = 6;
    static final int DEFAULT_MAX_SENDS = 8;
    public static final int DEFAULT_INITIAL_RTT = 8000;
    public static final int DEFAULT_INITIAL_ACK_DELAY = 2000;
    static final int MIN_WINDOW_SIZE = 1;
    private static final boolean DEFAULT_ANSWER_PINGS = true;
    private static final int DEFAULT_INACTIVITY_TIMEOUT = 90000;
    private static final int DEFAULT_INACTIVITY_ACTION = 2;
    private static final int DEFAULT_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR = 1;
    private static final int DEFAULT_SLOW_START_GROWTH_RATE_FACTOR = 1;
    private static final boolean DEFAULT_ENFORCE_PROTO = false;
    private final int[] _trend = new int[3];
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 1730;
    public static final int MIN_MESSAGE_SIZE = 512;
    private static final double RTT_DAMPENING = 0.875;

    public ConnectionOptions() {
        this.cinit(System.getProperties());
    }

    public ConnectionOptions(Properties opts) {
        super(opts);
        this.cinit(opts);
    }

    public ConnectionOptions(I2PSocketOptions opts) {
        super(opts);
        this.cinit(System.getProperties());
    }

    public ConnectionOptions(ConnectionOptions opts) {
        super((I2PSocketOptions)opts);
        this.cinit(System.getProperties());
        if (opts != null) {
            this.update(opts);
        }
    }

    public void updateAll(ConnectionOptions opts) {
        this.setConnectTimeout(opts.getConnectTimeout());
        this.setReadTimeout(opts.getReadTimeout());
        this.setWriteTimeout(opts.getWriteTimeout());
        this.setMaxBufferSize(opts.getMaxBufferSize());
        this.setLocalPort(opts.getLocalPort());
        this.setPort(opts.getPort());
        this.update(opts);
    }

    private void update(ConnectionOptions opts) {
        this.setMaxWindowSize(opts.getMaxWindowSize());
        this.setConnectDelay(opts.getConnectDelay());
        this.setProfile(opts.getProfile());
        this.setRTT(opts.getRTT());
        this.setRequireFullySigned(opts.getRequireFullySigned());
        this.setWindowSize(opts.getWindowSize());
        this.setResendDelay(opts.getResendDelay());
        this.setMaxMessageSize(opts.getMaxMessageSize());
        this.setChoke(opts.getChoke());
        this.setMaxResends(opts.getMaxResends());
        this.setInactivityTimeout(opts.getInactivityTimeout());
        this.setInactivityAction(opts.getInactivityAction());
        this.setInboundBufferSize(opts.getInboundBufferSize());
        this.setCongestionAvoidanceGrowthRateFactor(opts.getCongestionAvoidanceGrowthRateFactor());
        this.setSlowStartGrowthRateFactor(opts.getSlowStartGrowthRateFactor());
        this.setAnswerPings(opts.getAnswerPings());
        this.setEnforceProtocol(opts.getEnforceProtocol());
        this.initLists(opts);
        this._maxConnsPerMinute = opts.getMaxConnsPerMinute();
        this._maxConnsPerHour = opts.getMaxConnsPerHour();
        this._maxConnsPerDay = opts.getMaxConnsPerDay();
        this._maxTotalConnsPerMinute = opts.getMaxTotalConnsPerMinute();
        this._maxTotalConnsPerHour = opts.getMaxTotalConnsPerHour();
        this._maxTotalConnsPerDay = opts.getMaxTotalConnsPerDay();
        this._maxConns = opts.getMaxConns();
    }

    private void cinit(Properties opts) {
        this.setMaxWindowSize(ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_WINDOW_SIZE, (int)128));
        this.setConnectDelay(ConnectionOptions.getInt((Properties)opts, (String)PROP_CONNECT_DELAY, (int)-1));
        this.setProfile(ConnectionOptions.getInt((Properties)opts, (String)PROP_PROFILE, (int)1));
        this.setMaxMessageSize(ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_MESSAGE_SIZE, (int)1730));
        this.setRTT(ConnectionOptions.getInt((Properties)opts, (String)PROP_INITIAL_RTT, (int)8000));
        this.setReceiveWindow(ConnectionOptions.getInt((Properties)opts, (String)PROP_INITIAL_RECEIVE_WINDOW, (int)1));
        this.setResendDelay(ConnectionOptions.getInt((Properties)opts, (String)PROP_INITIAL_RESEND_DELAY, (int)1000));
        this.setSendAckDelay(ConnectionOptions.getInt((Properties)opts, (String)PROP_INITIAL_ACK_DELAY, (int)2000));
        this.setWindowSize(ConnectionOptions.getInt((Properties)opts, (String)PROP_INITIAL_WINDOW_SIZE, (int)6));
        this.setMaxResends(ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_RESENDS, (int)8));
        this.setInactivityTimeout(ConnectionOptions.getInt((Properties)opts, (String)PROP_INACTIVITY_TIMEOUT, (int)90000));
        this.setInactivityAction(ConnectionOptions.getInt((Properties)opts, (String)PROP_INACTIVITY_ACTION, (int)2));
        this.setInboundBufferSize(this.getMaxMessageSize() * 130);
        this.setCongestionAvoidanceGrowthRateFactor(ConnectionOptions.getInt((Properties)opts, (String)PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR, (int)1));
        this.setSlowStartGrowthRateFactor(ConnectionOptions.getInt((Properties)opts, (String)PROP_SLOW_START_GROWTH_RATE_FACTOR, (int)1));
        this.setAnswerPings(ConnectionOptions.getBool(opts, PROP_ANSWER_PINGS, true));
        this.setEnforceProtocol(ConnectionOptions.getBool(opts, PROP_ENFORCE_PROTO, false));
        this.initLists(opts);
        this._maxConnsPerMinute = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_CONNS_MIN, (int)0);
        this._maxConnsPerHour = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_CONNS_HOUR, (int)0);
        this._maxConnsPerDay = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_CONNS_DAY, (int)0);
        this._maxTotalConnsPerMinute = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_TOTAL_CONNS_MIN, (int)0);
        this._maxTotalConnsPerHour = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_TOTAL_CONNS_HOUR, (int)0);
        this._maxTotalConnsPerDay = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_TOTAL_CONNS_DAY, (int)0);
        this._maxConns = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_STREAMS, (int)0);
    }

    public void setProperties(Properties opts) {
        super.setProperties(opts);
        if (opts == null) {
            return;
        }
        if (opts.containsKey(PROP_MAX_WINDOW_SIZE)) {
            this.setMaxWindowSize(ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_WINDOW_SIZE, (int)128));
        }
        if (opts.containsKey(PROP_CONNECT_DELAY)) {
            this.setConnectDelay(ConnectionOptions.getInt((Properties)opts, (String)PROP_CONNECT_DELAY, (int)-1));
        }
        if (opts.containsKey(PROP_PROFILE)) {
            this.setProfile(ConnectionOptions.getInt((Properties)opts, (String)PROP_PROFILE, (int)1));
        }
        if (opts.containsKey(PROP_MAX_MESSAGE_SIZE)) {
            this.setMaxMessageSize(ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_MESSAGE_SIZE, (int)32768));
        }
        if (opts.containsKey(PROP_INITIAL_RTT)) {
            this.setRTT(ConnectionOptions.getInt((Properties)opts, (String)PROP_INITIAL_RTT, (int)8000));
        }
        if (opts.containsKey(PROP_INITIAL_RECEIVE_WINDOW)) {
            this.setReceiveWindow(ConnectionOptions.getInt((Properties)opts, (String)PROP_INITIAL_RECEIVE_WINDOW, (int)1));
        }
        if (opts.containsKey(PROP_INITIAL_RESEND_DELAY)) {
            this.setResendDelay(ConnectionOptions.getInt((Properties)opts, (String)PROP_INITIAL_RESEND_DELAY, (int)1000));
        }
        if (opts.containsKey(PROP_INITIAL_ACK_DELAY)) {
            this.setSendAckDelay(ConnectionOptions.getInt((Properties)opts, (String)PROP_INITIAL_ACK_DELAY, (int)2000));
        }
        if (opts.containsKey(PROP_INITIAL_WINDOW_SIZE)) {
            this.setWindowSize(ConnectionOptions.getInt((Properties)opts, (String)PROP_INITIAL_WINDOW_SIZE, (int)6));
        }
        if (opts.containsKey(PROP_MAX_RESENDS)) {
            this.setMaxResends(ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_RESENDS, (int)8));
        }
        if (opts.containsKey(PROP_INACTIVITY_TIMEOUT)) {
            this.setInactivityTimeout(ConnectionOptions.getInt((Properties)opts, (String)PROP_INACTIVITY_TIMEOUT, (int)90000));
        }
        if (opts.containsKey(PROP_INACTIVITY_ACTION)) {
            this.setInactivityAction(ConnectionOptions.getInt((Properties)opts, (String)PROP_INACTIVITY_ACTION, (int)2));
        }
        this.setInboundBufferSize(this.getMaxMessageSize() * 130);
        if (opts.contains(PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR)) {
            this.setCongestionAvoidanceGrowthRateFactor(ConnectionOptions.getInt((Properties)opts, (String)PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR, (int)1));
        }
        if (opts.contains(PROP_SLOW_START_GROWTH_RATE_FACTOR)) {
            this.setSlowStartGrowthRateFactor(ConnectionOptions.getInt((Properties)opts, (String)PROP_SLOW_START_GROWTH_RATE_FACTOR, (int)1));
        }
        if (opts.containsKey("i2p.streaming.connectTimeout")) {
            this.setConnectTimeout(ConnectionOptions.getInt((Properties)opts, (String)"i2p.streaming.connectTimeout", (int)60000));
        }
        if (opts.containsKey(PROP_ANSWER_PINGS)) {
            this.setAnswerPings(ConnectionOptions.getBool(opts, PROP_ANSWER_PINGS, true));
        }
        if (opts.containsKey(PROP_ENFORCE_PROTO)) {
            this.setEnforceProtocol(ConnectionOptions.getBool(opts, PROP_ENFORCE_PROTO, false));
        }
        this.initLists(opts);
        if (opts.containsKey(PROP_MAX_CONNS_MIN)) {
            this._maxConnsPerMinute = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_CONNS_MIN, (int)0);
        }
        if (opts.containsKey(PROP_MAX_CONNS_HOUR)) {
            this._maxConnsPerHour = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_CONNS_HOUR, (int)0);
        }
        if (opts.containsKey(PROP_MAX_CONNS_DAY)) {
            this._maxConnsPerDay = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_CONNS_DAY, (int)0);
        }
        if (opts.containsKey(PROP_MAX_TOTAL_CONNS_MIN)) {
            this._maxTotalConnsPerMinute = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_TOTAL_CONNS_MIN, (int)0);
        }
        if (opts.containsKey(PROP_MAX_TOTAL_CONNS_HOUR)) {
            this._maxTotalConnsPerHour = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_TOTAL_CONNS_HOUR, (int)0);
        }
        if (opts.containsKey(PROP_MAX_TOTAL_CONNS_DAY)) {
            this._maxTotalConnsPerDay = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_TOTAL_CONNS_DAY, (int)0);
        }
        if (opts.containsKey(PROP_MAX_STREAMS)) {
            this._maxConns = ConnectionOptions.getInt((Properties)opts, (String)PROP_MAX_STREAMS, (int)0);
        }
    }

    public int getConnectDelay() {
        return this._connectDelay;
    }

    public void setConnectDelay(int delayMs) {
        this._connectDelay = delayMs;
    }

    public boolean getRequireFullySigned() {
        return this._fullySigned;
    }

    public void setRequireFullySigned(boolean sign) {
        this._fullySigned = sign;
    }

    public boolean getAnswerPings() {
        return this._answerPings;
    }

    public void setAnswerPings(boolean yes) {
        this._answerPings = yes;
    }

    public boolean getEnforceProtocol() {
        return this._enforceProto;
    }

    public void setEnforceProtocol(boolean yes) {
        this._enforceProto = yes;
    }

    public int getWindowSize() {
        return this._windowSize;
    }

    public void setWindowSize(int numMsgs) {
        if (numMsgs <= 0) {
            numMsgs = 1;
        }
        if (numMsgs < 1) {
            numMsgs = 1;
        }
        if (numMsgs > this._maxWindowSize) {
            numMsgs = this._maxWindowSize;
        }
        this._windowSize = numMsgs;
    }

    public int getReceiveWindow() {
        return this._receiveWindow;
    }

    public void setReceiveWindow(int numMsgs) {
        this._receiveWindow = numMsgs;
    }

    public int getRTT() {
        return this._rtt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRTT(int ms) {
        if (this._rto == 0) {
            this._rttDev = ms / 2;
            this._rto = ms + ms / 2;
        }
        int[] nArray = this._trend;
        synchronized (this._trend) {
            this._trend[0] = this._trend[1];
            this._trend[1] = this._trend[2];
            this._trend[2] = ms > this._rtt ? 1 : (ms < this._rtt ? -1 : 0);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this._rtt = ms;
            if (this._rtt > 60000) {
                this._rtt = 60000;
            }
            return;
        }
    }

    public int getRTO() {
        return this._rto;
    }

    int getRTTDev() {
        return this._rttDev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRTTTrend() {
        int[] nArray = this._trend;
        synchronized (this._trend) {
            for (int i = 0; i < 2; ++i) {
                if (this._trend[i] == this._trend[i + 1]) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._trend[0];
        }
    }

    public void updateRTT(int measuredValue) {
        this._rttDev += (int)(0.25 * (double)(Math.abs(measuredValue - this._rtt) - this._rttDev));
        int smoothed = (int)(0.875 * (double)this._rtt + 0.125 * (double)measuredValue);
        this._rto = smoothed + (this._rttDev << 2);
        if ((long)this._rto < 2000L) {
            this._rto = 2000;
        } else if ((long)this._rto > 45000L) {
            this._rto = 45000;
        }
        this.setRTT(smoothed);
    }

    public int getResendDelay() {
        return this._resendDelay;
    }

    public void setResendDelay(int ms) {
        this._resendDelay = ms;
    }

    public int getSendAckDelay() {
        return this._sendAckDelay;
    }

    public void setSendAckDelay(int delayMs) {
        this._sendAckDelay = delayMs;
    }

    public int getMaxMessageSize() {
        return this._maxMessageSize;
    }

    public void setMaxMessageSize(int bytes) {
        this._maxMessageSize = Math.max(bytes, 512);
    }

    public int getChoke() {
        return this._choke;
    }

    public void setChoke(int ms) {
        this._choke = ms;
    }

    public int getProfile() {
        return this._profile;
    }

    public void setProfile(int profile) {
        if (profile != 1) {
            throw new IllegalArgumentException("Only bulk is supported so far");
        }
        this._profile = profile;
    }

    public int getMaxResends() {
        return this._maxResends;
    }

    public void setMaxResends(int numSends) {
        this._maxResends = Math.max(numSends, 0);
    }

    public int getInactivityTimeout() {
        return this._inactivityTimeout;
    }

    public void setInactivityTimeout(int timeout) {
        this._inactivityTimeout = timeout;
    }

    public int getInactivityAction() {
        return this._inactivityAction;
    }

    public void setInactivityAction(int action) {
        this._inactivityAction = action;
    }

    public int getMaxWindowSize() {
        return this._maxWindowSize;
    }

    public void setMaxWindowSize(int msgs) {
        this._maxWindowSize = msgs > 128 ? 128 : (msgs < 1 ? 1 : msgs);
    }

    public int getInboundBufferSize() {
        return this._inboundBufferSize;
    }

    public void setInboundBufferSize(int bytes) {
        this._inboundBufferSize = bytes;
    }

    public int getCongestionAvoidanceGrowthRateFactor() {
        return this._congestionAvoidanceGrowthRateFactor;
    }

    public void setCongestionAvoidanceGrowthRateFactor(int factor) {
        this._congestionAvoidanceGrowthRateFactor = factor;
    }

    public int getSlowStartGrowthRateFactor() {
        return this._slowStartGrowthRateFactor;
    }

    public void setSlowStartGrowthRateFactor(int factor) {
        this._slowStartGrowthRateFactor = factor;
    }

    public int getMaxConnsPerMinute() {
        return this._maxConnsPerMinute;
    }

    public int getMaxConnsPerHour() {
        return this._maxConnsPerHour;
    }

    public int getMaxConnsPerDay() {
        return this._maxConnsPerDay;
    }

    public int getMaxTotalConnsPerMinute() {
        return this._maxTotalConnsPerMinute;
    }

    public int getMaxTotalConnsPerHour() {
        return this._maxTotalConnsPerHour;
    }

    public int getMaxTotalConnsPerDay() {
        return this._maxTotalConnsPerDay;
    }

    public int getMaxConns() {
        return this._maxConns;
    }

    public boolean isAccessListEnabled() {
        return this._accessListEnabled;
    }

    public boolean isBlacklistEnabled() {
        return this._blackListEnabled;
    }

    public Set<Hash> getAccessList() {
        return this._accessList;
    }

    public Set<Hash> getBlacklist() {
        return this._blackList;
    }

    private void initLists(ConnectionOptions opts) {
        this._accessListEnabled = opts.isAccessListEnabled();
        this._blackListEnabled = opts.isBlacklistEnabled();
        this._accessList = opts.getAccessList();
        this._blackList = opts.getBlacklist();
    }

    private void initLists(Properties opts) {
        this._accessListEnabled = ConnectionOptions.getBool(opts, PROP_ENABLE_ACCESS_LIST, false);
        this._blackListEnabled = ConnectionOptions.getBool(opts, PROP_ENABLE_BLACKLIST, false);
        HashSet<Hash> accessList = this._accessListEnabled ? new HashSet<Hash>() : Collections.EMPTY_SET;
        HashSet<Hash> blackList = this._blackListEnabled ? new HashSet<Hash>() : Collections.EMPTY_SET;
        if (this._accessListEnabled || this._blackListEnabled) {
            String hashes = opts.getProperty(PROP_ACCESS_LIST);
            if (hashes == null) {
                return;
            }
            StringTokenizer tok = new StringTokenizer(hashes, ",; ");
            while (tok.hasMoreTokens()) {
                String hashstr = tok.nextToken();
                Hash h = ConvertToHash.getHash((String)hashstr);
                if (h == null) {
                    ConnectionOptions.error("bad list hash: " + hashstr);
                    continue;
                }
                if (this._blackListEnabled) {
                    blackList.add(h);
                    continue;
                }
                accessList.add(h);
            }
        }
        this._accessList = accessList;
        this._blackList = blackList;
        if (this._accessListEnabled && this._accessList.isEmpty()) {
            ConnectionOptions.error("Connection access list enabled but no valid entries; no peers can connect");
        } else if (this._blackListEnabled && this._blackList.isEmpty()) {
            ConnectionOptions.error("Connection blacklist enabled but no valid entries; all peers can connect");
        }
    }

    private static void error(String s) {
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        Log log = ctx.logManager().getLog(ConnectionOptions.class);
        log.error(s);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("conDelay=").append(this._connectDelay);
        buf.append(" maxSize=").append(this._maxMessageSize);
        buf.append(" rtt=").append(this._rtt);
        buf.append(" rwin=").append(this._receiveWindow);
        buf.append(" resendDelay=").append(this._resendDelay);
        buf.append(" ackDelay=").append(this._sendAckDelay);
        buf.append(" cwin=").append(this._windowSize);
        buf.append(" maxResends=").append(this._maxResends);
        buf.append(" writeTimeout=").append(this.getWriteTimeout());
        buf.append(" readTimeout=").append(this.getReadTimeout());
        buf.append(" inactivityTimeout=").append(this._inactivityTimeout);
        buf.append(" inboundBuffer=").append(this._inboundBufferSize);
        buf.append(" maxWindowSize=").append(this._maxWindowSize);
        buf.append(" blacklistSize=").append(this._blackList.size());
        buf.append(" whitelistSize=").append(this._accessList.size());
        buf.append(" maxConns=").append(this._maxConnsPerMinute).append('/').append(this._maxConnsPerHour).append('/').append(this._maxConnsPerDay);
        buf.append(" maxTotalConns=").append(this._maxTotalConnsPerMinute).append('/').append(this._maxTotalConnsPerHour).append('/').append(this._maxTotalConnsPerDay);
        return buf.toString();
    }

    private static boolean getBool(Properties opts, String name, boolean defaultVal) {
        if (opts == null) {
            return defaultVal;
        }
        String val = opts.getProperty(name);
        if (val == null) {
            return defaultVal;
        }
        return Boolean.parseBoolean(val);
    }
}

