/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DateAndFlags;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.SendMessageMessage;

public class SendMessageExpiresMessage
extends SendMessageMessage {
    public static final int MESSAGE_TYPE = 36;
    private final DateAndFlags _daf;

    public SendMessageExpiresMessage() {
        this(new DateAndFlags());
    }

    public SendMessageExpiresMessage(DateAndFlags options) {
        this._daf = options;
    }

    public Date getExpiration() {
        return this._daf.getDate();
    }

    public long getExpirationTime() {
        return this._daf.getTime();
    }

    public void setExpiration(Date d) {
        this._daf.setDate(d);
    }

    public void setExpiration(long d) {
        this._daf.setDate(d);
    }

    public int getFlags() {
        return this._daf.getFlags();
    }

    public void setFlags(int f) {
        this._daf.setFlags(f);
    }

    public void readMessage(InputStream in, int length, int type) throws I2CPMessageException, IOException {
        super.readMessage(in, length, type);
        try {
            this._daf.readBytes(in);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Unable to load the message data", dfe);
        }
    }

    public void writeMessage(OutputStream out) throws I2CPMessageException, IOException {
        if (this.getSessionId() == null || this.getDestination() == null || this.getPayload() == null || this.getNonce() <= 0L) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        int len = 2 + this.getDestination().size() + this.getPayload().getSize() + 4 + 4 + 8;
        try {
            DataHelper.writeLong(out, 4, len);
            DataHelper.writeLong(out, 1, this.getType());
            this.getSessionId().writeBytes(out);
            this.getDestination().writeBytes(out);
            this.getPayload().writeBytes(out);
            DataHelper.writeLong(out, 4, this.getNonce());
            this._daf.writeBytes(out);
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing the msg", dfe);
        }
    }

    public int getType() {
        return 36;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SendMessageExpiresMessage) {
            SendMessageExpiresMessage msg = (SendMessageExpiresMessage)object;
            return super.equals(object) && this._daf.equals(msg._daf);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[SendMessageMessage: ");
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("\n\tNonce: ").append(this.getNonce());
        buf.append("\n\tDestination: ").append(this.getDestination());
        buf.append("\n\tExpiration: ").append(this.getExpiration());
        buf.append("\n\tPayload: ").append(this.getPayload());
        buf.append("]");
        return buf.toString();
    }
}

