/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import com.nettgryppa.security.HashCash;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.crypto.DSAEngine;
import net.i2p.data.Base32;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.VerifiedDestination;

public class PrivateKeyFile {
    private static final int HASH_EFFORT = 20;
    private final File file;
    private final I2PClient client;
    private Destination dest;
    private PrivateKey privKey;
    private SigningPrivateKey signingPrivKey;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: PrivateKeyFile filename (generates if nonexistent, then prints)");
            System.err.println("       PrivateKeyFile -h filename (generates if nonexistent, adds hashcash cert)");
            System.err.println("       PrivateKeyFile -h effort filename (specify HashCash effort instead of default 20)");
            System.err.println("       PrivateKeyFile -n filename (changes to null cert)");
            System.err.println("       PrivateKeyFile -s filename signwithdestfile (generates if nonexistent, adds cert signed by 2nd dest)");
            System.err.println("       PrivateKeyFile -u filename (changes to unknown cert)");
            System.err.println("       PrivateKeyFile -x filename (changes to hidden cert)");
            return;
        }
        I2PClient client = I2PClientFactory.createClient();
        int filearg = 0;
        if (args.length > 1) {
            filearg = args.length >= 2 && args[0].equals("-h") ? args.length - 1 : 1;
        }
        try {
            File f = new File(args[filearg]);
            PrivateKeyFile pkf = new PrivateKeyFile(f, client);
            Destination d = pkf.createIfAbsent();
            System.out.println("Original Destination:");
            System.out.println(pkf);
            PrivateKeyFile.verifySignature(d);
            if (args.length == 1) {
                return;
            }
            if (args[0].equals("-n")) {
                pkf.setCertType(0);
                System.out.println("New destination with null cert is:");
            } else if (args[0].equals("-u")) {
                pkf.setCertType(99);
                System.out.println("New destination with unknown cert is:");
            } else if (args[0].equals("-x")) {
                pkf.setCertType(2);
                System.out.println("New destination with hidden cert is:");
            } else if (args[0].equals("-h")) {
                int hashEffort = 20;
                if (args.length == 3) {
                    hashEffort = Integer.parseInt(args[1]);
                }
                System.out.println("Estimating hashcash generation time, stand by...");
                System.out.println(PrivateKeyFile.estimateHashCashTime(hashEffort));
                pkf.setHashCashCert(hashEffort);
                System.out.println("New destination with hashcash cert is:");
            } else if (args.length == 3 && args[0].equals("-s")) {
                PrivateKeyFile pkf2 = new PrivateKeyFile(args[2]);
                pkf.setSignedCert(pkf2);
                System.out.println("New destination with signed cert is:");
            }
            System.out.println(pkf);
            pkf.write();
            PrivateKeyFile.verifySignature(d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PrivateKeyFile(String file) {
        this(new File(file), I2PClientFactory.createClient());
    }

    public PrivateKeyFile(File file) {
        this(file, I2PClientFactory.createClient());
    }

    public PrivateKeyFile(File file, I2PClient client) {
        this.file = file;
        this.client = client;
        this.dest = null;
        this.privKey = null;
        this.signingPrivKey = null;
    }

    public PrivateKeyFile(File file, I2PSession session) {
        this(file, session.getMyDestination(), session.getDecryptionKey(), session.getPrivateKey());
    }

    public PrivateKeyFile(File file, Destination dest, PrivateKey pk, SigningPrivateKey spk) {
        this.file = file;
        this.client = null;
        this.dest = dest;
        this.privKey = pk;
        this.signingPrivKey = spk;
    }

    public PrivateKeyFile(File file, PublicKey pubkey, SigningPublicKey spubkey, Certificate cert, PrivateKey pk, SigningPrivateKey spk) {
        this.file = file;
        this.client = null;
        this.dest = new Destination();
        this.dest.setPublicKey(pubkey);
        this.dest.setSigningPublicKey(spubkey);
        this.dest.setCertificate(cert);
        this.privKey = pk;
        this.signingPrivKey = spk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Destination createIfAbsent() throws I2PException, IOException, DataFormatException {
        if (this.file.exists()) return this.getDestination();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
            if (this.client != null) {
                this.client.createDestination(out);
            } else {
                this.write();
            }
            Object var3_2 = null;
            if (out == null) return this.getDestination();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            out.close();
            return this.getDestination();
        }
        catch (IOException ioe) {}
        return this.getDestination();
    }

    public Destination getDestination() throws I2PSessionException, IOException, DataFormatException {
        I2PSession s;
        if (this.dest == null && (s = this.open()) != null) {
            this.dest = new VerifiedDestination(s.getMyDestination());
            this.privKey = s.getDecryptionKey();
            this.signingPrivKey = s.getPrivateKey();
        }
        return this.dest;
    }

    public void setDestination(Destination d) {
        this.dest = d;
    }

    public Certificate setCertType(int t) {
        if (this.dest == null) {
            throw new IllegalArgumentException("Dest is null");
        }
        Certificate c = new Certificate();
        c.setCertificateType(t);
        this.dest.setCertificate(c);
        return c;
    }

    public Certificate setHashCashCert(int effort) {
        HashCash hc;
        Certificate c = this.setCertType(1);
        long begin = System.currentTimeMillis();
        System.out.println("Starting hashcash generation now...");
        String resource = this.dest.getPublicKey().toBase64() + this.dest.getSigningPublicKey().toBase64();
        try {
            hc = HashCash.mintCash(resource, effort);
        }
        catch (Exception e) {
            return null;
        }
        System.out.println("Generation took: " + DataHelper.formatDuration(System.currentTimeMillis() - begin));
        System.out.println("Full Hashcash is: " + hc);
        String hcs = hc.toString();
        int end1 = 0;
        for (int i = 0; i < 3; ++i) {
            if ((end1 = 1 + hcs.indexOf(58, end1)) >= 0) continue;
            System.out.println("Bad hashcash");
            return null;
        }
        int start2 = hcs.indexOf(58, end1);
        if (start2 < 0) {
            System.out.println("Bad hashcash");
            return null;
        }
        hcs = hcs.substring(0, end1) + hcs.substring(start2);
        System.out.println("Short Hashcash is: " + hcs);
        c.setPayload(hcs.getBytes());
        return c;
    }

    public Certificate setSignedCert(PrivateKeyFile pkf2) {
        Destination d2;
        Certificate c = this.setCertType(3);
        try {
            d2 = pkf2.getDestination();
        }
        catch (Exception e) {
            return null;
        }
        if (d2 == null) {
            return null;
        }
        SigningPrivateKey spk2 = pkf2.getSigningPrivKey();
        System.out.println("Signing With Dest:");
        System.out.println(pkf2.toString());
        int len = 384;
        byte[] data = new byte[len];
        System.arraycopy(this.dest.getPublicKey().getData(), 0, data, 0, 256);
        System.arraycopy(this.dest.getSigningPublicKey().getData(), 0, data, 256, 128);
        byte[] payload = new byte[72];
        byte[] sig = DSAEngine.getInstance().sign(new ByteArrayInputStream(data), spk2).getData();
        System.arraycopy(sig, 0, payload, 0, 40);
        byte[] h2 = d2.calculateHash().getData();
        System.arraycopy(h2, 0, payload, 40, 32);
        c.setCertificateType(3);
        c.setPayload(payload);
        return c;
    }

    public PrivateKey getPrivKey() {
        return this.privKey;
    }

    public SigningPrivateKey getSigningPrivKey() {
        return this.signingPrivKey;
    }

    public I2PSession open() throws I2PSessionException, IOException {
        return this.open(new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PSession open(Properties opts) throws I2PSessionException, IOException {
        I2PSession i2PSession;
        block5: {
            FileInputStream in = null;
            try {
                I2PSession s;
                in = new FileInputStream(this.file);
                i2PSession = s = this.client.createSession(in, opts);
                Object var6_5 = null;
                if (in == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var6_6 = null;
                    if (in == null) break block6;
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return i2PSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write() throws IOException, DataFormatException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file);
            this.dest.writeBytes(out);
            this.privKey.writeBytes(out);
            this.signingPrivKey.writeBytes(out);
            out.flush();
            Object var3_2 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            out.close();
            return;
        }
        catch (IOException ioe) {}
    }

    public String toString() {
        StringBuilder s = new StringBuilder(128);
        s.append("Dest: ");
        s.append(this.dest != null ? this.dest.toBase64() : "null");
        s.append("\nB32: ");
        s.append(this.dest != null ? Base32.encode(this.dest.calculateHash().getData()) + ".b32.i2p" : "null");
        s.append("\nContains: ");
        s.append(this.dest);
        s.append("\nPrivate Key: ");
        s.append(this.privKey);
        s.append("\nSigining Private Key: ");
        s.append(this.signingPrivKey);
        s.append("\n");
        return s.toString();
    }

    public static String estimateHashCashTime(int hashEffort) {
        if (hashEffort <= 0 || hashEffort > 160) {
            return "Bad HashCash value: " + hashEffort;
        }
        long low = Long.MAX_VALUE;
        try {
            low = HashCash.estimateTime(hashEffort);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "It is estimated that generating a HashCash Certificate with value " + hashEffort + " for the Destination will take " + (low < 86400000000L ? "approximately " + DataHelper.formatDuration(low) + " to " + DataHelper.formatDuration(4L * low) : "longer than three years!");
    }

    public static boolean verifySignature(Destination d) {
        if (d.getCertificate().getCertificateType() != 3) {
            return false;
        }
        int len = 384;
        byte[] data = new byte[len];
        System.arraycopy(d.getPublicKey().getData(), 0, data, 0, 256);
        System.arraycopy(d.getSigningPublicKey().getData(), 0, data, 256, 128);
        Signature sig = new Signature();
        byte[] payload = d.getCertificate().getPayload();
        Hash signerHash = null;
        if (payload == null) {
            System.out.println("Bad signed cert - no payload");
            return false;
        }
        if (payload.length == 40) {
            sig.setData(payload);
        } else if (payload.length == 72) {
            byte[] pl = new byte[40];
            System.arraycopy(payload, 0, pl, 0, 40);
            sig.setData(pl);
            byte[] hash = new byte[32];
            System.arraycopy(payload, 40, hash, 0, 32);
            signerHash = new Hash(hash);
            System.out.println("Destination is signed by " + Base32.encode(hash) + ".b32.i2p");
        } else {
            System.out.println("Bad signed cert - length = " + payload.length);
            return false;
        }
        String[] filenames = new String[]{"privatehosts.txt", "userhosts.txt", "hosts.txt"};
        int tried = 0;
        for (int i = 0; i < filenames.length; ++i) {
            Properties hosts = new Properties();
            try {
                File f = new File(filenames[i]);
                if (!f.exists() || !f.canRead()) continue;
                DataHelper.loadProps(hosts, f, true);
                int sz = hosts.size();
                if (sz > 0) {
                    tried += sz;
                    if (signerHash == null) {
                        System.out.println("Attempting to verify using " + sz + " hosts, this may take a while");
                    }
                }
                for (Map.Entry<Object, Object> entry : hosts.entrySet()) {
                    String s = (String)entry.getValue();
                    Destination signer = new Destination(s);
                    if (signerHash != null && !signer.calculateHash().equals(signerHash)) continue;
                    if (PrivateKeyFile.checkSignature(sig, data, signer.getSigningPublicKey())) {
                        System.out.println("Good signature from: " + entry.getKey());
                        return true;
                    }
                    if (signerHash == null) continue;
                    System.out.println("Bad signature from: " + entry.getKey());
                }
                continue;
            }
            catch (DataFormatException dfe) {
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (tried > 0) {
            System.out.println("No valid signer found");
        } else {
            System.out.println("No addressbooks found to valididate signer");
        }
        return false;
    }

    public static boolean checkSignature(Signature s, byte[] data, SigningPublicKey spk) {
        return DSAEngine.getInstance().verifySignature(s, data, spk);
    }
}

