/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Log;
import net.i2p.util.VersionComparator;
import net.i2p.util.ZipFileComment;

public class TrustedUpdate {
    private static final String DEFAULT_TRUSTED_KEY = "W4kJbnv9KSVwbnapV7SaNW2kMIZKs~hwL0ro9pZXFo1xTwqz45nykCp1HM7sAKYDZay5z1HvYYOl9CNVz00xF03KPU9RUCVxhDZ1YXhZIskPKjUPUsCIpE~Z1C~N9KSEV6~2stDlBNH10VZ4T0X1TrcXwb3IBXliWo2y2GAx~Ow=";
    private static final String DEFAULT_TRUSTED_KEY2 = "lT54eq3SH0TWWwQ1wgH6XPelIno7wH7UfiZOpQg-ZuxdNhc4UjjrohKdKZqfswt1ANPnmOlMewLGBESl7kJB9c5sByz~IOlNyz5BMLRC~R~ZC9QI4WXwUBYW8BhYO2mkvtdOrcy690lDkwzdf5xLxlCBpQlTaLYzQVjVWBcvbCA=";
    private static final String DEFAULT_TRUSTED_KEY3 = "JHFA0yXUgKtmhajXFZH9Nk62OPRHbvvQHTi8EANV-D~3tjLjaz9p9cs6Fs8W3FSLfUwsQeFg7dfVSQQZga~1jMjboo94vIcm3j6XbW4mbcorVQ74uPjd8EA1AQhJ6bBTxDAFk~6fVDOdhHT0Wo5CcUn7v8bAYY3x3UWiL8Remx0=";
    private static final String DEFAULT_TRUSTED_KEY4 = "l3G6um9nB9EDLkT9cUusz5fX-GxXSWE5zaj2~V8lUL~XsGuFf8gKqzJLKNkAw0CgDIDsLRHHuUaF7ZHo5Z7HG~9JJU9Il4G2jyNYtg5S8AzG0UxkEt-JeBEqIxv5GDn6OFKr~wTI0UafJbegEWokl-8m-GPWf0vW-yPMjL7y5MI=";
    private static final String DEFAULT_TRUSTED_KEY5 = "DAVvT6zMcRuzJi3V8DKKV6o0GjXoQsEwnJsFMaVG1Se-KPQjfP8PbgKJDcrFe0zNJfh3yPdsocA~A~s9U6pvimlCXH2pnJGlNNojtFCZC3DleROl5-4EkYw~UKAg940o5yg1OCBVlRZBSrRAQIIjFGkxxPQc12dA~cfpryNk7Dc=";
    private static final int VERSION_BYTES = 16;
    public static final int HEADER_BYTES = 56;
    private static final String PROP_TRUSTED_KEYS = "router.trustedUpdateKeys";
    private final I2PAppContext _context;
    private final Log _log;
    private final Map<SigningPublicKey, String> _trustedKeys;
    private String _newVersion;
    private static final int KEYSIZE_B64_BYTES = 172;
    private static final Map<String, String> DEFAULT_KEYS = new HashMap<String, String>(4);

    public TrustedUpdate() {
        this(I2PAppContext.getGlobalContext());
    }

    public TrustedUpdate(I2PAppContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(TrustedUpdate.class);
        this._trustedKeys = new HashMap<SigningPublicKey, String>(4);
        String propertyTrustedKeys = context.getProperty(PROP_TRUSTED_KEYS);
        if (propertyTrustedKeys != null && propertyTrustedKeys.length() > 0) {
            StringTokenizer propertyTrustedKeysTokens = new StringTokenizer(propertyTrustedKeys, " ,\r\n");
            while (propertyTrustedKeysTokens.hasMoreTokens()) {
                String key = propertyTrustedKeysTokens.nextToken().trim();
                String name = DEFAULT_KEYS.get(key);
                if (name == null) {
                    name = "";
                }
                this.addKey(key, name);
            }
        } else {
            for (Map.Entry<String, String> e : DEFAULT_KEYS.entrySet()) {
                this.addKey(e.getKey(), e.getValue());
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("TrustedUpdate created, trusting " + this._trustedKeys.size() + " keys.");
        }
    }

    public boolean addKey(String key, String name) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Adding " + name + ": " + key);
        }
        SigningPublicKey signingPublicKey = new SigningPublicKey();
        try {
            signingPublicKey.fromBase64(key);
        }
        catch (DataFormatException dfe) {
            this._log.error("Invalid signing key for " + name + " : " + key, dfe);
            return false;
        }
        String oldName = this._trustedKeys.get(signingPublicKey);
        if (name.equals(oldName)) {
            return true;
        }
        if (oldName != null && !oldName.equals("")) {
            this._log.error("Key for " + name + " already stored for different name " + oldName + " : " + key);
            return false;
        }
        if (!name.equals("") && this._trustedKeys.containsValue(name)) {
            this._log.error("Key mismatch for " + name + ", spoof attempt? : " + key);
            return false;
        }
        this._trustedKeys.put(signingPublicKey, name);
        return true;
    }

    public boolean haveKey(String key) {
        if (key.length() != 172) {
            return false;
        }
        SigningPublicKey signingPublicKey = new SigningPublicKey();
        try {
            signingPublicKey.fromBase64(key);
        }
        catch (DataFormatException dfe) {
            return false;
        }
        return this._trustedKeys.containsKey(signingPublicKey);
    }

    public static void main(String[] args) {
        boolean ok = false;
        try {
            if ("keygen".equals(args[0])) {
                ok = TrustedUpdate.genKeysCLI(args[1], args[2]);
            } else if ("showversion".equals(args[0])) {
                ok = TrustedUpdate.showVersionCLI(args[1]);
            } else if ("sign".equals(args[0])) {
                ok = TrustedUpdate.signCLI(args[1], args[2], args[3], args[4]);
            } else if ("verifysig".equals(args[0])) {
                ok = TrustedUpdate.verifySigCLI(args[1]);
            } else if ("verifyupdate".equals(args[0])) {
                ok = TrustedUpdate.verifyUpdateCLI(args[1]);
            } else if ("verifyversion".equals(args[0])) {
                ok = TrustedUpdate.verifyVersionCLI(args[1]);
            } else {
                TrustedUpdate.showUsageCLI();
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            TrustedUpdate.showUsageCLI();
        }
        if (!ok) {
            System.exit(1);
        }
    }

    public static final boolean needsUpdate(String currentVersion, String newVersion) {
        return new VersionComparator().compare(currentVersion, newVersion) < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean genKeysCLI(String publicKeyFile, String privateKeyFile) {
        FileOutputStream fileOutputStream = null;
        I2PAppContext context = I2PAppContext.getGlobalContext();
        Object[] signingKeypair = context.keyGenerator().generateSigningKeypair();
        SigningPublicKey signingPublicKey = (SigningPublicKey)signingKeypair[0];
        SigningPrivateKey signingPrivateKey = (SigningPrivateKey)signingKeypair[1];
        fileOutputStream = new FileOutputStream(publicKeyFile);
        signingPublicKey.writeBytes(fileOutputStream);
        fileOutputStream.close();
        fileOutputStream = null;
        fileOutputStream = new FileOutputStream(privateKeyFile);
        signingPrivateKey.writeBytes(fileOutputStream);
        System.out.println("\r\nPrivate key written to: " + privateKeyFile);
        System.out.println("Public key written to: " + publicKeyFile);
        System.out.println("\r\nPublic key: " + signingPublicKey.toBase64() + "\r\n");
        Object var8_9 = null;
        if (fileOutputStream == null) return true;
        try {
            fileOutputStream.close();
            return true;
        }
        catch (IOException ioe) {}
        return true;
        {
            catch (Exception e) {
                System.err.println("Error writing keys:");
                e.printStackTrace();
                boolean bl = false;
                Object var8_10 = null;
                if (fileOutputStream == null) return bl;
                try {
                    fileOutputStream.close();
                    return bl;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static final void showUsageCLI() {
        System.err.println("Usage: TrustedUpdate keygen        publicKeyFile privateKeyFile");
        System.err.println("       TrustedUpdate showversion   signedFile");
        System.err.println("       TrustedUpdate sign          inputFile signedFile privateKeyFile version");
        System.err.println("       TrustedUpdate verifysig     signedFile");
        System.err.println("       TrustedUpdate verifyupdate  signedFile");
        System.err.println("       TrustedUpdate verifyversion signedFile");
    }

    private static final boolean showVersionCLI(String signedFile) {
        String versionString = TrustedUpdate.getVersionString(new File(signedFile));
        if (versionString.equals("")) {
            System.out.println("No version string found in file '" + signedFile + "'");
        } else {
            System.out.println("Version: " + versionString);
        }
        return !versionString.equals("");
    }

    private static final boolean signCLI(String inputFile, String signedFile, String privateKeyFile, String version) {
        Signature signature = new TrustedUpdate().sign(inputFile, signedFile, privateKeyFile, version);
        if (signature != null) {
            System.out.println("Input file '" + inputFile + "' signed and written to '" + signedFile + "'");
        } else {
            System.out.println("Error signing input file '" + inputFile + "'");
        }
        return signature != null;
    }

    private static final boolean verifySigCLI(String signedFile) {
        boolean isValidSignature = new TrustedUpdate().verify(new File(signedFile));
        if (isValidSignature) {
            System.out.println("Signature VALID");
        } else {
            System.out.println("Signature INVALID");
        }
        return isValidSignature;
    }

    private static final boolean verifyUpdateCLI(String signedFile) {
        boolean isUpdate = new TrustedUpdate().isUpdatedVersion("0.9.3", new File(signedFile));
        if (isUpdate) {
            System.out.println("File version is newer than current version.");
        } else {
            System.out.println("File version is older than or equal to current version.");
        }
        return isUpdate;
    }

    private static final boolean verifyVersionCLI(String signedFile) {
        TrustedUpdate tu = new TrustedUpdate();
        File file = new File(signedFile);
        tu.isUpdatedVersion("0", file);
        boolean isMatch = tu.verifyVersionMatch(file);
        if (isMatch) {
            System.out.println("Version verified");
        } else {
            System.out.println("Version mismatch, header version does not match zip comment version");
        }
        return isMatch;
    }

    public String getTrustedKeysString() {
        StringBuilder buf = new StringBuilder(1024);
        for (SigningPublicKey spk : this._trustedKeys.keySet()) {
            if (buf.length() > 0) {
                buf.append("\r\n");
            }
            buf.append(spk.toBase64());
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersionString(File signedFile) {
        block19: {
            block18: {
                block17: {
                    block16: {
                        fileInputStream = null;
                        try {
                            try {
                                fileInputStream = new FileInputStream(signedFile);
                                skipped = fileInputStream.skip(40L);
                                if (skipped != 40L) {
                                    var4_5 = "";
                                    var9_7 = null;
                                    if (fileInputStream == null) return var4_5;
                                    break block16;
                                }
                                data = new byte[16];
                                bytesRead = DataHelper.read(fileInputStream, data);
                                if (bytesRead != 16) {
                                    var6_20 = "";
                                    break block17;
                                }
                                for (i = 0; i < 16; ++i) {
                                    if (data[i] != 0) continue;
                                    var7_23 = new String(data, 0, i, "UTF-8");
                                    break block18;
                                }
                                var6_22 = new String(data, "UTF-8");
                                break block19;
                            }
                            catch (UnsupportedEncodingException uee) {
                                throw new RuntimeException("wtf, your JVM doesnt support utf-8? " + uee.getMessage());
                            }
                            catch (IOException ioe) {
                                var3_24 = "";
                                var9_11 = null;
                                if (fileInputStream == null) return var3_24;
                                try {
                                    fileInputStream.close();
                                    return var3_24;
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                return var3_24;
                            }
                        }
                        catch (Throwable var8_25) {
                            var9_12 = null;
                            if (fileInputStream == null) throw var8_25;
                            try {}
                            catch (IOException ioe) {
                                throw var8_25;
                            }
                            fileInputStream.close();
                            throw var8_25;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [14 : 187->194)] { 
lbl50:
                    // 1 sources

                    fileInputStream.close();
                    return var4_5;
lbl52:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return var4_5;
                }
                var9_8 = null;
                if (fileInputStream == null) return var6_20;
                ** try [egrp 2[TRYBLOCK] [14 : 187->194)] { 
lbl59:
                // 1 sources

                fileInputStream.close();
                return var6_20;
lbl61:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                return var6_20;
            }
            var9_9 = null;
            if (fileInputStream == null) return var7_23;
            ** try [egrp 2[TRYBLOCK] [14 : 187->194)] { 
lbl68:
            // 1 sources

            fileInputStream.close();
            return var7_23;
lbl70:
            // 1 sources

            catch (IOException ioe) {
                // empty catch block
            }
            return var7_23;
        }
        var9_10 = null;
        if (fileInputStream == null) return var6_22;
        try {}
        catch (IOException ioe) {
            // empty catch block
            return var6_22;
        }
        fileInputStream.close();
        return var6_22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersionString(InputStream inputStream) {
        block19: {
            block18: {
                block17: {
                    block16: {
                        try {
                            try {
                                skipped = inputStream.skip(40L);
                                if (skipped != 40L) {
                                    var3_4 = "";
                                    var8_6 = null;
                                    if (inputStream == null) return var3_4;
                                    break block16;
                                }
                                data = new byte[16];
                                bytesRead = DataHelper.read(inputStream, data);
                                if (bytesRead != 16) {
                                    var5_19 = "";
                                    break block17;
                                }
                                for (i = 0; i < 16; ++i) {
                                    if (data[i] != 0) continue;
                                    var6_22 = new String(data, 0, i, "UTF-8");
                                    break block18;
                                }
                                var5_21 = new String(data, "UTF-8");
                                break block19;
                            }
                            catch (UnsupportedEncodingException uee) {
                                throw new RuntimeException("wtf, your JVM doesnt support utf-8? " + uee.getMessage());
                            }
                            catch (IOException ioe) {
                                var2_23 = "";
                                var8_10 = null;
                                if (inputStream == null) return var2_23;
                                try {
                                    inputStream.close();
                                    return var2_23;
                                }
                                catch (IOException ioe) {
                                    // empty catch block
                                }
                                return var2_23;
                            }
                        }
                        catch (Throwable var7_24) {
                            var8_11 = null;
                            if (inputStream == null) throw var7_24;
                            try {}
                            catch (IOException ioe) {
                                throw var7_24;
                            }
                            inputStream.close();
                            throw var7_24;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [14 : 169->176)] { 
lbl48:
                    // 1 sources

                    inputStream.close();
                    return var3_4;
lbl50:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return var3_4;
                }
                var8_7 = null;
                if (inputStream == null) return var5_19;
                ** try [egrp 2[TRYBLOCK] [14 : 169->176)] { 
lbl57:
                // 1 sources

                inputStream.close();
                return var5_19;
lbl59:
                // 1 sources

                catch (IOException ioe) {
                    // empty catch block
                }
                return var5_19;
            }
            var8_8 = null;
            if (inputStream == null) return var6_22;
            ** try [egrp 2[TRYBLOCK] [14 : 169->176)] { 
lbl66:
            // 1 sources

            inputStream.close();
            return var6_22;
lbl68:
            // 1 sources

            catch (IOException ioe) {
                // empty catch block
            }
            return var6_22;
        }
        var8_9 = null;
        if (inputStream == null) return var5_21;
        try {}
        catch (IOException ioe) {
            // empty catch block
            return var5_21;
        }
        inputStream.close();
        return var5_21;
    }

    public String newVersion() {
        return this._newVersion;
    }

    public boolean isUpdatedVersion(String currentVersion, File signedFile) {
        this._newVersion = TrustedUpdate.getVersionString(signedFile);
        return TrustedUpdate.needsUpdate(currentVersion, this._newVersion);
    }

    public String migrateVerified(String currentVersion, File signedFile, File outputFile) {
        if (!signedFile.exists()) {
            return "File not found: " + signedFile.getAbsolutePath();
        }
        if (!this.isUpdatedVersion(currentVersion, signedFile)) {
            if ("".equals(this._newVersion)) {
                return "Truncated or corrupt file: " + signedFile.getAbsolutePath();
            }
            return "Downloaded version is not greater than current version";
        }
        if (!this.verifyVersionMatch(signedFile)) {
            return "Update file invalid - signed version mismatch";
        }
        if (!this.verify(signedFile)) {
            return "Unknown signing key or corrupt file";
        }
        return this.migrateFile(signedFile, outputFile);
    }

    private boolean verifyVersionMatch(File signedFile) {
        try {
            String zipComment = ZipFileComment.getComment(signedFile, 16, 56);
            return zipComment.equals(this._newVersion);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String migrateFile(File signedFile, File outputFile) {
        block23: {
            IOException ioe222;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            block20: {
                if (!signedFile.exists()) {
                    return "File not found: " + signedFile.getAbsolutePath();
                }
                fileInputStream = null;
                fileOutputStream = null;
                fileInputStream = new FileInputStream(signedFile);
                fileOutputStream = new FileOutputStream(outputFile);
                for (long skipped = 0L; skipped < 56L; skipped += fileInputStream.skip(56L - skipped)) {
                }
                byte[] buffer = new byte[16384];
                int bytesRead = 0;
                while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, bytesRead);
                }
                Object var10_9 = null;
                if (fileInputStream == null) break block20;
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe222) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioe222) {}
            }
            break block23;
            {
                catch (IOException ioe3) {
                    IOException ioe222;
                    String string = "Error copying update: " + ioe3;
                    Object var10_10 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                    }
                    return string;
                }
            }
            catch (Throwable throwable) {
                IOException ioe222;
                Object var10_11 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Signature sign(String inputFile, String signedFile, String privateKeyFile, String version) {
        FileInputStream fileInputStream = null;
        SigningPrivateKey signingPrivateKey = new SigningPrivateKey();
        fileInputStream = new FileInputStream(privateKeyFile);
        signingPrivateKey.readBytes(fileInputStream);
        Object var10_7 = null;
        if (fileInputStream == null) return this.sign(inputFile, signedFile, signingPrivateKey, version);
        try {
            fileInputStream.close();
            return this.sign(inputFile, signedFile, signingPrivateKey, version);
        }
        catch (IOException ioe2) {}
        return this.sign(inputFile, signedFile, signingPrivateKey, version);
        {
            catch (IOException ioe) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to load the signing key", ioe);
                }
                Signature signature = null;
                Object var10_8 = null;
                if (fileInputStream == null) return signature;
                try {
                    fileInputStream.close();
                    return signature;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return signature;
            }
            catch (DataFormatException dfe) {
                Signature signature;
                try {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Unable to load the signing key", dfe);
                    }
                    signature = null;
                    Object var10_9 = null;
                    if (fileInputStream == null) return signature;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (fileInputStream == null) throw throwable;
                    try {
                        fileInputStream.close();
                        throw throwable;
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    fileInputStream.close();
                    return signature;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return signature;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Signature sign(String inputFile, String signedFile, SigningPrivateKey signingPrivateKey, String version) {
        Signature signature;
        block38: {
            IOException ioe322;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            block35: {
                byte[] versionHeader;
                block33: {
                    versionHeader = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                    byte[] versionRawBytes = null;
                    if (version.length() > 16) {
                        version = version.substring(0, 16);
                    }
                    try {
                        versionRawBytes = version.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("wtf, your JVM doesnt support utf-8? " + e.getMessage());
                    }
                    System.arraycopy(versionRawBytes, 0, versionHeader, 0, versionRawBytes.length);
                    fileInputStream = null;
                    signature = null;
                    SequenceInputStream bytesToSignInputStream = null;
                    ByteArrayInputStream versionHeaderInputStream = null;
                    fileInputStream = new FileInputStream(inputFile);
                    versionHeaderInputStream = new ByteArrayInputStream(versionHeader);
                    bytesToSignInputStream = new SequenceInputStream(versionHeaderInputStream, fileInputStream);
                    signature = this._context.dsa().sign(bytesToSignInputStream, signingPrivateKey);
                    Object var14_12 = null;
                    if (bytesToSignInputStream == null) break block33;
                    try {
                        bytesToSignInputStream.close();
                        break block33;
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    {
                        break block33;
                        catch (Exception e) {
                            if (this._log.shouldLog(40)) {
                                this._log.error("Error signing", e);
                            }
                            Signature signature2 = null;
                            Object var14_13 = null;
                            if (bytesToSignInputStream != null) {
                                try {
                                    bytesToSignInputStream.close();
                                }
                                catch (IOException ioe2) {
                                    // empty catch block
                                }
                            }
                            fileInputStream = null;
                            return signature2;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_14 = null;
                        if (bytesToSignInputStream != null) {
                            try {
                                bytesToSignInputStream.close();
                            }
                            catch (IOException ioe2) {
                                // empty catch block
                            }
                        }
                        fileInputStream = null;
                        throw throwable;
                    }
                }
                fileInputStream = null;
                fileOutputStream = null;
                fileOutputStream = new FileOutputStream(signedFile);
                fileOutputStream.write(signature.getData());
                fileOutputStream.write(versionHeader);
                fileInputStream = new FileInputStream(inputFile);
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                    fileOutputStream.write(buffer, 0, bytesRead);
                }
                fileOutputStream.close();
                Object var17_26 = null;
                if (fileInputStream == null) break block35;
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe322) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException ioe322) {}
            }
            break block38;
            {
                catch (IOException ioe4) {
                    IOException ioe322;
                    if (this._log.shouldLog(30)) {
                        this._log.log(30, "Error writing signed file " + signedFile, ioe4);
                    }
                    Signature signature3 = null;
                    Object var17_27 = null;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException ioe322) {
                            // empty catch block
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException ioe322) {
                            // empty catch block
                        }
                    }
                    return signature3;
                }
            }
            catch (Throwable throwable) {
                IOException ioe322;
                Object var17_28 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException ioe322) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException ioe322) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return signature;
    }

    public boolean verify(File signedFile) {
        for (SigningPublicKey signingPublicKey : this._trustedKeys.keySet()) {
            boolean isValidSignature = this.verify(signedFile, signingPublicKey);
            if (!isValidSignature) continue;
            return true;
        }
        if (this._log.shouldLog(30)) {
            this._log.warn("None of the keys match");
        }
        return false;
    }

    public String verifyAndGetSigner(File signedFile) {
        for (SigningPublicKey signingPublicKey : this._trustedKeys.keySet()) {
            boolean isValidSignature = this.verify(signedFile, signingPublicKey);
            if (!isValidSignature) continue;
            return this._trustedKeys.get(signingPublicKey);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean verify(String signedFile, String publicKeyFile) {
        SigningPublicKey signingPublicKey = new SigningPublicKey();
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(signedFile);
        signingPublicKey.readBytes(fileInputStream);
        Object var8_5 = null;
        if (fileInputStream == null) return this.verify(new File(signedFile), signingPublicKey);
        try {
            fileInputStream.close();
            return this.verify(new File(signedFile), signingPublicKey);
        }
        catch (IOException ioe2) {}
        return this.verify(new File(signedFile), signingPublicKey);
        {
            catch (IOException ioe) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to load the signature", ioe);
                }
                boolean bl = false;
                Object var8_6 = null;
                if (fileInputStream == null) return bl;
                try {
                    fileInputStream.close();
                    return bl;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return bl;
            }
            catch (DataFormatException dfe) {
                boolean bl;
                try {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Unable to load the signature", dfe);
                    }
                    bl = false;
                    Object var8_7 = null;
                    if (fileInputStream == null) return bl;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (fileInputStream == null) throw throwable;
                    try {
                        fileInputStream.close();
                        throw throwable;
                    }
                    catch (IOException ioe2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    fileInputStream.close();
                    return bl;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean verify(File signedFile, SigningPublicKey signingPublicKey) {
        boolean bl;
        FileInputStream fileInputStream;
        block13: {
            fileInputStream = null;
            fileInputStream = new FileInputStream(signedFile);
            Signature signature = new Signature();
            signature.readBytes(fileInputStream);
            bl = this._context.dsa().verifySignature(signature, fileInputStream, signingPublicKey);
            Object var7_10 = null;
            if (fileInputStream == null) break block13;
            try {
                fileInputStream.close();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
        }
        return bl;
        catch (IOException ioe) {
            boolean bl2;
            block14: {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Error reading " + signedFile + " to verify", ioe);
                }
                bl2 = false;
                Object var7_11 = null;
                if (fileInputStream == null) break block14;
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            return bl2;
        }
        catch (DataFormatException dfe) {
            boolean bl3;
            block15: {
                if (this._log.shouldLog(40)) {
                    this._log.error("Error reading the signature", dfe);
                }
                bl3 = false;
                Object var7_12 = null;
                if (fileInputStream == null) break block15;
                {
                    catch (Throwable throwable) {
                        block16: {
                            Object var7_13 = null;
                            if (fileInputStream == null) break block16;
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException ioe2) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    fileInputStream.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
            return bl3;
        }
    }

    static {
        DEFAULT_KEYS.put(DEFAULT_TRUSTED_KEY2, "zzz@mail.i2p");
        DEFAULT_KEYS.put(DEFAULT_TRUSTED_KEY4, "HungryHobo@mail.i2p");
        DEFAULT_KEYS.put(DEFAULT_TRUSTED_KEY5, "killyourtv@mail.i2p");
    }
}

