/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.I2PSessionImpl;
import net.i2p.client.I2PSessionListener;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.MessageState;
import net.i2p.client.SendMessageOptions;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.SessionKey;
import net.i2p.data.i2cp.MessageId;

class I2PSessionImpl2
extends I2PSessionImpl {
    private Set<MessageState> _sendingStates;
    private static final long SEND_TIMEOUT = 60000L;
    private static final boolean SHOULD_COMPRESS = true;
    private static final boolean SHOULD_DECOMPRESS = true;
    protected boolean _noEffort;
    private static final int DONT_COMPRESS_SIZE = 66;

    protected I2PSessionImpl2(I2PAppContext context, Properties options) {
        super(context, options);
    }

    public I2PSessionImpl2(I2PAppContext ctx, InputStream destKeyStream, Properties options) throws I2PSessionException {
        super(ctx, destKeyStream, options);
        this._sendingStates = new HashSet<MessageState>(32);
        this._noEffort = "none".equals(this.getOptions().getProperty("i2cp.messageReliability", "").toLowerCase(Locale.US));
        ctx.statManager().createRateStat("i2cp.sendBestEffortTotalTime", "how long to do the full sendBestEffort call?", "i2cp", new long[]{600000L});
        this._context.statManager().createRateStat("i2cp.receiveStatusTime.1", "How long it took to get status=1 back", "i2cp", new long[]{600000L});
        this._context.statManager().createRateStat("i2cp.receiveStatusTime.4", "How long it took to get status=4 back", "i2cp", new long[]{600000L});
        this._context.statManager().createRateStat("i2cp.receiveStatusTime.5", "How long it took to get status=5 back", "i2cp", new long[]{600000L});
        this._context.statManager().createRateStat("i2cp.receiveStatusTime", "How long it took to get any status", "i2cp", new long[]{600000L});
        this._context.statManager().createRateStat("i2cp.tx.msgCompressed", "compressed size transferred", "i2cp", new long[]{1800000L});
        this._context.statManager().createRateStat("i2cp.tx.msgExpanded", "size before compression", "i2cp", new long[]{1800000L});
    }

    protected long getTimeout() {
        return 60000L;
    }

    public void destroySession(boolean sendDisconnect) {
        this.clearStates();
        super.destroySession(sendDisconnect);
    }

    protected boolean shouldCompress(int size) {
        if (size <= 66) {
            return false;
        }
        String p = this.getOptions().getProperty("i2cp.gzip");
        if (p != null) {
            return Boolean.parseBoolean(p);
        }
        return true;
    }

    public void addSessionListener(I2PSessionListener lsnr, int proto, int port) {
        throw new IllegalArgumentException("Use MuxedImpl");
    }

    public void addMuxedSessionListener(I2PSessionMuxedListener l, int proto, int port) {
        throw new IllegalArgumentException("Use MuxedImpl");
    }

    public void removeListener(int proto, int port) {
        throw new IllegalArgumentException("Use MuxedImpl");
    }

    public boolean sendMessage(Destination dest, byte[] payload, int proto, int fromport, int toport) throws I2PSessionException {
        throw new IllegalArgumentException("Use MuxedImpl");
    }

    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set tagsSent, int proto, int fromport, int toport) throws I2PSessionException {
        throw new IllegalArgumentException("Use MuxedImpl");
    }

    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set tagsSent, long expire, int proto, int fromport, int toport) throws I2PSessionException {
        throw new IllegalArgumentException("Use MuxedImpl");
    }

    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set tagsSent, long expire, int proto, int fromport, int toport, int flags) throws I2PSessionException {
        throw new IllegalArgumentException("Use MuxedImpl");
    }

    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, int proto, int fromport, int toport, SendMessageOptions options) throws I2PSessionException {
        throw new IllegalArgumentException("Use MuxedImpl");
    }

    public boolean sendMessage(Destination dest, byte[] payload) throws I2PSessionException {
        return this.sendMessage(dest, payload, 0, payload.length);
    }

    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size) throws I2PSessionException {
        return this.sendMessage(dest, payload, offset, size, null, null, 0L);
    }

    public boolean sendMessage(Destination dest, byte[] payload, SessionKey keyUsed, Set tagsSent) throws I2PSessionException {
        return this.sendMessage(dest, payload, 0, payload.length, keyUsed, tagsSent, 0L);
    }

    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set tagsSent) throws I2PSessionException {
        return this.sendMessage(dest, payload, offset, size, keyUsed, tagsSent, 0L);
    }

    public boolean sendMessage(Destination dest, byte[] payload, int offset, int size, SessionKey keyUsed, Set tagsSent, long expires) throws I2PSessionException {
        if (this._log.shouldLog(10)) {
            this._log.debug("sending message");
        }
        if (this.isClosed()) {
            throw new I2PSessionException("Already closed");
        }
        this.updateActivity();
        boolean sc = this.shouldCompress(size);
        payload = sc ? DataHelper.compress(payload, offset, size) : DataHelper.compress(payload, offset, size, 0);
        int compressed = payload.length;
        if (this._log.shouldLog(20)) {
            String d = dest.calculateHash().toBase64().substring(0, 4);
            this._log.info("sending message to: " + d + " compress? " + sc + " sizeIn=" + size + " sizeOut=" + compressed);
        }
        this._context.statManager().addRateData("i2cp.tx.msgCompressed", compressed, 0L);
        this._context.statManager().addRateData("i2cp.tx.msgExpanded", size, 0L);
        if (this._noEffort) {
            return this.sendNoEffort(dest, payload, expires, 0);
        }
        return this.sendBestEffort(dest, payload, keyUsed, tagsSent, expires);
    }

    public byte[] receiveMessage(int msgId) throws I2PSessionException {
        byte[] compressed = super.receiveMessage(msgId);
        if (compressed == null) {
            this._log.error("Error: message " + msgId + " already received!");
            return null;
        }
        try {
            return DataHelper.decompress(compressed);
        }
        catch (IOException ioe) {
            throw new I2PSessionException("Error decompressing message", ioe);
        }
    }

    protected boolean sendBestEffort(Destination dest, byte[] payload, SessionKey keyUsed, Set tagsSent, long expires) throws I2PSessionException {
        return this.sendBestEffort(dest, payload, expires, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendBestEffort(Destination dest, byte[] payload, long expires, int flags) throws I2PSessionException {
        long timeToSend;
        boolean found;
        long begin = this._context.clock().now();
        long nonce = this._context.random().nextInt(Integer.MAX_VALUE);
        MessageState state = new MessageState(this._context, nonce, this.getPrefix());
        state.setTo(dest);
        long beforeSendingSync = this._context.clock().now();
        long inSendingSync = 0L;
        Set<MessageState> set = this._sendingStates;
        synchronized (set) {
            inSendingSync = this._context.clock().now();
            this._sendingStates.add(state);
        }
        long afterSendingSync = this._context.clock().now();
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "Adding sending state " + state.getMessageId() + " / " + state.getNonce() + " for best effort " + " sync took " + (inSendingSync - beforeSendingSync) + " add took " + (afterSendingSync - inSendingSync));
        }
        this._producer.sendMessage(this, dest, nonce, payload, expires, flags);
        boolean actuallyWait = false;
        long beforeWaitFor = this._context.clock().now();
        if (actuallyWait) {
            state.waitFor(1, this._context.clock().now() + this.getTimeout());
        }
        Set<MessageState> set2 = this._sendingStates;
        synchronized (set2) {
            this._sendingStates.remove(state);
        }
        long afterRemovingSync = this._context.clock().now();
        boolean bl = found = !actuallyWait || state.received(1);
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "After waitFor sending state " + state.getMessageId() + " / " + state.getNonce() + " found = " + found);
        }
        if ((timeToSend = afterRemovingSync - beforeSendingSync) > 10000L && this._log.shouldLog(30)) {
            this._log.warn("wtf, took " + timeToSend + "ms to send the message?!", new Exception("baz"));
        }
        if (afterRemovingSync - begin > 500L && this._log.shouldLog(30)) {
            this._log.warn("Took " + (afterRemovingSync - begin) + "ms to sendBestEffort, " + (afterSendingSync - begin) + "ms to prepare, " + (beforeWaitFor - afterSendingSync) + "ms to send, " + (afterRemovingSync - beforeWaitFor) + "ms waiting for reply");
        }
        this._context.statManager().addRateData("i2cp.sendBestEffortTotalTime", afterRemovingSync - begin, 0L);
        if (found) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Message sent after " + state.getElapsed() + "ms with " + payload.length + " bytes");
            }
        } else {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Message send failed after " + state.getElapsed() + "ms with " + payload.length + " bytes");
            }
            if (this._log.shouldLog(40)) {
                this._log.error(this.getPrefix() + "Never received *accepted* from the router!  dropping and reconnecting");
            }
            this.disconnect();
            return false;
        }
        return found;
    }

    protected boolean sendNoEffort(Destination dest, byte[] payload, long expires, int flags) throws I2PSessionException {
        this._producer.sendMessage(this, dest, 0L, payload, expires, flags);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveStatus(int msgId, long nonce, int status) {
        if (this._log.shouldLog(10)) {
            this._log.debug(this.getPrefix() + "Received status " + status + " for msgId " + msgId + " / " + nonce);
        }
        MessageState state2 = null;
        long beforeSync = this._context.clock().now();
        long inSync = 0L;
        Set<MessageState> set = this._sendingStates;
        synchronized (set) {
            inSync = this._context.clock().now();
            for (MessageState state2 : this._sendingStates) {
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix() + "State " + state2.getMessageId() + " / " + state2.getNonce());
                }
                if (state2.getNonce() == nonce) {
                    if (!this._log.shouldLog(10)) break;
                    this._log.debug(this.getPrefix() + "Found a matching state");
                    break;
                }
                if (state2.getMessageId() != null && state2.getMessageId().getMessageId() == (long)msgId) {
                    if (!this._log.shouldLog(10)) break;
                    this._log.debug(this.getPrefix() + "Found a matching state by msgId");
                    break;
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getPrefix() + "State does not match");
                }
                state2 = null;
            }
        }
        long afterSync = this._context.clock().now();
        if (this._log.shouldLog(10)) {
            this._log.debug("receiveStatus(" + msgId + ", " + nonce + ", " + status + "): sync: " + (inSync - beforeSync) + "ms, check: " + (afterSync - inSync));
        }
        if (state2 != null) {
            if (state2.getMessageId() == null) {
                MessageId id = new MessageId();
                id.setMessageId(msgId);
                state2.setMessageId(id);
            }
            state2.receive(status);
            long lifetime = state2.getElapsed();
            switch (status) {
                case 1: {
                    this._context.statManager().addRateData("i2cp.receiveStatusTime.1", lifetime, 0L);
                    break;
                }
                case 4: {
                    this._context.statManager().addRateData("i2cp.receiveStatusTime.4", lifetime, 0L);
                    break;
                }
                case 5: {
                    this._context.statManager().addRateData("i2cp.receiveStatusTime.5", lifetime, 0L);
                }
            }
        } else if (this._log.shouldLog(20)) {
            this._log.info(this.getPrefix() + "No matching state for messageId " + msgId + " / " + nonce + " w/ status = " + status);
        }
        this._context.statManager().addRateData("i2cp.receiveStatusTime", this._context.clock().now() - beforeSync, 0L);
    }

    protected boolean reconnect() {
        this.clearStates();
        return super.reconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearStates() {
        if (this._sendingStates == null) {
            return;
        }
        Set<MessageState> set = this._sendingStates;
        synchronized (set) {
            for (MessageState state : this._sendingStates) {
                state.cancel();
            }
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix() + "Disconnecting " + this._sendingStates.size() + " states");
            }
            this._sendingStates.clear();
        }
    }
}

