/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public abstract class RFC822Date {
    private static final SimpleDateFormat OUTPUT_FORMAT = new SimpleDateFormat("d MMM yyyy HH:mm:ss z", Locale.US);
    private static final SimpleDateFormat[] rfc822DateFormats = new SimpleDateFormat[]{OUTPUT_FORMAT, new SimpleDateFormat("EEE, d MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yy HH:mm z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("d MMM yyyy HH:mm z", Locale.US)};

    public static synchronized long parse822Date(String s) {
        for (int i = 0; i < rfc822DateFormats.length; ++i) {
            try {
                Date date = rfc822DateFormats[i].parse(s);
                if (date == null) continue;
                return date.getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return -1L;
    }

    public static synchronized String to822Date(long t) {
        return OUTPUT_FORMAT.format(new Date(t));
    }
}

