/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.util;

import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.router.util.PQEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriBlockingQueue<E extends PQEntry>
extends PriorityBlockingQueue<E> {
    private final AtomicLong _seqNum = new AtomicLong();
    protected static final int BACKLOG_SIZE = 256;

    public PriBlockingQueue(int initialCapacity) {
        super(initialCapacity, new PriorityComparator());
    }

    @Override
    public boolean add(E o) {
        this.timestamp(o);
        return super.add(o);
    }

    @Override
    public boolean offer(E o) {
        this.timestamp(o);
        return super.offer(o);
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) {
        this.timestamp(o);
        return super.offer(o, timeout, unit);
    }

    @Override
    public void put(E o) {
        this.timestamp(o);
        super.put(o);
    }

    public boolean isBacklogged() {
        return this.size() >= 256;
    }

    protected void timestamp(E o) {
        o.setSeqNum(this._seqNum.incrementAndGet());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PriorityComparator<E extends PQEntry>
    implements Comparator<E> {
        private PriorityComparator() {
        }

        @Override
        public int compare(E l, E r) {
            int d = r.getPriority() - l.getPriority();
            if (d != 0) {
                return d;
            }
            long ld = l.getSeqNum() - r.getSeqNum();
            return ld > 0L ? 1 : -1;
        }
    }
}

