/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import net.i2p.util.SystemVersion;

abstract class MTU {
    private static final boolean hasMTU = SystemVersion.isJava6();

    MTU() {
    }

    public static int getMTU(InetAddress ia) {
        Enumeration<NetworkInterface> ifcs;
        if (ia == null || !hasMTU) {
            return 0;
        }
        try {
            ifcs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException se) {
            return 0;
        }
        if (ifcs != null) {
            while (ifcs.hasMoreElements()) {
                NetworkInterface ifc = ifcs.nextElement();
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!ia.equals(addr)) continue;
                    try {
                        return MTU.rectify(ifc.getMTU());
                    }
                    catch (SocketException se) {
                    }
                    catch (Throwable t) {
                        return 0;
                    }
                }
            }
        }
        return 0;
    }

    public static int rectify(int mtu) {
        int rv = mtu;
        int mod = rv % 16;
        if (mod > 12) {
            rv -= mod - 12;
        } else if (mod < 12) {
            rv -= mod + 4;
        }
        return Math.max(620, Math.min(1484, rv));
    }
}

