/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterAddress;
import net.i2p.data.RouterInfo;
import net.i2p.data.SessionKey;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.PacketBuilder;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacketReader;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;

class IntroductionManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PacketBuilder _builder;
    private final Map<Long, PeerState> _outbound;
    private final Set<PeerState> _inbound;
    private final Set<InetAddress> _recentHolePunches;
    private long _lastHolePunchClean;
    private static final int MAX_INBOUND = 20;
    public static final int MAX_OUTBOUND = 100;
    private static final long PUNCH_CLEAN_TIME = 5000L;
    private static final int MAX_PUNCHES = 8;

    public IntroductionManager(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(IntroductionManager.class);
        this._transport = transport;
        this._builder = new PacketBuilder(ctx, transport);
        this._outbound = new ConcurrentHashMap<Long, PeerState>(100);
        this._inbound = new ConcurrentHashSet(20);
        this._recentHolePunches = new HashSet<InetAddress>(16);
        ctx.statManager().createRateStat("udp.receiveRelayIntro", "How often we get a relayed request for us to talk to someone?", "udp", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.receiveRelayRequest", "How often we receive a good request to relay to someone else?", "udp", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.receiveRelayRequestBadTag", "Received relay requests with bad/expired tag", "udp", UDPTransport.RATES);
        ctx.statManager().createRateStat("udp.relayBadIP", "Received IP or port was bad", "udp", UDPTransport.RATES);
    }

    public void reset() {
        this._inbound.clear();
        this._outbound.clear();
    }

    public void add(PeerState peer) {
        if (peer == null) {
            return;
        }
        if (peer.getRemotePort() < 1024) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Adding peer " + peer.getRemoteHostId() + ", weRelayToThemAs " + peer.getWeRelayToThemAs() + ", theyRelayToUsAs " + peer.getTheyRelayToUsAs());
        }
        if (peer.getWeRelayToThemAs() > 0L) {
            this._outbound.put(peer.getWeRelayToThemAs(), peer);
        }
        if (peer.getTheyRelayToUsAs() > 0L && this._inbound.size() < 20) {
            this._inbound.add(peer);
        }
    }

    public void remove(PeerState peer) {
        if (peer == null) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("removing peer " + peer.getRemoteHostId() + ", weRelayToThemAs " + peer.getWeRelayToThemAs() + ", theyRelayToUsAs " + peer.getTheyRelayToUsAs());
        }
        if (peer.getWeRelayToThemAs() > 0L) {
            this._outbound.remove(peer.getWeRelayToThemAs());
        }
        if (peer.getTheyRelayToUsAs() > 0L) {
            this._inbound.remove(peer);
        }
    }

    private PeerState get(long id) {
        return this._outbound.get(id);
    }

    public int pickInbound(Properties ssuOptions, int howMany) {
        int start = this._context.random().nextInt(Integer.MAX_VALUE);
        if (this._log.shouldLog(10)) {
            this._log.debug("Picking inbound out of " + this._inbound.size());
        }
        if (this._inbound.isEmpty()) {
            return 0;
        }
        ArrayList<PeerState> peers = new ArrayList<PeerState>(this._inbound);
        int sz = peers.size();
        start %= sz;
        int found = 0;
        long inactivityCutoff = this._context.clock().now() - 600000L;
        if (sz <= howMany + 2) {
            inactivityCutoff -= 300000L;
        }
        for (int i = 0; i < sz && found < howMany; ++i) {
            int port;
            PeerState cur = (PeerState)peers.get((start + i) % sz);
            RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(cur.getRemotePeer());
            if (ri == null) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Picked peer has no local routerInfo: " + cur);
                continue;
            }
            RouterAddress ra = ri.getTargetAddress("SSU");
            if (ra == null) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Picked peer has no SSU address: " + ri);
                continue;
            }
            if (this._context.shitlist().isShitlisted(cur.getRemotePeer()) || this._transport.wasUnreachable(cur.getRemotePeer())) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Peer is failing, shistlisted or was unreachable: " + cur);
                continue;
            }
            if (cur.getLastReceiveTime() < inactivityCutoff && cur.getLastSendTime() < inactivityCutoff) {
                if (!this._log.shouldLog(20)) continue;
                this._log.info("Peer is idle too long: " + cur);
                continue;
            }
            byte[] ip = cur.getRemoteIP();
            if (!this.isValid(ip, port = cur.getRemotePort())) continue;
            if (this._log.shouldLog(20)) {
                this._log.info("Picking introducer: " + cur);
            }
            cur.setIntroducerTime();
            UDPAddress ura = new UDPAddress(ra);
            ssuOptions.setProperty("ihost" + found, Addresses.toString((byte[])ip));
            ssuOptions.setProperty("iport" + found, String.valueOf(port));
            ssuOptions.setProperty("ikey" + found, Base64.encode((byte[])ura.getIntroKey()));
            ssuOptions.setProperty("itag" + found, String.valueOf(cur.getTheyRelayToUsAs()));
            ++found;
        }
        this.pingIntroducers();
        return found;
    }

    public void pingIntroducers() {
        long now = this._context.clock().now();
        long pingCutoff = now - 6300000L;
        long inactivityCutoff = now - 360000L;
        for (PeerState cur : this._inbound) {
            if (cur.getIntroducerTime() <= pingCutoff || cur.getLastSendTime() >= inactivityCutoff) continue;
            if (this._log.shouldLog(20)) {
                this._log.info("Pinging introducer: " + cur);
            }
            cur.setLastSendTime(now);
            this._transport.send(this._builder.buildPing(cur));
        }
    }

    int introducerCount() {
        return this._inbound.size();
    }

    int introducedCount() {
        return this._outbound.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveRelayIntro(RemoteHostId bob, UDPPacketReader reader) {
        if (this._context.router().isHidden()) {
            return;
        }
        this._context.statManager().addRateData("udp.receiveRelayIntro", 1L);
        if (!this._transport.allowConnection()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping RelayIntro, over conn limit");
            }
            return;
        }
        int ipSize = reader.getRelayIntroReader().readIPSize();
        byte[] ip = new byte[ipSize];
        reader.getRelayIntroReader().readIP(ip, 0);
        int port = reader.getRelayIntroReader().readPort();
        if (!this.isValid(ip, port) || !this.isValid(bob.getIP(), bob.getPort())) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Bad relay intro from " + bob + " for " + Addresses.toString((byte[])ip, (int)port));
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Receive relay intro from " + bob + " for " + Addresses.toString((byte[])ip, (int)port));
        }
        InetAddress to = null;
        try {
            to = InetAddress.getByAddress(ip);
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldLog(30)) {
                this._log.warn("IP for alice to hole punch to is invalid", (Throwable)uhe);
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        RemoteHostId alice = new RemoteHostId(ip, port);
        if (this._transport.getPeerState(alice) != null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring RelayIntro, already have a session to " + to);
            }
            return;
        }
        EstablishmentManager establisher = this._transport.getEstablisher();
        if (establisher != null) {
            if (establisher.getInboundState(alice) != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Ignoring RelayIntro, establishment in progress to " + to);
                }
                return;
            }
            if (!establisher.shouldAllowInboundEstablishment()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Dropping RelayIntro, too many establishments in progress - for " + to);
                }
                return;
            }
        }
        boolean tooMany = false;
        boolean already = false;
        Set<InetAddress> set = this._recentHolePunches;
        synchronized (set) {
            long now = this._context.clock().now();
            if (now > this._lastHolePunchClean + 5000L) {
                this._recentHolePunches.clear();
                this._lastHolePunchClean = now;
                this._recentHolePunches.add(to);
            } else {
                boolean bl = tooMany = this._recentHolePunches.size() >= 8;
                if (!tooMany) {
                    already = !this._recentHolePunches.add(to);
                }
            }
        }
        if (tooMany) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Dropping - too many - RelayIntro for " + to);
            }
            return;
        }
        if (already) {
            if (this._log.shouldLog(20)) {
                this._log.info("Ignoring dup RelayIntro for " + to);
            }
            return;
        }
        this._transport.send(this._builder.buildHolePunch(to, port));
    }

    void receiveRelayRequest(RemoteHostId alice, UDPPacketReader reader) {
        if (this._context.router().isHidden()) {
            return;
        }
        UDPPacketReader.RelayRequestReader rrReader = reader.getRelayRequestReader();
        long tag = rrReader.readTag();
        int ipSize = rrReader.readIPSize();
        int port = rrReader.readPort();
        if (!this.isValid(alice.getIP(), alice.getPort()) || ipSize != 0 || port != 0) {
            if (this._log.shouldLog(30)) {
                byte[] ip = new byte[ipSize];
                rrReader.readIP(ip, 0);
                this._log.warn("Bad relay req from " + alice + " for " + Addresses.toString((byte[])ip, (int)port));
            }
            this._context.statManager().addRateData("udp.relayBadIP", 1L);
            return;
        }
        PeerState charlie = this.get(tag);
        if (charlie == null) {
            if (this._log.shouldLog(20)) {
                this._log.info("Receive relay request from " + alice + " with unknown tag");
            }
            this._context.statManager().addRateData("udp.receiveRelayRequestBadTag", 1L, 0L);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Receive relay request from " + alice + " for tag " + tag + " and relaying with " + charlie);
        }
        this._context.statManager().addRateData("udp.receiveRelayRequest", 1L, 0L);
        byte[] key = new byte[32];
        reader.getRelayRequestReader().readAliceIntroKey(key, 0);
        SessionKey aliceIntroKey = new SessionKey(key);
        this._transport.send(this._builder.buildRelayIntro(alice, charlie, reader.getRelayRequestReader()));
        this._transport.send(this._builder.buildRelayResponse(alice, charlie, reader.getRelayRequestReader().readNonce(), aliceIntroKey));
    }

    private boolean isValid(byte[] ip, int port) {
        return port >= 1024 && port <= 65535 && this._transport.isValid(ip) && !DataHelper.eq((byte[])ip, (int)0, (byte[])this._transport.getExternalIP(), (int)0, (int)2) && !this._context.blocklist().isBlocklisted(ip);
    }
}

